# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConsumerGroupConsumeRetryPolicy',
    'RocketMQInstanceAclInfo',
    'RocketMQInstanceNetworkInfo',
    'RocketMQInstanceNetworkInfoEndpoint',
    'RocketMQInstanceNetworkInfoInternetInfo',
    'RocketMQInstanceNetworkInfoVpcInfo',
    'RocketMQInstanceNetworkInfoVpcInfoVswitch',
    'RocketMQInstanceProductInfo',
    'RocketMQInstanceSoftware',
    'GetGroupsGroupResult',
    'GetInstancesInstanceResult',
    'GetTopicsTopicResult',
]

@pulumi.output_type
class ConsumerGroupConsumeRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deadLetterTargetTopic":
            suggest = "dead_letter_target_topic"
        elif key == "maxRetryTimes":
            suggest = "max_retry_times"
        elif key == "retryPolicy":
            suggest = "retry_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConsumerGroupConsumeRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConsumerGroupConsumeRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConsumerGroupConsumeRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dead_letter_target_topic: Optional[_builtins.str] = None,
                 max_retry_times: Optional[_builtins.int] = None,
                 retry_policy: Optional[_builtins.str] = None):
        """
        :param _builtins.str dead_letter_target_topic: The dead-letter topic. If the consumer fails to consume a message in an abnormal situation and the message is still unsuccessful after retrying, the message will be delivered to the dead letter Topic for subsequent business recovery or backtracking.
        :param _builtins.int max_retry_times: Maximum number of retries.
        :param _builtins.str retry_policy: Consume retry policy.
        """
        if dead_letter_target_topic is not None:
            pulumi.set(__self__, "dead_letter_target_topic", dead_letter_target_topic)
        if max_retry_times is not None:
            pulumi.set(__self__, "max_retry_times", max_retry_times)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)

    @_builtins.property
    @pulumi.getter(name="deadLetterTargetTopic")
    def dead_letter_target_topic(self) -> Optional[_builtins.str]:
        """
        The dead-letter topic. If the consumer fails to consume a message in an abnormal situation and the message is still unsuccessful after retrying, the message will be delivered to the dead letter Topic for subsequent business recovery or backtracking.
        """
        return pulumi.get(self, "dead_letter_target_topic")

    @_builtins.property
    @pulumi.getter(name="maxRetryTimes")
    def max_retry_times(self) -> Optional[_builtins.int]:
        """
        Maximum number of retries.
        """
        return pulumi.get(self, "max_retry_times")

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[_builtins.str]:
        """
        Consume retry policy.
        """
        return pulumi.get(self, "retry_policy")


@pulumi.output_type
class RocketMQInstanceAclInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclTypes":
            suggest = "acl_types"
        elif key == "defaultVpcAuthFree":
            suggest = "default_vpc_auth_free"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceAclInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceAclInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceAclInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_types: Optional[Sequence[_builtins.str]] = None,
                 default_vpc_auth_free: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] acl_types: The authentication type of the instance. Valid values:
        :param _builtins.bool default_vpc_auth_free: Indicates whether the authentication-free in VPCs feature is enabled. Indicates whether the authentication-free in VPCs feature is enabled. Valid values:
        """
        if acl_types is not None:
            pulumi.set(__self__, "acl_types", acl_types)
        if default_vpc_auth_free is not None:
            pulumi.set(__self__, "default_vpc_auth_free", default_vpc_auth_free)

    @_builtins.property
    @pulumi.getter(name="aclTypes")
    def acl_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The authentication type of the instance. Valid values:
        """
        return pulumi.get(self, "acl_types")

    @_builtins.property
    @pulumi.getter(name="defaultVpcAuthFree")
    def default_vpc_auth_free(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the authentication-free in VPCs feature is enabled. Indicates whether the authentication-free in VPCs feature is enabled. Valid values:
        """
        return pulumi.get(self, "default_vpc_auth_free")


@pulumi.output_type
class RocketMQInstanceNetworkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internetInfo":
            suggest = "internet_info"
        elif key == "vpcInfo":
            suggest = "vpc_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceNetworkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceNetworkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceNetworkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 internet_info: 'outputs.RocketMQInstanceNetworkInfoInternetInfo',
                 vpc_info: 'outputs.RocketMQInstanceNetworkInfoVpcInfo',
                 endpoints: Optional[Sequence['outputs.RocketMQInstanceNetworkInfoEndpoint']] = None):
        """
        :param 'RocketMQInstanceNetworkInfoInternetInfoArgs' internet_info: instance internet info. See `internet_info` below.
        :param 'RocketMQInstanceNetworkInfoVpcInfoArgs' vpc_info: Proprietary network information. See `vpc_info` below.
        :param Sequence['RocketMQInstanceNetworkInfoEndpointArgs'] endpoints: Access point list.
        """
        pulumi.set(__self__, "internet_info", internet_info)
        pulumi.set(__self__, "vpc_info", vpc_info)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)

    @_builtins.property
    @pulumi.getter(name="internetInfo")
    def internet_info(self) -> 'outputs.RocketMQInstanceNetworkInfoInternetInfo':
        """
        instance internet info. See `internet_info` below.
        """
        return pulumi.get(self, "internet_info")

    @_builtins.property
    @pulumi.getter(name="vpcInfo")
    def vpc_info(self) -> 'outputs.RocketMQInstanceNetworkInfoVpcInfo':
        """
        Proprietary network information. See `vpc_info` below.
        """
        return pulumi.get(self, "vpc_info")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.RocketMQInstanceNetworkInfoEndpoint']]:
        """
        Access point list.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class RocketMQInstanceNetworkInfoEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "endpointUrl":
            suggest = "endpoint_url"
        elif key == "ipWhiteLists":
            suggest = "ip_white_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceNetworkInfoEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceNetworkInfoEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceNetworkInfoEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: Optional[_builtins.str] = None,
                 endpoint_url: Optional[_builtins.str] = None,
                 ip_white_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str endpoint_type: Access point type.
        :param _builtins.str endpoint_url: Access point address.
        :param Sequence[_builtins.str] ip_white_lists: White list of access addresses.
        """
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if ip_white_lists is not None:
            pulumi.set(__self__, "ip_white_lists", ip_white_lists)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[_builtins.str]:
        """
        Access point type.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[_builtins.str]:
        """
        Access point address.
        """
        return pulumi.get(self, "endpoint_url")

    @_builtins.property
    @pulumi.getter(name="ipWhiteLists")
    def ip_white_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        White list of access addresses.
        """
        return pulumi.get(self, "ip_white_lists")


@pulumi.output_type
class RocketMQInstanceNetworkInfoInternetInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowOutType":
            suggest = "flow_out_type"
        elif key == "internetSpec":
            suggest = "internet_spec"
        elif key == "flowOutBandwidth":
            suggest = "flow_out_bandwidth"
        elif key == "ipWhitelists":
            suggest = "ip_whitelists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceNetworkInfoInternetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceNetworkInfoInternetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceNetworkInfoInternetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_out_type: _builtins.str,
                 internet_spec: _builtins.str,
                 flow_out_bandwidth: Optional[_builtins.int] = None,
                 ip_whitelists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str flow_out_type: Public network billing type.  Parameter values are as follows:
               - payByBandwidth: Fixed bandwidth billing. This parameter must be set to the value when public network access is enabled.
               - uninvolved: Not involved. This parameter must be set to the value when public network access is disabled.
        :param _builtins.str internet_spec: Whether to enable public network access.  The parameter values are as follows:
               - enable: Enable public network access
               - disable: Disable public network access   Instances by default support VPC access. If public network access is enabled, Alibaba Cloud Message Queue RocketMQ version will incur charges for public network outbound bandwidth. For specific billing information, please refer to [Public Network Access Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/internet-access-fee).
        :param _builtins.int flow_out_bandwidth: Public network bandwidth specification. Unit: Mb/s.  This field should only be filled when the public network billing type is set to payByBandwidth.  The value range is [1 - 1000].
        :param Sequence[_builtins.str] ip_whitelists: Field `ip_whitelist` has been deprecated from provider version 1.245.0. New field `ip_whitelists` instead.
        """
        pulumi.set(__self__, "flow_out_type", flow_out_type)
        pulumi.set(__self__, "internet_spec", internet_spec)
        if flow_out_bandwidth is not None:
            pulumi.set(__self__, "flow_out_bandwidth", flow_out_bandwidth)
        if ip_whitelists is not None:
            pulumi.set(__self__, "ip_whitelists", ip_whitelists)

    @_builtins.property
    @pulumi.getter(name="flowOutType")
    def flow_out_type(self) -> _builtins.str:
        """
        Public network billing type.  Parameter values are as follows:
        - payByBandwidth: Fixed bandwidth billing. This parameter must be set to the value when public network access is enabled.
        - uninvolved: Not involved. This parameter must be set to the value when public network access is disabled.
        """
        return pulumi.get(self, "flow_out_type")

    @_builtins.property
    @pulumi.getter(name="internetSpec")
    def internet_spec(self) -> _builtins.str:
        """
        Whether to enable public network access.  The parameter values are as follows:
        - enable: Enable public network access
        - disable: Disable public network access   Instances by default support VPC access. If public network access is enabled, Alibaba Cloud Message Queue RocketMQ version will incur charges for public network outbound bandwidth. For specific billing information, please refer to [Public Network Access Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/internet-access-fee).
        """
        return pulumi.get(self, "internet_spec")

    @_builtins.property
    @pulumi.getter(name="flowOutBandwidth")
    def flow_out_bandwidth(self) -> Optional[_builtins.int]:
        """
        Public network bandwidth specification. Unit: Mb/s.  This field should only be filled when the public network billing type is set to payByBandwidth.  The value range is [1 - 1000].
        """
        return pulumi.get(self, "flow_out_bandwidth")

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    @_utilities.deprecated("""Field 'ip_whitelist' has been deprecated from provider version 1.245.0. New field 'ip_whitelists' instead.""")
    def ip_whitelists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Field `ip_whitelist` has been deprecated from provider version 1.245.0. New field `ip_whitelists` instead.
        """
        return pulumi.get(self, "ip_whitelists")


@pulumi.output_type
class RocketMQInstanceNetworkInfoVpcInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceNetworkInfoVpcInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceNetworkInfoVpcInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceNetworkInfoVpcInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: _builtins.str,
                 security_group_ids: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None,
                 vswitches: Optional[Sequence['outputs.RocketMQInstanceNetworkInfoVpcInfoVswitch']] = None):
        """
        :param _builtins.str vpc_id: Proprietary Network.
        :param _builtins.str security_group_ids: Security group id.
        :param _builtins.str vswitch_id: VPC switch id.
        :param Sequence['RocketMQInstanceNetworkInfoVpcInfoVswitchArgs'] vswitches: Multiple VSwitches. At least two VSwitches are required for a serverless instance. See `vswitches` below.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitches is not None:
            pulumi.set(__self__, "vswitches", vswitches)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Proprietary Network.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[_builtins.str]:
        """
        Security group id.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    @_utilities.deprecated("""Field 'vswitch_id' has been deprecated from provider version 1.231.0. New field 'vswitches' instead.""")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        VPC switch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter
    def vswitches(self) -> Optional[Sequence['outputs.RocketMQInstanceNetworkInfoVpcInfoVswitch']]:
        """
        Multiple VSwitches. At least two VSwitches are required for a serverless instance. See `vswitches` below.
        """
        return pulumi.get(self, "vswitches")


@pulumi.output_type
class RocketMQInstanceNetworkInfoVpcInfoVswitch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceNetworkInfoVpcInfoVswitch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceNetworkInfoVpcInfoVswitch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceNetworkInfoVpcInfoVswitch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str vswitch_id: VPC switch id.
        """
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        VPC switch id.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class RocketMQInstanceProductInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "msgProcessSpec":
            suggest = "msg_process_spec"
        elif key == "autoScaling":
            suggest = "auto_scaling"
        elif key == "messageRetentionTime":
            suggest = "message_retention_time"
        elif key == "sendReceiveRatio":
            suggest = "send_receive_ratio"
        elif key == "storageEncryption":
            suggest = "storage_encryption"
        elif key == "storageSecretKey":
            suggest = "storage_secret_key"
        elif key == "supportAutoScaling":
            suggest = "support_auto_scaling"
        elif key == "traceOn":
            suggest = "trace_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceProductInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceProductInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceProductInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 msg_process_spec: _builtins.str,
                 auto_scaling: Optional[_builtins.bool] = None,
                 message_retention_time: Optional[_builtins.int] = None,
                 send_receive_ratio: Optional[_builtins.float] = None,
                 storage_encryption: Optional[_builtins.bool] = None,
                 storage_secret_key: Optional[_builtins.str] = None,
                 support_auto_scaling: Optional[_builtins.bool] = None,
                 trace_on: Optional[_builtins.bool] = None):
        """
        :param _builtins.str msg_process_spec: Message sending and receiving calculation specifications. For details about the upper limit for sending and receiving messages, see [Instance Specifications](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-specifications).
        :param _builtins.bool auto_scaling: is open auto scaling.
        :param _builtins.int message_retention_time: Duration of message retention. Unit: hours.  For the range of values, please refer to [Usage Limits](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/usage-limits)>Resource Quotas>Limitations on Message Retention.  The message storage in AlibabaCloud RocketMQ is fully implemented in a serverless and elastic manner, with charges based on the actual storage space. You can control the storage capacity of messages by adjusting the duration of message retention. For more information, please see [Storage Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/storage-fees).
        :param _builtins.float send_receive_ratio: message send receive ratio.  Value range: [0.2, 0.5].
        :param _builtins.bool storage_encryption: Specifies whether to enable the encryption at rest feature. Valid values: `true`, `false`.
        :param _builtins.str storage_secret_key: The key for encryption at rest.
        :param _builtins.bool support_auto_scaling: is support auto scaling.
        :param _builtins.bool trace_on: Whether to enable the message trace function. Valid values: `true`, `false`.
        """
        pulumi.set(__self__, "msg_process_spec", msg_process_spec)
        if auto_scaling is not None:
            pulumi.set(__self__, "auto_scaling", auto_scaling)
        if message_retention_time is not None:
            pulumi.set(__self__, "message_retention_time", message_retention_time)
        if send_receive_ratio is not None:
            pulumi.set(__self__, "send_receive_ratio", send_receive_ratio)
        if storage_encryption is not None:
            pulumi.set(__self__, "storage_encryption", storage_encryption)
        if storage_secret_key is not None:
            pulumi.set(__self__, "storage_secret_key", storage_secret_key)
        if support_auto_scaling is not None:
            pulumi.set(__self__, "support_auto_scaling", support_auto_scaling)
        if trace_on is not None:
            pulumi.set(__self__, "trace_on", trace_on)

    @_builtins.property
    @pulumi.getter(name="msgProcessSpec")
    def msg_process_spec(self) -> _builtins.str:
        """
        Message sending and receiving calculation specifications. For details about the upper limit for sending and receiving messages, see [Instance Specifications](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-specifications).
        """
        return pulumi.get(self, "msg_process_spec")

    @_builtins.property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> Optional[_builtins.bool]:
        """
        is open auto scaling.
        """
        return pulumi.get(self, "auto_scaling")

    @_builtins.property
    @pulumi.getter(name="messageRetentionTime")
    def message_retention_time(self) -> Optional[_builtins.int]:
        """
        Duration of message retention. Unit: hours.  For the range of values, please refer to [Usage Limits](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/usage-limits)>Resource Quotas>Limitations on Message Retention.  The message storage in AlibabaCloud RocketMQ is fully implemented in a serverless and elastic manner, with charges based on the actual storage space. You can control the storage capacity of messages by adjusting the duration of message retention. For more information, please see [Storage Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/storage-fees).
        """
        return pulumi.get(self, "message_retention_time")

    @_builtins.property
    @pulumi.getter(name="sendReceiveRatio")
    def send_receive_ratio(self) -> Optional[_builtins.float]:
        """
        message send receive ratio.  Value range: [0.2, 0.5].
        """
        return pulumi.get(self, "send_receive_ratio")

    @_builtins.property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the encryption at rest feature. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "storage_encryption")

    @_builtins.property
    @pulumi.getter(name="storageSecretKey")
    def storage_secret_key(self) -> Optional[_builtins.str]:
        """
        The key for encryption at rest.
        """
        return pulumi.get(self, "storage_secret_key")

    @_builtins.property
    @pulumi.getter(name="supportAutoScaling")
    def support_auto_scaling(self) -> Optional[_builtins.bool]:
        """
        is support auto scaling.
        """
        return pulumi.get(self, "support_auto_scaling")

    @_builtins.property
    @pulumi.getter(name="traceOn")
    def trace_on(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the message trace function. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "trace_on")


@pulumi.output_type
class RocketMQInstanceSoftware(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintainTime":
            suggest = "maintain_time"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "upgradeMethod":
            suggest = "upgrade_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RocketMQInstanceSoftware. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RocketMQInstanceSoftware.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RocketMQInstanceSoftware.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maintain_time: Optional[_builtins.str] = None,
                 software_version: Optional[_builtins.str] = None,
                 upgrade_method: Optional[_builtins.str] = None):
        """
        :param _builtins.str maintain_time: Upgrade time period.
        :param _builtins.str software_version: Software version.
        :param _builtins.str upgrade_method: Upgrade method.
        """
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if upgrade_method is not None:
            pulumi.set(__self__, "upgrade_method", upgrade_method)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[_builtins.str]:
        """
        Upgrade time period.
        """
        return pulumi.get(self, "maintain_time")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[_builtins.str]:
        """
        Software version.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter(name="upgradeMethod")
    def upgrade_method(self) -> Optional[_builtins.str]:
        """
        Upgrade method.
        """
        return pulumi.get(self, "upgrade_method")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 group_name: _builtins.str,
                 group_type: _builtins.str,
                 id: _builtins.str,
                 independent_naming: _builtins.bool,
                 instance_id: _builtins.str,
                 owner: _builtins.str,
                 remark: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str group_name: The name of the group.
        :param _builtins.str group_type: Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
        :param _builtins.str id: The name of the group.
        :param _builtins.bool independent_naming: Indicates whether namespaces are available. Read [Fields in SubscribeInfoDo](https://www.alibabacloud.com/help/doc-detail/29619.html) for further details.
        :param _builtins.str instance_id: ID of the ONS Instance that owns the groups.
        :param _builtins.str owner: The ID of the group owner, which is the Alibaba Cloud UID.
        :param _builtins.str remark: Remark of the group.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the Ons instance.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "independent_naming", independent_naming)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        The name of the group.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.str:
        """
        Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The name of the group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="independentNaming")
    def independent_naming(self) -> _builtins.bool:
        """
        Indicates whether namespaces are available. Read [Fields in SubscribeInfoDo](https://www.alibabacloud.com/help/doc-detail/29619.html) for further details.
        """
        return pulumi.get(self, "independent_naming")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the ONS Instance that owns the groups.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        The ID of the group owner, which is the Alibaba Cloud UID.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        Remark of the group.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the Ons instance.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 http_internal_endpoint: _builtins.str,
                 http_internet_endpoint: _builtins.str,
                 http_internet_secure_endpoint: _builtins.str,
                 id: _builtins.str,
                 independent_naming: _builtins.bool,
                 instance_id: _builtins.str,
                 instance_name: _builtins.str,
                 instance_status: _builtins.int,
                 instance_type: _builtins.int,
                 release_time: _builtins.str,
                 remark: _builtins.str,
                 status: _builtins.int,
                 tags: Mapping[str, _builtins.str],
                 tcp_endpoint: _builtins.str):
        """
        :param _builtins.str http_internal_endpoint: The internal HTTP endpoint for the Message Queue for Apache RocketMQ instance.
        :param _builtins.str http_internet_endpoint: The public HTTP endpoint for the Message Queue for Apache RocketMQ instance.
        :param _builtins.str http_internet_secure_endpoint: The public HTTPS endpoint for the Message Queue for Apache RocketMQ instance.
        :param _builtins.str id: ID of the instance.
        :param _builtins.bool independent_naming: Indicates whether any namespace is configured for the Message Queue for Apache RocketMQ instance.
        :param _builtins.str instance_id: ID of the instance.
        :param _builtins.str instance_name: Name of the instance.
        :param _builtins.int instance_status: The status of the instance. Read [Fields in InstanceVO](https://www.alibabacloud.com/help/doc-detail/106351.html) for further details.
        :param _builtins.int instance_type: The type of the instance. Read [Fields in InstanceVO](https://www.alibabacloud.com/help/doc-detail/106351.html) for further details.
        :param _builtins.str release_time: The automatic release time of an Enterprise Platinum Edition instance.
        :param _builtins.str remark: This attribute is a concise description of instance.
        :param _builtins.int status: The status of Ons instance. Valid values: `0` deploying, `2` arrears, `5` running, `7` upgrading.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the Ons instance.
        :param _builtins.str tcp_endpoint: The TCP endpoint for the Message Queue for Apache RocketMQ instance.
        """
        pulumi.set(__self__, "http_internal_endpoint", http_internal_endpoint)
        pulumi.set(__self__, "http_internet_endpoint", http_internet_endpoint)
        pulumi.set(__self__, "http_internet_secure_endpoint", http_internet_secure_endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "independent_naming", independent_naming)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_status", instance_status)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "release_time", release_time)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tcp_endpoint", tcp_endpoint)

    @_builtins.property
    @pulumi.getter(name="httpInternalEndpoint")
    def http_internal_endpoint(self) -> _builtins.str:
        """
        The internal HTTP endpoint for the Message Queue for Apache RocketMQ instance.
        """
        return pulumi.get(self, "http_internal_endpoint")

    @_builtins.property
    @pulumi.getter(name="httpInternetEndpoint")
    def http_internet_endpoint(self) -> _builtins.str:
        """
        The public HTTP endpoint for the Message Queue for Apache RocketMQ instance.
        """
        return pulumi.get(self, "http_internet_endpoint")

    @_builtins.property
    @pulumi.getter(name="httpInternetSecureEndpoint")
    def http_internet_secure_endpoint(self) -> _builtins.str:
        """
        The public HTTPS endpoint for the Message Queue for Apache RocketMQ instance.
        """
        return pulumi.get(self, "http_internet_secure_endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="independentNaming")
    def independent_naming(self) -> _builtins.bool:
        """
        Indicates whether any namespace is configured for the Message Queue for Apache RocketMQ instance.
        """
        return pulumi.get(self, "independent_naming")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        Name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> _builtins.int:
        """
        The status of the instance. Read [Fields in InstanceVO](https://www.alibabacloud.com/help/doc-detail/106351.html) for further details.
        """
        return pulumi.get(self, "instance_status")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.int:
        """
        The type of the instance. Read [Fields in InstanceVO](https://www.alibabacloud.com/help/doc-detail/106351.html) for further details.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> _builtins.str:
        """
        The automatic release time of an Enterprise Platinum Edition instance.
        """
        return pulumi.get(self, "release_time")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        This attribute is a concise description of instance.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The status of Ons instance. Valid values: `0` deploying, `2` arrears, `5` running, `7` upgrading.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the Ons instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tcpEndpoint")
    def tcp_endpoint(self) -> _builtins.str:
        """
        The TCP endpoint for the Message Queue for Apache RocketMQ instance.
        """
        return pulumi.get(self, "tcp_endpoint")


@pulumi.output_type
class GetTopicsTopicResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 independent_naming: _builtins.bool,
                 instance_id: _builtins.str,
                 message_type: _builtins.int,
                 owner: _builtins.str,
                 perm: _builtins.int,
                 relation: _builtins.int,
                 relation_name: _builtins.str,
                 remark: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 topic: _builtins.str,
                 topic_name: _builtins.str):
        """
        :param _builtins.str id: The id of the topic.
        :param _builtins.bool independent_naming: Indicates whether namespaces are available. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
        :param _builtins.str instance_id: ID of the ONS Instance that owns the topics.
        :param _builtins.int message_type: The type of the message. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
        :param _builtins.str owner: The ID of the topic owner, which is the Alibaba Cloud UID.
        :param _builtins.int perm: This attribute is used to set the read-write mode for the topic.
        :param _builtins.int relation: The relation ID. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
        :param _builtins.str relation_name: The name of the relation, for example, owner, publishable, subscribable, and publishable and subscribable.
        :param _builtins.str remark: Remark of the topic.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the Ons instance.
        :param _builtins.str topic: The name of the topic.
        :param _builtins.str topic_name: The name of the topic.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "independent_naming", independent_naming)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "message_type", message_type)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "perm", perm)
        pulumi.set(__self__, "relation", relation)
        pulumi.set(__self__, "relation_name", relation_name)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "topic_name", topic_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the topic.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="independentNaming")
    def independent_naming(self) -> _builtins.bool:
        """
        Indicates whether namespaces are available. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
        """
        return pulumi.get(self, "independent_naming")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the ONS Instance that owns the topics.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> _builtins.int:
        """
        The type of the message. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        The ID of the topic owner, which is the Alibaba Cloud UID.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def perm(self) -> _builtins.int:
        """
        This attribute is used to set the read-write mode for the topic.
        """
        return pulumi.get(self, "perm")

    @_builtins.property
    @pulumi.getter
    def relation(self) -> _builtins.int:
        """
        The relation ID. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
        """
        return pulumi.get(self, "relation")

    @_builtins.property
    @pulumi.getter(name="relationName")
    def relation_name(self) -> _builtins.str:
        """
        The name of the relation, for example, owner, publishable, subscribable, and publishable and subscribable.
        """
        return pulumi.get(self, "relation_name")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        Remark of the topic.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the Ons instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The name of the topic.
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> _builtins.str:
        """
        The name of the topic.
        """
        return pulumi.get(self, "topic_name")


