# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['QosPolicyArgs', 'QosPolicy']

@pulumi.input_type
class QosPolicyArgs:
    def __init__(__self__, *,
                 dest_cidr: pulumi.Input[_builtins.str],
                 dest_port_range: pulumi.Input[_builtins.str],
                 ip_protocol: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int],
                 qos_id: pulumi.Input[_builtins.str],
                 source_cidr: pulumi.Input[_builtins.str],
                 source_port_range: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a QosPolicy resource.
        :param pulumi.Input[_builtins.str] dest_cidr: The destination CIDR block.
        :param pulumi.Input[_builtins.str] dest_port_range: The destination port range.
        :param pulumi.Input[_builtins.str] ip_protocol: The transport layer protocol.
        :param pulumi.Input[_builtins.int] priority: The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        :param pulumi.Input[_builtins.str] qos_id: The instance ID of the QoS policy to which the quintuple rule is created.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block.
        :param pulumi.Input[_builtins.str] source_port_range: The source port range of the transport layer.
        :param pulumi.Input[_builtins.str] description: The description of the QoS policy.
        :param pulumi.Input[_builtins.str] end_time: The expiration time of the quintuple rule.
        :param pulumi.Input[_builtins.str] name: The name of the QoS policy.
        :param pulumi.Input[_builtins.str] start_time: The time when the quintuple rule takes effect.
        """
        pulumi.set(__self__, "dest_cidr", dest_cidr)
        pulumi.set(__self__, "dest_port_range", dest_port_range)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "qos_id", qos_id)
        pulumi.set(__self__, "source_cidr", source_cidr)
        pulumi.set(__self__, "source_port_range", source_port_range)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="destCidr")
    def dest_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "dest_cidr")

    @dest_cidr.setter
    def dest_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dest_cidr", value)

    @_builtins.property
    @pulumi.getter(name="destPortRange")
    def dest_port_range(self) -> pulumi.Input[_builtins.str]:
        """
        The destination port range.
        """
        return pulumi.get(self, "dest_port_range")

    @dest_port_range.setter
    def dest_port_range(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dest_port_range", value)

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The transport layer protocol.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_protocol", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID of the QoS policy to which the quintuple rule is created.
        """
        return pulumi.get(self, "qos_id")

    @qos_id.setter
    def qos_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "qos_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        The source CIDR block.
        """
        return pulumi.get(self, "source_cidr")

    @source_cidr.setter
    def source_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_cidr", value)

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> pulumi.Input[_builtins.str]:
        """
        The source port range of the transport layer.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_port_range", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the QoS policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the quintuple rule.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the QoS policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the quintuple rule takes effect.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _QosPolicyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QosPolicy resources.
        :param pulumi.Input[_builtins.str] description: The description of the QoS policy.
        :param pulumi.Input[_builtins.str] dest_cidr: The destination CIDR block.
        :param pulumi.Input[_builtins.str] dest_port_range: The destination port range.
        :param pulumi.Input[_builtins.str] end_time: The expiration time of the quintuple rule.
        :param pulumi.Input[_builtins.str] ip_protocol: The transport layer protocol.
        :param pulumi.Input[_builtins.str] name: The name of the QoS policy.
        :param pulumi.Input[_builtins.int] priority: The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        :param pulumi.Input[_builtins.str] qos_id: The instance ID of the QoS policy to which the quintuple rule is created.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block.
        :param pulumi.Input[_builtins.str] source_port_range: The source port range of the transport layer.
        :param pulumi.Input[_builtins.str] start_time: The time when the quintuple rule takes effect.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_cidr is not None:
            pulumi.set(__self__, "dest_cidr", dest_cidr)
        if dest_port_range is not None:
            pulumi.set(__self__, "dest_port_range", dest_port_range)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if qos_id is not None:
            pulumi.set(__self__, "qos_id", qos_id)
        if source_cidr is not None:
            pulumi.set(__self__, "source_cidr", source_cidr)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the QoS policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destCidr")
    def dest_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "dest_cidr")

    @dest_cidr.setter
    def dest_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_cidr", value)

    @_builtins.property
    @pulumi.getter(name="destPortRange")
    def dest_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port range.
        """
        return pulumi.get(self, "dest_port_range")

    @dest_port_range.setter
    def dest_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_range", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the quintuple rule.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The transport layer protocol.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the QoS policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID of the QoS policy to which the quintuple rule is created.
        """
        return pulumi.get(self, "qos_id")

    @qos_id.setter
    def qos_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source CIDR block.
        """
        return pulumi.get(self, "source_cidr")

    @source_cidr.setter
    def source_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr", value)

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source port range of the transport layer.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port_range", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the quintuple rule takes effect.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.type_token("alicloud:sag/qosPolicy:QosPolicy")
class QosPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sag qos policy resource.
        You need to create a QoS policy to set priorities, rate limits, and quintuple rules for different messages.

        For information about Sag Qos Policy and how to use it, see [What is Qos Policy](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqospolicy).

        > **NOTE:** Available since v1.60.0.

        > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std
        import pulumi_time as time

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.sag.Qos("default", name=name)
        example = time.index.Static("example")
        default_qos_policy = alicloud.sag.QosPolicy("default",
            qos_id=default.id,
            name=name,
            description=name,
            priority=1,
            ip_protocol="ALL",
            source_cidr="192.168.0.0/24",
            source_port_range="-1/-1",
            dest_cidr="10.10.0.0/24",
            dest_port_range="-1/-1",
            start_time=std.replace(text=example["rfc3339"],
                search="Z",
                replace="+0800").result,
            end_time=std.replace(text=std.timeadd(duration=example["rfc3339"],
                    timestamp="24h").result,
                search="Z",
                replace="+0800").result)
        ```

        ## Import

        The Sag Qos Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sag/qosPolicy:QosPolicy example qos-abc123456:qospy-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the QoS policy.
        :param pulumi.Input[_builtins.str] dest_cidr: The destination CIDR block.
        :param pulumi.Input[_builtins.str] dest_port_range: The destination port range.
        :param pulumi.Input[_builtins.str] end_time: The expiration time of the quintuple rule.
        :param pulumi.Input[_builtins.str] ip_protocol: The transport layer protocol.
        :param pulumi.Input[_builtins.str] name: The name of the QoS policy.
        :param pulumi.Input[_builtins.int] priority: The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        :param pulumi.Input[_builtins.str] qos_id: The instance ID of the QoS policy to which the quintuple rule is created.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block.
        :param pulumi.Input[_builtins.str] source_port_range: The source port range of the transport layer.
        :param pulumi.Input[_builtins.str] start_time: The time when the quintuple rule takes effect.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QosPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sag qos policy resource.
        You need to create a QoS policy to set priorities, rate limits, and quintuple rules for different messages.

        For information about Sag Qos Policy and how to use it, see [What is Qos Policy](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqospolicy).

        > **NOTE:** Available since v1.60.0.

        > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std
        import pulumi_time as time

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.sag.Qos("default", name=name)
        example = time.index.Static("example")
        default_qos_policy = alicloud.sag.QosPolicy("default",
            qos_id=default.id,
            name=name,
            description=name,
            priority=1,
            ip_protocol="ALL",
            source_cidr="192.168.0.0/24",
            source_port_range="-1/-1",
            dest_cidr="10.10.0.0/24",
            dest_port_range="-1/-1",
            start_time=std.replace(text=example["rfc3339"],
                search="Z",
                replace="+0800").result,
            end_time=std.replace(text=std.timeadd(duration=example["rfc3339"],
                    timestamp="24h").result,
                search="Z",
                replace="+0800").result)
        ```

        ## Import

        The Sag Qos Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sag/qosPolicy:QosPolicy example qos-abc123456:qospy-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param QosPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QosPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QosPolicyArgs.__new__(QosPolicyArgs)

            __props__.__dict__["description"] = description
            if dest_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'dest_cidr'")
            __props__.__dict__["dest_cidr"] = dest_cidr
            if dest_port_range is None and not opts.urn:
                raise TypeError("Missing required property 'dest_port_range'")
            __props__.__dict__["dest_port_range"] = dest_port_range
            __props__.__dict__["end_time"] = end_time
            if ip_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'ip_protocol'")
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if qos_id is None and not opts.urn:
                raise TypeError("Missing required property 'qos_id'")
            __props__.__dict__["qos_id"] = qos_id
            if source_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'source_cidr'")
            __props__.__dict__["source_cidr"] = source_cidr
            if source_port_range is None and not opts.urn:
                raise TypeError("Missing required property 'source_port_range'")
            __props__.__dict__["source_port_range"] = source_port_range
            __props__.__dict__["start_time"] = start_time
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="alicloud:rocketmq/qosPolicy:QosPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(QosPolicy, __self__).__init__(
            'alicloud:sag/qosPolicy:QosPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dest_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_range: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            qos_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            source_port_range: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'QosPolicy':
        """
        Get an existing QosPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the QoS policy.
        :param pulumi.Input[_builtins.str] dest_cidr: The destination CIDR block.
        :param pulumi.Input[_builtins.str] dest_port_range: The destination port range.
        :param pulumi.Input[_builtins.str] end_time: The expiration time of the quintuple rule.
        :param pulumi.Input[_builtins.str] ip_protocol: The transport layer protocol.
        :param pulumi.Input[_builtins.str] name: The name of the QoS policy.
        :param pulumi.Input[_builtins.int] priority: The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        :param pulumi.Input[_builtins.str] qos_id: The instance ID of the QoS policy to which the quintuple rule is created.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block.
        :param pulumi.Input[_builtins.str] source_port_range: The source port range of the transport layer.
        :param pulumi.Input[_builtins.str] start_time: The time when the quintuple rule takes effect.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QosPolicyState.__new__(_QosPolicyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dest_cidr"] = dest_cidr
        __props__.__dict__["dest_port_range"] = dest_port_range
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["qos_id"] = qos_id
        __props__.__dict__["source_cidr"] = source_cidr
        __props__.__dict__["source_port_range"] = source_port_range
        __props__.__dict__["start_time"] = start_time
        return QosPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the QoS policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destCidr")
    def dest_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "dest_cidr")

    @_builtins.property
    @pulumi.getter(name="destPortRange")
    def dest_port_range(self) -> pulumi.Output[_builtins.str]:
        """
        The destination port range.
        """
        return pulumi.get(self, "dest_port_range")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expiration time of the quintuple rule.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The transport layer protocol.
        """
        return pulumi.get(self, "ip_protocol")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the QoS policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID of the QoS policy to which the quintuple rule is created.
        """
        return pulumi.get(self, "qos_id")

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The source CIDR block.
        """
        return pulumi.get(self, "source_cidr")

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> pulumi.Output[_builtins.str]:
        """
        The source port range of the transport layer.
        """
        return pulumi.get(self, "source_port_range")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time when the quintuple rule takes effect.
        """
        return pulumi.get(self, "start_time")

