# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 execute_mode: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 job_name: pulumi.Input[_builtins.str],
                 job_type: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 time_config: pulumi.Input['JobTimeConfigArgs'],
                 attempt_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 class_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 job_monitor_info: Optional[pulumi.Input['JobJobMonitorInfoArgs']] = None,
                 map_task_xattrs: Optional[pulumi.Input['JobMapTaskXattrsArgs']] = None,
                 max_attempt: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 success_notice_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 task_dispatch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 x_attrs: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.str] execute_mode: Task execution mode, the possible results are as follows:
        :param pulumi.Input[_builtins.str] group_id: The application ID, which is obtained from the **application management** page of the console.
        :param pulumi.Input[_builtins.str] job_name: JobName
        :param pulumi.Input[_builtins.str] job_type: Job Type
        :param pulumi.Input[_builtins.str] namespace: Namespace, which is obtained on the `Namespace` page of the console.
        :param pulumi.Input['JobTimeConfigArgs'] time_config: Time configuration information See `time_config` below.
        :param pulumi.Input[_builtins.int] attempt_interval: Error retry interval, unit s, default value 30.
        :param pulumi.Input[_builtins.str] class_name: Full path of the task interface class.
               
               This field is available only when your task is of the Java task type.
        :param pulumi.Input[_builtins.str] content: The script code of the python, shell, and go task types.
        :param pulumi.Input[_builtins.str] description: Task description.
        :param pulumi.Input[_builtins.int] fail_times: Number of consecutive failed alarms
        :param pulumi.Input['JobJobMonitorInfoArgs'] job_monitor_info: Task monitoring information See `job_monitor_info` below.
        :param pulumi.Input['JobMapTaskXattrsArgs'] map_task_xattrs: Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        :param pulumi.Input[_builtins.int] max_attempt: The maximum number of error retries, which is set based on business requirements. The default value is 0.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.str] namespace_source: Special third parties are required.
        :param pulumi.Input[_builtins.str] parameters: User-defined parameters, which can be obtained at runtime.
        :param pulumi.Input[_builtins.str] status: Task status. The values are as follows:
        :param pulumi.Input[_builtins.bool] success_notice_enable: Success Notification Switch
        :param pulumi.Input[_builtins.str] task_dispatch_mode: Advanced configuration of parallel grid tasks, push model or pull model
        :param pulumi.Input[_builtins.str] template: K8s task type custom task template
        :param pulumi.Input[_builtins.str] timezone: Time Zone
        :param pulumi.Input[_builtins.str] x_attrs: Task Extension Field
        """
        pulumi.set(__self__, "execute_mode", execute_mode)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "time_config", time_config)
        if attempt_interval is not None:
            pulumi.set(__self__, "attempt_interval", attempt_interval)
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fail_times is not None:
            pulumi.set(__self__, "fail_times", fail_times)
        if job_monitor_info is not None:
            pulumi.set(__self__, "job_monitor_info", job_monitor_info)
        if map_task_xattrs is not None:
            pulumi.set(__self__, "map_task_xattrs", map_task_xattrs)
        if max_attempt is not None:
            pulumi.set(__self__, "max_attempt", max_attempt)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if namespace_source is not None:
            pulumi.set(__self__, "namespace_source", namespace_source)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if success_notice_enable is not None:
            pulumi.set(__self__, "success_notice_enable", success_notice_enable)
        if task_dispatch_mode is not None:
            pulumi.set(__self__, "task_dispatch_mode", task_dispatch_mode)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if x_attrs is not None:
            pulumi.set(__self__, "x_attrs", x_attrs)

    @_builtins.property
    @pulumi.getter(name="executeMode")
    def execute_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Task execution mode, the possible results are as follows:
        """
        return pulumi.get(self, "execute_mode")

    @execute_mode.setter
    def execute_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execute_mode", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The application ID, which is obtained from the **application management** page of the console.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[_builtins.str]:
        """
        JobName
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_name", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[_builtins.str]:
        """
        Job Type
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        Namespace, which is obtained on the `Namespace` page of the console.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="timeConfig")
    def time_config(self) -> pulumi.Input['JobTimeConfigArgs']:
        """
        Time configuration information See `time_config` below.
        """
        return pulumi.get(self, "time_config")

    @time_config.setter
    def time_config(self, value: pulumi.Input['JobTimeConfigArgs']):
        pulumi.set(self, "time_config", value)

    @_builtins.property
    @pulumi.getter(name="attemptInterval")
    def attempt_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Error retry interval, unit s, default value 30.
        """
        return pulumi.get(self, "attempt_interval")

    @attempt_interval.setter
    def attempt_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "attempt_interval", value)

    @_builtins.property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path of the task interface class.

        This field is available only when your task is of the Java task type.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "class_name", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The script code of the python, shell, and go task types.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="failTimes")
    def fail_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive failed alarms
        """
        return pulumi.get(self, "fail_times")

    @fail_times.setter
    def fail_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fail_times", value)

    @_builtins.property
    @pulumi.getter(name="jobMonitorInfo")
    def job_monitor_info(self) -> Optional[pulumi.Input['JobJobMonitorInfoArgs']]:
        """
        Task monitoring information See `job_monitor_info` below.
        """
        return pulumi.get(self, "job_monitor_info")

    @job_monitor_info.setter
    def job_monitor_info(self, value: Optional[pulumi.Input['JobJobMonitorInfoArgs']]):
        pulumi.set(self, "job_monitor_info", value)

    @_builtins.property
    @pulumi.getter(name="mapTaskXattrs")
    def map_task_xattrs(self) -> Optional[pulumi.Input['JobMapTaskXattrsArgs']]:
        """
        Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        """
        return pulumi.get(self, "map_task_xattrs")

    @map_task_xattrs.setter
    def map_task_xattrs(self, value: Optional[pulumi.Input['JobMapTaskXattrsArgs']]):
        pulumi.set(self, "map_task_xattrs", value)

    @_builtins.property
    @pulumi.getter(name="maxAttempt")
    def max_attempt(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of error retries, which is set based on business requirements. The default value is 0.
        """
        return pulumi.get(self, "max_attempt")

    @max_attempt.setter
    def max_attempt(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_attempt", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="namespaceSource")
    def namespace_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Special third parties are required.
        """
        return pulumi.get(self, "namespace_source")

    @namespace_source.setter
    def namespace_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_source", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined parameters, which can be obtained at runtime.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task status. The values are as follows:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="successNoticeEnable")
    def success_notice_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Success Notification Switch
        """
        return pulumi.get(self, "success_notice_enable")

    @success_notice_enable.setter
    def success_notice_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "success_notice_enable", value)

    @_builtins.property
    @pulumi.getter(name="taskDispatchMode")
    def task_dispatch_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Advanced configuration of parallel grid tasks, push model or pull model
        """
        return pulumi.get(self, "task_dispatch_mode")

    @task_dispatch_mode.setter
    def task_dispatch_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_dispatch_mode", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        K8s task type custom task template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Zone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="xAttrs")
    def x_attrs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task Extension Field
        """
        return pulumi.get(self, "x_attrs")

    @x_attrs.setter
    def x_attrs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_attrs", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 attempt_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 class_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 job_monitor_info: Optional[pulumi.Input['JobJobMonitorInfoArgs']] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 map_task_xattrs: Optional[pulumi.Input['JobMapTaskXattrsArgs']] = None,
                 max_attempt: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 success_notice_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 task_dispatch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 time_config: Optional[pulumi.Input['JobTimeConfigArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 x_attrs: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[_builtins.int] attempt_interval: Error retry interval, unit s, default value 30.
        :param pulumi.Input[_builtins.str] class_name: Full path of the task interface class.
               
               This field is available only when your task is of the Java task type.
        :param pulumi.Input[_builtins.str] content: The script code of the python, shell, and go task types.
        :param pulumi.Input[_builtins.str] description: Task description.
        :param pulumi.Input[_builtins.str] execute_mode: Task execution mode, the possible results are as follows:
        :param pulumi.Input[_builtins.int] fail_times: Number of consecutive failed alarms
        :param pulumi.Input[_builtins.str] group_id: The application ID, which is obtained from the **application management** page of the console.
        :param pulumi.Input[_builtins.int] job_id: JobId
        :param pulumi.Input['JobJobMonitorInfoArgs'] job_monitor_info: Task monitoring information See `job_monitor_info` below.
        :param pulumi.Input[_builtins.str] job_name: JobName
        :param pulumi.Input[_builtins.str] job_type: Job Type
        :param pulumi.Input['JobMapTaskXattrsArgs'] map_task_xattrs: Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        :param pulumi.Input[_builtins.int] max_attempt: The maximum number of error retries, which is set based on business requirements. The default value is 0.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.str] namespace: Namespace, which is obtained on the `Namespace` page of the console.
        :param pulumi.Input[_builtins.str] namespace_source: Special third parties are required.
        :param pulumi.Input[_builtins.str] parameters: User-defined parameters, which can be obtained at runtime.
        :param pulumi.Input[_builtins.str] status: Task status. The values are as follows:
        :param pulumi.Input[_builtins.bool] success_notice_enable: Success Notification Switch
        :param pulumi.Input[_builtins.str] task_dispatch_mode: Advanced configuration of parallel grid tasks, push model or pull model
        :param pulumi.Input[_builtins.str] template: K8s task type custom task template
        :param pulumi.Input['JobTimeConfigArgs'] time_config: Time configuration information See `time_config` below.
        :param pulumi.Input[_builtins.str] timezone: Time Zone
        :param pulumi.Input[_builtins.str] x_attrs: Task Extension Field
        """
        if attempt_interval is not None:
            pulumi.set(__self__, "attempt_interval", attempt_interval)
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_mode is not None:
            pulumi.set(__self__, "execute_mode", execute_mode)
        if fail_times is not None:
            pulumi.set(__self__, "fail_times", fail_times)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_monitor_info is not None:
            pulumi.set(__self__, "job_monitor_info", job_monitor_info)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if map_task_xattrs is not None:
            pulumi.set(__self__, "map_task_xattrs", map_task_xattrs)
        if max_attempt is not None:
            pulumi.set(__self__, "max_attempt", max_attempt)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if namespace_source is not None:
            pulumi.set(__self__, "namespace_source", namespace_source)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if success_notice_enable is not None:
            pulumi.set(__self__, "success_notice_enable", success_notice_enable)
        if task_dispatch_mode is not None:
            pulumi.set(__self__, "task_dispatch_mode", task_dispatch_mode)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if time_config is not None:
            pulumi.set(__self__, "time_config", time_config)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if x_attrs is not None:
            pulumi.set(__self__, "x_attrs", x_attrs)

    @_builtins.property
    @pulumi.getter(name="attemptInterval")
    def attempt_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Error retry interval, unit s, default value 30.
        """
        return pulumi.get(self, "attempt_interval")

    @attempt_interval.setter
    def attempt_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "attempt_interval", value)

    @_builtins.property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path of the task interface class.

        This field is available only when your task is of the Java task type.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "class_name", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The script code of the python, shell, and go task types.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeMode")
    def execute_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task execution mode, the possible results are as follows:
        """
        return pulumi.get(self, "execute_mode")

    @execute_mode.setter
    def execute_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execute_mode", value)

    @_builtins.property
    @pulumi.getter(name="failTimes")
    def fail_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive failed alarms
        """
        return pulumi.get(self, "fail_times")

    @fail_times.setter
    def fail_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fail_times", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application ID, which is obtained from the **application management** page of the console.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        JobId
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobMonitorInfo")
    def job_monitor_info(self) -> Optional[pulumi.Input['JobJobMonitorInfoArgs']]:
        """
        Task monitoring information See `job_monitor_info` below.
        """
        return pulumi.get(self, "job_monitor_info")

    @job_monitor_info.setter
    def job_monitor_info(self, value: Optional[pulumi.Input['JobJobMonitorInfoArgs']]):
        pulumi.set(self, "job_monitor_info", value)

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JobName
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_name", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job Type
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter(name="mapTaskXattrs")
    def map_task_xattrs(self) -> Optional[pulumi.Input['JobMapTaskXattrsArgs']]:
        """
        Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        """
        return pulumi.get(self, "map_task_xattrs")

    @map_task_xattrs.setter
    def map_task_xattrs(self, value: Optional[pulumi.Input['JobMapTaskXattrsArgs']]):
        pulumi.set(self, "map_task_xattrs", value)

    @_builtins.property
    @pulumi.getter(name="maxAttempt")
    def max_attempt(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of error retries, which is set based on business requirements. The default value is 0.
        """
        return pulumi.get(self, "max_attempt")

    @max_attempt.setter
    def max_attempt(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_attempt", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace, which is obtained on the `Namespace` page of the console.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="namespaceSource")
    def namespace_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Special third parties are required.
        """
        return pulumi.get(self, "namespace_source")

    @namespace_source.setter
    def namespace_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_source", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined parameters, which can be obtained at runtime.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task status. The values are as follows:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="successNoticeEnable")
    def success_notice_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Success Notification Switch
        """
        return pulumi.get(self, "success_notice_enable")

    @success_notice_enable.setter
    def success_notice_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "success_notice_enable", value)

    @_builtins.property
    @pulumi.getter(name="taskDispatchMode")
    def task_dispatch_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Advanced configuration of parallel grid tasks, push model or pull model
        """
        return pulumi.get(self, "task_dispatch_mode")

    @task_dispatch_mode.setter
    def task_dispatch_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_dispatch_mode", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        K8s task type custom task template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter(name="timeConfig")
    def time_config(self) -> Optional[pulumi.Input['JobTimeConfigArgs']]:
        """
        Time configuration information See `time_config` below.
        """
        return pulumi.get(self, "time_config")

    @time_config.setter
    def time_config(self, value: Optional[pulumi.Input['JobTimeConfigArgs']]):
        pulumi.set(self, "time_config", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Zone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="xAttrs")
    def x_attrs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task Extension Field
        """
        return pulumi.get(self, "x_attrs")

    @x_attrs.setter
    def x_attrs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_attrs", value)


@pulumi.type_token("alicloud:schedulerx/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attempt_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 class_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_monitor_info: Optional[pulumi.Input[Union['JobJobMonitorInfoArgs', 'JobJobMonitorInfoArgsDict']]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 map_task_xattrs: Optional[pulumi.Input[Union['JobMapTaskXattrsArgs', 'JobMapTaskXattrsArgsDict']]] = None,
                 max_attempt: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 success_notice_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 task_dispatch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 time_config: Optional[pulumi.Input[Union['JobTimeConfigArgs', 'JobTimeConfigArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 x_attrs: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Schedulerx Job resource.

        For information about Schedulerx Job and how to use it, see [What is Job](https://www.alibabacloud.com/help/en/schedulerx/schedulerx-serverless/developer-reference/api-schedulerx2-2019-04-30-createjob).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        create_name_space = alicloud.schedulerx.Namespace("CreateNameSpace",
            namespace_name=name,
            description=name)
        default = alicloud.schedulerx.AppGroup("default",
            max_jobs=100,
            monitor_contacts_json=json.dumps([
                {
                    "userName": "name1",
                    "userPhone": "89756******",
                },
                {
                    "userName": "name2",
                    "ding": "http://www.example.com",
                },
            ]),
            delete_jobs=False,
            app_type=1,
            namespace_source="schedulerx",
            group_id="example-appgroup-pop-autoexample",
            namespace_name="default",
            description=name,
            monitor_config_json=json.dumps({
                "sendChannel": "sms,ding",
            }),
            app_version="1",
            app_name="example-appgroup-pop-autoexample",
            namespace=create_name_space.namespace_uid,
            enable_log=False,
            schedule_busy_workers=False)
        default_job = alicloud.schedulerx.Job("default",
            timezone="GTM+7",
            status="Enable",
            max_attempt=0,
            description=name,
            parameters="hello word",
            job_name=name,
            max_concurrency="1",
            time_config={
                "data_offset": 1,
                "time_expression": "100000",
                "time_type": 3,
                "calendar": "workday",
            },
            map_task_xattrs={
                "task_max_attempt": 1,
                "task_attempt_interval": 1,
                "consumer_size": 5,
                "queue_size": 10000,
                "dispatcher_size": 5,
                "page_size": 100,
            },
            namespace=create_name_space.namespace_uid,
            group_id=default.group_id,
            job_type="java",
            job_monitor_info={
                "contact_infos": [
                    {
                        "user_phone": "12345678910",
                        "user_name": "tangtao-1",
                        "ding": "https://alidocs.dingtalk.com",
                        "user_mail": "12345678@xx.com",
                    },
                    {
                        "user_phone": "12345678910",
                        "user_name": "tangtao-2",
                        "ding": "https://alidocs.dingtalk.com1",
                        "user_mail": "123456789@xx.com",
                    },
                ],
                "monitor_config": {
                    "timeout": 7200,
                    "send_channel": "sms",
                    "timeout_kill_enable": True,
                    "timeout_enable": True,
                    "fail_enable": True,
                    "miss_worker_enable": True,
                },
            },
            class_name="com.aliyun.schedulerx.example.processor.SimpleJob",
            namespace_source="schedulerx",
            attempt_interval=30,
            fail_times=1,
            execute_mode="batch")
        ```

        ## Import

        Schedulerx Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:schedulerx/job:Job example <namespace>:<group_id>:<job_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] attempt_interval: Error retry interval, unit s, default value 30.
        :param pulumi.Input[_builtins.str] class_name: Full path of the task interface class.
               
               This field is available only when your task is of the Java task type.
        :param pulumi.Input[_builtins.str] content: The script code of the python, shell, and go task types.
        :param pulumi.Input[_builtins.str] description: Task description.
        :param pulumi.Input[_builtins.str] execute_mode: Task execution mode, the possible results are as follows:
        :param pulumi.Input[_builtins.int] fail_times: Number of consecutive failed alarms
        :param pulumi.Input[_builtins.str] group_id: The application ID, which is obtained from the **application management** page of the console.
        :param pulumi.Input[Union['JobJobMonitorInfoArgs', 'JobJobMonitorInfoArgsDict']] job_monitor_info: Task monitoring information See `job_monitor_info` below.
        :param pulumi.Input[_builtins.str] job_name: JobName
        :param pulumi.Input[_builtins.str] job_type: Job Type
        :param pulumi.Input[Union['JobMapTaskXattrsArgs', 'JobMapTaskXattrsArgsDict']] map_task_xattrs: Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        :param pulumi.Input[_builtins.int] max_attempt: The maximum number of error retries, which is set based on business requirements. The default value is 0.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.str] namespace: Namespace, which is obtained on the `Namespace` page of the console.
        :param pulumi.Input[_builtins.str] namespace_source: Special third parties are required.
        :param pulumi.Input[_builtins.str] parameters: User-defined parameters, which can be obtained at runtime.
        :param pulumi.Input[_builtins.str] status: Task status. The values are as follows:
        :param pulumi.Input[_builtins.bool] success_notice_enable: Success Notification Switch
        :param pulumi.Input[_builtins.str] task_dispatch_mode: Advanced configuration of parallel grid tasks, push model or pull model
        :param pulumi.Input[_builtins.str] template: K8s task type custom task template
        :param pulumi.Input[Union['JobTimeConfigArgs', 'JobTimeConfigArgsDict']] time_config: Time configuration information See `time_config` below.
        :param pulumi.Input[_builtins.str] timezone: Time Zone
        :param pulumi.Input[_builtins.str] x_attrs: Task Extension Field
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Schedulerx Job resource.

        For information about Schedulerx Job and how to use it, see [What is Job](https://www.alibabacloud.com/help/en/schedulerx/schedulerx-serverless/developer-reference/api-schedulerx2-2019-04-30-createjob).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        create_name_space = alicloud.schedulerx.Namespace("CreateNameSpace",
            namespace_name=name,
            description=name)
        default = alicloud.schedulerx.AppGroup("default",
            max_jobs=100,
            monitor_contacts_json=json.dumps([
                {
                    "userName": "name1",
                    "userPhone": "89756******",
                },
                {
                    "userName": "name2",
                    "ding": "http://www.example.com",
                },
            ]),
            delete_jobs=False,
            app_type=1,
            namespace_source="schedulerx",
            group_id="example-appgroup-pop-autoexample",
            namespace_name="default",
            description=name,
            monitor_config_json=json.dumps({
                "sendChannel": "sms,ding",
            }),
            app_version="1",
            app_name="example-appgroup-pop-autoexample",
            namespace=create_name_space.namespace_uid,
            enable_log=False,
            schedule_busy_workers=False)
        default_job = alicloud.schedulerx.Job("default",
            timezone="GTM+7",
            status="Enable",
            max_attempt=0,
            description=name,
            parameters="hello word",
            job_name=name,
            max_concurrency="1",
            time_config={
                "data_offset": 1,
                "time_expression": "100000",
                "time_type": 3,
                "calendar": "workday",
            },
            map_task_xattrs={
                "task_max_attempt": 1,
                "task_attempt_interval": 1,
                "consumer_size": 5,
                "queue_size": 10000,
                "dispatcher_size": 5,
                "page_size": 100,
            },
            namespace=create_name_space.namespace_uid,
            group_id=default.group_id,
            job_type="java",
            job_monitor_info={
                "contact_infos": [
                    {
                        "user_phone": "12345678910",
                        "user_name": "tangtao-1",
                        "ding": "https://alidocs.dingtalk.com",
                        "user_mail": "12345678@xx.com",
                    },
                    {
                        "user_phone": "12345678910",
                        "user_name": "tangtao-2",
                        "ding": "https://alidocs.dingtalk.com1",
                        "user_mail": "123456789@xx.com",
                    },
                ],
                "monitor_config": {
                    "timeout": 7200,
                    "send_channel": "sms",
                    "timeout_kill_enable": True,
                    "timeout_enable": True,
                    "fail_enable": True,
                    "miss_worker_enable": True,
                },
            },
            class_name="com.aliyun.schedulerx.example.processor.SimpleJob",
            namespace_source="schedulerx",
            attempt_interval=30,
            fail_times=1,
            execute_mode="batch")
        ```

        ## Import

        Schedulerx Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:schedulerx/job:Job example <namespace>:<group_id>:<job_id>
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attempt_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 class_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_monitor_info: Optional[pulumi.Input[Union['JobJobMonitorInfoArgs', 'JobJobMonitorInfoArgsDict']]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 map_task_xattrs: Optional[pulumi.Input[Union['JobMapTaskXattrsArgs', 'JobMapTaskXattrsArgsDict']]] = None,
                 max_attempt: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 success_notice_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 task_dispatch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 time_config: Optional[pulumi.Input[Union['JobTimeConfigArgs', 'JobTimeConfigArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 x_attrs: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["attempt_interval"] = attempt_interval
            __props__.__dict__["class_name"] = class_name
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            if execute_mode is None and not opts.urn:
                raise TypeError("Missing required property 'execute_mode'")
            __props__.__dict__["execute_mode"] = execute_mode
            __props__.__dict__["fail_times"] = fail_times
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["job_monitor_info"] = job_monitor_info
            if job_name is None and not opts.urn:
                raise TypeError("Missing required property 'job_name'")
            __props__.__dict__["job_name"] = job_name
            if job_type is None and not opts.urn:
                raise TypeError("Missing required property 'job_type'")
            __props__.__dict__["job_type"] = job_type
            __props__.__dict__["map_task_xattrs"] = map_task_xattrs
            __props__.__dict__["max_attempt"] = max_attempt
            __props__.__dict__["max_concurrency"] = max_concurrency
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["namespace_source"] = namespace_source
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["status"] = status
            __props__.__dict__["success_notice_enable"] = success_notice_enable
            __props__.__dict__["task_dispatch_mode"] = task_dispatch_mode
            __props__.__dict__["template"] = template
            if time_config is None and not opts.urn:
                raise TypeError("Missing required property 'time_config'")
            __props__.__dict__["time_config"] = time_config
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["x_attrs"] = x_attrs
            __props__.__dict__["job_id"] = None
        super(Job, __self__).__init__(
            'alicloud:schedulerx/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attempt_interval: Optional[pulumi.Input[_builtins.int]] = None,
            class_name: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execute_mode: Optional[pulumi.Input[_builtins.str]] = None,
            fail_times: Optional[pulumi.Input[_builtins.int]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.int]] = None,
            job_monitor_info: Optional[pulumi.Input[Union['JobJobMonitorInfoArgs', 'JobJobMonitorInfoArgsDict']]] = None,
            job_name: Optional[pulumi.Input[_builtins.str]] = None,
            job_type: Optional[pulumi.Input[_builtins.str]] = None,
            map_task_xattrs: Optional[pulumi.Input[Union['JobMapTaskXattrsArgs', 'JobMapTaskXattrsArgsDict']]] = None,
            max_attempt: Optional[pulumi.Input[_builtins.int]] = None,
            max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            success_notice_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            task_dispatch_mode: Optional[pulumi.Input[_builtins.str]] = None,
            template: Optional[pulumi.Input[_builtins.str]] = None,
            time_config: Optional[pulumi.Input[Union['JobTimeConfigArgs', 'JobTimeConfigArgsDict']]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            x_attrs: Optional[pulumi.Input[_builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] attempt_interval: Error retry interval, unit s, default value 30.
        :param pulumi.Input[_builtins.str] class_name: Full path of the task interface class.
               
               This field is available only when your task is of the Java task type.
        :param pulumi.Input[_builtins.str] content: The script code of the python, shell, and go task types.
        :param pulumi.Input[_builtins.str] description: Task description.
        :param pulumi.Input[_builtins.str] execute_mode: Task execution mode, the possible results are as follows:
        :param pulumi.Input[_builtins.int] fail_times: Number of consecutive failed alarms
        :param pulumi.Input[_builtins.str] group_id: The application ID, which is obtained from the **application management** page of the console.
        :param pulumi.Input[_builtins.int] job_id: JobId
        :param pulumi.Input[Union['JobJobMonitorInfoArgs', 'JobJobMonitorInfoArgsDict']] job_monitor_info: Task monitoring information See `job_monitor_info` below.
        :param pulumi.Input[_builtins.str] job_name: JobName
        :param pulumi.Input[_builtins.str] job_type: Job Type
        :param pulumi.Input[Union['JobMapTaskXattrsArgs', 'JobMapTaskXattrsArgsDict']] map_task_xattrs: Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        :param pulumi.Input[_builtins.int] max_attempt: The maximum number of error retries, which is set based on business requirements. The default value is 0.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.str] namespace: Namespace, which is obtained on the `Namespace` page of the console.
        :param pulumi.Input[_builtins.str] namespace_source: Special third parties are required.
        :param pulumi.Input[_builtins.str] parameters: User-defined parameters, which can be obtained at runtime.
        :param pulumi.Input[_builtins.str] status: Task status. The values are as follows:
        :param pulumi.Input[_builtins.bool] success_notice_enable: Success Notification Switch
        :param pulumi.Input[_builtins.str] task_dispatch_mode: Advanced configuration of parallel grid tasks, push model or pull model
        :param pulumi.Input[_builtins.str] template: K8s task type custom task template
        :param pulumi.Input[Union['JobTimeConfigArgs', 'JobTimeConfigArgsDict']] time_config: Time configuration information See `time_config` below.
        :param pulumi.Input[_builtins.str] timezone: Time Zone
        :param pulumi.Input[_builtins.str] x_attrs: Task Extension Field
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["attempt_interval"] = attempt_interval
        __props__.__dict__["class_name"] = class_name
        __props__.__dict__["content"] = content
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_mode"] = execute_mode
        __props__.__dict__["fail_times"] = fail_times
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_monitor_info"] = job_monitor_info
        __props__.__dict__["job_name"] = job_name
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["map_task_xattrs"] = map_task_xattrs
        __props__.__dict__["max_attempt"] = max_attempt
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["namespace_source"] = namespace_source
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["status"] = status
        __props__.__dict__["success_notice_enable"] = success_notice_enable
        __props__.__dict__["task_dispatch_mode"] = task_dispatch_mode
        __props__.__dict__["template"] = template
        __props__.__dict__["time_config"] = time_config
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["x_attrs"] = x_attrs
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attemptInterval")
    def attempt_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Error retry interval, unit s, default value 30.
        """
        return pulumi.get(self, "attempt_interval")

    @_builtins.property
    @pulumi.getter(name="className")
    def class_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Full path of the task interface class.

        This field is available only when your task is of the Java task type.
        """
        return pulumi.get(self, "class_name")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The script code of the python, shell, and go task types.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Task description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executeMode")
    def execute_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Task execution mode, the possible results are as follows:
        """
        return pulumi.get(self, "execute_mode")

    @_builtins.property
    @pulumi.getter(name="failTimes")
    def fail_times(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of consecutive failed alarms
        """
        return pulumi.get(self, "fail_times")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The application ID, which is obtained from the **application management** page of the console.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.int]:
        """
        JobId
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobMonitorInfo")
    def job_monitor_info(self) -> pulumi.Output[Optional['outputs.JobJobMonitorInfo']]:
        """
        Task monitoring information See `job_monitor_info` below.
        """
        return pulumi.get(self, "job_monitor_info")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Output[_builtins.str]:
        """
        JobName
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[_builtins.str]:
        """
        Job Type
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="mapTaskXattrs")
    def map_task_xattrs(self) -> pulumi.Output[Optional['outputs.JobMapTaskXattrs']]:
        """
        Advanced configuration, limited to parallel computing, memory grid, and grid computing. See `map_task_xattrs` below.
        """
        return pulumi.get(self, "map_task_xattrs")

    @_builtins.property
    @pulumi.getter(name="maxAttempt")
    def max_attempt(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of error retries, which is set based on business requirements. The default value is 0.
        """
        return pulumi.get(self, "max_attempt")

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        """
        return pulumi.get(self, "max_concurrency")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace, which is obtained on the `Namespace` page of the console.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="namespaceSource")
    def namespace_source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Special third parties are required.
        """
        return pulumi.get(self, "namespace_source")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined parameters, which can be obtained at runtime.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Task status. The values are as follows:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="successNoticeEnable")
    def success_notice_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Success Notification Switch
        """
        return pulumi.get(self, "success_notice_enable")

    @_builtins.property
    @pulumi.getter(name="taskDispatchMode")
    def task_dispatch_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Advanced configuration of parallel grid tasks, push model or pull model
        """
        return pulumi.get(self, "task_dispatch_mode")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        K8s task type custom task template
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="timeConfig")
    def time_config(self) -> pulumi.Output['outputs.JobTimeConfig']:
        """
        Time configuration information See `time_config` below.
        """
        return pulumi.get(self, "time_config")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time Zone
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="xAttrs")
    def x_attrs(self) -> pulumi.Output[_builtins.str]:
        """
        Task Extension Field
        """
        return pulumi.get(self, "x_attrs")

