# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 period: pulumi.Input[_builtins.int],
                 sd_cbool: pulumi.Input[_builtins.str],
                 sdc: pulumi.Input[_builtins.str],
                 sddp_version: pulumi.Input[_builtins.str],
                 ud_cbool: pulumi.Input[_builtins.str],
                 udc: pulumi.Input[_builtins.str],
                 dataphin: Optional[pulumi.Input[_builtins.str]] = None,
                 dataphin_count: Optional[pulumi.Input[_builtins.str]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_size: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[_builtins.int] period: The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        :param pulumi.Input[_builtins.str] sd_cbool: Whether to use the database. Valid values:`yes`,`no`.
        :param pulumi.Input[_builtins.str] sdc: The number of instances.
        :param pulumi.Input[_builtins.str] sddp_version: The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        :param pulumi.Input[_builtins.str] ud_cbool: Whether to use OSS. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] udc: OSS Size.
        :param pulumi.Input[_builtins.str] dataphin: The dataphin. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] dataphin_count: The dataphin count. Valid values: 1 to 20.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        :param pulumi.Input[_builtins.str] oss_size: The OSS storage capacity.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "sd_cbool", sd_cbool)
        pulumi.set(__self__, "sdc", sdc)
        pulumi.set(__self__, "sddp_version", sddp_version)
        pulumi.set(__self__, "ud_cbool", ud_cbool)
        pulumi.set(__self__, "udc", udc)
        if dataphin is not None:
            pulumi.set(__self__, "dataphin", dataphin)
        if dataphin_count is not None:
            pulumi.set(__self__, "dataphin_count", dataphin_count)
        if logistics is not None:
            pulumi.set(__self__, "logistics", logistics)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if oss_size is not None:
            pulumi.set(__self__, "oss_size", oss_size)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Input[_builtins.int]:
        """
        The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="sdCbool")
    def sd_cbool(self) -> pulumi.Input[_builtins.str]:
        """
        Whether to use the database. Valid values:`yes`,`no`.
        """
        return pulumi.get(self, "sd_cbool")

    @sd_cbool.setter
    def sd_cbool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sd_cbool", value)

    @_builtins.property
    @pulumi.getter
    def sdc(self) -> pulumi.Input[_builtins.str]:
        """
        The number of instances.
        """
        return pulumi.get(self, "sdc")

    @sdc.setter
    def sdc(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sdc", value)

    @_builtins.property
    @pulumi.getter(name="sddpVersion")
    def sddp_version(self) -> pulumi.Input[_builtins.str]:
        """
        The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        """
        return pulumi.get(self, "sddp_version")

    @sddp_version.setter
    def sddp_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sddp_version", value)

    @_builtins.property
    @pulumi.getter(name="udCbool")
    def ud_cbool(self) -> pulumi.Input[_builtins.str]:
        """
        Whether to use OSS. Valid values: `yes`,`no`.
        """
        return pulumi.get(self, "ud_cbool")

    @ud_cbool.setter
    def ud_cbool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ud_cbool", value)

    @_builtins.property
    @pulumi.getter
    def udc(self) -> pulumi.Input[_builtins.str]:
        """
        OSS Size.
        """
        return pulumi.get(self, "udc")

    @udc.setter
    def udc(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "udc", value)

    @_builtins.property
    @pulumi.getter
    def dataphin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataphin. Valid values: `yes`,`no`.
        """
        return pulumi.get(self, "dataphin")

    @dataphin.setter
    def dataphin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataphin", value)

    @_builtins.property
    @pulumi.getter(name="dataphinCount")
    def dataphin_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataphin count. Valid values: 1 to 20.
        """
        return pulumi.get(self, "dataphin_count")

    @dataphin_count.setter
    def dataphin_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataphin_count", value)

    @_builtins.property
    @pulumi.getter
    def logistics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @logistics.setter
    def logistics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logistics", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter(name="ossSize")
    def oss_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OSS storage capacity.
        """
        return pulumi.get(self, "oss_size")

    @oss_size.setter
    def oss_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_size", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 authed: Optional[pulumi.Input[_builtins.bool]] = None,
                 dataphin: Optional[pulumi.Input[_builtins.str]] = None,
                 dataphin_count: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_num: Optional[pulumi.Input[_builtins.str]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 odps_set: Optional[pulumi.Input[_builtins.bool]] = None,
                 oss_bucket_set: Optional[pulumi.Input[_builtins.bool]] = None,
                 oss_size: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 rds_set: Optional[pulumi.Input[_builtins.bool]] = None,
                 remain_days: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sd_cbool: Optional[pulumi.Input[_builtins.str]] = None,
                 sdc: Optional[pulumi.Input[_builtins.str]] = None,
                 sddp_version: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 ud_cbool: Optional[pulumi.Input[_builtins.str]] = None,
                 udc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] authed: Whether the required RAM authorization is configured.
        :param pulumi.Input[_builtins.str] dataphin: The dataphin. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] dataphin_count: The dataphin count. Valid values: 1 to 20.
        :param pulumi.Input[_builtins.str] instance_num: The number of instances.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        :param pulumi.Input[_builtins.bool] odps_set: Whether the authorized MaxCompute (ODPS) assets.
        :param pulumi.Input[_builtins.bool] oss_bucket_set: Whether the authorized oss assets.
        :param pulumi.Input[_builtins.str] oss_size: The OSS storage capacity.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[_builtins.int] period: The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        :param pulumi.Input[_builtins.bool] rds_set: Whether the authorized rds assets.
        :param pulumi.Input[_builtins.str] remain_days: The remaining days of the protection period of the assets in the current login account.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        :param pulumi.Input[_builtins.str] sd_cbool: Whether to use the database. Valid values:`yes`,`no`.
        :param pulumi.Input[_builtins.str] sdc: The number of instances.
        :param pulumi.Input[_builtins.str] sddp_version: The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] ud_cbool: Whether to use OSS. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] udc: OSS Size.
        """
        if authed is not None:
            pulumi.set(__self__, "authed", authed)
        if dataphin is not None:
            pulumi.set(__self__, "dataphin", dataphin)
        if dataphin_count is not None:
            pulumi.set(__self__, "dataphin_count", dataphin_count)
        if instance_num is not None:
            pulumi.set(__self__, "instance_num", instance_num)
        if logistics is not None:
            pulumi.set(__self__, "logistics", logistics)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if odps_set is not None:
            pulumi.set(__self__, "odps_set", odps_set)
        if oss_bucket_set is not None:
            pulumi.set(__self__, "oss_bucket_set", oss_bucket_set)
        if oss_size is not None:
            pulumi.set(__self__, "oss_size", oss_size)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if rds_set is not None:
            pulumi.set(__self__, "rds_set", rds_set)
        if remain_days is not None:
            pulumi.set(__self__, "remain_days", remain_days)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if sd_cbool is not None:
            pulumi.set(__self__, "sd_cbool", sd_cbool)
        if sdc is not None:
            pulumi.set(__self__, "sdc", sdc)
        if sddp_version is not None:
            pulumi.set(__self__, "sddp_version", sddp_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if ud_cbool is not None:
            pulumi.set(__self__, "ud_cbool", ud_cbool)
        if udc is not None:
            pulumi.set(__self__, "udc", udc)

    @_builtins.property
    @pulumi.getter
    def authed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the required RAM authorization is configured.
        """
        return pulumi.get(self, "authed")

    @authed.setter
    def authed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "authed", value)

    @_builtins.property
    @pulumi.getter
    def dataphin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataphin. Valid values: `yes`,`no`.
        """
        return pulumi.get(self, "dataphin")

    @dataphin.setter
    def dataphin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataphin", value)

    @_builtins.property
    @pulumi.getter(name="dataphinCount")
    def dataphin_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataphin count. Valid values: 1 to 20.
        """
        return pulumi.get(self, "dataphin_count")

    @dataphin_count.setter
    def dataphin_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataphin_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceNum")
    def instance_num(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of instances.
        """
        return pulumi.get(self, "instance_num")

    @instance_num.setter
    def instance_num(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_num", value)

    @_builtins.property
    @pulumi.getter
    def logistics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @logistics.setter
    def logistics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logistics", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter(name="odpsSet")
    def odps_set(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authorized MaxCompute (ODPS) assets.
        """
        return pulumi.get(self, "odps_set")

    @odps_set.setter
    def odps_set(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "odps_set", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketSet")
    def oss_bucket_set(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authorized oss assets.
        """
        return pulumi.get(self, "oss_bucket_set")

    @oss_bucket_set.setter
    def oss_bucket_set(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "oss_bucket_set", value)

    @_builtins.property
    @pulumi.getter(name="ossSize")
    def oss_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OSS storage capacity.
        """
        return pulumi.get(self, "oss_size")

    @oss_size.setter
    def oss_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_size", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="rdsSet")
    def rds_set(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authorized rds assets.
        """
        return pulumi.get(self, "rds_set")

    @rds_set.setter
    def rds_set(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rds_set", value)

    @_builtins.property
    @pulumi.getter(name="remainDays")
    def remain_days(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remaining days of the protection period of the assets in the current login account.
        """
        return pulumi.get(self, "remain_days")

    @remain_days.setter
    def remain_days(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remain_days", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="sdCbool")
    def sd_cbool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use the database. Valid values:`yes`,`no`.
        """
        return pulumi.get(self, "sd_cbool")

    @sd_cbool.setter
    def sd_cbool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sd_cbool", value)

    @_builtins.property
    @pulumi.getter
    def sdc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of instances.
        """
        return pulumi.get(self, "sdc")

    @sdc.setter
    def sdc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sdc", value)

    @_builtins.property
    @pulumi.getter(name="sddpVersion")
    def sddp_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        """
        return pulumi.get(self, "sddp_version")

    @sddp_version.setter
    def sddp_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sddp_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="udCbool")
    def ud_cbool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use OSS. Valid values: `yes`,`no`.
        """
        return pulumi.get(self, "ud_cbool")

    @ud_cbool.setter
    def ud_cbool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ud_cbool", value)

    @_builtins.property
    @pulumi.getter
    def udc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS Size.
        """
        return pulumi.get(self, "udc")

    @udc.setter
    def udc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "udc", value)


@pulumi.type_token("alicloud:sddp/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataphin: Optional[pulumi.Input[_builtins.str]] = None,
                 dataphin_count: Optional[pulumi.Input[_builtins.str]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_size: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sd_cbool: Optional[pulumi.Input[_builtins.str]] = None,
                 sdc: Optional[pulumi.Input[_builtins.str]] = None,
                 sddp_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ud_cbool: Optional[pulumi.Input[_builtins.str]] = None,
                 udc: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Data Security Center Instance resource.

        For information about Data Security Center Instance and how to use it, see [What is Instance](https://help.aliyun.com/product/88674.html).

        > **NOTE:** Available in v1.136.0+.

        > **NOTE:** The Data Security Center Instance is not support in the international site.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.sddp.Instance("default",
            payment_type="Subscription",
            sddp_version="version_company",
            sd_cbool="yes",
            period=1,
            sdc="3",
            ud_cbool="yes",
            udc="2000",
            dataphin="yes")
        ```

        ## Import

        Data Security Center Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sddp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dataphin: The dataphin. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] dataphin_count: The dataphin count. Valid values: 1 to 20.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        :param pulumi.Input[_builtins.str] oss_size: The OSS storage capacity.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[_builtins.int] period: The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        :param pulumi.Input[_builtins.str] sd_cbool: Whether to use the database. Valid values:`yes`,`no`.
        :param pulumi.Input[_builtins.str] sdc: The number of instances.
        :param pulumi.Input[_builtins.str] sddp_version: The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        :param pulumi.Input[_builtins.str] ud_cbool: Whether to use OSS. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] udc: OSS Size.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Security Center Instance resource.

        For information about Data Security Center Instance and how to use it, see [What is Instance](https://help.aliyun.com/product/88674.html).

        > **NOTE:** Available in v1.136.0+.

        > **NOTE:** The Data Security Center Instance is not support in the international site.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.sddp.Instance("default",
            payment_type="Subscription",
            sddp_version="version_company",
            sd_cbool="yes",
            period=1,
            sdc="3",
            ud_cbool="yes",
            udc="2000",
            dataphin="yes")
        ```

        ## Import

        Data Security Center Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sddp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataphin: Optional[pulumi.Input[_builtins.str]] = None,
                 dataphin_count: Optional[pulumi.Input[_builtins.str]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_size: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sd_cbool: Optional[pulumi.Input[_builtins.str]] = None,
                 sdc: Optional[pulumi.Input[_builtins.str]] = None,
                 sddp_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ud_cbool: Optional[pulumi.Input[_builtins.str]] = None,
                 udc: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["dataphin"] = dataphin
            __props__.__dict__["dataphin_count"] = dataphin_count
            __props__.__dict__["logistics"] = logistics
            __props__.__dict__["modify_type"] = modify_type
            __props__.__dict__["oss_size"] = oss_size
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_status"] = renewal_status
            if sd_cbool is None and not opts.urn:
                raise TypeError("Missing required property 'sd_cbool'")
            __props__.__dict__["sd_cbool"] = sd_cbool
            if sdc is None and not opts.urn:
                raise TypeError("Missing required property 'sdc'")
            __props__.__dict__["sdc"] = sdc
            if sddp_version is None and not opts.urn:
                raise TypeError("Missing required property 'sddp_version'")
            __props__.__dict__["sddp_version"] = sddp_version
            if ud_cbool is None and not opts.urn:
                raise TypeError("Missing required property 'ud_cbool'")
            __props__.__dict__["ud_cbool"] = ud_cbool
            if udc is None and not opts.urn:
                raise TypeError("Missing required property 'udc'")
            __props__.__dict__["udc"] = udc
            __props__.__dict__["authed"] = None
            __props__.__dict__["instance_num"] = None
            __props__.__dict__["odps_set"] = None
            __props__.__dict__["oss_bucket_set"] = None
            __props__.__dict__["rds_set"] = None
            __props__.__dict__["remain_days"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:sddp/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authed: Optional[pulumi.Input[_builtins.bool]] = None,
            dataphin: Optional[pulumi.Input[_builtins.str]] = None,
            dataphin_count: Optional[pulumi.Input[_builtins.str]] = None,
            instance_num: Optional[pulumi.Input[_builtins.str]] = None,
            logistics: Optional[pulumi.Input[_builtins.str]] = None,
            modify_type: Optional[pulumi.Input[_builtins.str]] = None,
            odps_set: Optional[pulumi.Input[_builtins.bool]] = None,
            oss_bucket_set: Optional[pulumi.Input[_builtins.bool]] = None,
            oss_size: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            rds_set: Optional[pulumi.Input[_builtins.bool]] = None,
            remain_days: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            sd_cbool: Optional[pulumi.Input[_builtins.str]] = None,
            sdc: Optional[pulumi.Input[_builtins.str]] = None,
            sddp_version: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            ud_cbool: Optional[pulumi.Input[_builtins.str]] = None,
            udc: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] authed: Whether the required RAM authorization is configured.
        :param pulumi.Input[_builtins.str] dataphin: The dataphin. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] dataphin_count: The dataphin count. Valid values: 1 to 20.
        :param pulumi.Input[_builtins.str] instance_num: The number of instances.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        :param pulumi.Input[_builtins.bool] odps_set: Whether the authorized MaxCompute (ODPS) assets.
        :param pulumi.Input[_builtins.bool] oss_bucket_set: Whether the authorized oss assets.
        :param pulumi.Input[_builtins.str] oss_size: The OSS storage capacity.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[_builtins.int] period: The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        :param pulumi.Input[_builtins.bool] rds_set: Whether the authorized rds assets.
        :param pulumi.Input[_builtins.str] remain_days: The remaining days of the protection period of the assets in the current login account.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        :param pulumi.Input[_builtins.str] sd_cbool: Whether to use the database. Valid values:`yes`,`no`.
        :param pulumi.Input[_builtins.str] sdc: The number of instances.
        :param pulumi.Input[_builtins.str] sddp_version: The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] ud_cbool: Whether to use OSS. Valid values: `yes`,`no`.
        :param pulumi.Input[_builtins.str] udc: OSS Size.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["authed"] = authed
        __props__.__dict__["dataphin"] = dataphin
        __props__.__dict__["dataphin_count"] = dataphin_count
        __props__.__dict__["instance_num"] = instance_num
        __props__.__dict__["logistics"] = logistics
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["odps_set"] = odps_set
        __props__.__dict__["oss_bucket_set"] = oss_bucket_set
        __props__.__dict__["oss_size"] = oss_size
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["rds_set"] = rds_set
        __props__.__dict__["remain_days"] = remain_days
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["sd_cbool"] = sd_cbool
        __props__.__dict__["sdc"] = sdc
        __props__.__dict__["sddp_version"] = sddp_version
        __props__.__dict__["status"] = status
        __props__.__dict__["ud_cbool"] = ud_cbool
        __props__.__dict__["udc"] = udc
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authed(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the required RAM authorization is configured.
        """
        return pulumi.get(self, "authed")

    @_builtins.property
    @pulumi.getter
    def dataphin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The dataphin. Valid values: `yes`,`no`.
        """
        return pulumi.get(self, "dataphin")

    @_builtins.property
    @pulumi.getter(name="dataphinCount")
    def dataphin_count(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The dataphin count. Valid values: 1 to 20.
        """
        return pulumi.get(self, "dataphin_count")

    @_builtins.property
    @pulumi.getter(name="instanceNum")
    def instance_num(self) -> pulumi.Output[_builtins.str]:
        """
        The number of instances.
        """
        return pulumi.get(self, "instance_num")

    @_builtins.property
    @pulumi.getter
    def logistics(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
        """
        return pulumi.get(self, "modify_type")

    @_builtins.property
    @pulumi.getter(name="odpsSet")
    def odps_set(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the authorized MaxCompute (ODPS) assets.
        """
        return pulumi.get(self, "odps_set")

    @_builtins.property
    @pulumi.getter(name="ossBucketSet")
    def oss_bucket_set(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the authorized oss assets.
        """
        return pulumi.get(self, "oss_bucket_set")

    @_builtins.property
    @pulumi.getter(name="ossSize")
    def oss_size(self) -> pulumi.Output[_builtins.str]:
        """
        The OSS storage capacity.
        """
        return pulumi.get(self, "oss_size")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.int]:
        """
        The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="rdsSet")
    def rds_set(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the authorized rds assets.
        """
        return pulumi.get(self, "rds_set")

    @_builtins.property
    @pulumi.getter(name="remainDays")
    def remain_days(self) -> pulumi.Output[_builtins.str]:
        """
        The remaining days of the protection period of the assets in the current login account.
        """
        return pulumi.get(self, "remain_days")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="sdCbool")
    def sd_cbool(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to use the database. Valid values:`yes`,`no`.
        """
        return pulumi.get(self, "sd_cbool")

    @_builtins.property
    @pulumi.getter
    def sdc(self) -> pulumi.Output[_builtins.str]:
        """
        The number of instances.
        """
        return pulumi.get(self, "sdc")

    @_builtins.property
    @pulumi.getter(name="sddpVersion")
    def sddp_version(self) -> pulumi.Output[_builtins.str]:
        """
        The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
        """
        return pulumi.get(self, "sddp_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="udCbool")
    def ud_cbool(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to use OSS. Valid values: `yes`,`no`.
        """
        return pulumi.get(self, "ud_cbool")

    @_builtins.property
    @pulumi.getter
    def udc(self) -> pulumi.Output[_builtins.str]:
        """
        OSS Size.
        """
        return pulumi.get(self, "udc")

