# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerCertificateArgs', 'ServerCertificate']

@pulumi.input_type
class ServerCertificateArgs:
    def __init__(__self__, *,
                 alicloud_certifacte_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certifacte_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServerCertificate resource.
        :param pulumi.Input[_builtins.str] alicloud_certificate_id: an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_name: the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_region_id: the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] name: Name of the Server Certificate.
        :param pulumi.Input[_builtins.str] private_key: the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the slb server certificate belongs.
        :param pulumi.Input[_builtins.str] server_certificate: the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if alicloud_certifacte_id is not None:
            warnings.warn("""Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""alicloud_certifacte_id is deprecated: Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""")
        if alicloud_certifacte_id is not None:
            pulumi.set(__self__, "alicloud_certifacte_id", alicloud_certifacte_id)
        if alicloud_certifacte_name is not None:
            warnings.warn("""Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""alicloud_certifacte_name is deprecated: Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""")
        if alicloud_certifacte_name is not None:
            pulumi.set(__self__, "alicloud_certifacte_name", alicloud_certifacte_name)
        if alicloud_certificate_id is not None:
            pulumi.set(__self__, "alicloud_certificate_id", alicloud_certificate_id)
        if alicloud_certificate_name is not None:
            pulumi.set(__self__, "alicloud_certificate_name", alicloud_certificate_name)
        if alicloud_certificate_region_id is not None:
            pulumi.set(__self__, "alicloud_certificate_region_id", alicloud_certificate_region_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alicloudCertifacteId")
    @_utilities.deprecated("""Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""")
    def alicloud_certifacte_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alicloud_certifacte_id")

    @alicloud_certifacte_id.setter
    def alicloud_certifacte_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certifacte_id", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertifacteName")
    @_utilities.deprecated("""Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""")
    def alicloud_certifacte_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alicloud_certifacte_name")

    @alicloud_certifacte_name.setter
    def alicloud_certifacte_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certifacte_name", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateId")
    def alicloud_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_id")

    @alicloud_certificate_id.setter
    def alicloud_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateName")
    def alicloud_certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_name")

    @alicloud_certificate_name.setter
    def alicloud_certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateRegionId")
    def alicloud_certificate_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_region_id")

    @alicloud_certificate_region_id.setter
    def alicloud_certificate_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certificate_region_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Server Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the slb server certificate belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_certificate", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServerCertificateState:
    def __init__(__self__, *,
                 alicloud_certifacte_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certifacte_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ServerCertificate resources.
        :param pulumi.Input[_builtins.str] alicloud_certificate_id: an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_name: the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_region_id: the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] name: Name of the Server Certificate.
        :param pulumi.Input[_builtins.str] private_key: the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the slb server certificate belongs.
        :param pulumi.Input[_builtins.str] server_certificate: the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if alicloud_certifacte_id is not None:
            warnings.warn("""Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""alicloud_certifacte_id is deprecated: Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""")
        if alicloud_certifacte_id is not None:
            pulumi.set(__self__, "alicloud_certifacte_id", alicloud_certifacte_id)
        if alicloud_certifacte_name is not None:
            warnings.warn("""Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""alicloud_certifacte_name is deprecated: Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""")
        if alicloud_certifacte_name is not None:
            pulumi.set(__self__, "alicloud_certifacte_name", alicloud_certifacte_name)
        if alicloud_certificate_id is not None:
            pulumi.set(__self__, "alicloud_certificate_id", alicloud_certificate_id)
        if alicloud_certificate_name is not None:
            pulumi.set(__self__, "alicloud_certificate_name", alicloud_certificate_name)
        if alicloud_certificate_region_id is not None:
            pulumi.set(__self__, "alicloud_certificate_region_id", alicloud_certificate_region_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alicloudCertifacteId")
    @_utilities.deprecated("""Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""")
    def alicloud_certifacte_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alicloud_certifacte_id")

    @alicloud_certifacte_id.setter
    def alicloud_certifacte_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certifacte_id", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertifacteName")
    @_utilities.deprecated("""Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""")
    def alicloud_certifacte_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alicloud_certifacte_name")

    @alicloud_certifacte_name.setter
    def alicloud_certifacte_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certifacte_name", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateId")
    def alicloud_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_id")

    @alicloud_certificate_id.setter
    def alicloud_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateName")
    def alicloud_certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_name")

    @alicloud_certificate_name.setter
    def alicloud_certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateRegionId")
    def alicloud_certificate_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_region_id")

    @alicloud_certificate_region_id.setter
    def alicloud_certificate_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alicloud_certificate_region_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Server Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the slb server certificate belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_certificate", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:slb/serverCertificate:ServerCertificate")
class ServerCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alicloud_certifacte_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certifacte_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        A Load Balancer Server Certificate is an ssl Certificate used by the listener of the protocol https.

        For information about slb and how to use it, see [What is Server Load Balancer](https://www.alibabacloud.com/help/doc-detail/27539.htm).

        For information about Server Certificate and how to use it, see [Configure Server Certificate](https://www.alibabacloud.com/help/doc-detail/85968.htm).

        ## Example Usage

        * using server_certificate/private content as string example

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # create a server certificate
        foo = alicloud.slb.ServerCertificate("foo",
            name="slbservercertificate",
            server_certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIICWDCCAcGgAwIBAgIJAP7vOtjPtQIjMA0GCSqGSIb3DQEBCwUAMEUxCzAJBgNV
        BAYTAkNOMRMwEQYDVQQIDApjbi1iZWlqaW5nMSEwHwYDVQQKDBhJbnRlcm5ldCBX
        aWRnaXRzIFB0eSBMdGQwHhcNMjAxMDIwMDYxOTUxWhcNMjAxMTE5MDYxOTUxWjBF
        MQswCQYDVQQGEwJDTjETMBEGA1UECAwKY24tYmVpamluZzEhMB8GA1UECgwYSW50
        ZXJuZXQgV2lkZ2l0cyBQdHkgTHRkMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB
        gQDEdoyaJ0kdtjtbLRx5X9qwI7FblhJPRcScvhQSE8P5y/b/T8J9BVuFIBoU8nrP
        Y9ABz4JFklZ6SznxLbFBqtXoJTmzV6ixyjjH+AGEw6hCiA8Pqy2CNIzxr9DjCzN5
        tWruiHqO60O3Bve6cHipH0VyLAhrB85mflvOZSH4xGsJkwIDAQABo1AwTjAdBgNV
        HQ4EFgQUYDwuuqC2a2UPrfm1v31vE7+GRM4wHwYDVR0jBBgwFoAUYDwuuqC2a2UP
        rfm1v31vE7+GRM4wDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQsFAAOBgQAovSB0
        5JRKrg7lYR/KlTuKHmozfyL9UER0/dpTSoqsCyt8yc1BbtAKUJWh09BujBE1H22f
        lKvCAjhPmnNdfd/l9GrmAWNDWEDPLdUTkGSkKAScMpdS+mLmOBuYWgdnOtq3eQGf
        t07tlBL+dtzrrohHpfLeuNyYb40g8VQdp3RRRQ==
        -----END CERTIFICATE-----\"\"\",
            private_key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQDEdoyaJ0kdtjtbLRx5X9qwI7FblhJPRcScvhQSE8P5y/b/T8J9
        BVuFIBoU8nrPY9ABz4JFklZ6SznxLbFBqtXoJTmzV6ixyjjH+AGEw6hCiA8Pqy2C
        NIzxr9DjCzN5tWruiHqO60O3Bve6cHipH0VyLAhrB85mflvOZSH4xGsJkwIDAQAB
        AoGARe2oaCo5lTDK+c4Zx3392hoqQ94r0DmWHPBvNmwAooYd+YxLPrLMe5sMjY4t
        dmohnLNevCK1Uzw5eIX6BNSo5CORBcIDRmiAgwiYiS3WOv2+qi9g5uIdMiDr+EED
        K8wZJjB5E2WyfxL507vtW4T5L36yfr8SkmqH3GvzpI2jCqECQQDsy0AmBzyfK0tG
        Nw1+iF9SReJWgb1f5iHvz+6Dt5ueVQngrl/5++Gp5bNoaQMkLEDsy0iHIj9j43ji
        0DON05uDAkEA1GXgGn8MXXKyuzYuoyYXCBH7aF579d7KEGET/jjnXx9DHcfRJZBY
        B9ghMnnonSOGboF04Zsdd3xwYF/3OHYssQJAekd/SeQEzyE5TvoQ8t2Tc9X4yrlW
        xNX/gmp6/fPr3biGUEtb7qi+4NBodCt+XsingmB7hKUP3RJTk7T2WnAC5wJAMqHi
        jY5x3SkFkHl3Hq9q2CKpQxUbCd7FXqg1wum/xj5GmqfSpNjHE3+jUkwbdrJMTrWP
        rmRy3tQMWf0mixAo0QJBAN4IcZChanq8cZyNqqoNbxGm4hkxUmE0W4hxHmLC2CYZ
        V4JpNm8dpi4CiMWLasF6TYlVMgX+aPxYRUWc/qqf1/Q=
        -----END RSA PRIVATE KEY-----\"\"\")
        ```

        * using server_certificate/private file example

        ## Import

        Server Load balancer Server Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:slb/serverCertificate:ServerCertificate example abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alicloud_certificate_id: an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_name: the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_region_id: the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] name: Name of the Server Certificate.
        :param pulumi.Input[_builtins.str] private_key: the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the slb server certificate belongs.
        :param pulumi.Input[_builtins.str] server_certificate: the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerCertificateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Load Balancer Server Certificate is an ssl Certificate used by the listener of the protocol https.

        For information about slb and how to use it, see [What is Server Load Balancer](https://www.alibabacloud.com/help/doc-detail/27539.htm).

        For information about Server Certificate and how to use it, see [Configure Server Certificate](https://www.alibabacloud.com/help/doc-detail/85968.htm).

        ## Example Usage

        * using server_certificate/private content as string example

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # create a server certificate
        foo = alicloud.slb.ServerCertificate("foo",
            name="slbservercertificate",
            server_certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIICWDCCAcGgAwIBAgIJAP7vOtjPtQIjMA0GCSqGSIb3DQEBCwUAMEUxCzAJBgNV
        BAYTAkNOMRMwEQYDVQQIDApjbi1iZWlqaW5nMSEwHwYDVQQKDBhJbnRlcm5ldCBX
        aWRnaXRzIFB0eSBMdGQwHhcNMjAxMDIwMDYxOTUxWhcNMjAxMTE5MDYxOTUxWjBF
        MQswCQYDVQQGEwJDTjETMBEGA1UECAwKY24tYmVpamluZzEhMB8GA1UECgwYSW50
        ZXJuZXQgV2lkZ2l0cyBQdHkgTHRkMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB
        gQDEdoyaJ0kdtjtbLRx5X9qwI7FblhJPRcScvhQSE8P5y/b/T8J9BVuFIBoU8nrP
        Y9ABz4JFklZ6SznxLbFBqtXoJTmzV6ixyjjH+AGEw6hCiA8Pqy2CNIzxr9DjCzN5
        tWruiHqO60O3Bve6cHipH0VyLAhrB85mflvOZSH4xGsJkwIDAQABo1AwTjAdBgNV
        HQ4EFgQUYDwuuqC2a2UPrfm1v31vE7+GRM4wHwYDVR0jBBgwFoAUYDwuuqC2a2UP
        rfm1v31vE7+GRM4wDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQsFAAOBgQAovSB0
        5JRKrg7lYR/KlTuKHmozfyL9UER0/dpTSoqsCyt8yc1BbtAKUJWh09BujBE1H22f
        lKvCAjhPmnNdfd/l9GrmAWNDWEDPLdUTkGSkKAScMpdS+mLmOBuYWgdnOtq3eQGf
        t07tlBL+dtzrrohHpfLeuNyYb40g8VQdp3RRRQ==
        -----END CERTIFICATE-----\"\"\",
            private_key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQDEdoyaJ0kdtjtbLRx5X9qwI7FblhJPRcScvhQSE8P5y/b/T8J9
        BVuFIBoU8nrPY9ABz4JFklZ6SznxLbFBqtXoJTmzV6ixyjjH+AGEw6hCiA8Pqy2C
        NIzxr9DjCzN5tWruiHqO60O3Bve6cHipH0VyLAhrB85mflvOZSH4xGsJkwIDAQAB
        AoGARe2oaCo5lTDK+c4Zx3392hoqQ94r0DmWHPBvNmwAooYd+YxLPrLMe5sMjY4t
        dmohnLNevCK1Uzw5eIX6BNSo5CORBcIDRmiAgwiYiS3WOv2+qi9g5uIdMiDr+EED
        K8wZJjB5E2WyfxL507vtW4T5L36yfr8SkmqH3GvzpI2jCqECQQDsy0AmBzyfK0tG
        Nw1+iF9SReJWgb1f5iHvz+6Dt5ueVQngrl/5++Gp5bNoaQMkLEDsy0iHIj9j43ji
        0DON05uDAkEA1GXgGn8MXXKyuzYuoyYXCBH7aF579d7KEGET/jjnXx9DHcfRJZBY
        B9ghMnnonSOGboF04Zsdd3xwYF/3OHYssQJAekd/SeQEzyE5TvoQ8t2Tc9X4yrlW
        xNX/gmp6/fPr3biGUEtb7qi+4NBodCt+XsingmB7hKUP3RJTk7T2WnAC5wJAMqHi
        jY5x3SkFkHl3Hq9q2CKpQxUbCd7FXqg1wum/xj5GmqfSpNjHE3+jUkwbdrJMTrWP
        rmRy3tQMWf0mixAo0QJBAN4IcZChanq8cZyNqqoNbxGm4hkxUmE0W4hxHmLC2CYZ
        V4JpNm8dpi4CiMWLasF6TYlVMgX+aPxYRUWc/qqf1/Q=
        -----END RSA PRIVATE KEY-----\"\"\")
        ```

        * using server_certificate/private file example

        ## Import

        Server Load balancer Server Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:slb/serverCertificate:ServerCertificate example abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ServerCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alicloud_certifacte_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certifacte_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alicloud_certificate_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerCertificateArgs.__new__(ServerCertificateArgs)

            __props__.__dict__["alicloud_certifacte_id"] = alicloud_certifacte_id
            __props__.__dict__["alicloud_certifacte_name"] = alicloud_certifacte_name
            __props__.__dict__["alicloud_certificate_id"] = alicloud_certificate_id
            __props__.__dict__["alicloud_certificate_name"] = alicloud_certificate_name
            __props__.__dict__["alicloud_certificate_region_id"] = alicloud_certificate_region_id
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["server_certificate"] = server_certificate
            __props__.__dict__["tags"] = tags
        super(ServerCertificate, __self__).__init__(
            'alicloud:slb/serverCertificate:ServerCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alicloud_certifacte_id: Optional[pulumi.Input[_builtins.str]] = None,
            alicloud_certifacte_name: Optional[pulumi.Input[_builtins.str]] = None,
            alicloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            alicloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            alicloud_certificate_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ServerCertificate':
        """
        Get an existing ServerCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alicloud_certificate_id: an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_name: the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] alicloud_certificate_region_id: the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        :param pulumi.Input[_builtins.str] name: Name of the Server Certificate.
        :param pulumi.Input[_builtins.str] private_key: the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the slb server certificate belongs.
        :param pulumi.Input[_builtins.str] server_certificate: the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerCertificateState.__new__(_ServerCertificateState)

        __props__.__dict__["alicloud_certifacte_id"] = alicloud_certifacte_id
        __props__.__dict__["alicloud_certifacte_name"] = alicloud_certifacte_name
        __props__.__dict__["alicloud_certificate_id"] = alicloud_certificate_id
        __props__.__dict__["alicloud_certificate_name"] = alicloud_certificate_name
        __props__.__dict__["alicloud_certificate_region_id"] = alicloud_certificate_region_id
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["server_certificate"] = server_certificate
        __props__.__dict__["tags"] = tags
        return ServerCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alicloudCertifacteId")
    @_utilities.deprecated("""Field 'alicloud_certifacte_id' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_id' replaces it.""")
    def alicloud_certifacte_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "alicloud_certifacte_id")

    @_builtins.property
    @pulumi.getter(name="alicloudCertifacteName")
    @_utilities.deprecated("""Field 'alicloud_certifacte_name' has been deprecated from provider version 1.68.0. Use 'alicloud_certificate_name' replaces it.""")
    def alicloud_certifacte_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "alicloud_certifacte_name")

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateId")
    def alicloud_certificate_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        an id of server certificate ssued/proxied by alibaba cloud. but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_id")

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateName")
    def alicloud_certificate_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        the name of the certificate specified by `alicloud_certificate_id`.but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_name")

    @_builtins.property
    @pulumi.getter(name="alicloudCertificateRegionId")
    def alicloud_certificate_region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        the region of the certificate specified by `alicloud_certificate_id`. but it is not supported on the international site of alibaba cloud now.
        """
        return pulumi.get(self, "alicloud_certificate_region_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Server Certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        the content of privat key of the ssl certificate specified by `server_certificate`. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of resource group which the slb server certificate belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        the content of the ssl certificate. where `alicloud_certificate_id` is null, it is required, otherwise it is ignored.
        """
        return pulumi.get(self, "server_certificate")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

