# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlertsResult',
    'AwaitableGetAlertsResult',
    'get_alerts',
    'get_alerts_output',
]

@pulumi.output_type
class GetAlertsResult:
    """
    A collection of values returned by getAlerts.
    """
    def __init__(__self__, alerts=None, id=None, ids=None, name_regex=None, names=None, output_file=None, project_name=None):
        if alerts and not isinstance(alerts, list):
            raise TypeError("Expected argument 'alerts' to be a list")
        pulumi.set(__self__, "alerts", alerts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> Sequence['outputs.GetAlertsAlertResult']:
        """
        A list of Alert Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "alerts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Alert IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Alerts.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        return pulumi.get(self, "project_name")


class AwaitableGetAlertsResult(GetAlertsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertsResult(
            alerts=self.alerts,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            project_name=self.project_name)


def get_alerts(ids: Optional[Sequence[_builtins.str]] = None,
               name_regex: Optional[_builtins.str] = None,
               output_file: Optional[_builtins.str] = None,
               project_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertsResult:
    """
    This data source provides Sls Alert available to the user.[What is Alert](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateAlert)

    > **NOTE:** Available since v1.250.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    alert_name = config.get("alertName")
    if alert_name is None:
        alert_name = "openapi-terraform-alert"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "terraform-alert-example"
    default_ins_mgl = alicloud.log.Project("defaultINsMgl",
        description="terraform-alert-example",
        name="terraform-alert-example")
    default_alert = alicloud.sls.Alert("default",
        configuration={
            "type": "tpl",
            "version": "2",
            "query_lists": [
                {
                    "query": "* | select *",
                    "time_span_type": "Relative",
                    "start": "-15m",
                    "end": "now",
                    "store_type": "log",
                    "project": default_ins_mgl.id,
                    "store": "alert",
                    "region": "cn-beijing",
                    "power_sql_mode": "disable",
                    "chart_title": "wkb-chart",
                    "dashboard_id": "wkb-dashboard",
                    "ui": "{}",
                    "role_arn": "acs:ram::1654218965343050:role/aliyunslsalertmonitorrole",
                },
                {
                    "store_type": "meta",
                    "store": "user.rds_ip_whitelist",
                },
                {
                    "store_type": "meta",
                    "store": "myexample1",
                },
            ],
            "group_configuration": {
                "type": "no_group",
                "fields": [
                    "a",
                    "b",
                ],
            },
            "join_configurations": [
                {
                    "type": "no_join",
                    "condition": "aa",
                },
                {
                    "type": "cross_join",
                    "condition": "qqq",
                },
                {
                    "type": "inner_join",
                    "condition": "fefefe",
                },
            ],
            "severity_configurations": [{
                "severity": 6,
                "eval_condition": {
                    "condition": "__count__ > 1",
                    "count_condition": "cnt > 0",
                },
            }],
            "labels": [{
                "key": "a",
                "value": "b",
            }],
            "annotations": [{
                "key": "x",
                "value": "y",
            }],
            "auto_annotation": True,
            "send_resolved": False,
            "threshold": 1,
            "no_data_fire": False,
            "sink_event_store": {
                "enabled": True,
                "endpoint": "cn-shanghai-intranet.log.aliyuncs.com",
                "project": "wkb-wangren",
                "event_store": "alert",
                "role_arn": "acs:ram::1654218965343050:role/aliyunlogetlrole",
            },
            "sink_cms": {
                "enabled": False,
            },
            "sink_alerthub": {
                "enabled": False,
            },
            "template_configuration": {
                "template_id": "sls.app.ack.autoscaler.cluster_unhealthy",
                "type": "sys",
                "version": "1.0",
                "lang": "cn",
            },
            "condition_configuration": {
                "condition": "cnt > 3",
                "count_condition": "__count__ < 3",
            },
            "policy_configuration": {
                "alert_policy_id": "sls.builtin.dynamic",
                "action_policy_id": "wkb-action",
                "repeat_interval": "1m",
            },
            "dashboard": "internal-alert",
            "mute_until": 0,
            "no_data_severity": 6,
            "tags": [
                "wkb",
                "wangren",
                "sls",
            ],
        },
        alert_name=alert_name,
        project_name=default_ins_mgl.id,
        schedule={
            "type": "Cron",
            "run_immdiately": True,
            "time_zone": "+0800",
            "delay": 10,
            "cron_expression": "0/5 * * * *",
        },
        display_name="openapi-terraform",
        description="create alert")
    default = alicloud.sls.get_alerts_output(ids=[default_alert.id],
        name_regex=default_alert.alert_name,
        project_name=default_ins_mgl.id)
    pulumi.export("alicloudSlsAlertExampleId", default.alerts[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Alert IDs. The value is formulated as `<project_name>:<alert_name>`.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project Name
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:sls/getAlerts:getAlerts', __args__, opts=opts, typ=GetAlertsResult).value

    return AwaitableGetAlertsResult(
        alerts=pulumi.get(__ret__, 'alerts'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'))
def get_alerts_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      project_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertsResult]:
    """
    This data source provides Sls Alert available to the user.[What is Alert](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateAlert)

    > **NOTE:** Available since v1.250.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    alert_name = config.get("alertName")
    if alert_name is None:
        alert_name = "openapi-terraform-alert"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "terraform-alert-example"
    default_ins_mgl = alicloud.log.Project("defaultINsMgl",
        description="terraform-alert-example",
        name="terraform-alert-example")
    default_alert = alicloud.sls.Alert("default",
        configuration={
            "type": "tpl",
            "version": "2",
            "query_lists": [
                {
                    "query": "* | select *",
                    "time_span_type": "Relative",
                    "start": "-15m",
                    "end": "now",
                    "store_type": "log",
                    "project": default_ins_mgl.id,
                    "store": "alert",
                    "region": "cn-beijing",
                    "power_sql_mode": "disable",
                    "chart_title": "wkb-chart",
                    "dashboard_id": "wkb-dashboard",
                    "ui": "{}",
                    "role_arn": "acs:ram::1654218965343050:role/aliyunslsalertmonitorrole",
                },
                {
                    "store_type": "meta",
                    "store": "user.rds_ip_whitelist",
                },
                {
                    "store_type": "meta",
                    "store": "myexample1",
                },
            ],
            "group_configuration": {
                "type": "no_group",
                "fields": [
                    "a",
                    "b",
                ],
            },
            "join_configurations": [
                {
                    "type": "no_join",
                    "condition": "aa",
                },
                {
                    "type": "cross_join",
                    "condition": "qqq",
                },
                {
                    "type": "inner_join",
                    "condition": "fefefe",
                },
            ],
            "severity_configurations": [{
                "severity": 6,
                "eval_condition": {
                    "condition": "__count__ > 1",
                    "count_condition": "cnt > 0",
                },
            }],
            "labels": [{
                "key": "a",
                "value": "b",
            }],
            "annotations": [{
                "key": "x",
                "value": "y",
            }],
            "auto_annotation": True,
            "send_resolved": False,
            "threshold": 1,
            "no_data_fire": False,
            "sink_event_store": {
                "enabled": True,
                "endpoint": "cn-shanghai-intranet.log.aliyuncs.com",
                "project": "wkb-wangren",
                "event_store": "alert",
                "role_arn": "acs:ram::1654218965343050:role/aliyunlogetlrole",
            },
            "sink_cms": {
                "enabled": False,
            },
            "sink_alerthub": {
                "enabled": False,
            },
            "template_configuration": {
                "template_id": "sls.app.ack.autoscaler.cluster_unhealthy",
                "type": "sys",
                "version": "1.0",
                "lang": "cn",
            },
            "condition_configuration": {
                "condition": "cnt > 3",
                "count_condition": "__count__ < 3",
            },
            "policy_configuration": {
                "alert_policy_id": "sls.builtin.dynamic",
                "action_policy_id": "wkb-action",
                "repeat_interval": "1m",
            },
            "dashboard": "internal-alert",
            "mute_until": 0,
            "no_data_severity": 6,
            "tags": [
                "wkb",
                "wangren",
                "sls",
            ],
        },
        alert_name=alert_name,
        project_name=default_ins_mgl.id,
        schedule={
            "type": "Cron",
            "run_immdiately": True,
            "time_zone": "+0800",
            "delay": 10,
            "cron_expression": "0/5 * * * *",
        },
        display_name="openapi-terraform",
        description="create alert")
    default = alicloud.sls.get_alerts_output(ids=[default_alert.id],
        name_regex=default_alert.alert_name,
        project_name=default_ins_mgl.id)
    pulumi.export("alicloudSlsAlertExampleId", default.alerts[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Alert IDs. The value is formulated as `<project_name>:<alert_name>`.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project Name
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:sls/getAlerts:getAlerts', __args__, opts=opts, typ=GetAlertsResult)
    return __ret__.apply(lambda __response__: GetAlertsResult(
        alerts=pulumi.get(__response__, 'alerts'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        project_name=pulumi.get(__response__, 'project_name')))
