# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MachineGroupArgs', 'MachineGroup']

@pulumi.input_type
class MachineGroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[_builtins.str],
                 machine_identify_type: pulumi.Input[_builtins.str],
                 machine_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 project_name: pulumi.Input[_builtins.str],
                 group_attribute: Optional[pulumi.Input['MachineGroupGroupAttributeArgs']] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MachineGroup resource.
        :param pulumi.Input[_builtins.str] group_name: Machine Group name
        :param pulumi.Input[_builtins.str] machine_identify_type: Machine identification type.
               - ip: ip address Machine Group.
               - userdefined: user-defined identity Machine Group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] machine_lists: The identification information of the machine group.
               - If machineidentifiytype is configured to ip, enter the ip address of the server.
               - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        :param pulumi.Input[_builtins.str] project_name: Project name
        :param pulumi.Input['MachineGroupGroupAttributeArgs'] group_attribute: Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        :param pulumi.Input[_builtins.str] group_type: Machine group type, optional value is empty.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "machine_identify_type", machine_identify_type)
        pulumi.set(__self__, "machine_lists", machine_lists)
        pulumi.set(__self__, "project_name", project_name)
        if group_attribute is not None:
            pulumi.set(__self__, "group_attribute", group_attribute)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Machine Group name
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="machineIdentifyType")
    def machine_identify_type(self) -> pulumi.Input[_builtins.str]:
        """
        Machine identification type.
        - ip: ip address Machine Group.
        - userdefined: user-defined identity Machine Group.
        """
        return pulumi.get(self, "machine_identify_type")

    @machine_identify_type.setter
    def machine_identify_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "machine_identify_type", value)

    @_builtins.property
    @pulumi.getter(name="machineLists")
    def machine_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The identification information of the machine group.
        - If machineidentifiytype is configured to ip, enter the ip address of the server.
        - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        """
        return pulumi.get(self, "machine_lists")

    @machine_lists.setter
    def machine_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "machine_lists", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> Optional[pulumi.Input['MachineGroupGroupAttributeArgs']]:
        """
        Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        """
        return pulumi.get(self, "group_attribute")

    @group_attribute.setter
    def group_attribute(self, value: Optional[pulumi.Input['MachineGroupGroupAttributeArgs']]):
        pulumi.set(self, "group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine group type, optional value is empty.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_type", value)


@pulumi.input_type
class _MachineGroupState:
    def __init__(__self__, *,
                 group_attribute: Optional[pulumi.Input['MachineGroupGroupAttributeArgs']] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_identify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MachineGroup resources.
        :param pulumi.Input['MachineGroupGroupAttributeArgs'] group_attribute: Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        :param pulumi.Input[_builtins.str] group_name: Machine Group name
        :param pulumi.Input[_builtins.str] group_type: Machine group type, optional value is empty.
        :param pulumi.Input[_builtins.str] machine_identify_type: Machine identification type.
               - ip: ip address Machine Group.
               - userdefined: user-defined identity Machine Group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] machine_lists: The identification information of the machine group.
               - If machineidentifiytype is configured to ip, enter the ip address of the server.
               - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        if group_attribute is not None:
            pulumi.set(__self__, "group_attribute", group_attribute)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if machine_identify_type is not None:
            pulumi.set(__self__, "machine_identify_type", machine_identify_type)
        if machine_lists is not None:
            pulumi.set(__self__, "machine_lists", machine_lists)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @_builtins.property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> Optional[pulumi.Input['MachineGroupGroupAttributeArgs']]:
        """
        Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        """
        return pulumi.get(self, "group_attribute")

    @group_attribute.setter
    def group_attribute(self, value: Optional[pulumi.Input['MachineGroupGroupAttributeArgs']]):
        pulumi.set(self, "group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine Group name
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine group type, optional value is empty.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_type", value)

    @_builtins.property
    @pulumi.getter(name="machineIdentifyType")
    def machine_identify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine identification type.
        - ip: ip address Machine Group.
        - userdefined: user-defined identity Machine Group.
        """
        return pulumi.get(self, "machine_identify_type")

    @machine_identify_type.setter
    def machine_identify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_identify_type", value)

    @_builtins.property
    @pulumi.getter(name="machineLists")
    def machine_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The identification information of the machine group.
        - If machineidentifiytype is configured to ip, enter the ip address of the server.
        - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        """
        return pulumi.get(self, "machine_lists")

    @machine_lists.setter
    def machine_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "machine_lists", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)


@pulumi.type_token("alicloud:sls/machineGroup:MachineGroup")
class MachineGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_attribute: Optional[pulumi.Input[Union['MachineGroupGroupAttributeArgs', 'MachineGroupGroupAttributeArgsDict']]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_identify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Log Service (SLS) Machine Group resource.

        For information about Log Service (SLS) Machine Group and how to use it, see [What is Machine Group](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateMachineGroup).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "project-for-machine-group-terraform"
        defaulty_jqrue = alicloud.log.Project("defaultyJqrue",
            description="for terraform example",
            name=project_name)
        default = alicloud.sls.MachineGroup("default",
            group_name="group1",
            project_name=project_name,
            machine_identify_type="ip",
            group_attribute={
                "group_topic": "example",
                "external_name": "example",
            },
            machine_lists=["192.168.1.1"])
        ```

        ## Import

        Log Service (SLS) Machine Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/machineGroup:MachineGroup example <project_name>:<group_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MachineGroupGroupAttributeArgs', 'MachineGroupGroupAttributeArgsDict']] group_attribute: Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        :param pulumi.Input[_builtins.str] group_name: Machine Group name
        :param pulumi.Input[_builtins.str] group_type: Machine group type, optional value is empty.
        :param pulumi.Input[_builtins.str] machine_identify_type: Machine identification type.
               - ip: ip address Machine Group.
               - userdefined: user-defined identity Machine Group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] machine_lists: The identification information of the machine group.
               - If machineidentifiytype is configured to ip, enter the ip address of the server.
               - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MachineGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Log Service (SLS) Machine Group resource.

        For information about Log Service (SLS) Machine Group and how to use it, see [What is Machine Group](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateMachineGroup).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "project-for-machine-group-terraform"
        defaulty_jqrue = alicloud.log.Project("defaultyJqrue",
            description="for terraform example",
            name=project_name)
        default = alicloud.sls.MachineGroup("default",
            group_name="group1",
            project_name=project_name,
            machine_identify_type="ip",
            group_attribute={
                "group_topic": "example",
                "external_name": "example",
            },
            machine_lists=["192.168.1.1"])
        ```

        ## Import

        Log Service (SLS) Machine Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/machineGroup:MachineGroup example <project_name>:<group_name>
        ```

        :param str resource_name: The name of the resource.
        :param MachineGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MachineGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_attribute: Optional[pulumi.Input[Union['MachineGroupGroupAttributeArgs', 'MachineGroupGroupAttributeArgsDict']]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_identify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MachineGroupArgs.__new__(MachineGroupArgs)

            __props__.__dict__["group_attribute"] = group_attribute
            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["group_type"] = group_type
            if machine_identify_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_identify_type'")
            __props__.__dict__["machine_identify_type"] = machine_identify_type
            if machine_lists is None and not opts.urn:
                raise TypeError("Missing required property 'machine_lists'")
            __props__.__dict__["machine_lists"] = machine_lists
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
        super(MachineGroup, __self__).__init__(
            'alicloud:sls/machineGroup:MachineGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_attribute: Optional[pulumi.Input[Union['MachineGroupGroupAttributeArgs', 'MachineGroupGroupAttributeArgsDict']]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            group_type: Optional[pulumi.Input[_builtins.str]] = None,
            machine_identify_type: Optional[pulumi.Input[_builtins.str]] = None,
            machine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'MachineGroup':
        """
        Get an existing MachineGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MachineGroupGroupAttributeArgs', 'MachineGroupGroupAttributeArgsDict']] group_attribute: Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        :param pulumi.Input[_builtins.str] group_name: Machine Group name
        :param pulumi.Input[_builtins.str] group_type: Machine group type, optional value is empty.
        :param pulumi.Input[_builtins.str] machine_identify_type: Machine identification type.
               - ip: ip address Machine Group.
               - userdefined: user-defined identity Machine Group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] machine_lists: The identification information of the machine group.
               - If machineidentifiytype is configured to ip, enter the ip address of the server.
               - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MachineGroupState.__new__(_MachineGroupState)

        __props__.__dict__["group_attribute"] = group_attribute
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["group_type"] = group_type
        __props__.__dict__["machine_identify_type"] = machine_identify_type
        __props__.__dict__["machine_lists"] = machine_lists
        __props__.__dict__["project_name"] = project_name
        return MachineGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> pulumi.Output[Optional['outputs.MachineGroupGroupAttribute']]:
        """
        Properties of machine groups. For details, please refer to the groupAttribute parameter description in the following table. See `group_attribute` below.
        """
        return pulumi.get(self, "group_attribute")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Machine Group name
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Machine group type, optional value is empty.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter(name="machineIdentifyType")
    def machine_identify_type(self) -> pulumi.Output[_builtins.str]:
        """
        Machine identification type.
        - ip: ip address Machine Group.
        - userdefined: user-defined identity Machine Group.
        """
        return pulumi.get(self, "machine_identify_type")

    @_builtins.property
    @pulumi.getter(name="machineLists")
    def machine_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The identification information of the machine group.
        - If machineidentifiytype is configured to ip, enter the ip address of the server.
        - If machineidentifiytype is configured to userdefined, enter a custom identifier here.
        """
        return pulumi.get(self, "machine_lists")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

