# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogShipperResult',
    'AwaitableGetLogShipperResult',
    'get_log_shipper',
    'get_log_shipper_output',
]

@pulumi.output_type
class GetLogShipperResult:
    """
    A collection of values returned by getLogShipper.
    """
    def __init__(__self__, auth_status=None, buy_status=None, enable=None, id=None, open_status=None, sls_project_status=None, sls_service_status=None, status=None):
        if auth_status and not isinstance(auth_status, str):
            raise TypeError("Expected argument 'auth_status' to be a str")
        pulumi.set(__self__, "auth_status", auth_status)
        if buy_status and not isinstance(buy_status, str):
            raise TypeError("Expected argument 'buy_status' to be a str")
        pulumi.set(__self__, "buy_status", buy_status)
        if enable and not isinstance(enable, str):
            raise TypeError("Expected argument 'enable' to be a str")
        pulumi.set(__self__, "enable", enable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if open_status and not isinstance(open_status, str):
            raise TypeError("Expected argument 'open_status' to be a str")
        pulumi.set(__self__, "open_status", open_status)
        if sls_project_status and not isinstance(sls_project_status, str):
            raise TypeError("Expected argument 'sls_project_status' to be a str")
        pulumi.set(__self__, "sls_project_status", sls_project_status)
        if sls_service_status and not isinstance(sls_service_status, str):
            raise TypeError("Expected argument 'sls_service_status' to be a str")
        pulumi.set(__self__, "sls_service_status", sls_service_status)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="authStatus")
    def auth_status(self) -> _builtins.str:
        """
        Log Analysis Service authorization status.
        """
        return pulumi.get(self, "auth_status")

    @_builtins.property
    @pulumi.getter(name="buyStatus")
    def buy_status(self) -> _builtins.str:
        """
        Cloud Security Center purchase status.
        """
        return pulumi.get(self, "buy_status")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="openStatus")
    def open_status(self) -> _builtins.str:
        """
        Log analysis shipping activation status.
        """
        return pulumi.get(self, "open_status")

    @_builtins.property
    @pulumi.getter(name="slsProjectStatus")
    def sls_project_status(self) -> _builtins.str:
        """
        Log analysis project status.
        """
        return pulumi.get(self, "sls_project_status")

    @_builtins.property
    @pulumi.getter(name="slsServiceStatus")
    def sls_service_status(self) -> _builtins.str:
        """
        Log Analysis Service is activated.
        """
        return pulumi.get(self, "sls_service_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current service enable status.
        """
        return pulumi.get(self, "status")


class AwaitableGetLogShipperResult(GetLogShipperResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogShipperResult(
            auth_status=self.auth_status,
            buy_status=self.buy_status,
            enable=self.enable,
            id=self.id,
            open_status=self.open_status,
            sls_project_status=self.sls_project_status,
            sls_service_status=self.sls_service_status,
            status=self.status)


def get_log_shipper(enable: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogShipperResult:
    """
    Using this data source can open Threat Detection Log Shipper automatically. If the service has been enabled, it will return `Opened`.

    For information about Threat Detection Log Shipper and how to use it, see [What is Log Shipper](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifyopenlogshipper).

    > **NOTE:** Available in v1.195.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    open = alicloud.threatdetection.get_log_shipper(enable="On")
    ```


    :param _builtins.str enable: Setting the value to `On` to enable the service. Valid values: `On` or `Off`. Default to `Off`.
           
           > **NOTE:** Setting `enable = "On"` to open the Threat Detection Log Shipper that means you have read and agreed the [Threat Detection Log Shipper Terms of Service](https://help.aliyun.com/document_detail/170157.html). The service can not closed once it is opened.
    """
    __args__ = dict()
    __args__['enable'] = enable
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:threatdetection/getLogShipper:getLogShipper', __args__, opts=opts, typ=GetLogShipperResult).value

    return AwaitableGetLogShipperResult(
        auth_status=pulumi.get(__ret__, 'auth_status'),
        buy_status=pulumi.get(__ret__, 'buy_status'),
        enable=pulumi.get(__ret__, 'enable'),
        id=pulumi.get(__ret__, 'id'),
        open_status=pulumi.get(__ret__, 'open_status'),
        sls_project_status=pulumi.get(__ret__, 'sls_project_status'),
        sls_service_status=pulumi.get(__ret__, 'sls_service_status'),
        status=pulumi.get(__ret__, 'status'))
def get_log_shipper_output(enable: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogShipperResult]:
    """
    Using this data source can open Threat Detection Log Shipper automatically. If the service has been enabled, it will return `Opened`.

    For information about Threat Detection Log Shipper and how to use it, see [What is Log Shipper](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifyopenlogshipper).

    > **NOTE:** Available in v1.195.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    open = alicloud.threatdetection.get_log_shipper(enable="On")
    ```


    :param _builtins.str enable: Setting the value to `On` to enable the service. Valid values: `On` or `Off`. Default to `Off`.
           
           > **NOTE:** Setting `enable = "On"` to open the Threat Detection Log Shipper that means you have read and agreed the [Threat Detection Log Shipper Terms of Service](https://help.aliyun.com/document_detail/170157.html). The service can not closed once it is opened.
    """
    __args__ = dict()
    __args__['enable'] = enable
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:threatdetection/getLogShipper:getLogShipper', __args__, opts=opts, typ=GetLogShipperResult)
    return __ret__.apply(lambda __response__: GetLogShipperResult(
        auth_status=pulumi.get(__response__, 'auth_status'),
        buy_status=pulumi.get(__response__, 'buy_status'),
        enable=pulumi.get(__response__, 'enable'),
        id=pulumi.get(__response__, 'id'),
        open_status=pulumi.get(__response__, 'open_status'),
        sls_project_status=pulumi.get(__response__, 'sls_project_status'),
        sls_service_status=pulumi.get(__response__, 'sls_service_status'),
        status=pulumi.get(__response__, 'status')))
