# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OssScanConfigArgs', 'OssScanConfig']

@pulumi.input_type
class OssScanConfigArgs:
    def __init__(__self__, *,
                 bucket_name_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 enable: pulumi.Input[_builtins.int],
                 end_time: pulumi.Input[_builtins.str],
                 key_suffix_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 scan_day_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]],
                 start_time: pulumi.Input[_builtins.str],
                 all_key_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 decompress_max_file_count: Optional[pulumi.Input[_builtins.int]] = None,
                 decompress_max_layer: Optional[pulumi.Input[_builtins.int]] = None,
                 decryption_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_modified_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 oss_scan_config_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OssScanConfig resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bucket_name_lists: The names of the buckets.
        :param pulumi.Input[_builtins.int] enable: Indicates whether the check policy is enabled. Valid values:
        :param pulumi.Input[_builtins.str] end_time: The end time of the check. The time is in the HH:mm:ss format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_suffix_lists: The suffixes of the objects that are checked.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] scan_day_lists: The days when the check is performed. The value indicates the days of the week.
        :param pulumi.Input[_builtins.str] start_time: The start time of the check. The time is in the HH:mm:ss format.
        :param pulumi.Input[_builtins.bool] all_key_prefix: Indicates whether the prefixes of all objects are matched.
        :param pulumi.Input[_builtins.int] decompress_max_file_count: The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[_builtins.int] decompress_max_layer: The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] decryption_lists: The decryption methods.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_prefix_lists: The prefixes of the objects.
        :param pulumi.Input[_builtins.int] last_modified_start_time: The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        :param pulumi.Input[_builtins.str] oss_scan_config_name: The policy name.
        """
        pulumi.set(__self__, "bucket_name_lists", bucket_name_lists)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "key_suffix_lists", key_suffix_lists)
        pulumi.set(__self__, "scan_day_lists", scan_day_lists)
        pulumi.set(__self__, "start_time", start_time)
        if all_key_prefix is not None:
            pulumi.set(__self__, "all_key_prefix", all_key_prefix)
        if decompress_max_file_count is not None:
            pulumi.set(__self__, "decompress_max_file_count", decompress_max_file_count)
        if decompress_max_layer is not None:
            pulumi.set(__self__, "decompress_max_layer", decompress_max_layer)
        if decryption_lists is not None:
            pulumi.set(__self__, "decryption_lists", decryption_lists)
        if key_prefix_lists is not None:
            pulumi.set(__self__, "key_prefix_lists", key_prefix_lists)
        if last_modified_start_time is not None:
            pulumi.set(__self__, "last_modified_start_time", last_modified_start_time)
        if oss_scan_config_name is not None:
            pulumi.set(__self__, "oss_scan_config_name", oss_scan_config_name)

    @_builtins.property
    @pulumi.getter(name="bucketNameLists")
    def bucket_name_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The names of the buckets.
        """
        return pulumi.get(self, "bucket_name_lists")

    @bucket_name_lists.setter
    def bucket_name_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "bucket_name_lists", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Input[_builtins.int]:
        """
        Indicates whether the check policy is enabled. Valid values:
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[_builtins.str]:
        """
        The end time of the check. The time is in the HH:mm:ss format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="keySuffixLists")
    def key_suffix_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The suffixes of the objects that are checked.
        """
        return pulumi.get(self, "key_suffix_lists")

    @key_suffix_lists.setter
    def key_suffix_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "key_suffix_lists", value)

    @_builtins.property
    @pulumi.getter(name="scanDayLists")
    def scan_day_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        The days when the check is performed. The value indicates the days of the week.
        """
        return pulumi.get(self, "scan_day_lists")

    @scan_day_lists.setter
    def scan_day_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "scan_day_lists", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        The start time of the check. The time is in the HH:mm:ss format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="allKeyPrefix")
    def all_key_prefix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the prefixes of all objects are matched.
        """
        return pulumi.get(self, "all_key_prefix")

    @all_key_prefix.setter
    def all_key_prefix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "all_key_prefix", value)

    @_builtins.property
    @pulumi.getter(name="decompressMaxFileCount")
    def decompress_max_file_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        """
        return pulumi.get(self, "decompress_max_file_count")

    @decompress_max_file_count.setter
    def decompress_max_file_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "decompress_max_file_count", value)

    @_builtins.property
    @pulumi.getter(name="decompressMaxLayer")
    def decompress_max_layer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        """
        return pulumi.get(self, "decompress_max_layer")

    @decompress_max_layer.setter
    def decompress_max_layer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "decompress_max_layer", value)

    @_builtins.property
    @pulumi.getter(name="decryptionLists")
    def decryption_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The decryption methods.
        """
        return pulumi.get(self, "decryption_lists")

    @decryption_lists.setter
    def decryption_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "decryption_lists", value)

    @_builtins.property
    @pulumi.getter(name="keyPrefixLists")
    def key_prefix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The prefixes of the objects.
        """
        return pulumi.get(self, "key_prefix_lists")

    @key_prefix_lists.setter
    def key_prefix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_prefix_lists", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedStartTime")
    def last_modified_start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        """
        return pulumi.get(self, "last_modified_start_time")

    @last_modified_start_time.setter
    def last_modified_start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modified_start_time", value)

    @_builtins.property
    @pulumi.getter(name="ossScanConfigName")
    def oss_scan_config_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "oss_scan_config_name")

    @oss_scan_config_name.setter
    def oss_scan_config_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_scan_config_name", value)


@pulumi.input_type
class _OssScanConfigState:
    def __init__(__self__, *,
                 all_key_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 decompress_max_file_count: Optional[pulumi.Input[_builtins.int]] = None,
                 decompress_max_layer: Optional[pulumi.Input[_builtins.int]] = None,
                 decryption_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_suffix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_modified_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 oss_scan_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_day_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OssScanConfig resources.
        :param pulumi.Input[_builtins.bool] all_key_prefix: Indicates whether the prefixes of all objects are matched.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bucket_name_lists: The names of the buckets.
        :param pulumi.Input[_builtins.int] decompress_max_file_count: The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[_builtins.int] decompress_max_layer: The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] decryption_lists: The decryption methods.
        :param pulumi.Input[_builtins.int] enable: Indicates whether the check policy is enabled. Valid values:
        :param pulumi.Input[_builtins.str] end_time: The end time of the check. The time is in the HH:mm:ss format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_prefix_lists: The prefixes of the objects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_suffix_lists: The suffixes of the objects that are checked.
        :param pulumi.Input[_builtins.int] last_modified_start_time: The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        :param pulumi.Input[_builtins.str] oss_scan_config_name: The policy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] scan_day_lists: The days when the check is performed. The value indicates the days of the week.
        :param pulumi.Input[_builtins.str] start_time: The start time of the check. The time is in the HH:mm:ss format.
        """
        if all_key_prefix is not None:
            pulumi.set(__self__, "all_key_prefix", all_key_prefix)
        if bucket_name_lists is not None:
            pulumi.set(__self__, "bucket_name_lists", bucket_name_lists)
        if decompress_max_file_count is not None:
            pulumi.set(__self__, "decompress_max_file_count", decompress_max_file_count)
        if decompress_max_layer is not None:
            pulumi.set(__self__, "decompress_max_layer", decompress_max_layer)
        if decryption_lists is not None:
            pulumi.set(__self__, "decryption_lists", decryption_lists)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if key_prefix_lists is not None:
            pulumi.set(__self__, "key_prefix_lists", key_prefix_lists)
        if key_suffix_lists is not None:
            pulumi.set(__self__, "key_suffix_lists", key_suffix_lists)
        if last_modified_start_time is not None:
            pulumi.set(__self__, "last_modified_start_time", last_modified_start_time)
        if oss_scan_config_name is not None:
            pulumi.set(__self__, "oss_scan_config_name", oss_scan_config_name)
        if scan_day_lists is not None:
            pulumi.set(__self__, "scan_day_lists", scan_day_lists)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="allKeyPrefix")
    def all_key_prefix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the prefixes of all objects are matched.
        """
        return pulumi.get(self, "all_key_prefix")

    @all_key_prefix.setter
    def all_key_prefix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "all_key_prefix", value)

    @_builtins.property
    @pulumi.getter(name="bucketNameLists")
    def bucket_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of the buckets.
        """
        return pulumi.get(self, "bucket_name_lists")

    @bucket_name_lists.setter
    def bucket_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bucket_name_lists", value)

    @_builtins.property
    @pulumi.getter(name="decompressMaxFileCount")
    def decompress_max_file_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        """
        return pulumi.get(self, "decompress_max_file_count")

    @decompress_max_file_count.setter
    def decompress_max_file_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "decompress_max_file_count", value)

    @_builtins.property
    @pulumi.getter(name="decompressMaxLayer")
    def decompress_max_layer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        """
        return pulumi.get(self, "decompress_max_layer")

    @decompress_max_layer.setter
    def decompress_max_layer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "decompress_max_layer", value)

    @_builtins.property
    @pulumi.getter(name="decryptionLists")
    def decryption_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The decryption methods.
        """
        return pulumi.get(self, "decryption_lists")

    @decryption_lists.setter
    def decryption_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "decryption_lists", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates whether the check policy is enabled. Valid values:
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the check. The time is in the HH:mm:ss format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="keyPrefixLists")
    def key_prefix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The prefixes of the objects.
        """
        return pulumi.get(self, "key_prefix_lists")

    @key_prefix_lists.setter
    def key_prefix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_prefix_lists", value)

    @_builtins.property
    @pulumi.getter(name="keySuffixLists")
    def key_suffix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The suffixes of the objects that are checked.
        """
        return pulumi.get(self, "key_suffix_lists")

    @key_suffix_lists.setter
    def key_suffix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_suffix_lists", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedStartTime")
    def last_modified_start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        """
        return pulumi.get(self, "last_modified_start_time")

    @last_modified_start_time.setter
    def last_modified_start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modified_start_time", value)

    @_builtins.property
    @pulumi.getter(name="ossScanConfigName")
    def oss_scan_config_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "oss_scan_config_name")

    @oss_scan_config_name.setter
    def oss_scan_config_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_scan_config_name", value)

    @_builtins.property
    @pulumi.getter(name="scanDayLists")
    def scan_day_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        The days when the check is performed. The value indicates the days of the week.
        """
        return pulumi.get(self, "scan_day_lists")

    @scan_day_lists.setter
    def scan_day_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "scan_day_lists", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the check. The time is in the HH:mm:ss format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.type_token("alicloud:threatdetection/ossScanConfig:OssScanConfig")
class OssScanConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_key_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 decompress_max_file_count: Optional[pulumi.Input[_builtins.int]] = None,
                 decompress_max_layer: Optional[pulumi.Input[_builtins.int]] = None,
                 decryption_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_suffix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_modified_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 oss_scan_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_day_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Threat Detection Oss Scan Config resource.

        Oss detection configuration.

        For information about Threat Detection Oss Scan Config and how to use it, see [What is Oss Scan Config](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createossscanconfig/).

        > **NOTE:** Available since v1.214.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        bucket_random = default["result"]
        default8j4t1_r = alicloud.oss.Bucket("default8j4t1R",
            bucket=f"{name}-1-{bucket_random}",
            storage_class="Standard")
        default9_h_mqf_t = alicloud.oss.Bucket("default9HMqfT",
            bucket=f"{name}-2-{bucket_random}",
            storage_class="Standard")
        defaultx_b_xq_fq = alicloud.oss.Bucket("defaultxBXqFQ",
            bucket=f"{name}-3-{bucket_random}",
            storage_class="Standard")
        defaulth_zv_cm_r = alicloud.oss.Bucket("defaulthZvCmR",
            bucket=f"{name}-4-{bucket_random}",
            storage_class="Standard")
        default_oss_scan_config = alicloud.threatdetection.OssScanConfig("default",
            key_suffix_lists=[
                ".jsp",
                ".php",
                ".k",
            ],
            scan_day_lists=[
                2,
                5,
                4,
                3,
            ],
            oss_scan_config_name=name,
            end_time="00:00:02",
            start_time="00:00:01",
            enable=1,
            all_key_prefix=False,
            bucket_name_lists=[
                default8j4t1_r.bucket,
                default9_h_mqf_t.bucket,
                defaultx_b_xq_fq.bucket,
            ],
            key_prefix_lists=[
                "/root",
                "/usr",
                "/123",
            ])
        ```

        ## Import

        Threat Detection Oss Scan Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/ossScanConfig:OssScanConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] all_key_prefix: Indicates whether the prefixes of all objects are matched.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bucket_name_lists: The names of the buckets.
        :param pulumi.Input[_builtins.int] decompress_max_file_count: The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[_builtins.int] decompress_max_layer: The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] decryption_lists: The decryption methods.
        :param pulumi.Input[_builtins.int] enable: Indicates whether the check policy is enabled. Valid values:
        :param pulumi.Input[_builtins.str] end_time: The end time of the check. The time is in the HH:mm:ss format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_prefix_lists: The prefixes of the objects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_suffix_lists: The suffixes of the objects that are checked.
        :param pulumi.Input[_builtins.int] last_modified_start_time: The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        :param pulumi.Input[_builtins.str] oss_scan_config_name: The policy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] scan_day_lists: The days when the check is performed. The value indicates the days of the week.
        :param pulumi.Input[_builtins.str] start_time: The start time of the check. The time is in the HH:mm:ss format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OssScanConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Threat Detection Oss Scan Config resource.

        Oss detection configuration.

        For information about Threat Detection Oss Scan Config and how to use it, see [What is Oss Scan Config](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createossscanconfig/).

        > **NOTE:** Available since v1.214.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        bucket_random = default["result"]
        default8j4t1_r = alicloud.oss.Bucket("default8j4t1R",
            bucket=f"{name}-1-{bucket_random}",
            storage_class="Standard")
        default9_h_mqf_t = alicloud.oss.Bucket("default9HMqfT",
            bucket=f"{name}-2-{bucket_random}",
            storage_class="Standard")
        defaultx_b_xq_fq = alicloud.oss.Bucket("defaultxBXqFQ",
            bucket=f"{name}-3-{bucket_random}",
            storage_class="Standard")
        defaulth_zv_cm_r = alicloud.oss.Bucket("defaulthZvCmR",
            bucket=f"{name}-4-{bucket_random}",
            storage_class="Standard")
        default_oss_scan_config = alicloud.threatdetection.OssScanConfig("default",
            key_suffix_lists=[
                ".jsp",
                ".php",
                ".k",
            ],
            scan_day_lists=[
                2,
                5,
                4,
                3,
            ],
            oss_scan_config_name=name,
            end_time="00:00:02",
            start_time="00:00:01",
            enable=1,
            all_key_prefix=False,
            bucket_name_lists=[
                default8j4t1_r.bucket,
                default9_h_mqf_t.bucket,
                defaultx_b_xq_fq.bucket,
            ],
            key_prefix_lists=[
                "/root",
                "/usr",
                "/123",
            ])
        ```

        ## Import

        Threat Detection Oss Scan Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/ossScanConfig:OssScanConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param OssScanConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OssScanConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_key_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 decompress_max_file_count: Optional[pulumi.Input[_builtins.int]] = None,
                 decompress_max_layer: Optional[pulumi.Input[_builtins.int]] = None,
                 decryption_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_suffix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_modified_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 oss_scan_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_day_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OssScanConfigArgs.__new__(OssScanConfigArgs)

            __props__.__dict__["all_key_prefix"] = all_key_prefix
            if bucket_name_lists is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name_lists'")
            __props__.__dict__["bucket_name_lists"] = bucket_name_lists
            __props__.__dict__["decompress_max_file_count"] = decompress_max_file_count
            __props__.__dict__["decompress_max_layer"] = decompress_max_layer
            __props__.__dict__["decryption_lists"] = decryption_lists
            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            if end_time is None and not opts.urn:
                raise TypeError("Missing required property 'end_time'")
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["key_prefix_lists"] = key_prefix_lists
            if key_suffix_lists is None and not opts.urn:
                raise TypeError("Missing required property 'key_suffix_lists'")
            __props__.__dict__["key_suffix_lists"] = key_suffix_lists
            __props__.__dict__["last_modified_start_time"] = last_modified_start_time
            __props__.__dict__["oss_scan_config_name"] = oss_scan_config_name
            if scan_day_lists is None and not opts.urn:
                raise TypeError("Missing required property 'scan_day_lists'")
            __props__.__dict__["scan_day_lists"] = scan_day_lists
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
        super(OssScanConfig, __self__).__init__(
            'alicloud:threatdetection/ossScanConfig:OssScanConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_key_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
            bucket_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            decompress_max_file_count: Optional[pulumi.Input[_builtins.int]] = None,
            decompress_max_layer: Optional[pulumi.Input[_builtins.int]] = None,
            decryption_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enable: Optional[pulumi.Input[_builtins.int]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            key_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_suffix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            last_modified_start_time: Optional[pulumi.Input[_builtins.int]] = None,
            oss_scan_config_name: Optional[pulumi.Input[_builtins.str]] = None,
            scan_day_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'OssScanConfig':
        """
        Get an existing OssScanConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] all_key_prefix: Indicates whether the prefixes of all objects are matched.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bucket_name_lists: The names of the buckets.
        :param pulumi.Input[_builtins.int] decompress_max_file_count: The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[_builtins.int] decompress_max_layer: The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] decryption_lists: The decryption methods.
        :param pulumi.Input[_builtins.int] enable: Indicates whether the check policy is enabled. Valid values:
        :param pulumi.Input[_builtins.str] end_time: The end time of the check. The time is in the HH:mm:ss format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_prefix_lists: The prefixes of the objects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_suffix_lists: The suffixes of the objects that are checked.
        :param pulumi.Input[_builtins.int] last_modified_start_time: The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        :param pulumi.Input[_builtins.str] oss_scan_config_name: The policy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] scan_day_lists: The days when the check is performed. The value indicates the days of the week.
        :param pulumi.Input[_builtins.str] start_time: The start time of the check. The time is in the HH:mm:ss format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OssScanConfigState.__new__(_OssScanConfigState)

        __props__.__dict__["all_key_prefix"] = all_key_prefix
        __props__.__dict__["bucket_name_lists"] = bucket_name_lists
        __props__.__dict__["decompress_max_file_count"] = decompress_max_file_count
        __props__.__dict__["decompress_max_layer"] = decompress_max_layer
        __props__.__dict__["decryption_lists"] = decryption_lists
        __props__.__dict__["enable"] = enable
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["key_prefix_lists"] = key_prefix_lists
        __props__.__dict__["key_suffix_lists"] = key_suffix_lists
        __props__.__dict__["last_modified_start_time"] = last_modified_start_time
        __props__.__dict__["oss_scan_config_name"] = oss_scan_config_name
        __props__.__dict__["scan_day_lists"] = scan_day_lists
        __props__.__dict__["start_time"] = start_time
        return OssScanConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allKeyPrefix")
    def all_key_prefix(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the prefixes of all objects are matched.
        """
        return pulumi.get(self, "all_key_prefix")

    @_builtins.property
    @pulumi.getter(name="bucketNameLists")
    def bucket_name_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The names of the buckets.
        """
        return pulumi.get(self, "bucket_name_lists")

    @_builtins.property
    @pulumi.getter(name="decompressMaxFileCount")
    def decompress_max_file_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        """
        return pulumi.get(self, "decompress_max_file_count")

    @_builtins.property
    @pulumi.getter(name="decompressMaxLayer")
    def decompress_max_layer(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        """
        return pulumi.get(self, "decompress_max_layer")

    @_builtins.property
    @pulumi.getter(name="decryptionLists")
    def decryption_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The decryption methods.
        """
        return pulumi.get(self, "decryption_lists")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates whether the check policy is enabled. Valid values:
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The end time of the check. The time is in the HH:mm:ss format.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="keyPrefixLists")
    def key_prefix_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The prefixes of the objects.
        """
        return pulumi.get(self, "key_prefix_lists")

    @_builtins.property
    @pulumi.getter(name="keySuffixLists")
    def key_suffix_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The suffixes of the objects that are checked.
        """
        return pulumi.get(self, "key_suffix_lists")

    @_builtins.property
    @pulumi.getter(name="lastModifiedStartTime")
    def last_modified_start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        """
        return pulumi.get(self, "last_modified_start_time")

    @_builtins.property
    @pulumi.getter(name="ossScanConfigName")
    def oss_scan_config_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "oss_scan_config_name")

    @_builtins.property
    @pulumi.getter(name="scanDayLists")
    def scan_day_lists(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        The days when the check is performed. The value indicates the days of the week.
        """
        return pulumi.get(self, "scan_day_lists")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The start time of the check. The time is in the HH:mm:ss format.
        """
        return pulumi.get(self, "start_time")

