# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BgpPeerArgs', 'BgpPeer']

@pulumi.input_type
class BgpPeerArgs:
    def __init__(__self__, *,
                 bgp_group_id: pulumi.Input[_builtins.str],
                 bfd_multi_hop: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_bfd: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BgpPeer resource.
        :param pulumi.Input[_builtins.str] bgp_group_id: The ID of the BGP group.
        :param pulumi.Input[_builtins.int] bfd_multi_hop: The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        :param pulumi.Input[_builtins.bool] enable_bfd: Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        :param pulumi.Input[_builtins.str] ip_version: The IP version.
        :param pulumi.Input[_builtins.str] peer_ip_address: The IP address of the BGP peer.
        """
        pulumi.set(__self__, "bgp_group_id", bgp_group_id)
        if bfd_multi_hop is not None:
            pulumi.set(__self__, "bfd_multi_hop", bfd_multi_hop)
        if enable_bfd is not None:
            pulumi.set(__self__, "enable_bfd", enable_bfd)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)

    @_builtins.property
    @pulumi.getter(name="bgpGroupId")
    def bgp_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the BGP group.
        """
        return pulumi.get(self, "bgp_group_id")

    @bgp_group_id.setter
    def bgp_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bgp_group_id", value)

    @_builtins.property
    @pulumi.getter(name="bfdMultiHop")
    def bfd_multi_hop(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        """
        return pulumi.get(self, "bfd_multi_hop")

    @bfd_multi_hop.setter
    def bfd_multi_hop(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bfd_multi_hop", value)

    @_builtins.property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        """
        return pulumi.get(self, "enable_bfd")

    @enable_bfd.setter
    def enable_bfd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_bfd", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the BGP peer.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ip_address", value)


@pulumi.input_type
class _BgpPeerState:
    def __init__(__self__, *,
                 bfd_multi_hop: Optional[pulumi.Input[_builtins.int]] = None,
                 bgp_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_peer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bfd: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BgpPeer resources.
        :param pulumi.Input[_builtins.int] bfd_multi_hop: The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        :param pulumi.Input[_builtins.str] bgp_group_id: The ID of the BGP group.
        :param pulumi.Input[_builtins.str] bgp_peer_name: The name of the BGP neighbor.
        :param pulumi.Input[_builtins.bool] enable_bfd: Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        :param pulumi.Input[_builtins.str] ip_version: The IP version.
        :param pulumi.Input[_builtins.str] peer_ip_address: The IP address of the BGP peer.
        :param pulumi.Input[_builtins.str] status: Status of BGP neighbors.
        """
        if bfd_multi_hop is not None:
            pulumi.set(__self__, "bfd_multi_hop", bfd_multi_hop)
        if bgp_group_id is not None:
            pulumi.set(__self__, "bgp_group_id", bgp_group_id)
        if bgp_peer_name is not None:
            pulumi.set(__self__, "bgp_peer_name", bgp_peer_name)
        if enable_bfd is not None:
            pulumi.set(__self__, "enable_bfd", enable_bfd)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="bfdMultiHop")
    def bfd_multi_hop(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        """
        return pulumi.get(self, "bfd_multi_hop")

    @bfd_multi_hop.setter
    def bfd_multi_hop(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bfd_multi_hop", value)

    @_builtins.property
    @pulumi.getter(name="bgpGroupId")
    def bgp_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the BGP group.
        """
        return pulumi.get(self, "bgp_group_id")

    @bgp_group_id.setter
    def bgp_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_group_id", value)

    @_builtins.property
    @pulumi.getter(name="bgpPeerName")
    def bgp_peer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the BGP neighbor.
        """
        return pulumi.get(self, "bgp_peer_name")

    @bgp_peer_name.setter
    def bgp_peer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_peer_name", value)

    @_builtins.property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        """
        return pulumi.get(self, "enable_bfd")

    @enable_bfd.setter
    def enable_bfd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_bfd", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the BGP peer.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of BGP neighbors.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/bgpPeer:BgpPeer")
class BgpPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bfd_multi_hop: Optional[pulumi.Input[_builtins.int]] = None,
                 bgp_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bfd: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Bgp Peer resource.

        For information about VPC Bgp Peer and how to use it, see [What is Bgp Peer](https://www.alibabacloud.com/help/en/doc-detail/91267.html).

        > **NOTE:** Available since v1.153.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.index.Integer("vlan_id",
            max=2999,
            min=1)
        example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=example.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=vlan_id["id"],
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        example_bgp_group = alicloud.vpc.BgpGroup("example",
            auth_key="YourPassword+12345678",
            bgp_group_name=name,
            description=name,
            peer_asn=1111,
            router_id=example_virtual_border_router.id,
            is_fake_asn=True)
        example_bgp_peer = alicloud.vpc.BgpPeer("example",
            bfd_multi_hop=10,
            bgp_group_id=example_bgp_group.id,
            enable_bfd=True,
            ip_version="IPV4",
            peer_ip_address="1.1.1.1")
        ```

        ## Import

        Express Connect Bgp Peer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/bgpPeer:BgpPeer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bfd_multi_hop: The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        :param pulumi.Input[_builtins.str] bgp_group_id: The ID of the BGP group.
        :param pulumi.Input[_builtins.bool] enable_bfd: Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        :param pulumi.Input[_builtins.str] ip_version: The IP version.
        :param pulumi.Input[_builtins.str] peer_ip_address: The IP address of the BGP peer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BgpPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Bgp Peer resource.

        For information about VPC Bgp Peer and how to use it, see [What is Bgp Peer](https://www.alibabacloud.com/help/en/doc-detail/91267.html).

        > **NOTE:** Available since v1.153.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.index.Integer("vlan_id",
            max=2999,
            min=1)
        example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=example.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=vlan_id["id"],
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        example_bgp_group = alicloud.vpc.BgpGroup("example",
            auth_key="YourPassword+12345678",
            bgp_group_name=name,
            description=name,
            peer_asn=1111,
            router_id=example_virtual_border_router.id,
            is_fake_asn=True)
        example_bgp_peer = alicloud.vpc.BgpPeer("example",
            bfd_multi_hop=10,
            bgp_group_id=example_bgp_group.id,
            enable_bfd=True,
            ip_version="IPV4",
            peer_ip_address="1.1.1.1")
        ```

        ## Import

        Express Connect Bgp Peer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/bgpPeer:BgpPeer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BgpPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BgpPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bfd_multi_hop: Optional[pulumi.Input[_builtins.int]] = None,
                 bgp_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bfd: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BgpPeerArgs.__new__(BgpPeerArgs)

            __props__.__dict__["bfd_multi_hop"] = bfd_multi_hop
            if bgp_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_group_id'")
            __props__.__dict__["bgp_group_id"] = bgp_group_id
            __props__.__dict__["enable_bfd"] = enable_bfd
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["peer_ip_address"] = peer_ip_address
            __props__.__dict__["bgp_peer_name"] = None
            __props__.__dict__["status"] = None
        super(BgpPeer, __self__).__init__(
            'alicloud:vpc/bgpPeer:BgpPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bfd_multi_hop: Optional[pulumi.Input[_builtins.int]] = None,
            bgp_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            bgp_peer_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_bfd: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            peer_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'BgpPeer':
        """
        Get an existing BgpPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bfd_multi_hop: The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        :param pulumi.Input[_builtins.str] bgp_group_id: The ID of the BGP group.
        :param pulumi.Input[_builtins.str] bgp_peer_name: The name of the BGP neighbor.
        :param pulumi.Input[_builtins.bool] enable_bfd: Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        :param pulumi.Input[_builtins.str] ip_version: The IP version.
        :param pulumi.Input[_builtins.str] peer_ip_address: The IP address of the BGP peer.
        :param pulumi.Input[_builtins.str] status: Status of BGP neighbors.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BgpPeerState.__new__(_BgpPeerState)

        __props__.__dict__["bfd_multi_hop"] = bfd_multi_hop
        __props__.__dict__["bgp_group_id"] = bgp_group_id
        __props__.__dict__["bgp_peer_name"] = bgp_peer_name
        __props__.__dict__["enable_bfd"] = enable_bfd
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["peer_ip_address"] = peer_ip_address
        __props__.__dict__["status"] = status
        return BgpPeer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bfdMultiHop")
    def bfd_multi_hop(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The BFD hop count. Valid values: `1` to `255`. **NOTE:** The attribute is valid when the attribute `enable_bfd` is `true`. The parameter specifies the maximum number of network devices that a packet can traverse from the source to the destination. You can set a proper value based on the factors that affect the physical connection.
        """
        return pulumi.get(self, "bfd_multi_hop")

    @_builtins.property
    @pulumi.getter(name="bgpGroupId")
    def bgp_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the BGP group.
        """
        return pulumi.get(self, "bgp_group_id")

    @_builtins.property
    @pulumi.getter(name="bgpPeerName")
    def bgp_peer_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the BGP neighbor.
        """
        return pulumi.get(self, "bgp_peer_name")

    @_builtins.property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the Bidirectional Forwarding Detection (BFD) feature.
        """
        return pulumi.get(self, "enable_bfd")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the BGP peer.
        """
        return pulumi.get(self, "peer_ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of BGP neighbors.
        """
        return pulumi.get(self, "status")

