# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlowLogArgs', 'FlowLog']

@pulumi.input_type
class FlowLogArgs:
    def __init__(__self__, *,
                 log_store_name: pulumi.Input[_builtins.str],
                 project_name: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 traffic_type: pulumi.Input[_builtins.str],
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FlowLog resource.
        :param pulumi.Input[_builtins.str] log_store_name: The Logstore that stores the captured traffic data.
        :param pulumi.Input[_builtins.str] project_name: The project that manages the captured traffic data.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the traffic captured by the flow log:
               - `NetworkInterface`: ENI.
               - `VSwitch`: All ENIs in the VSwitch.
               - `VPC`: All ENIs in the VPC.
        :param pulumi.Input[_builtins.str] traffic_type: The type of traffic collected. Valid values:
               - *All**: All traffic.
               - *Allow**: Access control allowedtraffic.
               - *Drop**: Access control denied traffic.
        :param pulumi.Input[_builtins.str] aggregation_interval: The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        :param pulumi.Input[_builtins.str] description: The Description of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] flow_log_name: The Name of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] ip_version: The IP address type of the collected traffic.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the current instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_paths: The collected flow path. Value:
               - *all**: indicates full acquisition.
               - *internetGateway**: indicates public network traffic collection.
        """
        pulumi.set(__self__, "log_store_name", log_store_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "traffic_type", traffic_type)
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_log_name is not None:
            pulumi.set(__self__, "flow_log_name", flow_log_name)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_paths is not None:
            pulumi.set(__self__, "traffic_paths", traffic_paths)

    @_builtins.property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Logstore that stores the captured traffic data.
        """
        return pulumi.get(self, "log_store_name")

    @log_store_name.setter
    def log_store_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_store_name", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        The project that manages the captured traffic data.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The resource type of the traffic captured by the flow log:
        - `NetworkInterface`: ENI.
        - `VSwitch`: All ENIs in the VSwitch.
        - `VPC`: All ENIs in the VPC.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of traffic collected. Valid values:
        - *All**: All traffic.
        - *Allow**: Access control allowedtraffic.
        - *Drop**: Access control denied traffic.
        """
        return pulumi.get(self, "traffic_type")

    @traffic_type.setter
    def traffic_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "traffic_type", value)

    @_builtins.property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_interval", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Description of the VPC Flow Log.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the VPC Flow Log.
        """
        return pulumi.get(self, "flow_log_name")

    @flow_log_name.setter
    def flow_log_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flow_log_name", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address type of the collected traffic.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the current instance resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trafficPaths")
    def traffic_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The collected flow path. Value:
        - *all**: indicates full acquisition.
        - *internetGateway**: indicates public network traffic collection.
        """
        return pulumi.get(self, "traffic_paths")

    @traffic_paths.setter
    def traffic_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "traffic_paths", value)


@pulumi.input_type
class _FlowLogState:
    def __init__(__self__, *,
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlowLog resources.
        :param pulumi.Input[_builtins.str] aggregation_interval: The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        :param pulumi.Input[_builtins.str] business_status: Business status
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] description: The Description of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] flow_log_id: The flow log ID.
        :param pulumi.Input[_builtins.str] flow_log_name: The Name of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] ip_version: The IP address type of the collected traffic.
        :param pulumi.Input[_builtins.str] log_store_name: The Logstore that stores the captured traffic data.
        :param pulumi.Input[_builtins.str] project_name: The project that manages the captured traffic data.
        :param pulumi.Input[_builtins.str] region_id: The region ID.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the traffic captured by the flow log:
               - `NetworkInterface`: ENI.
               - `VSwitch`: All ENIs in the VSwitch.
               - `VPC`: All ENIs in the VPC.
        :param pulumi.Input[_builtins.str] status: The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the current instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_paths: The collected flow path. Value:
               - *all**: indicates full acquisition.
               - *internetGateway**: indicates public network traffic collection.
        :param pulumi.Input[_builtins.str] traffic_type: The type of traffic collected. Valid values:
               - *All**: All traffic.
               - *Allow**: Access control allowedtraffic.
               - *Drop**: Access control denied traffic.
        """
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_log_id is not None:
            pulumi.set(__self__, "flow_log_id", flow_log_id)
        if flow_log_name is not None:
            pulumi.set(__self__, "flow_log_name", flow_log_name)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if log_store_name is not None:
            pulumi.set(__self__, "log_store_name", log_store_name)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_paths is not None:
            pulumi.set(__self__, "traffic_paths", traffic_paths)
        if traffic_type is not None:
            pulumi.set(__self__, "traffic_type", traffic_type)

    @_builtins.property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_interval", value)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Business status
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_status", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Description of the VPC Flow Log.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flow log ID.
        """
        return pulumi.get(self, "flow_log_id")

    @flow_log_id.setter
    def flow_log_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flow_log_id", value)

    @_builtins.property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the VPC Flow Log.
        """
        return pulumi.get(self, "flow_log_name")

    @flow_log_name.setter
    def flow_log_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flow_log_name", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address type of the collected traffic.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Logstore that stores the captured traffic data.
        """
        return pulumi.get(self, "log_store_name")

    @log_store_name.setter
    def log_store_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store_name", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project that manages the captured traffic data.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of the traffic captured by the flow log:
        - `NetworkInterface`: ENI.
        - `VSwitch`: All ENIs in the VSwitch.
        - `VPC`: All ENIs in the VPC.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the current instance resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trafficPaths")
    def traffic_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The collected flow path. Value:
        - *all**: indicates full acquisition.
        - *internetGateway**: indicates public network traffic collection.
        """
        return pulumi.get(self, "traffic_paths")

    @traffic_paths.setter
    def traffic_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "traffic_paths", value)

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of traffic collected. Valid values:
        - *All**: All traffic.
        - *Allow**: Access control allowedtraffic.
        - *Drop**: Access control denied traffic.
        """
        return pulumi.get(self, "traffic_type")

    @traffic_type.setter
    def traffic_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_type", value)


@pulumi.type_token("alicloud:vpc/flowLog:FlowLog")
class FlowLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Flow Log resource.

        While it uses vpc.FlowLog to build a vpc flow log resource, it will be active by default.

        For information about VPC Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/flow-logs-overview).

        > **NOTE:** Available since v1.117.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        example = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_uuid = random.index.Uuid("example")
        example_project = alicloud.log.Project("example",
            project_name=std.substr(input=f"tf-example-{std.replace(text=example_uuid['result'],
                    search='-',
                    replace='').result}",
                offset=0,
                length=16).result,
            description=name)
        example_store = alicloud.log.Store("example",
            project_name=example_project.project_name,
            logstore_name=name,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_flow_log = alicloud.vpc.FlowLog("example",
            flow_log_name=name,
            log_store_name=example_store.logstore_name,
            description=name,
            traffic_paths=["all"],
            project_name=example_project.project_name,
            resource_type="VPC",
            resource_group_id=default.ids[0],
            resource_id=example.id,
            aggregation_interval="1",
            traffic_type="All")
        ```

        ## Import

        VPC Flow Log can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/flowLog:FlowLog example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregation_interval: The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        :param pulumi.Input[_builtins.str] description: The Description of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] flow_log_name: The Name of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] ip_version: The IP address type of the collected traffic.
        :param pulumi.Input[_builtins.str] log_store_name: The Logstore that stores the captured traffic data.
        :param pulumi.Input[_builtins.str] project_name: The project that manages the captured traffic data.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the traffic captured by the flow log:
               - `NetworkInterface`: ENI.
               - `VSwitch`: All ENIs in the VSwitch.
               - `VPC`: All ENIs in the VPC.
        :param pulumi.Input[_builtins.str] status: The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the current instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_paths: The collected flow path. Value:
               - *all**: indicates full acquisition.
               - *internetGateway**: indicates public network traffic collection.
        :param pulumi.Input[_builtins.str] traffic_type: The type of traffic collected. Valid values:
               - *All**: All traffic.
               - *Allow**: Access control allowedtraffic.
               - *Drop**: Access control denied traffic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Flow Log resource.

        While it uses vpc.FlowLog to build a vpc flow log resource, it will be active by default.

        For information about VPC Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/flow-logs-overview).

        > **NOTE:** Available since v1.117.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        example = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_uuid = random.index.Uuid("example")
        example_project = alicloud.log.Project("example",
            project_name=std.substr(input=f"tf-example-{std.replace(text=example_uuid['result'],
                    search='-',
                    replace='').result}",
                offset=0,
                length=16).result,
            description=name)
        example_store = alicloud.log.Store("example",
            project_name=example_project.project_name,
            logstore_name=name,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_flow_log = alicloud.vpc.FlowLog("example",
            flow_log_name=name,
            log_store_name=example_store.logstore_name,
            description=name,
            traffic_paths=["all"],
            project_name=example_project.project_name,
            resource_type="VPC",
            resource_group_id=default.ids[0],
            resource_id=example.id,
            aggregation_interval="1",
            traffic_type="All")
        ```

        ## Import

        VPC Flow Log can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/flowLog:FlowLog example <id>
        ```

        :param str resource_name: The name of the resource.
        :param FlowLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_log_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowLogArgs.__new__(FlowLogArgs)

            __props__.__dict__["aggregation_interval"] = aggregation_interval
            __props__.__dict__["description"] = description
            __props__.__dict__["flow_log_name"] = flow_log_name
            __props__.__dict__["ip_version"] = ip_version
            if log_store_name is None and not opts.urn:
                raise TypeError("Missing required property 'log_store_name'")
            __props__.__dict__["log_store_name"] = log_store_name
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_paths"] = traffic_paths
            if traffic_type is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_type'")
            __props__.__dict__["traffic_type"] = traffic_type
            __props__.__dict__["business_status"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["flow_log_id"] = None
            __props__.__dict__["region_id"] = None
        super(FlowLog, __self__).__init__(
            'alicloud:vpc/flowLog:FlowLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_interval: Optional[pulumi.Input[_builtins.str]] = None,
            business_status: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            flow_log_id: Optional[pulumi.Input[_builtins.str]] = None,
            flow_log_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            log_store_name: Optional[pulumi.Input[_builtins.str]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            traffic_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            traffic_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlowLog':
        """
        Get an existing FlowLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregation_interval: The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        :param pulumi.Input[_builtins.str] business_status: Business status
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] description: The Description of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] flow_log_id: The flow log ID.
        :param pulumi.Input[_builtins.str] flow_log_name: The Name of the VPC Flow Log.
        :param pulumi.Input[_builtins.str] ip_version: The IP address type of the collected traffic.
        :param pulumi.Input[_builtins.str] log_store_name: The Logstore that stores the captured traffic data.
        :param pulumi.Input[_builtins.str] project_name: The project that manages the captured traffic data.
        :param pulumi.Input[_builtins.str] region_id: The region ID.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the traffic captured by the flow log:
               - `NetworkInterface`: ENI.
               - `VSwitch`: All ENIs in the VSwitch.
               - `VPC`: All ENIs in the VPC.
        :param pulumi.Input[_builtins.str] status: The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the current instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_paths: The collected flow path. Value:
               - *all**: indicates full acquisition.
               - *internetGateway**: indicates public network traffic collection.
        :param pulumi.Input[_builtins.str] traffic_type: The type of traffic collected. Valid values:
               - *All**: All traffic.
               - *Allow**: Access control allowedtraffic.
               - *Drop**: Access control denied traffic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowLogState.__new__(_FlowLogState)

        __props__.__dict__["aggregation_interval"] = aggregation_interval
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["flow_log_id"] = flow_log_id
        __props__.__dict__["flow_log_name"] = flow_log_name
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["log_store_name"] = log_store_name
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["traffic_paths"] = traffic_paths
        __props__.__dict__["traffic_type"] = traffic_type
        return FlowLog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> pulumi.Output[_builtins.str]:
        """
        The sampling interval of the flow log. Unit: seconds. Valid values: 1, 5, and 10 (default).
        """
        return pulumi.get(self, "aggregation_interval")

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[_builtins.str]:
        """
        Business status
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Description of the VPC Flow Log.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> pulumi.Output[_builtins.str]:
        """
        The flow log ID.
        """
        return pulumi.get(self, "flow_log_id")

    @_builtins.property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Name of the VPC Flow Log.
        """
        return pulumi.get(self, "flow_log_name")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address type of the collected traffic.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Logstore that stores the captured traffic data.
        """
        return pulumi.get(self, "log_store_name")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        The project that manages the captured traffic data.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The resource type of the traffic captured by the flow log:
        - `NetworkInterface`: ENI.
        - `VSwitch`: All ENIs in the VSwitch.
        - `VPC`: All ENIs in the VPC.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the VPC Flow Log. Valid values: `Active` and `Inactive`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the current instance resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trafficPaths")
    def traffic_paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The collected flow path. Value:
        - *all**: indicates full acquisition.
        - *internetGateway**: indicates public network traffic collection.
        """
        return pulumi.get(self, "traffic_paths")

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of traffic collected. Valid values:
        - *All**: All traffic.
        - *Allow**: Access control allowedtraffic.
        - *Drop**: Access control denied traffic.
        """
        return pulumi.get(self, "traffic_type")

