# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Ipv6EgressRuleArgs', 'Ipv6EgressRule']

@pulumi.input_type
class Ipv6EgressRuleArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 ipv6_gateway_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_egress_rule_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Ipv6EgressRule resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the IPv6 address to which you want to apply the egress-only rule.
        :param pulumi.Input[_builtins.str] ipv6_gateway_id: The ID of the IPv6 gateway.
        :param pulumi.Input[_builtins.str] description: The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        :param pulumi.Input[_builtins.str] ipv6_egress_rule_name: The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_egress_rule_name is not None:
            pulumi.set(__self__, "ipv6_egress_rule_name", ipv6_egress_rule_name)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IPv6 address to which you want to apply the egress-only rule.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @ipv6_gateway_id.setter
    def ipv6_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipv6_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleName")
    def ipv6_egress_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "ipv6_egress_rule_name")

    @ipv6_egress_rule_name.setter
    def ipv6_egress_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_egress_rule_name", value)


@pulumi.input_type
class _Ipv6EgressRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_egress_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_egress_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ipv6EgressRule resources.
        :param pulumi.Input[_builtins.str] description: The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the IPv6 address to which you want to apply the egress-only rule.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        :param pulumi.Input[_builtins.str] ipv6_egress_rule_id: The ID of the IPv6 EgressRule.
        :param pulumi.Input[_builtins.str] ipv6_egress_rule_name: The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] ipv6_gateway_id: The ID of the IPv6 gateway.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_egress_rule_id is not None:
            pulumi.set(__self__, "ipv6_egress_rule_id", ipv6_egress_rule_id)
        if ipv6_egress_rule_name is not None:
            pulumi.set(__self__, "ipv6_egress_rule_name", ipv6_egress_rule_name)
        if ipv6_gateway_id is not None:
            pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPv6 address to which you want to apply the egress-only rule.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleId")
    def ipv6_egress_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPv6 EgressRule.
        """
        return pulumi.get(self, "ipv6_egress_rule_id")

    @ipv6_egress_rule_id.setter
    def ipv6_egress_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_egress_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleName")
    def ipv6_egress_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "ipv6_egress_rule_name")

    @ipv6_egress_rule_name.setter
    def ipv6_egress_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_egress_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @ipv6_gateway_id.setter
    def ipv6_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/ipv6EgressRule:Ipv6EgressRule")
class Ipv6EgressRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_egress_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Ipv6 Egress Rule resource. IPv6 address addition only active exit rule.

        For information about VPC Ipv6 Egress Rule and how to use it, see [What is Ipv6 Egress Rule](https://www.alibabacloud.com/help/doc-detail/102200.htm).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            system_disk_category="cloud_efficiency",
            cpu_core_count=4,
            minimum_eni_ipv6_address_quantity=1)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            enable_ipv6=True,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name,
            ipv6_cidr_block_mask=64)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            description=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            ipv6_address_count=1,
            instance_type=default_get_instance_types.instance_types[0].id,
            system_disk_category="cloud_efficiency",
            image_id=default_get_images.images[0].id,
            instance_name=name,
            vswitch_id=default_switch.id,
            internet_max_bandwidth_out=10,
            security_groups=[default_security_group.id])
        default_ipv6_gateway = alicloud.vpc.Ipv6Gateway("default",
            ipv6_gateway_name=name,
            vpc_id=default_network.id)
        default_get_ipv6_addresses = alicloud.vpc.get_ipv6_addresses_output(associated_instance_id=default_instance.id,
            status="Available")
        default_ipv6_internet_bandwidth = alicloud.vpc.Ipv6InternetBandwidth("default",
            ipv6_address_id=default_get_ipv6_addresses.addresses[0].id,
            ipv6_gateway_id=default_ipv6_gateway.ipv6_gateway_id,
            internet_charge_type="PayByBandwidth",
            bandwidth=20)
        default_ipv6_egress_rule = alicloud.vpc.Ipv6EgressRule("default",
            instance_id=default_ipv6_internet_bandwidth.ipv6_address_id,
            ipv6_egress_rule_name=name,
            description=name,
            ipv6_gateway_id=default_ipv6_internet_bandwidth.ipv6_gateway_id,
            instance_type="Ipv6Address")
        ```

        ## Import

        VPC Ipv6 Egress Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv6EgressRule:Ipv6EgressRule example <ipv6_gateway_id>:<ipv6_egress_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the IPv6 address to which you want to apply the egress-only rule.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        :param pulumi.Input[_builtins.str] ipv6_egress_rule_name: The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] ipv6_gateway_id: The ID of the IPv6 gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ipv6EgressRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Ipv6 Egress Rule resource. IPv6 address addition only active exit rule.

        For information about VPC Ipv6 Egress Rule and how to use it, see [What is Ipv6 Egress Rule](https://www.alibabacloud.com/help/doc-detail/102200.htm).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            system_disk_category="cloud_efficiency",
            cpu_core_count=4,
            minimum_eni_ipv6_address_quantity=1)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            enable_ipv6=True,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name,
            ipv6_cidr_block_mask=64)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            description=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            ipv6_address_count=1,
            instance_type=default_get_instance_types.instance_types[0].id,
            system_disk_category="cloud_efficiency",
            image_id=default_get_images.images[0].id,
            instance_name=name,
            vswitch_id=default_switch.id,
            internet_max_bandwidth_out=10,
            security_groups=[default_security_group.id])
        default_ipv6_gateway = alicloud.vpc.Ipv6Gateway("default",
            ipv6_gateway_name=name,
            vpc_id=default_network.id)
        default_get_ipv6_addresses = alicloud.vpc.get_ipv6_addresses_output(associated_instance_id=default_instance.id,
            status="Available")
        default_ipv6_internet_bandwidth = alicloud.vpc.Ipv6InternetBandwidth("default",
            ipv6_address_id=default_get_ipv6_addresses.addresses[0].id,
            ipv6_gateway_id=default_ipv6_gateway.ipv6_gateway_id,
            internet_charge_type="PayByBandwidth",
            bandwidth=20)
        default_ipv6_egress_rule = alicloud.vpc.Ipv6EgressRule("default",
            instance_id=default_ipv6_internet_bandwidth.ipv6_address_id,
            ipv6_egress_rule_name=name,
            description=name,
            ipv6_gateway_id=default_ipv6_internet_bandwidth.ipv6_gateway_id,
            instance_type="Ipv6Address")
        ```

        ## Import

        VPC Ipv6 Egress Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv6EgressRule:Ipv6EgressRule example <ipv6_gateway_id>:<ipv6_egress_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param Ipv6EgressRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ipv6EgressRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_egress_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ipv6EgressRuleArgs.__new__(Ipv6EgressRuleArgs)

            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_egress_rule_name"] = ipv6_egress_rule_name
            if ipv6_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipv6_gateway_id'")
            __props__.__dict__["ipv6_gateway_id"] = ipv6_gateway_id
            __props__.__dict__["ipv6_egress_rule_id"] = None
            __props__.__dict__["status"] = None
        super(Ipv6EgressRule, __self__).__init__(
            'alicloud:vpc/ipv6EgressRule:Ipv6EgressRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_egress_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_egress_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ipv6EgressRule':
        """
        Get an existing Ipv6EgressRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the IPv6 address to which you want to apply the egress-only rule.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        :param pulumi.Input[_builtins.str] ipv6_egress_rule_id: The ID of the IPv6 EgressRule.
        :param pulumi.Input[_builtins.str] ipv6_egress_rule_name: The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] ipv6_gateway_id: The ID of the IPv6 gateway.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ipv6EgressRuleState.__new__(_Ipv6EgressRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_egress_rule_id"] = ipv6_egress_rule_id
        __props__.__dict__["ipv6_egress_rule_name"] = ipv6_egress_rule_name
        __props__.__dict__["ipv6_gateway_id"] = ipv6_gateway_id
        __props__.__dict__["status"] = status
        return Ipv6EgressRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the egress-only rule. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPv6 address to which you want to apply the egress-only rule.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of instance to which you want to apply the egress-only rule. Valid values: `Ipv6Address`. `Ipv6Address` (default): an IPv6 address.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleId")
    def ipv6_egress_rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPv6 EgressRule.
        """
        return pulumi.get(self, "ipv6_egress_rule_id")

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleName")
    def ipv6_egress_rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the egress-only rule. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "ipv6_egress_rule_name")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

