# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DhcpOptionsSetAssociateVpc',
    'NatGatewayAccessMode',
    'NetworkAclAttachmentResource',
    'NetworkAclEgressAclEntry',
    'NetworkAclEntriesEgress',
    'NetworkAclEntriesIngress',
    'NetworkAclIngressAclEntry',
    'NetworkAclResource',
    'NetworkIpv6CidrBlock',
    'PrefixListEntry',
    'PrefixListPrefixListAssociation',
    'TrafficMirrorFilterEgressRule',
    'TrafficMirrorFilterIngressRule',
    'VPCRouteEntryNextHop',
    'VPCRouteEntryNextHopNextHopRelatedInfo',
    'VPCRouteEntryRoutePublishTarget',
    'GetBgpGroupsGroupResult',
    'GetBgpNetworksNetworkResult',
    'GetBgpPeersPeerResult',
    'GetCommonBandwidthPackagesPackageResult',
    'GetCommonBandwidthPackagesPackagePublicIpAddressResult',
    'GetDhcpOptionsSetsSetResult',
    'GetEnhancedNatAvailableZonesZoneResult',
    'GetForwardEntriesEntryResult',
    'GetHavipsHavipResult',
    'GetIpamIpamPoolAllocationsAllocationResult',
    'GetIpamIpamPoolCidrsCidrResult',
    'GetIpamIpamPoolsPoolResult',
    'GetIpamIpamScopesScopeResult',
    'GetIpamIpamsIpamResult',
    'GetIpsecServersServerResult',
    'GetIpsecServersServerIkeConfigResult',
    'GetIpsecServersServerIpsecConfigResult',
    'GetIpv4GatewaysGatewayResult',
    'GetIpv6AddressesAddressResult',
    'GetIpv6EgressRulesRuleResult',
    'GetIpv6GatewaysGatewayResult',
    'GetIpv6InternetBandwidthsBandwidthResult',
    'GetNatGatewaysGatewayResult',
    'GetNatIpCidrsCidrResult',
    'GetNatIpsIpResult',
    'GetNetworkAclsAclResult',
    'GetNetworkAclsAclEgressAclEntryResult',
    'GetNetworkAclsAclIngressAclEntryResult',
    'GetNetworkAclsAclResourceResult',
    'GetNetworksVpcResult',
    'GetPbrRouteEntriesEntryResult',
    'GetPeerConnectionsConnectionResult',
    'GetPrefixListsListResult',
    'GetPrefixListsListEntryResult',
    'GetPublicIpAddressPoolCidrBlocksBlockResult',
    'GetPublicIpAddressPoolsPoolResult',
    'GetRouteEntriesEntryResult',
    'GetRouteTablesTableResult',
    'GetRouterInterfacesInterfaceResult',
    'GetSnatEntriesEntryResult',
    'GetSslVpnClientCertsCertResult',
    'GetSslVpnServersServerResult',
    'GetSwitchesVswitchResult',
    'GetTrafficMirrorFilterEgressRulesRuleResult',
    'GetTrafficMirrorFilterIngressRulesRuleResult',
    'GetTrafficMirrorFiltersFilterResult',
    'GetTrafficMirrorSessionsSessionResult',
    'GetVpcFlowLogsLogResult',
]

@pulumi.output_type
class DhcpOptionsSetAssociateVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "associateStatus":
            suggest = "associate_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DhcpOptionsSetAssociateVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DhcpOptionsSetAssociateVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DhcpOptionsSetAssociateVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: _builtins.str,
                 associate_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str vpc_id: The ID of the VPC network that is associated with the DHCP options set.
        :param _builtins.str associate_status: The status of the VPC associated with the DHCP option set.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if associate_status is not None:
            pulumi.set(__self__, "associate_status", associate_status)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC network that is associated with the DHCP options set.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="associateStatus")
    def associate_status(self) -> Optional[_builtins.str]:
        """
        The status of the VPC associated with the DHCP option set.
        """
        return pulumi.get(self, "associate_status")


@pulumi.output_type
class NatGatewayAccessMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modeValue":
            suggest = "mode_value"
        elif key == "tunnelType":
            suggest = "tunnel_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NatGatewayAccessMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NatGatewayAccessMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NatGatewayAccessMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode_value: Optional[_builtins.str] = None,
                 tunnel_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode_value: The mode of Access. Valid values:
        :param _builtins.str tunnel_type: The type of Tunnel. Valid values: `geneve`. **NOTE:** `tunnel_type` takes effect only if `mode_value` is set to `tunnel`.
        """
        if mode_value is not None:
            pulumi.set(__self__, "mode_value", mode_value)
        if tunnel_type is not None:
            pulumi.set(__self__, "tunnel_type", tunnel_type)

    @_builtins.property
    @pulumi.getter(name="modeValue")
    def mode_value(self) -> Optional[_builtins.str]:
        """
        The mode of Access. Valid values:
        """
        return pulumi.get(self, "mode_value")

    @_builtins.property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> Optional[_builtins.str]:
        """
        The type of Tunnel. Valid values: `geneve`. **NOTE:** `tunnel_type` takes effect only if `mode_value` is set to `tunnel`.
        """
        return pulumi.get(self, "tunnel_type")


@pulumi.output_type
class NetworkAclAttachmentResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclAttachmentResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclAttachmentResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclAttachmentResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str resource_id: The resource id that the network acl will associate with.
        :param _builtins.str resource_type: The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource id that the network acl will associate with.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class NetworkAclEgressAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrIp":
            suggest = "destination_cidr_ip"
        elif key == "entryType":
            suggest = "entry_type"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "networkAclEntryName":
            suggest = "network_acl_entry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclEgressAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclEgressAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclEgressAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 destination_cidr_ip: Optional[_builtins.str] = None,
                 entry_type: Optional[_builtins.str] = None,
                 ip_version: Optional[_builtins.str] = None,
                 network_acl_entry_name: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: The description of the outbound rule.
               The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param _builtins.str destination_cidr_ip: The destination CIDR block.
        :param _builtins.str entry_type: The route entry type. Value
               custom custom rule
               system system rules
               service Cloud service rules
        :param _builtins.str ip_version: The IP protocol version of the route entry. Valid values: "Ipv4" and "ipv6'
        :param _builtins.str network_acl_entry_name: Name of the outbound rule entry.
               The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param _builtins.str policy: The action to be performed on network traffic that matches the rule. Valid values:
               - accept
               - drop
        :param _builtins.str port: The destination port range of the outbound rule.
               When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.
               When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param _builtins.str protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the outbound rule.
        The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[_builtins.str]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[_builtins.str]:
        """
        The route entry type. Value
        custom custom rule
        system system rules
        service Cloud service rules
        """
        return pulumi.get(self, "entry_type")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.str]:
        """
        The IP protocol version of the route entry. Valid values: "Ipv4" and "ipv6'
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[_builtins.str]:
        """
        Name of the outbound rule entry.
        The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The action to be performed on network traffic that matches the rule. Valid values:
        - accept
        - drop
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The destination port range of the outbound rule.
        When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.
        When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkAclEntriesEgress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrIp":
            suggest = "destination_cidr_ip"
        elif key == "entryType":
            suggest = "entry_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclEntriesEgress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclEntriesEgress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclEntriesEgress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 destination_cidr_ip: Optional[_builtins.str] = None,
                 entry_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination_cidr_ip: The destination ip of the egress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[_builtins.str]:
        """
        The destination ip of the egress entry.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "entry_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkAclEntriesIngress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryType":
            suggest = "entry_type"
        elif key == "sourceCidrIp":
            suggest = "source_cidr_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclEntriesIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclEntriesIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclEntriesIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 entry_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 source_cidr_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_cidr_ip: The source ip of the ingress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "entry_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[_builtins.str]:
        """
        The source ip of the ingress entry.
        """
        return pulumi.get(self, "source_cidr_ip")


@pulumi.output_type
class NetworkAclIngressAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryType":
            suggest = "entry_type"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "networkAclEntryName":
            suggest = "network_acl_entry_name"
        elif key == "sourceCidrIp":
            suggest = "source_cidr_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclIngressAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclIngressAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclIngressAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 entry_type: Optional[_builtins.str] = None,
                 ip_version: Optional[_builtins.str] = None,
                 network_acl_entry_name: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 source_cidr_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Description of the inbound rule.
               The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param _builtins.str entry_type: The route entry type. Value
        :param _builtins.str ip_version: The IP protocol version of the route entry. Valid values: "Ipv4" and "ipv6'
        :param _builtins.str network_acl_entry_name: The name of the inbound rule entry.
               The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param _builtins.str policy: The action to be performed on network traffic that matches the rule. Valid values:
               - accept
               - drop
        :param _builtins.str port: The source port range of the inbound rule.
               When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.
               When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param _builtins.str protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        :param _builtins.str source_cidr_ip: The source CIDR block.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the inbound rule.
        The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[_builtins.str]:
        """
        The route entry type. Value
        """
        return pulumi.get(self, "entry_type")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.str]:
        """
        The IP protocol version of the route entry. Valid values: "Ipv4" and "ipv6'
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[_builtins.str]:
        """
        The name of the inbound rule entry.
        The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The action to be performed on network traffic that matches the rule. Valid values:
        - accept
        - drop
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The source port range of the inbound rule.
        When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.
        When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[_builtins.str]:
        """
        The source CIDR block.
        """
        return pulumi.get(self, "source_cidr_ip")


@pulumi.output_type
class NetworkAclResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_id: The ID of the associated resource.
        :param _builtins.str resource_type: The type of the associated resource.
        :param _builtins.str status: The state of the network ACL.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of the associated resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the network ACL.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkIpv6CidrBlock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv6CidrBlock":
            suggest = "ipv6_cidr_block"
        elif key == "ipv6Isp":
            suggest = "ipv6_isp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkIpv6CidrBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkIpv6CidrBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkIpv6CidrBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv6_cidr_block: Optional[_builtins.str] = None,
                 ipv6_isp: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipv6_cidr_block: The IPv6 CIDR block of the default VPC.
               
               > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        :param _builtins.str ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - `BGP` (default): Alibaba Cloud BGP IPv6.
               - `ChinaMobile`: China Mobile (single line).
               - `ChinaUnicom`: China Unicom (single line).
               - `ChinaTelecom`: China Telecom (single line).
               
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_isp is not None:
            pulumi.set(__self__, "ipv6_isp", ipv6_isp)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[_builtins.str]:
        """
        The IPv6 CIDR block of the default VPC.

        > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @_builtins.property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> Optional[_builtins.str]:
        """
        The IPv6 address segment type of the VPC. Value:
        - `BGP` (default): Alibaba Cloud BGP IPv6.
        - `ChinaMobile`: China Mobile (single line).
        - `ChinaUnicom`: China Unicom (single line).
        - `ChinaTelecom`: China Telecom (single line).

        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")


@pulumi.output_type
class PrefixListEntry(dict):
    def __init__(__self__, *,
                 cidr: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr: The CIDR address block of the prefix list.
        :param _builtins.str description: The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[_builtins.str]:
        """
        The CIDR address block of the prefix list.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PrefixListPrefixListAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerId":
            suggest = "owner_id"
        elif key == "prefixListId":
            suggest = "prefix_list_id"
        elif key == "regionId":
            suggest = "region_id"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "resourceUid":
            suggest = "resource_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrefixListPrefixListAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrefixListPrefixListAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrefixListPrefixListAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_id: Optional[_builtins.str] = None,
                 prefix_list_id: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 region_id: Optional[_builtins.str] = None,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None,
                 resource_uid: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str owner_id: The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        :param _builtins.str prefix_list_id: The ID of the query Prefix List.
        :param _builtins.str reason: Reason when the association fails.
        :param _builtins.str region_id: The region ID of the prefix list to be queried.
        :param _builtins.str resource_id: The ID of the associated resource.
        :param _builtins.str resource_type: The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        :param _builtins.str resource_uid: The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        :param _builtins.str status: Resource attribute fields that represent the status of the resource.
        """
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if prefix_list_id is not None:
            pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uid is not None:
            pulumi.set(__self__, "resource_uid", resource_uid)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[_builtins.str]:
        """
        The ID of the query Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Reason when the association fails.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The region ID of the prefix list to be queried.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="resourceUid")
    def resource_uid(self) -> Optional[_builtins.str]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        """
        return pulumi.get(self, "resource_uid")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Resource attribute fields that represent the status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TrafficMirrorFilterEgressRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrBlock":
            suggest = "destination_cidr_block"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "sourceCidrBlock":
            suggest = "source_cidr_block"
        elif key == "sourcePortRange":
            suggest = "source_port_range"
        elif key == "trafficMirrorFilterRuleStatus":
            suggest = "traffic_mirror_filter_rule_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficMirrorFilterEgressRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficMirrorFilterEgressRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficMirrorFilterEgressRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 protocol: _builtins.str,
                 destination_cidr_block: Optional[_builtins.str] = None,
                 destination_port_range: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 source_cidr_block: Optional[_builtins.str] = None,
                 source_port_range: Optional[_builtins.str] = None,
                 traffic_mirror_filter_rule_status: Optional[_builtins.str] = None):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "destination_port_range")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source_cidr_block")

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source_port_range")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")


@pulumi.output_type
class TrafficMirrorFilterIngressRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrBlock":
            suggest = "destination_cidr_block"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "sourceCidrBlock":
            suggest = "source_cidr_block"
        elif key == "sourcePortRange":
            suggest = "source_port_range"
        elif key == "trafficMirrorFilterRuleStatus":
            suggest = "traffic_mirror_filter_rule_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficMirrorFilterIngressRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficMirrorFilterIngressRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficMirrorFilterIngressRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 protocol: _builtins.str,
                 destination_cidr_block: Optional[_builtins.str] = None,
                 destination_port_range: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 source_cidr_block: Optional[_builtins.str] = None,
                 source_port_range: Optional[_builtins.str] = None,
                 traffic_mirror_filter_rule_status: Optional[_builtins.str] = None):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "destination_port_range")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source_cidr_block")

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source_port_range")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")


@pulumi.output_type
class VPCRouteEntryNextHop(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHopRegionId":
            suggest = "next_hop_region_id"
        elif key == "nextHopRelatedInfo":
            suggest = "next_hop_related_info"
        elif key == "nexthopId":
            suggest = "nexthop_id"
        elif key == "nexthopType":
            suggest = "nexthop_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VPCRouteEntryNextHop. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VPCRouteEntryNextHop.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VPCRouteEntryNextHop.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.int] = None,
                 next_hop_region_id: Optional[_builtins.str] = None,
                 next_hop_related_info: Optional['outputs.VPCRouteEntryNextHopNextHopRelatedInfo'] = None,
                 nexthop_id: Optional[_builtins.str] = None,
                 nexthop_type: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int enabled: Whether the route is available.
        :param _builtins.str next_hop_region_id: The region of the next instance.
        :param 'VPCRouteEntryNextHopNextHopRelatedInfoArgs' next_hop_related_info: Next hop information.
        :param _builtins.str nexthop_id: ID of next hop
        :param _builtins.str nexthop_type: type of next hop
        :param _builtins.int weight: The weight of the route entry.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if next_hop_region_id is not None:
            pulumi.set(__self__, "next_hop_region_id", next_hop_region_id)
        if next_hop_related_info is not None:
            pulumi.set(__self__, "next_hop_related_info", next_hop_related_info)
        if nexthop_id is not None:
            pulumi.set(__self__, "nexthop_id", nexthop_id)
        if nexthop_type is not None:
            pulumi.set(__self__, "nexthop_type", nexthop_type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.int]:
        """
        Whether the route is available.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="nextHopRegionId")
    def next_hop_region_id(self) -> Optional[_builtins.str]:
        """
        The region of the next instance.
        """
        return pulumi.get(self, "next_hop_region_id")

    @_builtins.property
    @pulumi.getter(name="nextHopRelatedInfo")
    def next_hop_related_info(self) -> Optional['outputs.VPCRouteEntryNextHopNextHopRelatedInfo']:
        """
        Next hop information.
        """
        return pulumi.get(self, "next_hop_related_info")

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> Optional[_builtins.str]:
        """
        ID of next hop
        """
        return pulumi.get(self, "nexthop_id")

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> Optional[_builtins.str]:
        """
        type of next hop
        """
        return pulumi.get(self, "nexthop_type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The weight of the route entry.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class VPCRouteEntryNextHopNextHopRelatedInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VPCRouteEntryNextHopNextHopRelatedInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VPCRouteEntryNextHopNextHopRelatedInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VPCRouteEntryNextHopNextHopRelatedInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: Optional[_builtins.str] = None,
                 instance_type: Optional[_builtins.str] = None,
                 region_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_id: InstanceId
        :param _builtins.str instance_type: InstanceType
        :param _builtins.str region_id: The region of the instance associated with the next hop.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        InstanceId
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        InstanceType
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The region of the instance associated with the next hop.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class VPCRouteEntryRoutePublishTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetType":
            suggest = "target_type"
        elif key == "publishStatus":
            suggest = "publish_status"
        elif key == "targetInstanceId":
            suggest = "target_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VPCRouteEntryRoutePublishTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VPCRouteEntryRoutePublishTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VPCRouteEntryRoutePublishTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_type: _builtins.str,
                 publish_status: Optional[_builtins.str] = None,
                 target_instance_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str target_type: Route publish target type
        :param _builtins.str publish_status: Route Publish Status
        :param _builtins.str target_instance_id: Route publish target instance id.
        """
        pulumi.set(__self__, "target_type", target_type)
        if publish_status is not None:
            pulumi.set(__self__, "publish_status", publish_status)
        if target_instance_id is not None:
            pulumi.set(__self__, "target_instance_id", target_instance_id)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        Route publish target type
        """
        return pulumi.get(self, "target_type")

    @_builtins.property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> Optional[_builtins.str]:
        """
        Route Publish Status
        """
        return pulumi.get(self, "publish_status")

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> Optional[_builtins.str]:
        """
        Route publish target instance id.
        """
        return pulumi.get(self, "target_instance_id")


@pulumi.output_type
class GetBgpGroupsGroupResult(dict):
    def __init__(__self__, *,
                 auth_key: _builtins.str,
                 bgp_group_name: _builtins.str,
                 description: _builtins.str,
                 hold: _builtins.str,
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 is_fake_asn: _builtins.bool,
                 keepalive: _builtins.str,
                 local_asn: _builtins.int,
                 peer_asn: _builtins.int,
                 route_limit: _builtins.str,
                 router_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str auth_key: The key used by the BGP group.
        :param _builtins.str bgp_group_name: The name of the BGP group.
        :param _builtins.str description: Description of the BGP group.
        :param _builtins.str hold: The hold time to wait for the incoming BGP message. If no message has been passed in after the hold time, the BGP neighbor is considered disconnected.
        :param _builtins.str id: The ID of the Bgp Group.
        :param _builtins.str ip_version: IP version.
        :param _builtins.bool is_fake_asn: Whether the AS number is false.
        :param _builtins.str keepalive: The keepalive time.
        :param _builtins.int local_asn: The local AS number.
        :param _builtins.int peer_asn: The autonomous system (AS) number of the BGP peer.
        :param _builtins.str route_limit: Routing limits.
        :param _builtins.str router_id: The ID of the VBR.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "auth_key", auth_key)
        pulumi.set(__self__, "bgp_group_name", bgp_group_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hold", hold)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_fake_asn", is_fake_asn)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "route_limit", route_limit)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> _builtins.str:
        """
        The key used by the BGP group.
        """
        return pulumi.get(self, "auth_key")

    @_builtins.property
    @pulumi.getter(name="bgpGroupName")
    def bgp_group_name(self) -> _builtins.str:
        """
        The name of the BGP group.
        """
        return pulumi.get(self, "bgp_group_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the BGP group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def hold(self) -> _builtins.str:
        """
        The hold time to wait for the incoming BGP message. If no message has been passed in after the hold time, the BGP neighbor is considered disconnected.
        """
        return pulumi.get(self, "hold")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Bgp Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        IP version.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isFakeAsn")
    def is_fake_asn(self) -> _builtins.bool:
        """
        Whether the AS number is false.
        """
        return pulumi.get(self, "is_fake_asn")

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> _builtins.str:
        """
        The keepalive time.
        """
        return pulumi.get(self, "keepalive")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> _builtins.int:
        """
        The local AS number.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> _builtins.int:
        """
        The autonomous system (AS) number of the BGP peer.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="routeLimit")
    def route_limit(self) -> _builtins.str:
        """
        Routing limits.
        """
        return pulumi.get(self, "route_limit")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        The ID of the VBR.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBgpNetworksNetworkResult(dict):
    def __init__(__self__, *,
                 dst_cidr_block: _builtins.str,
                 id: _builtins.str,
                 router_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str dst_cidr_block: Advertised BGP networks.
        :param _builtins.str id: The ID of the Bgp Network. The value formats as `<router_id>:<dst_cidr_block>`.
        :param _builtins.str router_id: The ID of the vRouter.
        :param _builtins.str status: The state of the advertised BGP network.
        """
        pulumi.set(__self__, "dst_cidr_block", dst_cidr_block)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dstCidrBlock")
    def dst_cidr_block(self) -> _builtins.str:
        """
        Advertised BGP networks.
        """
        return pulumi.get(self, "dst_cidr_block")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Bgp Network. The value formats as `<router_id>:<dst_cidr_block>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        The ID of the vRouter.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the advertised BGP network.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBgpPeersPeerResult(dict):
    def __init__(__self__, *,
                 auth_key: _builtins.str,
                 bfd_multi_hop: _builtins.int,
                 bgp_group_id: _builtins.str,
                 bgp_peer_id: _builtins.str,
                 bgp_peer_name: _builtins.str,
                 bgp_status: _builtins.str,
                 description: _builtins.str,
                 enable_bfd: _builtins.bool,
                 hold: _builtins.str,
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 is_fake: _builtins.bool,
                 keepalive: _builtins.str,
                 local_asn: _builtins.str,
                 peer_asn: _builtins.str,
                 peer_ip_address: _builtins.str,
                 route_limit: _builtins.str,
                 router_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str auth_key: The authentication key of the BGP group.
        :param _builtins.int bfd_multi_hop: The BFD hop count.
        :param _builtins.str bgp_group_id: The ID of the BGP group.
        :param _builtins.str bgp_peer_id: The ID of the BGP neighbor.
        :param _builtins.str bgp_peer_name: The name of the BGP neighbor.
        :param _builtins.str bgp_status: The status of the BGP connection.
        :param _builtins.str description: The description of the BGP group.
        :param _builtins.bool enable_bfd: Indicates whether the Bidirectional Forwarding Detection (BFD) protocol is enabled.
        :param _builtins.str hold: The hold time.
        :param _builtins.str id: The ID of the Bgp Peer.
        :param _builtins.str ip_version: The IP version.
        :param _builtins.bool is_fake: Indicates whether a fake AS number is used.
        :param _builtins.str keepalive: The keepalive time.
        :param _builtins.str local_asn: The AS number of the device on the Alibaba Cloud side.
        :param _builtins.str peer_asn: The autonomous system (AS) number of the BGP peer.
        :param _builtins.str peer_ip_address: The IP address of the BGP neighbor.
        :param _builtins.str route_limit: The limit on routes.
        :param _builtins.str router_id: The ID of the router.
        :param _builtins.str status: The status of the BGP peer.
        """
        pulumi.set(__self__, "auth_key", auth_key)
        pulumi.set(__self__, "bfd_multi_hop", bfd_multi_hop)
        pulumi.set(__self__, "bgp_group_id", bgp_group_id)
        pulumi.set(__self__, "bgp_peer_id", bgp_peer_id)
        pulumi.set(__self__, "bgp_peer_name", bgp_peer_name)
        pulumi.set(__self__, "bgp_status", bgp_status)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_bfd", enable_bfd)
        pulumi.set(__self__, "hold", hold)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_fake", is_fake)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        pulumi.set(__self__, "route_limit", route_limit)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> _builtins.str:
        """
        The authentication key of the BGP group.
        """
        return pulumi.get(self, "auth_key")

    @_builtins.property
    @pulumi.getter(name="bfdMultiHop")
    def bfd_multi_hop(self) -> _builtins.int:
        """
        The BFD hop count.
        """
        return pulumi.get(self, "bfd_multi_hop")

    @_builtins.property
    @pulumi.getter(name="bgpGroupId")
    def bgp_group_id(self) -> _builtins.str:
        """
        The ID of the BGP group.
        """
        return pulumi.get(self, "bgp_group_id")

    @_builtins.property
    @pulumi.getter(name="bgpPeerId")
    def bgp_peer_id(self) -> _builtins.str:
        """
        The ID of the BGP neighbor.
        """
        return pulumi.get(self, "bgp_peer_id")

    @_builtins.property
    @pulumi.getter(name="bgpPeerName")
    def bgp_peer_name(self) -> _builtins.str:
        """
        The name of the BGP neighbor.
        """
        return pulumi.get(self, "bgp_peer_name")

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> _builtins.str:
        """
        The status of the BGP connection.
        """
        return pulumi.get(self, "bgp_status")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the BGP group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> _builtins.bool:
        """
        Indicates whether the Bidirectional Forwarding Detection (BFD) protocol is enabled.
        """
        return pulumi.get(self, "enable_bfd")

    @_builtins.property
    @pulumi.getter
    def hold(self) -> _builtins.str:
        """
        The hold time.
        """
        return pulumi.get(self, "hold")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Bgp Peer.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isFake")
    def is_fake(self) -> _builtins.bool:
        """
        Indicates whether a fake AS number is used.
        """
        return pulumi.get(self, "is_fake")

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> _builtins.str:
        """
        The keepalive time.
        """
        return pulumi.get(self, "keepalive")

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> _builtins.str:
        """
        The AS number of the device on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_asn")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> _builtins.str:
        """
        The autonomous system (AS) number of the BGP peer.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> _builtins.str:
        """
        The IP address of the BGP neighbor.
        """
        return pulumi.get(self, "peer_ip_address")

    @_builtins.property
    @pulumi.getter(name="routeLimit")
    def route_limit(self) -> _builtins.str:
        """
        The limit on routes.
        """
        return pulumi.get(self, "route_limit")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        The ID of the router.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the BGP peer.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCommonBandwidthPackagesPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.str,
                 bandwidth_package_id: _builtins.str,
                 bandwidth_package_name: _builtins.str,
                 business_status: _builtins.str,
                 deletion_protection: _builtins.bool,
                 description: _builtins.str,
                 expired_time: _builtins.str,
                 has_reservation_data: _builtins.bool,
                 id: _builtins.str,
                 internet_charge_type: _builtins.str,
                 isp: _builtins.str,
                 name: _builtins.str,
                 payment_type: _builtins.str,
                 public_ip_addresses: Sequence['outputs.GetCommonBandwidthPackagesPackagePublicIpAddressResult'],
                 ratio: _builtins.int,
                 reservation_active_time: _builtins.str,
                 reservation_bandwidth: _builtins.str,
                 reservation_internet_charge_type: _builtins.str,
                 reservation_order_type: _builtins.str,
                 resource_group_id: _builtins.str,
                 service_managed: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.str bandwidth: The peak bandwidth of the Internet Shared Bandwidth instance.
        :param _builtins.str bandwidth_package_id: The resource ID of bandwidth package.
        :param _builtins.str bandwidth_package_name: The name of bandwidth package.
        :param _builtins.str business_status: The business status of the Common Bandwidth Package instance.
        :param _builtins.bool deletion_protection: The deletion protection of bandwidth package.
        :param _builtins.str description: The description of the Common Bandwidth Package instance.
        :param _builtins.str expired_time: The expired time of bandwidth package.
        :param _builtins.bool has_reservation_data: Is has reservation data.
        :param _builtins.str id: ID of the Common Bandwidth Package.
        :param _builtins.str internet_charge_type: The internet charge type of bandwidth package.
        :param _builtins.str isp: ISP of the Common Bandwidth Package.
        :param _builtins.str name: Name of the Common Bandwidth Package.
        :param _builtins.str payment_type: The payment type of bandwidth package.
        :param Sequence['GetCommonBandwidthPackagesPackagePublicIpAddressArgs'] public_ip_addresses: Public ip addresses that in the Common Bandwidth Pakcage.
        :param _builtins.int ratio: The ratio of bandwidth package.
        :param _builtins.str reservation_active_time: The active time of reservation.
        :param _builtins.str reservation_bandwidth: The bandwidth of reservation.
        :param _builtins.str reservation_internet_charge_type: The charge type of reservation internet.
        :param _builtins.str reservation_order_type: The type of reservation order.
        :param _builtins.str resource_group_id: The Id of resource group which the common bandwidth package belongs.
        :param _builtins.int service_managed: The service managed.
        :param _builtins.str status: The status of bandwidth package. Valid values: `Available` and `Pending`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "ratio", ratio)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "service_managed", service_managed)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.str:
        """
        The peak bandwidth of the Internet Shared Bandwidth instance.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> _builtins.str:
        """
        The resource ID of bandwidth package.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> _builtins.str:
        """
        The name of bandwidth package.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> _builtins.str:
        """
        The business status of the Common Bandwidth Package instance.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The deletion protection of bandwidth package.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Common Bandwidth Package instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The expired time of bandwidth package.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> _builtins.bool:
        """
        Is has reservation data.
        """
        return pulumi.get(self, "has_reservation_data")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the Common Bandwidth Package.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        """
        The internet charge type of bandwidth package.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> _builtins.str:
        """
        ISP of the Common Bandwidth Package.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Common Bandwidth Package.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of bandwidth package.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence['outputs.GetCommonBandwidthPackagesPackagePublicIpAddressResult']:
        """
        Public ip addresses that in the Common Bandwidth Pakcage.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> _builtins.int:
        """
        The ratio of bandwidth package.
        """
        return pulumi.get(self, "ratio")

    @_builtins.property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> _builtins.str:
        """
        The active time of reservation.
        """
        return pulumi.get(self, "reservation_active_time")

    @_builtins.property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> _builtins.str:
        """
        The bandwidth of reservation.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @_builtins.property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> _builtins.str:
        """
        The charge type of reservation internet.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> _builtins.str:
        """
        The type of reservation order.
        """
        return pulumi.get(self, "reservation_order_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which the common bandwidth package belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> _builtins.int:
        """
        The service managed.
        """
        return pulumi.get(self, "service_managed")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of bandwidth package. Valid values: `Available` and `Pending`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCommonBandwidthPackagesPackagePublicIpAddressResult(dict):
    def __init__(__self__, *,
                 allocation_id: _builtins.str,
                 bandwidth_package_ip_relation_status: _builtins.str,
                 ip_address: _builtins.str):
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "bandwidth_package_ip_relation_status", bandwidth_package_ip_relation_status)
        pulumi.set(__self__, "ip_address", ip_address)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> _builtins.str:
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageIpRelationStatus")
    def bandwidth_package_ip_relation_status(self) -> _builtins.str:
        return pulumi.get(self, "bandwidth_package_ip_relation_status")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class GetDhcpOptionsSetsSetResult(dict):
    def __init__(__self__, *,
                 associate_vpc_count: _builtins.int,
                 dhcp_options_set_description: _builtins.str,
                 dhcp_options_set_id: _builtins.str,
                 dhcp_options_set_name: _builtins.str,
                 domain_name: _builtins.str,
                 domain_name_servers: _builtins.str,
                 id: _builtins.str,
                 owner_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.int associate_vpc_count: The Number of VPCs bound by the DHCP option set.
        :param _builtins.str dhcp_options_set_description: The description of the DHCP options set. The description must be 2 to 256
               characters in length and cannot start with `http://` or `https://`.
        :param _builtins.str dhcp_options_set_name: The root domain, for example, example.com. After a DHCP options set is associated with a
               Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the
               ECS instances in the VPC network.
        :param _builtins.str domain_name: The root domain, for example, example.com. After a DHCP options set is associated with a Virtual
               Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS
               instances in the VPC network.
        :param _builtins.str domain_name_servers: The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP
               addresses must be separated with commas (,).
        :param _builtins.str owner_id: The ID of the account to which the DHCP options set belongs.
        :param _builtins.str status: The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
        """
        pulumi.set(__self__, "associate_vpc_count", associate_vpc_count)
        pulumi.set(__self__, "dhcp_options_set_description", dhcp_options_set_description)
        pulumi.set(__self__, "dhcp_options_set_id", dhcp_options_set_id)
        pulumi.set(__self__, "dhcp_options_set_name", dhcp_options_set_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_name_servers", domain_name_servers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="associateVpcCount")
    def associate_vpc_count(self) -> _builtins.int:
        """
        The Number of VPCs bound by the DHCP option set.
        """
        return pulumi.get(self, "associate_vpc_count")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsSetDescription")
    def dhcp_options_set_description(self) -> _builtins.str:
        """
        The description of the DHCP options set. The description must be 2 to 256
        characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "dhcp_options_set_description")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsSetId")
    def dhcp_options_set_id(self) -> _builtins.str:
        return pulumi.get(self, "dhcp_options_set_id")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsSetName")
    def dhcp_options_set_name(self) -> _builtins.str:
        """
        The root domain, for example, example.com. After a DHCP options set is associated with a
        Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the
        ECS instances in the VPC network.
        """
        return pulumi.get(self, "dhcp_options_set_name")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The root domain, for example, example.com. After a DHCP options set is associated with a Virtual
        Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS
        instances in the VPC network.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainNameServers")
    def domain_name_servers(self) -> _builtins.str:
        """
        The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP
        addresses must be separated with commas (,).
        """
        return pulumi.get(self, "domain_name_servers")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        The ID of the account to which the DHCP options set belongs.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEnhancedNatAvailableZonesZoneResult(dict):
    def __init__(__self__, *,
                 local_name: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str local_name: Name of the available zone.
        :param _builtins.str zone_id: The ID of the available zone.
        """
        pulumi.set(__self__, "local_name", local_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="localName")
    def local_name(self) -> _builtins.str:
        """
        Name of the available zone.
        """
        return pulumi.get(self, "local_name")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the available zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetForwardEntriesEntryResult(dict):
    def __init__(__self__, *,
                 external_ip: _builtins.str,
                 external_port: _builtins.str,
                 forward_entry_id: _builtins.str,
                 forward_entry_name: _builtins.str,
                 id: _builtins.str,
                 internal_ip: _builtins.str,
                 internal_port: _builtins.str,
                 ip_protocol: _builtins.str,
                 name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str external_ip: The public IP address.
        :param _builtins.str external_port: The public port.
        :param _builtins.str forward_entry_id: The forward entry ID.
        :param _builtins.str forward_entry_name: The name of forward entry.
        :param _builtins.str id: The ID of the Forward Entry.
        :param _builtins.str internal_ip: The private IP address.
        :param _builtins.str internal_port: The internal port.
        :param _builtins.str ip_protocol: The ip protocol. Valid values: `any`,`tcp` and `udp`.
        :param _builtins.str name: The forward entry name.
        :param _builtins.str status: The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
        """
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "external_port", external_port)
        pulumi.set(__self__, "forward_entry_id", forward_entry_id)
        pulumi.set(__self__, "forward_entry_name", forward_entry_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "internal_port", internal_port)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> _builtins.str:
        """
        The public IP address.
        """
        return pulumi.get(self, "external_ip")

    @_builtins.property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> _builtins.str:
        """
        The public port.
        """
        return pulumi.get(self, "external_port")

    @_builtins.property
    @pulumi.getter(name="forwardEntryId")
    def forward_entry_id(self) -> _builtins.str:
        """
        The forward entry ID.
        """
        return pulumi.get(self, "forward_entry_id")

    @_builtins.property
    @pulumi.getter(name="forwardEntryName")
    def forward_entry_name(self) -> _builtins.str:
        """
        The name of forward entry.
        """
        return pulumi.get(self, "forward_entry_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Forward Entry.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> _builtins.str:
        """
        The private IP address.
        """
        return pulumi.get(self, "internal_ip")

    @_builtins.property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> _builtins.str:
        """
        The internal port.
        """
        return pulumi.get(self, "internal_port")

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> _builtins.str:
        """
        The ip protocol. Valid values: `any`,`tcp` and `udp`.
        """
        return pulumi.get(self, "ip_protocol")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The forward entry name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHavipsHavipResult(dict):
    def __init__(__self__, *,
                 associated_eip_addresses: Sequence[_builtins.str],
                 associated_instances: Sequence[_builtins.str],
                 description: _builtins.str,
                 havip_id: _builtins.str,
                 havip_name: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 master_instance_id: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param Sequence[_builtins.str] associated_eip_addresses: EIP bound to HaVip.
        :param Sequence[_builtins.str] associated_instances: An ECS instance that is bound to HaVip.
        :param _builtins.str description: Dependence of a HaVip instance.
        :param _builtins.str havip_id: The  ID of the resource.
        :param _builtins.str havip_name: The name of the HaVip instance.
        :param _builtins.str id: The ID of the Ha Vip.
        :param _builtins.str ip_address: IP address of private network.
        :param _builtins.str master_instance_id: The primary instance ID bound to HaVip.
        :param _builtins.str status: The status.
        :param _builtins.str vpc_id: The VPC ID to which the HaVip instance belongs.
        :param _builtins.str vswitch_id: The vswitch id.
        """
        pulumi.set(__self__, "associated_eip_addresses", associated_eip_addresses)
        pulumi.set(__self__, "associated_instances", associated_instances)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "havip_id", havip_id)
        pulumi.set(__self__, "havip_name", havip_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "master_instance_id", master_instance_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="associatedEipAddresses")
    def associated_eip_addresses(self) -> Sequence[_builtins.str]:
        """
        EIP bound to HaVip.
        """
        return pulumi.get(self, "associated_eip_addresses")

    @_builtins.property
    @pulumi.getter(name="associatedInstances")
    def associated_instances(self) -> Sequence[_builtins.str]:
        """
        An ECS instance that is bound to HaVip.
        """
        return pulumi.get(self, "associated_instances")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Dependence of a HaVip instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="havipId")
    def havip_id(self) -> _builtins.str:
        """
        The  ID of the resource.
        """
        return pulumi.get(self, "havip_id")

    @_builtins.property
    @pulumi.getter(name="havipName")
    def havip_name(self) -> _builtins.str:
        """
        The name of the HaVip instance.
        """
        return pulumi.get(self, "havip_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ha Vip.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        IP address of private network.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="masterInstanceId")
    def master_instance_id(self) -> _builtins.str:
        """
        The primary instance ID bound to HaVip.
        """
        return pulumi.get(self, "master_instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC ID to which the HaVip instance belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetIpamIpamPoolAllocationsAllocationResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 ipam_pool_allocation_description: _builtins.str,
                 ipam_pool_allocation_id: _builtins.str,
                 ipam_pool_allocation_name: _builtins.str,
                 ipam_pool_id: _builtins.str,
                 region_id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_owner_id: _builtins.int,
                 resource_region_id: _builtins.str,
                 resource_type: _builtins.str,
                 source_cidr: _builtins.str,
                 status: _builtins.str,
                 total_count: _builtins.int):
        """
        :param _builtins.str cidr: The allocated address segment.
        :param _builtins.str create_time: Instance creation time.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str ipam_pool_allocation_description: The description of the ipam pool alloctaion.It must be 1 to 256 characters in length and must start with an English letter or Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param _builtins.str ipam_pool_allocation_id: The instance ID of the ipam pool allocation.
        :param _builtins.str ipam_pool_allocation_name: The name of the ipam pool allocation.It must be 1 to 128 characters in length and cannot start with 'http:// 'or 'https.
        :param _builtins.str ipam_pool_id: The ID of the IPAM Pool.
        :param _builtins.str region_id: When the IPAM Pool to which CIDR is allocated has the region attribute, this attribute is the IPAM Pool region.When the IPAM Pool to which CIDR is allocated does not have the region attribute, this attribute is the IPAM region.
        :param _builtins.str resource_id: The ID of the resource.
        :param _builtins.int resource_owner_id: The ID of the Alibaba Cloud account (primary account) to which the resource belongs.
        :param _builtins.str resource_region_id: The region of the resource.
        :param _builtins.str resource_type: The type of resource. Value:-**VPC**: indicates that the resource type is VPC.-**IpamPool**: indicates that the resource type is a child address pool.-**Custom**: indicates that the resource type is a Custom reserved CIDR block.
        :param _builtins.str source_cidr: The source address segment.
        :param _builtins.str status: The status of the instance. Value:-**Created**: indicates that the creation is complete.
        :param _builtins.int total_count: Total number of records.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_pool_allocation_description", ipam_pool_allocation_description)
        pulumi.set(__self__, "ipam_pool_allocation_id", ipam_pool_allocation_id)
        pulumi.set(__self__, "ipam_pool_allocation_name", ipam_pool_allocation_name)
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_owner_id", resource_owner_id)
        pulumi.set(__self__, "resource_region_id", resource_region_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "source_cidr", source_cidr)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_count", total_count)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        The allocated address segment.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Instance creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolAllocationDescription")
    def ipam_pool_allocation_description(self) -> _builtins.str:
        """
        The description of the ipam pool alloctaion.It must be 1 to 256 characters in length and must start with an English letter or Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        """
        return pulumi.get(self, "ipam_pool_allocation_description")

    @_builtins.property
    @pulumi.getter(name="ipamPoolAllocationId")
    def ipam_pool_allocation_id(self) -> _builtins.str:
        """
        The instance ID of the ipam pool allocation.
        """
        return pulumi.get(self, "ipam_pool_allocation_id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolAllocationName")
    def ipam_pool_allocation_name(self) -> _builtins.str:
        """
        The name of the ipam pool allocation.It must be 1 to 128 characters in length and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "ipam_pool_allocation_name")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> _builtins.str:
        """
        The ID of the IPAM Pool.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        When the IPAM Pool to which CIDR is allocated has the region attribute, this attribute is the IPAM Pool region.When the IPAM Pool to which CIDR is allocated does not have the region attribute, this attribute is the IPAM region.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceOwnerId")
    def resource_owner_id(self) -> _builtins.int:
        """
        The ID of the Alibaba Cloud account (primary account) to which the resource belongs.
        """
        return pulumi.get(self, "resource_owner_id")

    @_builtins.property
    @pulumi.getter(name="resourceRegionId")
    def resource_region_id(self) -> _builtins.str:
        """
        The region of the resource.
        """
        return pulumi.get(self, "resource_region_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of resource. Value:-**VPC**: indicates that the resource type is VPC.-**IpamPool**: indicates that the resource type is a child address pool.-**Custom**: indicates that the resource type is a Custom reserved CIDR block.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> _builtins.str:
        """
        The source address segment.
        """
        return pulumi.get(self, "source_cidr")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the instance. Value:-**Created**: indicates that the creation is complete.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        """
        Total number of records.
        """
        return pulumi.get(self, "total_count")


@pulumi.output_type
class GetIpamIpamPoolCidrsCidrResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 id: _builtins.str,
                 ipam_pool_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cidr: The CIDR address segment to be preset.> currently, only IPv4 address segments are supported.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str ipam_pool_id: The ID of the IPAM pool instance.
        :param _builtins.str status: The status of the resource
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        The CIDR address segment to be preset.> currently, only IPv4 address segments are supported.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> _builtins.str:
        """
        The ID of the IPAM pool instance.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetIpamIpamPoolsPoolResult(dict):
    def __init__(__self__, *,
                 allocation_default_cidr_mask: _builtins.int,
                 allocation_max_cidr_mask: _builtins.int,
                 allocation_min_cidr_mask: _builtins.int,
                 auto_import: _builtins.bool,
                 create_time: _builtins.str,
                 has_sub_pool: _builtins.bool,
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 ipam_id: _builtins.str,
                 ipam_pool_description: _builtins.str,
                 ipam_pool_id: _builtins.str,
                 ipam_pool_name: _builtins.str,
                 ipam_scope_id: _builtins.str,
                 pool_depth: _builtins.int,
                 pool_region_id: _builtins.str,
                 region_id: _builtins.str,
                 resource_group_id: _builtins.str,
                 source_ipam_pool_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.int allocation_default_cidr_mask: The default network mask assigned by the IPAM address pool.IPv4 network mask value range: **0 to 32** bits.
        :param _builtins.int allocation_max_cidr_mask: The maximum network mask assigned by the IPAM address pool.IPv4 network mask value range: **0 to 32** bits.
        :param _builtins.int allocation_min_cidr_mask: The minimum Network mask assigned by the IPAM address pool.IPv4 network mask value range: **0 to 32** bits.
        :param _builtins.bool auto_import: Whether the automatic import function is enabled for the address pool.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.bool has_sub_pool: Whether it is a child address pool. Value:-**true**: Yes.-**false**: No.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str ip_version: The IP protocol version. Currently, only **IPv4** is supported * *.
        :param _builtins.str ipam_id: Ipam id.
        :param _builtins.str ipam_pool_description: The description of the IPAM address pool.It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param _builtins.str ipam_pool_id: The first ID of the resource.
        :param _builtins.str ipam_pool_name: The name of the resource.
        :param _builtins.str ipam_scope_id: Ipam scope id.
        :param _builtins.int pool_depth: The depth of the IPAM address pool. Value range: **0 to 10 * *.
        :param _builtins.str pool_region_id: The effective region of the IPAM address pool.
        :param _builtins.str region_id: The region ID of the resource.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str source_ipam_pool_id: The instance ID of the source IPAM address pool.> If this parameter is not entered, the created address pool is the parent address pool.
        :param _builtins.str status: The status of the resource.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        """
        pulumi.set(__self__, "allocation_default_cidr_mask", allocation_default_cidr_mask)
        pulumi.set(__self__, "allocation_max_cidr_mask", allocation_max_cidr_mask)
        pulumi.set(__self__, "allocation_min_cidr_mask", allocation_min_cidr_mask)
        pulumi.set(__self__, "auto_import", auto_import)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "has_sub_pool", has_sub_pool)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "ipam_id", ipam_id)
        pulumi.set(__self__, "ipam_pool_description", ipam_pool_description)
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        pulumi.set(__self__, "ipam_pool_name", ipam_pool_name)
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        pulumi.set(__self__, "pool_depth", pool_depth)
        pulumi.set(__self__, "pool_region_id", pool_region_id)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="allocationDefaultCidrMask")
    def allocation_default_cidr_mask(self) -> _builtins.int:
        """
        The default network mask assigned by the IPAM address pool.IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_default_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="allocationMaxCidrMask")
    def allocation_max_cidr_mask(self) -> _builtins.int:
        """
        The maximum network mask assigned by the IPAM address pool.IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_max_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="allocationMinCidrMask")
    def allocation_min_cidr_mask(self) -> _builtins.int:
        """
        The minimum Network mask assigned by the IPAM address pool.IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_min_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> _builtins.bool:
        """
        Whether the automatic import function is enabled for the address pool.
        """
        return pulumi.get(self, "auto_import")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="hasSubPool")
    def has_sub_pool(self) -> _builtins.bool:
        """
        Whether it is a child address pool. Value:-**true**: Yes.-**false**: No.
        """
        return pulumi.get(self, "has_sub_pool")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        The IP protocol version. Currently, only **IPv4** is supported * *.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> _builtins.str:
        """
        Ipam id.
        """
        return pulumi.get(self, "ipam_id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolDescription")
    def ipam_pool_description(self) -> _builtins.str:
        """
        The description of the IPAM address pool.It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        """
        return pulumi.get(self, "ipam_pool_description")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolName")
    def ipam_pool_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_pool_name")

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> _builtins.str:
        """
        Ipam scope id.
        """
        return pulumi.get(self, "ipam_scope_id")

    @_builtins.property
    @pulumi.getter(name="poolDepth")
    def pool_depth(self) -> _builtins.int:
        """
        The depth of the IPAM address pool. Value range: **0 to 10 * *.
        """
        return pulumi.get(self, "pool_depth")

    @_builtins.property
    @pulumi.getter(name="poolRegionId")
    def pool_region_id(self) -> _builtins.str:
        """
        The effective region of the IPAM address pool.
        """
        return pulumi.get(self, "pool_region_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> _builtins.str:
        """
        The instance ID of the source IPAM address pool.> If this parameter is not entered, the created address pool is the parent address pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetIpamIpamScopesScopeResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 ipam_id: _builtins.str,
                 ipam_scope_description: _builtins.str,
                 ipam_scope_id: _builtins.str,
                 ipam_scope_name: _builtins.str,
                 ipam_scope_type: _builtins.str,
                 region_id: _builtins.str,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str ipam_id: The id of the Ipam instance.
        :param _builtins.str ipam_scope_description: The description of the IPAM's scope of action.It must be 2 to 256 characters in length and must start with a lowercase letter, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param _builtins.str ipam_scope_id: The first ID of the resource.
        :param _builtins.str ipam_scope_name: The name of the resource.
        :param _builtins.str ipam_scope_type: IPAM scope of action type:**private**.> Currently, only the role scope of the private network is supported.
        :param _builtins.str region_id: The region ID of the resource.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str status: The status of the resource.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_id", ipam_id)
        pulumi.set(__self__, "ipam_scope_description", ipam_scope_description)
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        pulumi.set(__self__, "ipam_scope_name", ipam_scope_name)
        pulumi.set(__self__, "ipam_scope_type", ipam_scope_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> _builtins.str:
        """
        The id of the Ipam instance.
        """
        return pulumi.get(self, "ipam_id")

    @_builtins.property
    @pulumi.getter(name="ipamScopeDescription")
    def ipam_scope_description(self) -> _builtins.str:
        """
        The description of the IPAM's scope of action.It must be 2 to 256 characters in length and must start with a lowercase letter, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        """
        return pulumi.get(self, "ipam_scope_description")

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipam_scope_id")

    @_builtins.property
    @pulumi.getter(name="ipamScopeName")
    def ipam_scope_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_scope_name")

    @_builtins.property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> _builtins.str:
        """
        IPAM scope of action type:**private**.> Currently, only the role scope of the private network is supported.
        """
        return pulumi.get(self, "ipam_scope_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetIpamIpamsIpamResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 default_resource_discovery_association_id: _builtins.str,
                 default_resource_discovery_id: _builtins.str,
                 id: _builtins.str,
                 ipam_description: _builtins.str,
                 ipam_id: _builtins.str,
                 ipam_name: _builtins.str,
                 private_default_scope_id: _builtins.str,
                 public_default_scope_id: _builtins.str,
                 region_id: _builtins.str,
                 resource_discovery_association_count: _builtins.int,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str default_resource_discovery_association_id: After an IPAM is created, the association between the resource discovery created by the system by default and the IPAM.
        :param _builtins.str default_resource_discovery_id: After IPAM is created, the system creates resource discovery by default.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str ipam_description: The description of IPAM.It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        :param _builtins.str ipam_id: The first ID of the resource.
        :param _builtins.str ipam_name: The name of the resource.
        :param _builtins.str private_default_scope_id: After an IPAM is created, the scope of the private network IPAM created by the system by default.
        :param _builtins.str public_default_scope_id: After an IPAM is created, the public network IPAM is created by default.
        :param _builtins.str region_id: The region ID of the resource.
        :param _builtins.int resource_discovery_association_count: The number of resource discovery objects associated with IPAM.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str status: The status of the resource.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "default_resource_discovery_association_id", default_resource_discovery_association_id)
        pulumi.set(__self__, "default_resource_discovery_id", default_resource_discovery_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_description", ipam_description)
        pulumi.set(__self__, "ipam_id", ipam_id)
        pulumi.set(__self__, "ipam_name", ipam_name)
        pulumi.set(__self__, "private_default_scope_id", private_default_scope_id)
        pulumi.set(__self__, "public_default_scope_id", public_default_scope_id)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_discovery_association_count", resource_discovery_association_count)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultResourceDiscoveryAssociationId")
    def default_resource_discovery_association_id(self) -> _builtins.str:
        """
        After an IPAM is created, the association between the resource discovery created by the system by default and the IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_association_id")

    @_builtins.property
    @pulumi.getter(name="defaultResourceDiscoveryId")
    def default_resource_discovery_id(self) -> _builtins.str:
        """
        After IPAM is created, the system creates resource discovery by default.
        """
        return pulumi.get(self, "default_resource_discovery_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamDescription")
    def ipam_description(self) -> _builtins.str:
        """
        The description of IPAM.It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        """
        return pulumi.get(self, "ipam_description")

    @_builtins.property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipam_id")

    @_builtins.property
    @pulumi.getter(name="ipamName")
    def ipam_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_name")

    @_builtins.property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> _builtins.str:
        """
        After an IPAM is created, the scope of the private network IPAM created by the system by default.
        """
        return pulumi.get(self, "private_default_scope_id")

    @_builtins.property
    @pulumi.getter(name="publicDefaultScopeId")
    def public_default_scope_id(self) -> _builtins.str:
        """
        After an IPAM is created, the public network IPAM is created by default.
        """
        return pulumi.get(self, "public_default_scope_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryAssociationCount")
    def resource_discovery_association_count(self) -> _builtins.int:
        """
        The number of resource discovery objects associated with IPAM.
        """
        return pulumi.get(self, "resource_discovery_association_count")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetIpsecServersServerResult(dict):
    def __init__(__self__, *,
                 client_ip_pool: _builtins.str,
                 create_time: _builtins.str,
                 effect_immediately: _builtins.bool,
                 id: _builtins.str,
                 idaas_instance_id: _builtins.str,
                 ike_configs: Sequence['outputs.GetIpsecServersServerIkeConfigResult'],
                 internet_ip: _builtins.str,
                 ipsec_configs: Sequence['outputs.GetIpsecServersServerIpsecConfigResult'],
                 ipsec_server_id: _builtins.str,
                 ipsec_server_name: _builtins.str,
                 local_subnet: _builtins.str,
                 max_connections: _builtins.int,
                 multi_factor_auth_enabled: _builtins.bool,
                 online_client_count: _builtins.int,
                 psk: _builtins.str,
                 psk_enabled: _builtins.bool,
                 vpn_gateway_id: _builtins.str):
        """
        :param _builtins.str client_ip_pool: The CIDR block of the client, which is assigned an access address to the virtual NIC of the client.
        :param _builtins.str create_time: The creation time of the IPsec server. T represents the delimiter, and Z represents UTC, which is World Standard Time.
        :param _builtins.bool effect_immediately: Indicates whether the current IPsec tunnel is deleted and negotiations are reinitiated.
        :param _builtins.str id: The ID of the Ipsec Server.
        :param _builtins.str idaas_instance_id: The ID of the Identity as a Service (IDaaS) instance.
        :param Sequence['GetIpsecServersServerIkeConfigArgs'] ike_configs: The configurations of Phase 1 negotiations.
        :param _builtins.str internet_ip: The public IP address of the VPN gateway.
        :param Sequence['GetIpsecServersServerIpsecConfigArgs'] ipsec_configs: The configuration of Phase 2 negotiations.
        :param _builtins.str ipsec_server_id: The ID of the IPsec server.
        :param _builtins.str ipsec_server_name: The name of the IPsec server.
        :param _builtins.str local_subnet: Local network segment: the network segment on The VPC side that needs to be interconnected with the client network segment.
        :param _builtins.int max_connections: The number of SSL connections of the VPN gateway. SSL-VPN the number of SSL connections shared with the IPsec server. For example, if the number of SSL connections is 5 and you have three SSL clients connected to the SSL-VPN, you can also use two clients to connect to the IPsec server.
        :param _builtins.bool multi_factor_auth_enabled: Whether the two-factor authentication function has been turned on.
        :param _builtins.int online_client_count: The number of clients that have connected to the IPsec server.
        :param _builtins.str psk: The pre-shared key.
        :param _builtins.bool psk_enabled: Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
        :param _builtins.str vpn_gateway_id: The ID of the VPN gateway.
        """
        pulumi.set(__self__, "client_ip_pool", client_ip_pool)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "effect_immediately", effect_immediately)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idaas_instance_id", idaas_instance_id)
        pulumi.set(__self__, "ike_configs", ike_configs)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "ipsec_configs", ipsec_configs)
        pulumi.set(__self__, "ipsec_server_id", ipsec_server_id)
        pulumi.set(__self__, "ipsec_server_name", ipsec_server_name)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "multi_factor_auth_enabled", multi_factor_auth_enabled)
        pulumi.set(__self__, "online_client_count", online_client_count)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "psk_enabled", psk_enabled)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @_builtins.property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> _builtins.str:
        """
        The CIDR block of the client, which is assigned an access address to the virtual NIC of the client.
        """
        return pulumi.get(self, "client_ip_pool")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the IPsec server. T represents the delimiter, and Z represents UTC, which is World Standard Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> _builtins.bool:
        """
        Indicates whether the current IPsec tunnel is deleted and negotiations are reinitiated.
        """
        return pulumi.get(self, "effect_immediately")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ipsec Server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idaasInstanceId")
    def idaas_instance_id(self) -> _builtins.str:
        """
        The ID of the Identity as a Service (IDaaS) instance.
        """
        return pulumi.get(self, "idaas_instance_id")

    @_builtins.property
    @pulumi.getter(name="ikeConfigs")
    def ike_configs(self) -> Sequence['outputs.GetIpsecServersServerIkeConfigResult']:
        """
        The configurations of Phase 1 negotiations.
        """
        return pulumi.get(self, "ike_configs")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The public IP address of the VPN gateway.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="ipsecConfigs")
    def ipsec_configs(self) -> Sequence['outputs.GetIpsecServersServerIpsecConfigResult']:
        """
        The configuration of Phase 2 negotiations.
        """
        return pulumi.get(self, "ipsec_configs")

    @_builtins.property
    @pulumi.getter(name="ipsecServerId")
    def ipsec_server_id(self) -> _builtins.str:
        """
        The ID of the IPsec server.
        """
        return pulumi.get(self, "ipsec_server_id")

    @_builtins.property
    @pulumi.getter(name="ipsecServerName")
    def ipsec_server_name(self) -> _builtins.str:
        """
        The name of the IPsec server.
        """
        return pulumi.get(self, "ipsec_server_name")

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> _builtins.str:
        """
        Local network segment: the network segment on The VPC side that needs to be interconnected with the client network segment.
        """
        return pulumi.get(self, "local_subnet")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The number of SSL connections of the VPN gateway. SSL-VPN the number of SSL connections shared with the IPsec server. For example, if the number of SSL connections is 5 and you have three SSL clients connected to the SSL-VPN, you can also use two clients to connect to the IPsec server.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="multiFactorAuthEnabled")
    def multi_factor_auth_enabled(self) -> _builtins.bool:
        """
        Whether the two-factor authentication function has been turned on.
        """
        return pulumi.get(self, "multi_factor_auth_enabled")

    @_builtins.property
    @pulumi.getter(name="onlineClientCount")
    def online_client_count(self) -> _builtins.int:
        """
        The number of clients that have connected to the IPsec server.
        """
        return pulumi.get(self, "online_client_count")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> _builtins.str:
        """
        The pre-shared key.
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="pskEnabled")
    def psk_enabled(self) -> _builtins.bool:
        """
        Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
        """
        return pulumi.get(self, "psk_enabled")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> _builtins.str:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")


@pulumi.output_type
class GetIpsecServersServerIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: _builtins.str,
                 ike_enc_alg: _builtins.str,
                 ike_lifetime: _builtins.int,
                 ike_mode: _builtins.str,
                 ike_pfs: _builtins.str,
                 ike_version: _builtins.str,
                 local_id: _builtins.str,
                 remote_id: _builtins.str):
        """
        :param _builtins.str ike_auth_alg: The IKE authentication algorithm.
        :param _builtins.str ike_enc_alg: The IKE encryption algorithm.
        :param _builtins.int ike_lifetime: The IKE lifetime. Unit: seconds.
        :param _builtins.str ike_mode: The IKE negotiation mode.
        :param _builtins.str ike_pfs: Diffie-Hellman key exchange algorithm.
        :param _builtins.str ike_version: The IKE version.
        :param _builtins.str local_id: IPsec server identifier. Supports the format of FQDN and IP address. The public IP address of the VPN gateway is selected by default.
        :param _builtins.str remote_id: The peer identifier. Supports the format of FQDN and IP address, which is empty by default.
        """
        pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        pulumi.set(__self__, "ike_mode", ike_mode)
        pulumi.set(__self__, "ike_pfs", ike_pfs)
        pulumi.set(__self__, "ike_version", ike_version)
        pulumi.set(__self__, "local_id", local_id)
        pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> _builtins.str:
        """
        The IKE authentication algorithm.
        """
        return pulumi.get(self, "ike_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> _builtins.str:
        """
        The IKE encryption algorithm.
        """
        return pulumi.get(self, "ike_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> _builtins.int:
        """
        The IKE lifetime. Unit: seconds.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> _builtins.str:
        """
        The IKE negotiation mode.
        """
        return pulumi.get(self, "ike_mode")

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> _builtins.str:
        """
        Diffie-Hellman key exchange algorithm.
        """
        return pulumi.get(self, "ike_pfs")

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> _builtins.str:
        """
        The IKE version.
        """
        return pulumi.get(self, "ike_version")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> _builtins.str:
        """
        IPsec server identifier. Supports the format of FQDN and IP address. The public IP address of the VPN gateway is selected by default.
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> _builtins.str:
        """
        The peer identifier. Supports the format of FQDN and IP address, which is empty by default.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GetIpsecServersServerIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: _builtins.str,
                 ipsec_enc_alg: _builtins.str,
                 ipsec_lifetime: _builtins.int,
                 ipsec_pfs: _builtins.str):
        """
        :param _builtins.str ipsec_auth_alg: IPsec authentication algorithm.
        :param _builtins.str ipsec_enc_alg: IPsec encryption algorithm.
        :param _builtins.int ipsec_lifetime: IPsec survival time. Unit: seconds.
        :param _builtins.str ipsec_pfs: Diffie-Hellman key exchange algorithm.
        """
        pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> _builtins.str:
        """
        IPsec authentication algorithm.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> _builtins.str:
        """
        IPsec encryption algorithm.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> _builtins.int:
        """
        IPsec survival time. Unit: seconds.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> _builtins.str:
        """
        Diffie-Hellman key exchange algorithm.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetIpv4GatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 ipv4_gateway_description: _builtins.str,
                 ipv4_gateway_id: _builtins.str,
                 ipv4_gateway_name: _builtins.str,
                 ipv4_gateway_route_table_id: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.bool enabled: Indicates whether the IPv4 gateway is activated.
        :param _builtins.str id: The ID of the Ipv4 Gateway.
        :param _builtins.str ipv4_gateway_description: The description of the IPv4 gateway.
        :param _builtins.str ipv4_gateway_id: The resource attribute field that represents the resource level 1 ID.
        :param _builtins.str ipv4_gateway_name: The name of the IPv4 gateway.
        :param _builtins.str ipv4_gateway_route_table_id: ID of the route table associated with IPv4 Gateway.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str vpc_id: The ID of the VPC associated with the IPv4 Gateway.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4_gateway_description", ipv4_gateway_description)
        pulumi.set(__self__, "ipv4_gateway_id", ipv4_gateway_id)
        pulumi.set(__self__, "ipv4_gateway_name", ipv4_gateway_name)
        pulumi.set(__self__, "ipv4_gateway_route_table_id", ipv4_gateway_route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Indicates whether the IPv4 gateway is activated.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ipv4 Gateway.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayDescription")
    def ipv4_gateway_description(self) -> _builtins.str:
        """
        The description of the IPv4 gateway.
        """
        return pulumi.get(self, "ipv4_gateway_description")

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayId")
    def ipv4_gateway_id(self) -> _builtins.str:
        """
        The resource attribute field that represents the resource level 1 ID.
        """
        return pulumi.get(self, "ipv4_gateway_id")

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayName")
    def ipv4_gateway_name(self) -> _builtins.str:
        """
        The name of the IPv4 gateway.
        """
        return pulumi.get(self, "ipv4_gateway_name")

    @_builtins.property
    @pulumi.getter(name="ipv4GatewayRouteTableId")
    def ipv4_gateway_route_table_id(self) -> _builtins.str:
        """
        ID of the route table associated with IPv4 Gateway.
        """
        return pulumi.get(self, "ipv4_gateway_route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC associated with the IPv4 Gateway.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetIpv6AddressesAddressResult(dict):
    def __init__(__self__, *,
                 associated_instance_id: _builtins.str,
                 associated_instance_type: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 ipv6_address: _builtins.str,
                 ipv6_address_id: _builtins.str,
                 ipv6_address_name: _builtins.str,
                 ipv6_gateway_id: _builtins.str,
                 network_type: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str associated_instance_id: The ID of the instance that is assigned the IPv6 address.
        :param _builtins.str associated_instance_type: The type of the instance that is assigned the IPv6 address.
        :param _builtins.str create_time: The time when the IPv6 address was created.
        :param _builtins.str id: The ID of the Ipv6 Address.
        :param _builtins.str ipv6_address: The address of the Ipv6 Address.
        :param _builtins.str ipv6_address_id: The ID of the IPv6 address.
        :param _builtins.str ipv6_address_name: The name of the IPv6 address.
        :param _builtins.str ipv6_gateway_id: The ID of the IPv6 gateway to which the IPv6 address belongs.
        :param _builtins.str network_type: The type of communication supported by the IPv6 address. Valid values:`Private` or `Public`. `Private`: communication within the private network. `Public`: communication over the public network
        :param _builtins.str status: The status of the IPv6 address. Valid values:`Pending` or `Available`.
        :param _builtins.str vpc_id: The ID of the VPC to which the IPv6 address belongs.
        :param _builtins.str vswitch_id: The ID of the vSwitch to which the IPv6 address belongs.
        """
        pulumi.set(__self__, "associated_instance_id", associated_instance_id)
        pulumi.set(__self__, "associated_instance_type", associated_instance_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_address_id", ipv6_address_id)
        pulumi.set(__self__, "ipv6_address_name", ipv6_address_name)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="associatedInstanceId")
    def associated_instance_id(self) -> _builtins.str:
        """
        The ID of the instance that is assigned the IPv6 address.
        """
        return pulumi.get(self, "associated_instance_id")

    @_builtins.property
    @pulumi.getter(name="associatedInstanceType")
    def associated_instance_type(self) -> _builtins.str:
        """
        The type of the instance that is assigned the IPv6 address.
        """
        return pulumi.get(self, "associated_instance_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the IPv6 address was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ipv6 Address.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        """
        The address of the Ipv6 Address.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressId")
    def ipv6_address_id(self) -> _builtins.str:
        """
        The ID of the IPv6 address.
        """
        return pulumi.get(self, "ipv6_address_id")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressName")
    def ipv6_address_name(self) -> _builtins.str:
        """
        The name of the IPv6 address.
        """
        return pulumi.get(self, "ipv6_address_name")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> _builtins.str:
        """
        The ID of the IPv6 gateway to which the IPv6 address belongs.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The type of communication supported by the IPv6 address. Valid values:`Private` or `Public`. `Private`: communication within the private network. `Public`: communication over the public network
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the IPv6 address. Valid values:`Pending` or `Available`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC to which the IPv6 address belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch to which the IPv6 address belongs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetIpv6EgressRulesRuleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 instance_type: _builtins.str,
                 ipv6_egress_rule_id: _builtins.str,
                 ipv6_egress_rule_name: _builtins.str,
                 ipv6_gateway_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str description: The description of the egress-only rule.
        :param _builtins.str id: The ID of the Ipv6 Egress Rule. The value formats as `<ipv6_gateway_id>:<ipv6_egress_rule_id>`.
        :param _builtins.str instance_id: The ID of the instance to which the egress-only rule is applied.
        :param _builtins.str instance_type: The type of the instance to which the egress-only rule is applied.
        :param _builtins.str ipv6_egress_rule_id: The first ID of the resource.
        :param _builtins.str ipv6_egress_rule_name: The name of the resource.
        :param _builtins.str ipv6_gateway_id: The ID of the IPv6 gateway.
        :param _builtins.str status: The status of the resource. Valid values: `Available`, `Pending` and `Deleting`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "ipv6_egress_rule_id", ipv6_egress_rule_id)
        pulumi.set(__self__, "ipv6_egress_rule_name", ipv6_egress_rule_name)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the egress-only rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ipv6 Egress Rule. The value formats as `<ipv6_gateway_id>:<ipv6_egress_rule_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance to which the egress-only rule is applied.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The type of the instance to which the egress-only rule is applied.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleId")
    def ipv6_egress_rule_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipv6_egress_rule_id")

    @_builtins.property
    @pulumi.getter(name="ipv6EgressRuleName")
    def ipv6_egress_rule_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipv6_egress_rule_name")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> _builtins.str:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `Available`, `Pending` and `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetIpv6GatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 business_status: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 expired_time: _builtins.str,
                 id: _builtins.str,
                 instance_charge_type: _builtins.str,
                 ipv6_gateway_id: _builtins.str,
                 ipv6_gateway_name: _builtins.str,
                 spec: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str business_status: The status of the IPv6 gateway. Valid values:`Normal`, `FinancialLocked` and `SecurityLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments. `SecurityLocked`: locked due to security reasons.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str description: The description of the IPv6 gateway.
        :param _builtins.str expired_time: The time when the IPv6 gateway expires.
        :param _builtins.str id: The ID of the Ipv6 Gateway.
        :param _builtins.str instance_charge_type: The metering method of the IPv6 gateway. Valid values: `PayAsYouGo`.
        :param _builtins.str ipv6_gateway_id: The first ID of the resource.
        :param _builtins.str ipv6_gateway_name: The name of the IPv6 gateway.
        :param _builtins.str spec: The specification of the IPv6 gateway. Valid values: `Large`, `Medium` and `Small`. `Small` (default): Free Edition. `Medium`: Enterprise Edition . `Large`: Enhanced Enterprise Edition. The throughput capacity of an IPv6 gateway varies based on the edition. For more information, see [Editions of IPv6 gateways](https://www.alibabacloud.com/help/doc-detail/98926.htm).
        :param _builtins.str status: The status of the IPv6 gateway. Valid values: `Available`, `Deleting`, `Pending`.
        :param _builtins.str vpc_id: The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
        """
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "ipv6_gateway_name", ipv6_gateway_name)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> _builtins.str:
        """
        The status of the IPv6 gateway. Valid values:`Normal`, `FinancialLocked` and `SecurityLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments. `SecurityLocked`: locked due to security reasons.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the IPv6 gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The time when the IPv6 gateway expires.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ipv6 Gateway.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> _builtins.str:
        """
        The metering method of the IPv6 gateway. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayName")
    def ipv6_gateway_name(self) -> _builtins.str:
        """
        The name of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_name")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        The specification of the IPv6 gateway. Valid values: `Large`, `Medium` and `Small`. `Small` (default): Free Edition. `Medium`: Enterprise Edition . `Large`: Enhanced Enterprise Edition. The throughput capacity of an IPv6 gateway varies based on the edition. For more information, see [Editions of IPv6 gateways](https://www.alibabacloud.com/help/doc-detail/98926.htm).
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the IPv6 gateway. Valid values: `Available`, `Deleting`, `Pending`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetIpv6InternetBandwidthsBandwidthResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 id: _builtins.str,
                 internet_charge_type: _builtins.str,
                 ipv6_address_id: _builtins.str,
                 ipv6_gateway_id: _builtins.str,
                 ipv6_internet_bandwidth_id: _builtins.str,
                 payment_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.int bandwidth: The amount of Internet bandwidth resources of the IPv6 address, Unit: `Mbit/s`.
        :param _builtins.str id: The ID of the Ipv6 Internet Bandwidth.
        :param _builtins.str internet_charge_type: The metering method of the Internet bandwidth resources of the IPv6 gateway.
        :param _builtins.str ipv6_address_id: The ID of the IPv6 address.
        :param _builtins.str ipv6_gateway_id: The ID of the IPv6 gateway.
        :param _builtins.str ipv6_internet_bandwidth_id: The ID of the Ipv6 Internet Bandwidth.
        :param _builtins.str payment_type: The payment type of the resource.
        :param _builtins.str status: The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ipv6_address_id", ipv6_address_id)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "ipv6_internet_bandwidth_id", ipv6_internet_bandwidth_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The amount of Internet bandwidth resources of the IPv6 address, Unit: `Mbit/s`.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ipv6 Internet Bandwidth.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        """
        The metering method of the Internet bandwidth resources of the IPv6 gateway.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressId")
    def ipv6_address_id(self) -> _builtins.str:
        """
        The ID of the IPv6 address.
        """
        return pulumi.get(self, "ipv6_address_id")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> _builtins.str:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @_builtins.property
    @pulumi.getter(name="ipv6InternetBandwidthId")
    def ipv6_internet_bandwidth_id(self) -> _builtins.str:
        """
        The ID of the Ipv6 Internet Bandwidth.
        """
        return pulumi.get(self, "ipv6_internet_bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNatGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 business_status: _builtins.str,
                 deletion_protection: _builtins.bool,
                 description: _builtins.str,
                 ecs_metric_enabled: _builtins.bool,
                 expired_time: _builtins.str,
                 forward_table_ids: Sequence[_builtins.str],
                 id: _builtins.str,
                 internet_charge_type: _builtins.str,
                 ip_lists: Sequence[_builtins.str],
                 name: _builtins.str,
                 nat_gateway_id: _builtins.str,
                 nat_gateway_name: _builtins.str,
                 nat_type: _builtins.str,
                 network_type: _builtins.str,
                 payment_type: _builtins.str,
                 resource_group_id: _builtins.str,
                 snat_table_ids: Sequence[_builtins.str],
                 spec: _builtins.str,
                 specification: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str business_status: The state of the NAT gateway.
        :param _builtins.bool deletion_protection: Indicates whether deletion protection is enabled.
        :param _builtins.str description: The description of the NAT gateway.
        :param _builtins.bool ecs_metric_enabled: Indicates whether the traffic monitoring feature is enabled.
        :param _builtins.str expired_time: The time when the NAT gateway expires.
        :param Sequence[_builtins.str] forward_table_ids: The ID of the DNAT table.
        :param _builtins.str id: The ID of the NAT gateway.
        :param _builtins.str internet_charge_type: The metering method of the NAT gateway.
        :param Sequence[_builtins.str] ip_lists: The ip address of the bind eip.
        :param _builtins.str name: Name of the NAT gateway.
        :param _builtins.str nat_gateway_id: The ID of the NAT gateway.
        :param _builtins.str nat_gateway_name: The name of NAT gateway.
        :param _builtins.str nat_type: The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
        :param _builtins.str network_type: (Available in 1.137.0+) Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`.
        :param _builtins.str payment_type: The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
        :param _builtins.str resource_group_id: The resource group id of NAT gateway.
        :param Sequence[_builtins.str] snat_table_ids: The ID of the SNAT table that is associated with the NAT gateway.
        :param _builtins.str spec: The specification of the NAT gateway.
        :param _builtins.str specification: The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
        :param _builtins.str status: The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
        :param Mapping[str, _builtins.str] tags: The tags of NAT gateway.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitch_id: The ID of the vSwitch to which the NAT gateway belongs.
        """
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ecs_metric_enabled", ecs_metric_enabled)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "forward_table_ids", forward_table_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ip_lists", ip_lists)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        pulumi.set(__self__, "nat_type", nat_type)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "snat_table_ids", snat_table_ids)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> _builtins.str:
        """
        The state of the NAT gateway.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        Indicates whether deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the NAT gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ecsMetricEnabled")
    def ecs_metric_enabled(self) -> _builtins.bool:
        """
        Indicates whether the traffic monitoring feature is enabled.
        """
        return pulumi.get(self, "ecs_metric_enabled")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The time when the NAT gateway expires.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="forwardTableIds")
    def forward_table_ids(self) -> Sequence[_builtins.str]:
        """
        The ID of the DNAT table.
        """
        return pulumi.get(self, "forward_table_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the NAT gateway.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        """
        The metering method of the NAT gateway.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Sequence[_builtins.str]:
        """
        The ip address of the bind eip.
        """
        return pulumi.get(self, "ip_lists")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the NAT gateway.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of the NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> _builtins.str:
        """
        The name of NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_name")

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> _builtins.str:
        """
        The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
        """
        return pulumi.get(self, "nat_type")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        (Available in 1.137.0+) Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The resource group id of NAT gateway.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="snatTableIds")
    def snat_table_ids(self) -> Sequence[_builtins.str]:
        """
        The ID of the SNAT table that is associated with the NAT gateway.
        """
        return pulumi.get(self, "snat_table_ids")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        The specification of the NAT gateway.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> _builtins.str:
        """
        The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags of NAT gateway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch to which the NAT gateway belongs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetNatIpCidrsCidrResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 is_default: _builtins.bool,
                 nat_gateway_id: _builtins.str,
                 nat_ip_cidr: _builtins.str,
                 nat_ip_cidr_description: _builtins.str,
                 nat_ip_cidr_id: _builtins.str,
                 nat_ip_cidr_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The time when the CIDR block was created.
        :param _builtins.str id: The ID of the Nat Ip Cidr.
        :param _builtins.bool is_default: Whether it is the default NAT IP ADDRESS. Valid values:`true` or `false`.`true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        :param _builtins.str nat_gateway_id: The ID of the VPC NAT gateway.
        :param _builtins.str nat_ip_cidr: The NAT CIDR block to be created. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
        :param _builtins.str nat_ip_cidr_description: NAT IP ADDRESS range to the description of. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        :param _builtins.str nat_ip_cidr_id: NAT IP ADDRESS instance ID.
        :param _builtins.str nat_ip_cidr_name: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        :param _builtins.str status: The status of the CIDR block of the NAT gateway. If the value is `Available`, the CIDR block is available.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        pulumi.set(__self__, "nat_ip_cidr_description", nat_ip_cidr_description)
        pulumi.set(__self__, "nat_ip_cidr_id", nat_ip_cidr_id)
        pulumi.set(__self__, "nat_ip_cidr_name", nat_ip_cidr_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the CIDR block was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Nat Ip Cidr.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether it is the default NAT IP ADDRESS. Valid values:`true` or `false`.`true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of the VPC NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> _builtins.str:
        """
        The NAT CIDR block to be created. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
        """
        return pulumi.get(self, "nat_ip_cidr")

    @_builtins.property
    @pulumi.getter(name="natIpCidrDescription")
    def nat_ip_cidr_description(self) -> _builtins.str:
        """
        NAT IP ADDRESS range to the description of. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_cidr_description")

    @_builtins.property
    @pulumi.getter(name="natIpCidrId")
    def nat_ip_cidr_id(self) -> _builtins.str:
        """
        NAT IP ADDRESS instance ID.
        """
        return pulumi.get(self, "nat_ip_cidr_id")

    @_builtins.property
    @pulumi.getter(name="natIpCidrName")
    def nat_ip_cidr_name(self) -> _builtins.str:
        """
        NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_cidr_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the CIDR block of the NAT gateway. If the value is `Available`, the CIDR block is available.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNatIpsIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 is_default: _builtins.bool,
                 nat_gateway_id: _builtins.str,
                 nat_ip: _builtins.str,
                 nat_ip_cidr: _builtins.str,
                 nat_ip_description: _builtins.str,
                 nat_ip_id: _builtins.str,
                 nat_ip_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the Nat Ip.
        :param _builtins.bool is_default: Indicates whether the BGP Group is the default NAT IP ADDRESS. Valid values: `true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        :param _builtins.str nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway to which the NAT IP address belongs.
        :param _builtins.str nat_ip: The NAT IP address that is queried.
        :param _builtins.str nat_ip_cidr: The CIDR block to which the NAT IP address belongs.
        :param _builtins.str nat_ip_description: The description of the NAT IP address.
        :param _builtins.str nat_ip_id: The ID of the NAT IP address.
        :param _builtins.str nat_ip_name: The name of the NAT IP address.
        :param _builtins.str status: The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_ip", nat_ip)
        pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        pulumi.set(__self__, "nat_ip_description", nat_ip_description)
        pulumi.set(__self__, "nat_ip_id", nat_ip_id)
        pulumi.set(__self__, "nat_ip_name", nat_ip_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Nat Ip.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Indicates whether the BGP Group is the default NAT IP ADDRESS. Valid values: `true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of the Virtual Private Cloud (VPC) NAT gateway to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> _builtins.str:
        """
        The NAT IP address that is queried.
        """
        return pulumi.get(self, "nat_ip")

    @_builtins.property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> _builtins.str:
        """
        The CIDR block to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_ip_cidr")

    @_builtins.property
    @pulumi.getter(name="natIpDescription")
    def nat_ip_description(self) -> _builtins.str:
        """
        The description of the NAT IP address.
        """
        return pulumi.get(self, "nat_ip_description")

    @_builtins.property
    @pulumi.getter(name="natIpId")
    def nat_ip_id(self) -> _builtins.str:
        """
        The ID of the NAT IP address.
        """
        return pulumi.get(self, "nat_ip_id")

    @_builtins.property
    @pulumi.getter(name="natIpName")
    def nat_ip_name(self) -> _builtins.str:
        """
        The name of the NAT IP address.
        """
        return pulumi.get(self, "nat_ip_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworkAclsAclResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 egress_acl_entries: Sequence['outputs.GetNetworkAclsAclEgressAclEntryResult'],
                 id: _builtins.str,
                 ingress_acl_entries: Sequence['outputs.GetNetworkAclsAclIngressAclEntryResult'],
                 network_acl_id: _builtins.str,
                 network_acl_name: _builtins.str,
                 resources: Sequence['outputs.GetNetworkAclsAclResourceResult'],
                 status: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str description: Description of network ACL information.
        :param Sequence['GetNetworkAclsAclEgressAclEntryArgs'] egress_acl_entries: Output direction rule information.
        :param _builtins.str id: The ID of the Network Acl.
        :param Sequence['GetNetworkAclsAclIngressAclEntryArgs'] ingress_acl_entries: Entry direction rule information.
        :param _builtins.str network_acl_id: The first ID of the resource.
        :param _builtins.str network_acl_name: The name of the network ACL.
        :param Sequence['GetNetworkAclsAclResourceArgs'] resources: The associated resource.
        :param _builtins.str status: The state of the network ACL.
        :param _builtins.str vpc_id: The ID of the associated VPC.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "egress_acl_entries", egress_acl_entries)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ingress_acl_entries", ingress_acl_entries)
        pulumi.set(__self__, "network_acl_id", network_acl_id)
        pulumi.set(__self__, "network_acl_name", network_acl_name)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of network ACL information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="egressAclEntries")
    def egress_acl_entries(self) -> Sequence['outputs.GetNetworkAclsAclEgressAclEntryResult']:
        """
        Output direction rule information.
        """
        return pulumi.get(self, "egress_acl_entries")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Network Acl.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ingressAclEntries")
    def ingress_acl_entries(self) -> Sequence['outputs.GetNetworkAclsAclIngressAclEntryResult']:
        """
        Entry direction rule information.
        """
        return pulumi.get(self, "ingress_acl_entries")

    @_builtins.property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "network_acl_id")

    @_builtins.property
    @pulumi.getter(name="networkAclName")
    def network_acl_name(self) -> _builtins.str:
        """
        The name of the network ACL.
        """
        return pulumi.get(self, "network_acl_name")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetNetworkAclsAclResourceResult']:
        """
        The associated resource.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the network ACL.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the associated VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetNetworkAclsAclEgressAclEntryResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 destination_cidr_ip: _builtins.str,
                 network_acl_entry_name: _builtins.str,
                 policy: _builtins.str,
                 port: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.str description: Give the description information of the direction rule.
        :param _builtins.str destination_cidr_ip: The destination address segment.
        :param _builtins.str network_acl_entry_name: The name of the entry for the direction rule.
        :param _builtins.str policy: The  authorization policy.
        :param _builtins.str port: Destination port range.
        :param _builtins.str protocol: Transport  layer protocol.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Give the description information of the direction rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> _builtins.str:
        """
        The destination address segment.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @_builtins.property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> _builtins.str:
        """
        The name of the entry for the direction rule.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The  authorization policy.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        Destination port range.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Transport  layer protocol.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetNetworkAclsAclIngressAclEntryResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 network_acl_entry_name: _builtins.str,
                 policy: _builtins.str,
                 port: _builtins.str,
                 protocol: _builtins.str,
                 source_cidr_ip: _builtins.str):
        """
        :param _builtins.str description: Description of the entry direction rule.
        :param _builtins.str network_acl_entry_name: The name of the entry direction rule entry.
        :param _builtins.str policy: The authorization policy.
        :param _builtins.str port: Source port range.
        :param _builtins.str protocol: Transport layer protocol.
        :param _builtins.str source_cidr_ip: The source address field.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the entry direction rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> _builtins.str:
        """
        The name of the entry direction rule entry.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The authorization policy.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        Source port range.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Transport layer protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> _builtins.str:
        """
        The source address field.
        """
        return pulumi.get(self, "source_cidr_ip")


@pulumi.output_type
class GetNetworkAclsAclResourceResult(dict):
    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str resource_id: The ID of the associated resource.
        :param _builtins.str resource_type: The type of the associated resource.
        :param _builtins.str status: The state of the associated resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of the associated resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the associated resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworksVpcResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 creation_time: _builtins.str,
                 description: _builtins.str,
                 dhcp_options_set_id: _builtins.str,
                 dhcp_options_set_status: _builtins.str,
                 dns_hostname_status: _builtins.str,
                 id: _builtins.str,
                 ipv6_cidr_block: _builtins.str,
                 is_default: _builtins.bool,
                 region_id: _builtins.str,
                 resource_group_id: _builtins.str,
                 route_table_id: _builtins.str,
                 router_id: _builtins.str,
                 secondary_cidr_blocks: Sequence[_builtins.str],
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 user_cidrs: Sequence[_builtins.str],
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str,
                 vrouter_id: _builtins.str,
                 vswitch_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        :param _builtins.str creation_time: Time of creation.
        :param _builtins.str description: Description of the VPC
        :param _builtins.str dhcp_options_set_id: The ID of dhcp options set.
        :param _builtins.str dhcp_options_set_status: The status of the DHCP options set. Valid values: `Available`, `InUse`, `Deleted`, `Pending`.
        :param _builtins.str dns_hostname_status: Indicates whether the Domain Name System (DNS) feature is enabled.
        :param _builtins.str id: ID of the VPC.
        :param _builtins.str ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param _builtins.bool is_default: Indicate whether the VPC is the default one in the specified region.
        :param _builtins.str region_id: ID of the region where the VPC is located.
        :param _builtins.str resource_group_id: The Id of resource group which VPC belongs.
        :param _builtins.str route_table_id: Route table ID of the VRouter.
        :param _builtins.str router_id: The ID of the VRouter.
        :param Sequence[_builtins.str] secondary_cidr_blocks: A list of secondary IPv4 CIDR blocks of the VPC.
        :param _builtins.str status: Filter results by a specific status. Valid value are `Pending` and `Available`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param Sequence[_builtins.str] user_cidrs: A list of user CIDRs.
        :param _builtins.str vpc_id: ID of the VPC.
        :param _builtins.str vpc_name: The name of the VPC.
        :param _builtins.str vrouter_id: ID of the VRouter.
        :param Sequence[_builtins.str] vswitch_ids: List of vSwitch IDs in the specified VPC
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dhcp_options_set_id", dhcp_options_set_id)
        pulumi.set(__self__, "dhcp_options_set_status", dhcp_options_set_status)
        pulumi.set(__self__, "dns_hostname_status", dns_hostname_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "secondary_cidr_blocks", secondary_cidr_blocks)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_cidrs", user_cidrs)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)
        pulumi.set(__self__, "vrouter_id", vrouter_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        Time of creation.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the VPC
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsSetId")
    def dhcp_options_set_id(self) -> _builtins.str:
        """
        The ID of dhcp options set.
        """
        return pulumi.get(self, "dhcp_options_set_id")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsSetStatus")
    def dhcp_options_set_status(self) -> _builtins.str:
        """
        The status of the DHCP options set. Valid values: `Available`, `InUse`, `Deleted`, `Pending`.
        """
        return pulumi.get(self, "dhcp_options_set_status")

    @_builtins.property
    @pulumi.getter(name="dnsHostnameStatus")
    def dns_hostname_status(self) -> _builtins.str:
        """
        Indicates whether the Domain Name System (DNS) feature is enabled.
        """
        return pulumi.get(self, "dns_hostname_status")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> _builtins.str:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Indicate whether the VPC is the default one in the specified region.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        ID of the region where the VPC is located.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which VPC belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        Route table ID of the VRouter.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        The ID of the VRouter.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlocks")
    def secondary_cidr_blocks(self) -> Sequence[_builtins.str]:
        """
        A list of secondary IPv4 CIDR blocks of the VPC.
        """
        return pulumi.get(self, "secondary_cidr_blocks")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Filter results by a specific status. Valid value are `Pending` and `Available`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userCidrs")
    def user_cidrs(self) -> Sequence[_builtins.str]:
        """
        A list of user CIDRs.
        """
        return pulumi.get(self, "user_cidrs")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="vrouterId")
    def vrouter_id(self) -> _builtins.str:
        """
        ID of the VRouter.
        """
        return pulumi.get(self, "vrouter_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[_builtins.str]:
        """
        List of vSwitch IDs in the specified VPC
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetPbrRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 next_hop: _builtins.str,
                 route_dest: _builtins.str,
                 route_source: _builtins.str,
                 status: _builtins.str,
                 vpn_gateway_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str create_time: The creation time of the VPN Pbr Route Entry.
        :param _builtins.str id: The id of the vpn pbr route entry. The value formats as `<vpn_gateway_id>:<next_hop>:<route_source>:<route_dest>`.
        :param _builtins.str next_hop: The next hop of the policy-based route.
        :param _builtins.str route_dest: The destination CIDR block of the policy-based route.
        :param _builtins.str route_source: The source CIDR block of the policy-based route.
        :param _builtins.str status: The status of the VPN Pbr Route Entry.
        :param _builtins.str vpn_gateway_id: The ID of the VPN gateway.
        :param _builtins.int weight: The weight of the policy-based route. Valid values: 0 and 100.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_dest", route_dest)
        pulumi.set(__self__, "route_source", route_source)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the VPN Pbr Route Entry.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the vpn pbr route entry. The value formats as `<vpn_gateway_id>:<next_hop>:<route_source>:<route_dest>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> _builtins.str:
        """
        The next hop of the policy-based route.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> _builtins.str:
        """
        The destination CIDR block of the policy-based route.
        """
        return pulumi.get(self, "route_dest")

    @_builtins.property
    @pulumi.getter(name="routeSource")
    def route_source(self) -> _builtins.str:
        """
        The source CIDR block of the policy-based route.
        """
        return pulumi.get(self, "route_source")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the VPN Pbr Route Entry.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> _builtins.str:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the policy-based route. Valid values: 0 and 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetPeerConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 accepting_ali_uid: _builtins.int,
                 accepting_region_id: _builtins.str,
                 accepting_vpc_id: _builtins.str,
                 bandwidth: _builtins.int,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 peer_connection_id: _builtins.str,
                 peer_connection_name: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.int accepting_ali_uid: The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
        :param _builtins.str accepting_region_id: The region ID of the recipient of the VPC peering connection to be created.
        :param _builtins.str accepting_vpc_id: The VPC ID of the receiving end of the VPC peer connection.
        :param _builtins.int bandwidth: The bandwidth of the VPC peering connection to be modified. Unit: Mbps.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str description: The description of the VPC peer connection to be created.
        :param _builtins.str id: The ID of the PeerConnection.
        :param _builtins.str peer_connection_id: The first ID of the resource.
        :param _builtins.str peer_connection_name: The name of the resource.
        :param _builtins.str status: The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
        :param _builtins.str vpc_id: The ID of the requester VPC.
        """
        pulumi.set(__self__, "accepting_ali_uid", accepting_ali_uid)
        pulumi.set(__self__, "accepting_region_id", accepting_region_id)
        pulumi.set(__self__, "accepting_vpc_id", accepting_vpc_id)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_connection_id", peer_connection_id)
        pulumi.set(__self__, "peer_connection_name", peer_connection_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="acceptingAliUid")
    def accepting_ali_uid(self) -> _builtins.int:
        """
        The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
        """
        return pulumi.get(self, "accepting_ali_uid")

    @_builtins.property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> _builtins.str:
        """
        The region ID of the recipient of the VPC peering connection to be created.
        """
        return pulumi.get(self, "accepting_region_id")

    @_builtins.property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> _builtins.str:
        """
        The VPC ID of the receiving end of the VPC peer connection.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth of the VPC peering connection to be modified. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the VPC peer connection to be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the PeerConnection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="peerConnectionId")
    def peer_connection_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "peer_connection_id")

    @_builtins.property
    @pulumi.getter(name="peerConnectionName")
    def peer_connection_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "peer_connection_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the requester VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetPrefixListsListResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 entrys: Sequence['outputs.GetPrefixListsListEntryResult'],
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 max_entries: _builtins.int,
                 prefix_list_description: _builtins.str,
                 prefix_list_id: _builtins.str,
                 prefix_list_name: _builtins.str,
                 share_type: _builtins.str):
        """
        :param _builtins.str create_time: The time when the prefix list was created.
        :param Sequence['GetPrefixListsListEntryArgs'] entrys: The CIDR address block list of the prefix list.
        :param _builtins.str id: The ID of the Prefix List.
        :param _builtins.str ip_version: The IP version of the prefix list.
        :param _builtins.int max_entries: The maximum number of entries for CIDR address blocks in the prefix list.
        :param _builtins.str prefix_list_description: The description of the prefix list.
        :param _builtins.str prefix_list_id: The ID of the query Prefix List.
        :param _builtins.str prefix_list_name: The name of the prefix list.
        :param _builtins.str share_type: The share type of the prefix list.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "entrys", entrys)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "max_entries", max_entries)
        pulumi.set(__self__, "prefix_list_description", prefix_list_description)
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        pulumi.set(__self__, "prefix_list_name", prefix_list_name)
        pulumi.set(__self__, "share_type", share_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the prefix list was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def entrys(self) -> Sequence['outputs.GetPrefixListsListEntryResult']:
        """
        The CIDR address block list of the prefix list.
        """
        return pulumi.get(self, "entrys")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Prefix List.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        The IP version of the prefix list.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> _builtins.int:
        """
        The maximum number of entries for CIDR address blocks in the prefix list.
        """
        return pulumi.get(self, "max_entries")

    @_builtins.property
    @pulumi.getter(name="prefixListDescription")
    def prefix_list_description(self) -> _builtins.str:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "prefix_list_description")

    @_builtins.property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> _builtins.str:
        """
        The ID of the query Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @_builtins.property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> _builtins.str:
        """
        The name of the prefix list.
        """
        return pulumi.get(self, "prefix_list_name")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        The share type of the prefix list.
        """
        return pulumi.get(self, "share_type")


@pulumi.output_type
class GetPrefixListsListEntryResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 description: _builtins.str):
        """
        :param _builtins.str cidr: The CIDR address block of the prefix list.
        :param _builtins.str description: The description of the cidr entry.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        The CIDR address block of the prefix list.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the cidr entry.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetPublicIpAddressPoolCidrBlocksBlockResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 public_ip_address_pool_id: _builtins.str,
                 status: _builtins.str,
                 total_ip_num: _builtins.int,
                 used_ip_num: _builtins.int):
        """
        :param _builtins.str cidr_block: The CIDR block.
        :param _builtins.str create_time: The time when the CIDR block was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        :param _builtins.str id: The ID of the Public Ip Address Pool Cidr Block.
        :param _builtins.str public_ip_address_pool_id: The ID of the Vpc Public IP address pool.
        :param _builtins.str status: The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
        :param _builtins.int total_ip_num: The number of occupied IP addresses in the CIDR block.
        :param _builtins.int used_ip_num: The total number of available IP addresses in the CIDR block.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_ip_num", total_ip_num)
        pulumi.set(__self__, "used_ip_num", used_ip_num)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the CIDR block was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Public Ip Address Pool Cidr Block.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> _builtins.str:
        """
        The ID of the Vpc Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> _builtins.int:
        """
        The number of occupied IP addresses in the CIDR block.
        """
        return pulumi.get(self, "total_ip_num")

    @_builtins.property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> _builtins.int:
        """
        The total number of available IP addresses in the CIDR block.
        """
        return pulumi.get(self, "used_ip_num")


@pulumi.output_type
class GetPublicIpAddressPoolsPoolResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 ip_address_remaining: _builtins.bool,
                 isp: _builtins.str,
                 public_ip_address_pool_id: _builtins.str,
                 public_ip_address_pool_name: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str,
                 total_ip_num: _builtins.int,
                 used_ip_num: _builtins.int,
                 user_type: _builtins.str):
        """
        :param _builtins.str create_time: The time when the Vpc Public Ip Address Pool was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        :param _builtins.str description: The description of the Vpc Public Ip Address Pool.
        :param _builtins.str id: The ID of the Vpc Public Ip Address Pool.
        :param _builtins.bool ip_address_remaining: Indicates whether the Vpc Public Ip Address Pool has idle IP addresses.
        :param _builtins.str isp: The Internet service provider.
        :param _builtins.str public_ip_address_pool_id: The ID of the Vpc Public Ip Address Pool.
        :param _builtins.str public_ip_address_pool_name: The name of the Vpc Public Ip Address Pool.
        :param _builtins.str region_id: The region ID of the Vpc Public Ip Address Pool.
        :param _builtins.str status: The status of the Vpc Public Ip Address Pool.
        :param _builtins.int total_ip_num: The total number of IP addresses in the Vpc Public Ip Address Pool.
        :param _builtins.int used_ip_num: The number of occupied IP addresses in the Vpc Public Ip Address Pool.
        :param _builtins.str user_type: The user type.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address_remaining", ip_address_remaining)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_ip_num", total_ip_num)
        pulumi.set(__self__, "used_ip_num", used_ip_num)
        pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the Vpc Public Ip Address Pool was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddressRemaining")
    def ip_address_remaining(self) -> _builtins.bool:
        """
        Indicates whether the Vpc Public Ip Address Pool has idle IP addresses.
        """
        return pulumi.get(self, "ip_address_remaining")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> _builtins.str:
        """
        The Internet service provider.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> _builtins.str:
        """
        The ID of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> _builtins.str:
        """
        The name of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> _builtins.int:
        """
        The total number of IP addresses in the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "total_ip_num")

    @_builtins.property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> _builtins.int:
        """
        The number of occupied IP addresses in the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "used_ip_num")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> _builtins.str:
        """
        The user type.
        """
        return pulumi.get(self, "user_type")


@pulumi.output_type
class GetRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 instance_id: _builtins.str,
                 next_hop_type: _builtins.str,
                 route_table_id: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str cidr_block: The destination CIDR block of the route entry.
        :param _builtins.str instance_id: The instance ID of the next hop.
        :param _builtins.str next_hop_type: The type of the next hop.
        :param _builtins.str route_table_id: The ID of the router table to which the route entry belongs.
        :param _builtins.str status: The status of the route entry.
        :param _builtins.str type: The type of the route entry.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The instance ID of the next hop.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> _builtins.str:
        """
        The type of the next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The ID of the router table to which the route entry belongs.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the route entry.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the route entry.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRouteTablesTableResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 resource_group_id: _builtins.str,
                 route_table_id: _builtins.str,
                 route_table_name: _builtins.str,
                 route_table_type: _builtins.str,
                 router_id: _builtins.str,
                 router_type: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str description: The description of the route table instance.
        :param _builtins.str id: ID of the Route Table.
        :param _builtins.str name: Name of the route table.
        :param _builtins.str resource_group_id: The Id of resource group which route tables belongs.
        :param _builtins.str route_table_id: The route table id.
        :param _builtins.str route_table_name: The route table name.
        :param _builtins.str route_table_type: The route table type.
        :param _builtins.str router_id: The router ID.
        :param _builtins.str router_type: The route type of route table. Valid values: `VRouter` and `VBR`.
        :param _builtins.str status: The status of resource. Valid values: `Available` and `Pending`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str vpc_id: Vpc id of the route table.
        :param Sequence[_builtins.str] vswitch_ids: A list of vswitch id.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "route_table_name", route_table_name)
        pulumi.set(__self__, "route_table_type", route_table_type)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_type", router_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the route table instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the Route Table.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the route table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which route tables belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The route table id.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> _builtins.str:
        """
        The route table name.
        """
        return pulumi.get(self, "route_table_name")

    @_builtins.property
    @pulumi.getter(name="routeTableType")
    def route_table_type(self) -> _builtins.str:
        """
        The route table type.
        """
        return pulumi.get(self, "route_table_type")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        The router ID.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> _builtins.str:
        """
        The route type of route table. Valid values: `VRouter` and `VBR`.
        """
        return pulumi.get(self, "router_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of resource. Valid values: `Available` and `Pending`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Vpc id of the route table.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[_builtins.str]:
        """
        A list of vswitch id.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetRouterInterfacesInterfaceResult(dict):
    def __init__(__self__, *,
                 access_point_id: _builtins.str,
                 creation_time: _builtins.str,
                 description: _builtins.str,
                 health_check_source_ip: _builtins.str,
                 health_check_target_ip: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 opposite_interface_id: _builtins.str,
                 opposite_interface_owner_id: _builtins.str,
                 opposite_region_id: _builtins.str,
                 opposite_router_id: _builtins.str,
                 opposite_router_type: _builtins.str,
                 role: _builtins.str,
                 router_id: _builtins.str,
                 router_type: _builtins.str,
                 specification: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str access_point_id: ID of the access point used by the VBR.
        :param _builtins.str creation_time: Router interface creation time.
        :param _builtins.str description: Router interface description.
        :param _builtins.str health_check_source_ip: Source IP address used to perform health check on the physical connection.
        :param _builtins.str health_check_target_ip: Destination IP address used to perform health check on the physical connection.
        :param _builtins.str id: Router interface ID.
        :param _builtins.str name: Router interface name.
        :param _builtins.str opposite_interface_id: ID of the peer router interface.
        :param _builtins.str opposite_interface_owner_id: Account ID of the owner of the peer router interface.
        :param _builtins.str opposite_region_id: Peer router region ID.
        :param _builtins.str opposite_router_id: Peer router ID.
        :param _builtins.str opposite_router_type: Router type in the peer region. Possible values: `VRouter` and `VBR`.
        :param _builtins.str role: Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and 
               `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
        :param _builtins.str router_id: ID of the VRouter located in the local region.
        :param _builtins.str router_type: Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
        :param _builtins.str specification: Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
        :param _builtins.str status: Expected status. Valid values are `Active`, `Inactive` and `Idle`.
        :param _builtins.str vpc_id: ID of the VPC that owns the router in the local region.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        pulumi.set(__self__, "opposite_router_type", opposite_router_type)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_type", router_type)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> _builtins.str:
        """
        ID of the access point used by the VBR.
        """
        return pulumi.get(self, "access_point_id")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        Router interface creation time.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Router interface description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> _builtins.str:
        """
        Source IP address used to perform health check on the physical connection.
        """
        return pulumi.get(self, "health_check_source_ip")

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> _builtins.str:
        """
        Destination IP address used to perform health check on the physical connection.
        """
        return pulumi.get(self, "health_check_target_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Router interface ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Router interface name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> _builtins.str:
        """
        ID of the peer router interface.
        """
        return pulumi.get(self, "opposite_interface_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> _builtins.str:
        """
        Account ID of the owner of the peer router interface.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> _builtins.str:
        """
        Peer router region ID.
        """
        return pulumi.get(self, "opposite_region_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> _builtins.str:
        """
        Peer router ID.
        """
        return pulumi.get(self, "opposite_router_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> _builtins.str:
        """
        Router type in the peer region. Possible values: `VRouter` and `VBR`.
        """
        return pulumi.get(self, "opposite_router_type")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and 
        `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        ID of the VRouter located in the local region.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> _builtins.str:
        """
        Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
        """
        return pulumi.get(self, "router_type")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> _builtins.str:
        """
        Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Expected status. Valid values are `Active`, `Inactive` and `Idle`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC that owns the router in the local region.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetSnatEntriesEntryResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 snat_entry_id: _builtins.str,
                 snat_entry_name: _builtins.str,
                 snat_ip: _builtins.str,
                 source_cidr: _builtins.str,
                 source_vswitch_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the Snat Entry.
        :param _builtins.str snat_entry_id: The ID of snat entry.
        :param _builtins.str snat_entry_name: The name of snat entry.
        :param _builtins.str snat_ip: The public IP of the Snat Entry.
        :param _builtins.str source_cidr: The source CIDR block of the Snat Entry.
        :param _builtins.str source_vswitch_id: The source vswitch ID.
        :param _builtins.str status: The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "snat_entry_id", snat_entry_id)
        pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        pulumi.set(__self__, "snat_ip", snat_ip)
        pulumi.set(__self__, "source_cidr", source_cidr)
        pulumi.set(__self__, "source_vswitch_id", source_vswitch_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Snat Entry.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="snatEntryId")
    def snat_entry_id(self) -> _builtins.str:
        """
        The ID of snat entry.
        """
        return pulumi.get(self, "snat_entry_id")

    @_builtins.property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> _builtins.str:
        """
        The name of snat entry.
        """
        return pulumi.get(self, "snat_entry_name")

    @_builtins.property
    @pulumi.getter(name="snatIp")
    def snat_ip(self) -> _builtins.str:
        """
        The public IP of the Snat Entry.
        """
        return pulumi.get(self, "snat_ip")

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> _builtins.str:
        """
        The source CIDR block of the Snat Entry.
        """
        return pulumi.get(self, "source_cidr")

    @_builtins.property
    @pulumi.getter(name="sourceVswitchId")
    def source_vswitch_id(self) -> _builtins.str:
        """
        The source vswitch ID.
        """
        return pulumi.get(self, "source_vswitch_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSslVpnClientCertsCertResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 end_time: _builtins.int,
                 id: _builtins.str,
                 name: _builtins.str,
                 ssl_vpn_server_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The time of creation.
        :param _builtins.int end_time: The expiration time of the client certificate.
        :param _builtins.str id: ID of the SSL-VPN client certificate.
        :param _builtins.str name: The name of the SSL-VPN client certificate.
        :param _builtins.str ssl_vpn_server_id: Use the SSL-VPN server ID as the search key.
        :param _builtins.str status: The status of the client certificate. valid value:expiring-soon, normal, expired.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssl_vpn_server_id", ssl_vpn_server_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time of creation.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.int:
        """
        The expiration time of the client certificate.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the SSL-VPN client certificate.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the SSL-VPN client certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> _builtins.str:
        """
        Use the SSL-VPN server ID as the search key.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the client certificate. valid value:expiring-soon, normal, expired.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSslVpnServersServerResult(dict):
    def __init__(__self__, *,
                 cipher: _builtins.str,
                 client_ip_pool: _builtins.str,
                 compress: _builtins.bool,
                 connections: _builtins.int,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 internet_ip: _builtins.str,
                 local_subnet: _builtins.str,
                 max_connections: _builtins.int,
                 name: _builtins.str,
                 port: _builtins.int,
                 proto: _builtins.str,
                 vpn_gateway_id: _builtins.str):
        """
        :param _builtins.str cipher: The encryption algorithm used.
        :param _builtins.str client_ip_pool: The IP address pool of the client.
        :param _builtins.bool compress: Whether to compress.
        :param _builtins.int connections: The number of current connections.
        :param _builtins.str create_time: The time of creation.
        :param _builtins.str id: The ID of the SSL-VPN server.
        :param _builtins.str internet_ip: The public IP.
        :param _builtins.str local_subnet: The local subnet of the VPN connection.
        :param _builtins.int max_connections: The maximum number of connections.
        :param _builtins.str name: The name of the SSL-VPN server.
        :param _builtins.int port: The port used by the SSL-VPN server.
        :param _builtins.str proto: The protocol used by the SSL-VPN server.
        :param _builtins.str vpn_gateway_id: Use the VPN gateway ID as the search key.
        """
        pulumi.set(__self__, "cipher", cipher)
        pulumi.set(__self__, "client_ip_pool", client_ip_pool)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @_builtins.property
    @pulumi.getter
    def cipher(self) -> _builtins.str:
        """
        The encryption algorithm used.
        """
        return pulumi.get(self, "cipher")

    @_builtins.property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> _builtins.str:
        """
        The IP address pool of the client.
        """
        return pulumi.get(self, "client_ip_pool")

    @_builtins.property
    @pulumi.getter
    def compress(self) -> _builtins.bool:
        """
        Whether to compress.
        """
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> _builtins.int:
        """
        The number of current connections.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time of creation.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the SSL-VPN server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The public IP.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> _builtins.str:
        """
        The local subnet of the VPN connection.
        """
        return pulumi.get(self, "local_subnet")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The maximum number of connections.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the SSL-VPN server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port used by the SSL-VPN server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> _builtins.str:
        """
        The protocol used by the SSL-VPN server.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> _builtins.str:
        """
        Use the VPN gateway ID as the search key.
        """
        return pulumi.get(self, "vpn_gateway_id")


@pulumi.output_type
class GetSwitchesVswitchResult(dict):
    def __init__(__self__, *,
                 available_ip_address_count: _builtins.int,
                 cidr_block: _builtins.str,
                 creation_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 ipv6_cidr_block: _builtins.str,
                 is_default: _builtins.bool,
                 name: _builtins.str,
                 resource_group_id: _builtins.str,
                 route_table_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 vswitch_name: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.int available_ip_address_count: The available ip address count of the vSwitch.
        :param _builtins.str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        :param _builtins.str creation_time: Time of creation.
        :param _builtins.str description: Description of the vSwitch.
        :param _builtins.str id: ID of the vSwitch.
        :param _builtins.str ipv6_cidr_block: The IPv6 CIDR block of the switch.
        :param _builtins.bool is_default: Indicate whether the vSwitch is created by the system.
        :param _builtins.str name: Name of the vSwitch.
        :param _builtins.str resource_group_id: The Id of resource group which VSWitch belongs.
        :param _builtins.str route_table_id: The route table ID of the vSwitch.
        :param _builtins.str status: The status of the vSwitch. Valid values: `Available` and `Pending`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str vpc_id: ID of the VPC that owns the vSwitch.
        :param _builtins.str vswitch_id: ID of the vSwitch.
        :param _builtins.str vswitch_name: The name of the vSwitch.
        :param _builtins.str zone_id: The availability zone of the vSwitch.
        """
        pulumi.set(__self__, "available_ip_address_count", available_ip_address_count)
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "vswitch_name", vswitch_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="availableIpAddressCount")
    def available_ip_address_count(self) -> _builtins.int:
        """
        The available ip address count of the vSwitch.
        """
        return pulumi.get(self, "available_ip_address_count")

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        Time of creation.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the vSwitch.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the vSwitch.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> _builtins.str:
        """
        The IPv6 CIDR block of the switch.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Indicate whether the vSwitch is created by the system.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the vSwitch.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Id of resource group which VSWitch belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The route table ID of the vSwitch.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the vSwitch. Valid values: `Available` and `Pending`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC that owns the vSwitch.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="vswitchName")
    def vswitch_name(self) -> _builtins.str:
        """
        The name of the vSwitch.
        """
        return pulumi.get(self, "vswitch_name")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The availability zone of the vSwitch.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetTrafficMirrorFilterEgressRulesRuleResult(dict):
    def __init__(__self__, *,
                 destination_cidr_block: _builtins.str,
                 destination_port_range: _builtins.str,
                 id: _builtins.str,
                 priority: _builtins.int,
                 protocol: _builtins.str,
                 rule_action: _builtins.str,
                 source_cidr_block: _builtins.str,
                 source_port_range: _builtins.str,
                 status: _builtins.str,
                 traffic_mirror_filter_id: _builtins.str,
                 traffic_mirror_filter_rule_id: _builtins.str):
        """
        :param _builtins.str destination_cidr_block: The destination CIDR block of the outbound traffic.
        :param _builtins.str destination_port_range: The destination port range of the outbound traffic.
        :param _builtins.str id: The ID of the Traffic Mirror Filter Egress Rule.
        :param _builtins.int priority: The priority of the outbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        :param _builtins.str protocol: The transport protocol used by outbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        :param _builtins.str rule_action: The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        :param _builtins.str source_cidr_block: The source CIDR block of the outbound traffic.
        :param _builtins.str source_port_range: The source port range of the outbound traffic.
        :param _builtins.str status: The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        :param _builtins.str traffic_mirror_filter_id: The ID of the filter associated with the outbound rule.
        :param _builtins.str traffic_mirror_filter_rule_id: The first ID of the resource.
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "destination_port_range", destination_port_range)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        pulumi.set(__self__, "source_port_range", source_port_range)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_filter_rule_id", traffic_mirror_filter_rule_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> _builtins.str:
        """
        The destination CIDR block of the outbound traffic.
        """
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> _builtins.str:
        """
        The destination port range of the outbound traffic.
        """
        return pulumi.get(self, "destination_port_range")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Traffic Mirror Filter Egress Rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the outbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The transport protocol used by outbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> _builtins.str:
        """
        The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> _builtins.str:
        """
        The source CIDR block of the outbound traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> _builtins.str:
        """
        The source port range of the outbound traffic.
        """
        return pulumi.get(self, "source_port_range")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> _builtins.str:
        """
        The ID of the filter associated with the outbound rule.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterRuleId")
    def traffic_mirror_filter_rule_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "traffic_mirror_filter_rule_id")


@pulumi.output_type
class GetTrafficMirrorFilterIngressRulesRuleResult(dict):
    def __init__(__self__, *,
                 destination_cidr_block: _builtins.str,
                 destination_port_range: _builtins.str,
                 id: _builtins.str,
                 priority: _builtins.int,
                 protocol: _builtins.str,
                 rule_action: _builtins.str,
                 source_cidr_block: _builtins.str,
                 source_port_range: _builtins.str,
                 status: _builtins.str,
                 traffic_mirror_filter_id: _builtins.str,
                 traffic_mirror_filter_rule_id: _builtins.str):
        """
        :param _builtins.str destination_cidr_block: The destination CIDR block of the inbound traffic.
        :param _builtins.str destination_port_range: The destination port range of the inbound traffic.
        :param _builtins.str id: The ID of the Traffic Mirror Filter Egress Rule.
        :param _builtins.int priority: The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        :param _builtins.str protocol: The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        :param _builtins.str rule_action: The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        :param _builtins.str source_cidr_block: The source CIDR block of the inbound traffic.
        :param _builtins.str source_port_range: The source port range of the inbound traffic.
        :param _builtins.str status: The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        :param _builtins.str traffic_mirror_filter_id: The ID of the filter associated with the inbound rule.
        :param _builtins.str traffic_mirror_filter_rule_id: The first ID of the resource.
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "destination_port_range", destination_port_range)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        pulumi.set(__self__, "source_port_range", source_port_range)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_filter_rule_id", traffic_mirror_filter_rule_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> _builtins.str:
        """
        The destination CIDR block of the inbound traffic.
        """
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> _builtins.str:
        """
        The destination port range of the inbound traffic.
        """
        return pulumi.get(self, "destination_port_range")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Traffic Mirror Filter Egress Rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> _builtins.str:
        """
        The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> _builtins.str:
        """
        The source CIDR block of the inbound traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> _builtins.str:
        """
        The source port range of the inbound traffic.
        """
        return pulumi.get(self, "source_port_range")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> _builtins.str:
        """
        The ID of the filter associated with the inbound rule.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterRuleId")
    def traffic_mirror_filter_rule_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "traffic_mirror_filter_rule_id")


@pulumi.output_type
class GetTrafficMirrorFiltersFilterResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 status: _builtins.str,
                 traffic_mirror_filter_description: _builtins.str,
                 traffic_mirror_filter_id: _builtins.str,
                 traffic_mirror_filter_name: _builtins.str):
        """
        :param _builtins.str id: The ID of the Traffic Mirror Filter.
        :param _builtins.str status: The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
        :param _builtins.str traffic_mirror_filter_description: The description of the filter.
        :param _builtins.str traffic_mirror_filter_id: The ID of the filter.
        :param _builtins.str traffic_mirror_filter_name: The name of the filter. The name must be `2` to `128` characters in length, and can contain digits, periods (.), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_description", traffic_mirror_filter_description)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_filter_name", traffic_mirror_filter_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Traffic Mirror Filter.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterDescription")
    def traffic_mirror_filter_description(self) -> _builtins.str:
        """
        The description of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_description")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> _builtins.str:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterName")
    def traffic_mirror_filter_name(self) -> _builtins.str:
        """
        The name of the filter. The name must be `2` to `128` characters in length, and can contain digits, periods (.), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "traffic_mirror_filter_name")


@pulumi.output_type
class GetTrafficMirrorSessionsSessionResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 packet_length: _builtins.int,
                 priority: _builtins.int,
                 status: _builtins.str,
                 traffic_mirror_filter_id: _builtins.str,
                 traffic_mirror_session_business_status: _builtins.str,
                 traffic_mirror_session_description: _builtins.str,
                 traffic_mirror_session_id: _builtins.str,
                 traffic_mirror_session_name: _builtins.str,
                 traffic_mirror_source_ids: Sequence[_builtins.str],
                 traffic_mirror_target_id: _builtins.str,
                 traffic_mirror_target_type: _builtins.str,
                 virtual_network_id: _builtins.int):
        """
        :param _builtins.bool enabled: Indicates whether traffic mirror sessions are enabled. default to `false`.
        :param _builtins.str id: The ID of the Traffic Mirror Session.
        :param _builtins.int packet_length: The maximum transmission unit (MTU).
        :param _builtins.int priority: The priority of the traffic mirror session. A smaller value indicates a higher priority.
        :param _builtins.str status: The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
        :param _builtins.str traffic_mirror_filter_id: The ID of the filter.
        :param _builtins.str traffic_mirror_session_business_status: The state of the traffic mirror session. Valid values: `Normal` or `FinancialLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments.
        :param _builtins.str traffic_mirror_session_description: The description of the traffic mirror session.
        :param _builtins.str traffic_mirror_session_id: The first ID of the resource.
        :param _builtins.str traffic_mirror_session_name: The name of the traffic mirror session.
        :param Sequence[_builtins.str] traffic_mirror_source_ids: The ID of the mirror source.
        :param _builtins.str traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        :param _builtins.str traffic_mirror_target_type: The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance
        :param _builtins.int virtual_network_id: You can specify VNIs to distinguish different mirrored traffic.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "packet_length", packet_length)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_session_business_status", traffic_mirror_session_business_status)
        pulumi.set(__self__, "traffic_mirror_session_description", traffic_mirror_session_description)
        pulumi.set(__self__, "traffic_mirror_session_id", traffic_mirror_session_id)
        pulumi.set(__self__, "traffic_mirror_session_name", traffic_mirror_session_name)
        pulumi.set(__self__, "traffic_mirror_source_ids", traffic_mirror_source_ids)
        pulumi.set(__self__, "traffic_mirror_target_id", traffic_mirror_target_id)
        pulumi.set(__self__, "traffic_mirror_target_type", traffic_mirror_target_type)
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Indicates whether traffic mirror sessions are enabled. default to `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Traffic Mirror Session.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="packetLength")
    def packet_length(self) -> _builtins.int:
        """
        The maximum transmission unit (MTU).
        """
        return pulumi.get(self, "packet_length")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the traffic mirror session. A smaller value indicates a higher priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> _builtins.str:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorSessionBusinessStatus")
    def traffic_mirror_session_business_status(self) -> _builtins.str:
        """
        The state of the traffic mirror session. Valid values: `Normal` or `FinancialLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments.
        """
        return pulumi.get(self, "traffic_mirror_session_business_status")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorSessionDescription")
    def traffic_mirror_session_description(self) -> _builtins.str:
        """
        The description of the traffic mirror session.
        """
        return pulumi.get(self, "traffic_mirror_session_description")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorSessionId")
    def traffic_mirror_session_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "traffic_mirror_session_id")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorSessionName")
    def traffic_mirror_session_name(self) -> _builtins.str:
        """
        The name of the traffic mirror session.
        """
        return pulumi.get(self, "traffic_mirror_session_name")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorSourceIds")
    def traffic_mirror_source_ids(self) -> Sequence[_builtins.str]:
        """
        The ID of the mirror source.
        """
        return pulumi.get(self, "traffic_mirror_source_ids")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> _builtins.str:
        """
        The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        """
        return pulumi.get(self, "traffic_mirror_target_id")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorTargetType")
    def traffic_mirror_target_type(self) -> _builtins.str:
        """
        The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance
        """
        return pulumi.get(self, "traffic_mirror_target_type")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> _builtins.int:
        """
        You can specify VNIs to distinguish different mirrored traffic.
        """
        return pulumi.get(self, "virtual_network_id")


@pulumi.output_type
class GetVpcFlowLogsLogResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 flow_log_id: _builtins.str,
                 flow_log_name: _builtins.str,
                 id: _builtins.str,
                 log_store_name: _builtins.str,
                 project_name: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 traffic_type: _builtins.str):
        """
        :param _builtins.str description: The Description of flow log.
        :param _builtins.str flow_log_id: The flow log ID.
        :param _builtins.str flow_log_name: The flow log name.
        :param _builtins.str id: The ID of the Flow Log.
        :param _builtins.str log_store_name: The log store name.
        :param _builtins.str project_name: The project name.
        :param _builtins.str resource_id: The resource id.
        :param _builtins.str resource_type: The resource type.
        :param _builtins.str status: The status of flow log.
        :param _builtins.str traffic_type: The traffic type.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "flow_log_id", flow_log_id)
        pulumi.set(__self__, "flow_log_name", flow_log_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_store_name", log_store_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_type", traffic_type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description of flow log.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> _builtins.str:
        """
        The flow log ID.
        """
        return pulumi.get(self, "flow_log_id")

    @_builtins.property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> _builtins.str:
        """
        The flow log name.
        """
        return pulumi.get(self, "flow_log_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Flow Log.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> _builtins.str:
        """
        The log store name.
        """
        return pulumi.get(self, "log_store_name")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource id.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of flow log.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> _builtins.str:
        """
        The traffic type.
        """
        return pulumi.get(self, "traffic_type")


