# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterInterfaceConnectionArgs', 'RouterInterfaceConnection']

@pulumi.input_type
class RouterInterfaceConnectionArgs:
    def __init__(__self__, *,
                 interface_id: pulumi.Input[_builtins.str],
                 opposite_interface_id: pulumi.Input[_builtins.str],
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouterInterfaceConnection resource.
        :param pulumi.Input[_builtins.str] interface_id: One side router interface ID.
        :param pulumi.Input[_builtins.str] opposite_interface_id: Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        :param pulumi.Input[_builtins.str] opposite_router_id: Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        :param pulumi.Input[_builtins.str] opposite_router_type: Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.
               
               > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        pulumi.set(__self__, "interface_id", interface_id)
        pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        if opposite_interface_owner_id is not None:
            pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        if opposite_router_id is not None:
            pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        if opposite_router_type is not None:
            pulumi.set(__self__, "opposite_router_type", opposite_router_type)

    @_builtins.property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        One side router interface ID.
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        """
        return pulumi.get(self, "opposite_interface_id")

    @opposite_interface_id.setter
    def opposite_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "opposite_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @opposite_interface_owner_id.setter
    def opposite_interface_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        """
        return pulumi.get(self, "opposite_router_id")

    @opposite_router_id.setter
    def opposite_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.

        > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        return pulumi.get(self, "opposite_router_type")

    @opposite_router_type.setter
    def opposite_router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_type", value)


@pulumi.input_type
class _RouterInterfaceConnectionState:
    def __init__(__self__, *,
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouterInterfaceConnection resources.
        :param pulumi.Input[_builtins.str] interface_id: One side router interface ID.
        :param pulumi.Input[_builtins.str] opposite_interface_id: Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        :param pulumi.Input[_builtins.str] opposite_router_id: Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        :param pulumi.Input[_builtins.str] opposite_router_type: Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.
               
               > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if opposite_interface_id is not None:
            pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        if opposite_interface_owner_id is not None:
            pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        if opposite_router_id is not None:
            pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        if opposite_router_type is not None:
            pulumi.set(__self__, "opposite_router_type", opposite_router_type)

    @_builtins.property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One side router interface ID.
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        """
        return pulumi.get(self, "opposite_interface_id")

    @opposite_interface_id.setter
    def opposite_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @opposite_interface_owner_id.setter
    def opposite_interface_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        """
        return pulumi.get(self, "opposite_router_id")

    @opposite_router_id.setter
    def opposite_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.

        > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        return pulumi.get(self, "opposite_router_type")

    @opposite_router_type.setter
    def opposite_router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_type", value)


@pulumi.type_token("alicloud:vpc/routerInterfaceConnection:RouterInterfaceConnection")
class RouterInterfaceConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **DEPRECATED:**  This resource has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.

        Provides a VPC router interface connection resource to connect two router interfaces which are in two different VPCs.
        After that, all of the two router interfaces will be active.

        > **NOTE:** At present, Router interface does not support changing opposite router interface, the connection delete action is only deactivating it to inactive, not modifying the connection to empty.

        > **NOTE:** If you want to changing opposite router interface, you can delete router interface and re-build them.

        > **NOTE:** A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.

        > **NOTE:** Please remember to add a `depends_on` clause in the router interface connection from the InitiatingSide to the AcceptingSide, because the connection from the AcceptingSide to the InitiatingSide must be done first.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "alicloudRouterInterfaceConnectionBasic"
        foo = alicloud.vpc.Network("foo",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        bar = alicloud.vpc.Network("bar",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        initiate = alicloud.vpc.RouterInterface("initiate",
            opposite_region=region,
            router_type="VRouter",
            router_id=foo.router_id,
            role="InitiatingSide",
            specification="Large.2",
            name=name,
            description=name,
            instance_charge_type="PostPaid")
        opposite = alicloud.vpc.RouterInterface("opposite",
            opposite_region=region,
            router_type="VRouter",
            router_id=bar.router_id,
            role="AcceptingSide",
            specification="Large.1",
            name=f"{name}-opposite",
            description=f"{name}-opposite")
        bar_router_interface_connection = alicloud.vpc.RouterInterfaceConnection("bar",
            interface_id=opposite.id,
            opposite_interface_id=initiate.id)
        # A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
        foo_router_interface_connection = alicloud.vpc.RouterInterfaceConnection("foo",
            interface_id=initiate.id,
            opposite_interface_id=opposite.id,
            opts = pulumi.ResourceOptions(depends_on=[bar_router_interface_connection]))
        ```

        ## Import

        The router interface connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routerInterfaceConnection:RouterInterfaceConnection foo ri-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] interface_id: One side router interface ID.
        :param pulumi.Input[_builtins.str] opposite_interface_id: Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        :param pulumi.Input[_builtins.str] opposite_router_id: Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        :param pulumi.Input[_builtins.str] opposite_router_type: Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.
               
               > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterInterfaceConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **DEPRECATED:**  This resource has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.

        Provides a VPC router interface connection resource to connect two router interfaces which are in two different VPCs.
        After that, all of the two router interfaces will be active.

        > **NOTE:** At present, Router interface does not support changing opposite router interface, the connection delete action is only deactivating it to inactive, not modifying the connection to empty.

        > **NOTE:** If you want to changing opposite router interface, you can delete router interface and re-build them.

        > **NOTE:** A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.

        > **NOTE:** Please remember to add a `depends_on` clause in the router interface connection from the InitiatingSide to the AcceptingSide, because the connection from the AcceptingSide to the InitiatingSide must be done first.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "alicloudRouterInterfaceConnectionBasic"
        foo = alicloud.vpc.Network("foo",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        bar = alicloud.vpc.Network("bar",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        initiate = alicloud.vpc.RouterInterface("initiate",
            opposite_region=region,
            router_type="VRouter",
            router_id=foo.router_id,
            role="InitiatingSide",
            specification="Large.2",
            name=name,
            description=name,
            instance_charge_type="PostPaid")
        opposite = alicloud.vpc.RouterInterface("opposite",
            opposite_region=region,
            router_type="VRouter",
            router_id=bar.router_id,
            role="AcceptingSide",
            specification="Large.1",
            name=f"{name}-opposite",
            description=f"{name}-opposite")
        bar_router_interface_connection = alicloud.vpc.RouterInterfaceConnection("bar",
            interface_id=opposite.id,
            opposite_interface_id=initiate.id)
        # A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
        foo_router_interface_connection = alicloud.vpc.RouterInterfaceConnection("foo",
            interface_id=initiate.id,
            opposite_interface_id=opposite.id,
            opts = pulumi.ResourceOptions(depends_on=[bar_router_interface_connection]))
        ```

        ## Import

        The router interface connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routerInterfaceConnection:RouterInterfaceConnection foo ri-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param RouterInterfaceConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterInterfaceConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterInterfaceConnectionArgs.__new__(RouterInterfaceConnectionArgs)

            if interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'interface_id'")
            __props__.__dict__["interface_id"] = interface_id
            if opposite_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'opposite_interface_id'")
            __props__.__dict__["opposite_interface_id"] = opposite_interface_id
            __props__.__dict__["opposite_interface_owner_id"] = opposite_interface_owner_id
            __props__.__dict__["opposite_router_id"] = opposite_router_id
            __props__.__dict__["opposite_router_type"] = opposite_router_type
        super(RouterInterfaceConnection, __self__).__init__(
            'alicloud:vpc/routerInterfaceConnection:RouterInterfaceConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouterInterfaceConnection':
        """
        Get an existing RouterInterfaceConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] interface_id: One side router interface ID.
        :param pulumi.Input[_builtins.str] opposite_interface_id: Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        :param pulumi.Input[_builtins.str] opposite_router_id: Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        :param pulumi.Input[_builtins.str] opposite_router_type: Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.
               
               > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterInterfaceConnectionState.__new__(_RouterInterfaceConnectionState)

        __props__.__dict__["interface_id"] = interface_id
        __props__.__dict__["opposite_interface_id"] = opposite_interface_id
        __props__.__dict__["opposite_interface_owner_id"] = opposite_interface_owner_id
        __props__.__dict__["opposite_router_id"] = opposite_router_id
        __props__.__dict__["opposite_router_type"] = opposite_router_type
        return RouterInterfaceConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        One side router interface ID.
        """
        return pulumi.get(self, "interface_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
        """
        return pulumi.get(self, "opposite_interface_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
        """
        return pulumi.get(self, "opposite_router_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.

        > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
        """
        return pulumi.get(self, "opposite_router_type")

