# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectionsResult',
    'AwaitableGetConnectionsResult',
    'get_connections',
    'get_connections_output',
]

@pulumi.output_type
class GetConnectionsResult:
    """
    A collection of values returned by getConnections.
    """
    def __init__(__self__, connections=None, customer_gateway_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, vpn_gateway_id=None):
        if connections and not isinstance(connections, list):
            raise TypeError("Expected argument 'connections' to be a list")
        pulumi.set(__self__, "connections", connections)
        if customer_gateway_id and not isinstance(customer_gateway_id, str):
            raise TypeError("Expected argument 'customer_gateway_id' to be a str")
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if vpn_gateway_id and not isinstance(vpn_gateway_id, str):
            raise TypeError("Expected argument 'vpn_gateway_id' to be a str")
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetConnectionsConnectionResult']:
        """
        A list of VPN connections. Each element contains the following attributes:
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[_builtins.str]:
        """
        The ID of the customer gateway in Tunnel.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        (Optional) IDs of the VPN connections.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        (Optional) names of the VPN connections.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[_builtins.str]:
        """
        ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")


class AwaitableGetConnectionsResult(GetConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionsResult(
            connections=self.connections,
            customer_gateway_id=self.customer_gateway_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            vpn_gateway_id=self.vpn_gateway_id)


def get_connections(customer_gateway_id: Optional[_builtins.str] = None,
                    ids: Optional[Sequence[_builtins.str]] = None,
                    name_regex: Optional[_builtins.str] = None,
                    output_file: Optional[_builtins.str] = None,
                    vpn_gateway_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionsResult:
    """
    The VPN connections data source lists lots of VPN connections resource information owned by an Alicloud account.

    > **NOTE:** Available since v1.18.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    foo = alicloud.vpn.get_connections(ids=["fake-conn-id"],
        vpn_gateway_id="fake-vpn-id",
        customer_gateway_id="fake-cgw-id",
        output_file="/tmp/vpnconn")
    ```


    :param _builtins.str customer_gateway_id: Use the VPN customer gateway ID as the search key.
    :param Sequence[_builtins.str] ids: IDs of the VPN connections.
    :param _builtins.str name_regex: A regex string of VPN connection name.
    :param _builtins.str output_file: Save the result to the file.
    :param _builtins.str vpn_gateway_id: Use the VPN gateway ID as the search key.
    """
    __args__ = dict()
    __args__['customerGatewayId'] = customer_gateway_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['vpnGatewayId'] = vpn_gateway_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpn/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult).value

    return AwaitableGetConnectionsResult(
        connections=pulumi.get(__ret__, 'connections'),
        customer_gateway_id=pulumi.get(__ret__, 'customer_gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        vpn_gateway_id=pulumi.get(__ret__, 'vpn_gateway_id'))
def get_connections_output(customer_gateway_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           vpn_gateway_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionsResult]:
    """
    The VPN connections data source lists lots of VPN connections resource information owned by an Alicloud account.

    > **NOTE:** Available since v1.18.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    foo = alicloud.vpn.get_connections(ids=["fake-conn-id"],
        vpn_gateway_id="fake-vpn-id",
        customer_gateway_id="fake-cgw-id",
        output_file="/tmp/vpnconn")
    ```


    :param _builtins.str customer_gateway_id: Use the VPN customer gateway ID as the search key.
    :param Sequence[_builtins.str] ids: IDs of the VPN connections.
    :param _builtins.str name_regex: A regex string of VPN connection name.
    :param _builtins.str output_file: Save the result to the file.
    :param _builtins.str vpn_gateway_id: Use the VPN gateway ID as the search key.
    """
    __args__ = dict()
    __args__['customerGatewayId'] = customer_gateway_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['vpnGatewayId'] = vpn_gateway_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpn/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult)
    return __ret__.apply(lambda __response__: GetConnectionsResult(
        connections=pulumi.get(__response__, 'connections'),
        customer_gateway_id=pulumi.get(__response__, 'customer_gateway_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        vpn_gateway_id=pulumi.get(__response__, 'vpn_gateway_id')))
