# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayZonesResult',
    'AwaitableGetGatewayZonesResult',
    'get_gateway_zones',
    'get_gateway_zones_output',
]

@pulumi.output_type
class GetGatewayZonesResult:
    """
    A collection of values returned by getGatewayZones.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, spec=None, zones=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if spec and not isinstance(spec, str):
            raise TypeError("Expected argument 'spec' to be a str")
        pulumi.set(__self__, "spec", spec)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Zone IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetGatewayZonesZoneResult']:
        """
        A list of Zone Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "zones")


class AwaitableGetGatewayZonesResult(GetGatewayZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayZonesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            spec=self.spec,
            zones=self.zones)


def get_gateway_zones(ids: Optional[Sequence[_builtins.str]] = None,
                      output_file: Optional[_builtins.str] = None,
                      spec: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayZonesResult:
    """
    This data source provides VPN Gateway Zone available to the user.[What is Zone](https://next.api.alibabacloud.com/api/Vpc/2016-04-28/DescribeVpnGatewayAvailableZones?lang=JAVA)

    > **NOTE:** Available since v1.216.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.vpn.get_gateway_zones(spec="5M")
    ```


    :param Sequence[_builtins.str] ids: A list of Zone IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str spec: Bandwidth specification.-If an IPsec connection is bound to a VPN gateway instance, this parameter indicates the Bandwidth specification of the VPN gateway instance.-If an IPsec connection is bound to a forwarding router, this parameter indicates the bandwidth that you expect the IPsec connection to support.Different bandwidth specifications may affect the zone information that is found. Value:
           - `5M`
           - `10M`
           - `20M`
           - `50M`
           - `100M`
           - `200M`
           - `500M`
           - `1000M`
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['spec'] = spec
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpn/getGatewayZones:getGatewayZones', __args__, opts=opts, typ=GetGatewayZonesResult).value

    return AwaitableGetGatewayZonesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        spec=pulumi.get(__ret__, 'spec'),
        zones=pulumi.get(__ret__, 'zones'))
def get_gateway_zones_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             spec: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewayZonesResult]:
    """
    This data source provides VPN Gateway Zone available to the user.[What is Zone](https://next.api.alibabacloud.com/api/Vpc/2016-04-28/DescribeVpnGatewayAvailableZones?lang=JAVA)

    > **NOTE:** Available since v1.216.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.vpn.get_gateway_zones(spec="5M")
    ```


    :param Sequence[_builtins.str] ids: A list of Zone IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str spec: Bandwidth specification.-If an IPsec connection is bound to a VPN gateway instance, this parameter indicates the Bandwidth specification of the VPN gateway instance.-If an IPsec connection is bound to a forwarding router, this parameter indicates the bandwidth that you expect the IPsec connection to support.Different bandwidth specifications may affect the zone information that is found. Value:
           - `5M`
           - `10M`
           - `20M`
           - `50M`
           - `100M`
           - `200M`
           - `500M`
           - `1000M`
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['spec'] = spec
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpn/getGatewayZones:getGatewayZones', __args__, opts=opts, typ=GetGatewayZonesResult)
    return __ret__.apply(lambda __response__: GetGatewayZonesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        spec=pulumi.get(__response__, 'spec'),
        zones=pulumi.get(__response__, 'zones')))
