/*
 Highcharts JS v10.3.3 (2023-01-20)

 Boost module

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(u){a(u);a.Highcharts=u;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function u(a,f,c,n){a.hasOwnProperty(f)||(a[f]=n.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:f,module:a[f]}})))}a=a?a._modules:{};
u(a,"Extensions/Boost/Boostables.js",[],function(){return"area areaspline arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});u(a,"Extensions/Boost/BoostableMap.js",[a["Extensions/Boost/Boostables.js"]],function(a){var f={};a.forEach(function(a){f[a]=!0});return f});u(a,"Extensions/Boost/BoostChart.js",[a["Extensions/Boost/BoostableMap.js"],a["Core/Utilities.js"]],function(a,f){function c(b){var g=b.series,f=b.boost=b.boost||{},C=b.options.boost||{},c=B(C.seriesThreshold,
50);if(g.length>=c)return!0;if(1===g.length)return!1;C=C.allowForce;if("undefined"===typeof C)for(C=!0,c=0,b=b.xAxis;c<b.length;c++){var m=b[c];if(B(m.min,-Infinity)>B(m.dataMin,-Infinity)||B(m.max,Infinity)<B(m.dataMax,Infinity)){C=!1;break}}if("undefined"!==typeof f.forceChartBoost){if(C)return f.forceChartBoost;f.forceChartBoost=void 0}for(var n=c=b=0;n<g.length;n++){var H=g[n];m=H.options;0!==m.boostThreshold&&!1!==H.visible&&"heatmap"!==H.type&&(a[H.type]&&++b,t(H.processedXData,m.data,H.points)>=
(m.boostThreshold||Number.MAX_VALUE)&&++c)}f.forceChartBoost=C&&(b===g.length&&0<c||5<c);return f.forceChartBoost}function n(b){g(b,"predraw",function(){b.boost=b.boost||{};b.boost.forceChartBoost=void 0;b.boosted=!1;b.boost.clear&&b.boost.clear();b.boost.canvas&&b.boost.wgl&&c(b)&&b.boost.wgl.allocateBuffer(b);b.boost.markerGroup&&b.xAxis&&0<b.xAxis.length&&b.yAxis&&0<b.yAxis.length&&b.boost.markerGroup.translate(b.xAxis[0].pos,b.yAxis[0].pos)});g(b,"render",function(){b.boost&&b.boost.wgl&&c(b)&&
b.boost.wgl.render(b)});var a=-1,t=-1;g(b.pointer,"afterGetHoverData",function(){var g=b.hoverSeries;b.boost=b.boost||{};if(b.boost.markerGroup&&g){var f=b.inverted?g.yAxis:g.xAxis;g=b.inverted?g.xAxis:g.yAxis;if(f&&f.pos!==a||g&&g.pos!==t)b.boost.markerGroup.translate(f.pos,g.pos),a=f.pos,t=g.pos}})}function t(){for(var b=[],g=0;g<arguments.length;g++)b[g]=arguments[g];var a=-Number.MAX_VALUE;b.forEach(function(b){if("undefined"!==typeof b&&null!==b&&"undefined"!==typeof b.length&&0<b.length)return a=
b.length,!0});return a}var g=f.addEvent,B=f.pick,m=[];return{compose:function(b,g){g&&-1===m.indexOf(b)&&(m.push(b),b.prototype.callbacks.push(n));return b},getBoostClipRect:function(b,g){var a={x:b.plotLeft,y:b.plotTop,width:b.plotWidth,height:b.plotHeight};g===b&&(g=b.inverted?b.xAxis:b.yAxis,1>=g.length?(a.y=Math.min(g[0].pos,a.y),a.height=g[0].pos-b.plotTop+g[0].len):a.height=b.plotHeight);return a},isChartSeriesBoosting:c}});u(a,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",
arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}});u(a,"Extensions/Boost/WGLShader.js",[a["Core/Utilities.js"]],function(a){var f=a.clamp,c=a.error,n=a.pick;return function(){function a(a){this.errors=[];this.uLocations={};(this.gl=a)&&this.createShader()}a.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)};a.prototype.createShader=
function(){var a=this,f=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),c=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),b=function(b){return a.gl.getUniformLocation(a.shaderProgram,
b)};if(!f||!c)return this.shaderProgram=!1,this.handleErrors(),!1;this.shaderProgram=this.gl.createProgram();this.gl.attachShader(this.shaderProgram,f);this.gl.attachShader(this.shaderProgram,c);this.gl.linkProgram(this.shaderProgram);if(!this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))return this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1;this.gl.useProgram(this.shaderProgram);this.gl.bindAttribLocation(this.shaderProgram,
0,"aVertexPosition");this.pUniform=b("uPMatrix");this.psUniform=b("pSize");this.fcUniform=b("fillColor");this.isBubbleUniform=b("isBubble");this.bubbleSizeAbsUniform=b("bubbleSizeAbs");this.bubbleSizeAreaUniform=b("bubbleSizeByArea");this.uSamplerUniform=b("uSampler");this.skipTranslationUniform=b("skipTranslation");this.isCircleUniform=b("isCircle");this.isInverted=b("isInverted");return!0};a.prototype.handleErrors=function(){this.errors.length&&c("[highcharts boost] shader error - "+this.errors.join("\n"))};
a.prototype.stringToProgram=function(a,f){var g=this.gl.createShader("vertex"===f?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);this.gl.shaderSource(g,a);this.gl.compileShader(g);return this.gl.getShaderParameter(g,this.gl.COMPILE_STATUS)?g:(this.errors.push("when compiling "+f+" shader:\n"+this.gl.getShaderInfoLog(g)),!1)};a.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)};a.prototype.fillColorUniform=function(){return this.fcUniform};
a.prototype.getProgram=function(){return this.shaderProgram};a.prototype.pointSizeUniform=function(){return this.psUniform};a.prototype.perspectiveUniform=function(){return this.pUniform};a.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))};a.prototype.setBubbleUniforms=function(a,c,m,b){void 0===b&&(b=1);var g=a.options,t=Number.MAX_VALUE,H=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&a.is("bubble")){var B=
a.getPxExtremes();t=n(g.zMin,f(c,!1===g.displayNegative?g.zThreshold:-Number.MAX_VALUE,t));H=n(g.zMax,Math.max(H,m));this.gl.uniform1i(this.isBubbleUniform,1);this.gl.uniform1i(this.isCircleUniform,1);this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==a.options.sizeBy);this.gl.uniform1i(this.bubbleSizeAbsUniform,a.options.sizeByAbsoluteValue);this.setUniform("bubbleMinSize",B.minPxSize*b);this.setUniform("bubbleMaxSize",B.maxPxSize*b);this.setUniform("bubbleZMin",t);this.setUniform("bubbleZMax",
H);this.setUniform("bubbleZThreshold",a.options.zThreshold)}};a.prototype.setColor=function(a){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,a[0]/255,a[1]/255,a[2]/255,a[3])};a.prototype.setDrawAsCircle=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,a?1:0)};a.prototype.setInverted=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,a)};a.prototype.setPMatrix=function(a){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,
!1,a)};a.prototype.setPointSize=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,a)};a.prototype.setSkipTranslation=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===a?1:0)};a.prototype.setTexture=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,a)};a.prototype.setUniform=function(a,f){this.gl&&this.shaderProgram&&(a=this.uLocations[a]=this.uLocations[a]||this.gl.getUniformLocation(this.shaderProgram,
a),this.gl.uniform1f(a,f))};return a}()});u(a,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function a(a,c,n){this.buffer=!1;this.iterator=0;this.vertAttribute=this.preAllocated=!1;this.components=n||2;this.dataComponents=n;this.gl=a;this.shader=c}a.prototype.allocate=function(a){this.iterator=-1;this.preAllocated=new Float32Array(4*a)};a.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)};
a.prototype.build=function(a,c,n){var f;this.data=a||[];if(!(this.data&&0!==this.data.length||this.preAllocated))return this.destroy(),!1;this.components=n||this.components;this.buffer&&this.gl.deleteBuffer(this.buffer);this.preAllocated||(f=new Float32Array(this.data));this.buffer=this.gl.createBuffer();this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer);this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||f,this.gl.STATIC_DRAW);this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),
c);this.gl.enableVertexAttribArray(this.vertAttribute);return!0};a.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.vertAttribute=this.buffer=!1);this.iterator=0;this.components=this.dataComponents||2;this.data=[]};a.prototype.push=function(a,c,n,t){this.preAllocated&&(this.preAllocated[++this.iterator]=a,this.preAllocated[++this.iterator]=c,this.preAllocated[++this.iterator]=n,this.preAllocated[++this.iterator]=t)};a.prototype.render=function(a,c,n){var f=this.preAllocated?
this.preAllocated.length:this.data.length;if(!this.buffer||!f)return!1;if(!a||a>f||0>a)a=0;if(!c||c>f)c=f;if(a>=c)return!1;this.gl.drawArrays(this.gl[n||"POINTS"],a/this.components,(c-a)/this.components);return!0};return a}()});u(a,"Extensions/Boost/WGLRenderer.js",[a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLDrawMode.js"],a["Extensions/Boost/WGLShader.js"],a["Extensions/Boost/WGLVertexBuffer.js"]],function(a,f,c,n,t,g){var B=a.parse,m=f.doc,b=f.win,
H=c.isNumber,u=c.isObject,C=c.merge,X=c.objectEach,Q=c.pick,F={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},ca={scatter:!0,bubble:!0},G=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function c(a){this.data=[];this.height=0;this.isInited=!1;this.markerData=[];this.series=[];this.textureHandles={};this.width=0;this.postRenderCallback=a;this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,
timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}c.orthoMatrix=function(a,b){return[2/a,0,0,0,0,-(2/b),0,0,0,0,-2,0,-1,1,-1,1]};c.seriesPointCount=function(a){if(a.boosted){var h=!!a.options.stacking;var b=a.xData||a.options.xData||a.processedXData;h=(h?a.data:b||a.options.data).length;"treemap"===a.type?h*=12:"heatmap"===a.type?h*=6:F[a.type]&&(h*=2);return h}return 0};c.prototype.getPixelRatio=function(){return this.settings.pixelRatio||b.devicePixelRatio||
1};c.prototype.setOptions=function(a){"pixelRatio"in a||(a.pixelRatio=1);C(!0,this.settings,a)};c.prototype.allocateBuffer=function(a){var h=this.vbuffer,b=0;this.settings.usePreallocated&&(a.series.forEach(function(a){a.boosted&&(b+=c.seriesPointCount(a))}),h&&h.allocate(b))};c.prototype.allocateBufferForSingleSeries=function(a){var h=this.vbuffer,b=0;this.settings.usePreallocated&&(a.boosted&&(b=c.seriesPointCount(a)),h&&h.allocate(b))};c.prototype.clear=function(){var a=this.gl;a&&a.clear(a.COLOR_BUFFER_BIT|
a.DEPTH_BUFFER_BIT)};c.prototype.pushSeriesData=function(a,b){var h=this,c=this.data,g=this.settings,e=this.vbuffer,l=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),p=a.chart,q=a.options,O=!!q.stacking,da=q.data,d=a.xAxis.getExtremes(),R=d.min,f=d.max;d=a.yAxis.getExtremes();var m=d.min,n=d.max,t=a.xData||q.xData||a.processedXData,H=a.yData||q.yData||a.processedYData,I=a.zData||q.zData||a.processedZData,C=a.yAxis,K=a.xAxis,w=!t||0===t.length,G=q.connectNulls;d=a.points||!1;var E=O?a.data:
t||da,k={x:Number.MAX_VALUE,y:0},z={x:-Number.MAX_VALUE,y:0},ya="undefined"===typeof p.index,Aa=F[a.type],Ba=q.zoneAxis||"y",Y=q.zones||!1,T=q.threshold,Z=this.getPixelRatio(),ra=a.chart.plotWidth,ea=!1,fa=!1,W,S,Q=0,sa=!1,A,v,D,ha,x=-1,P=!1,U=!1,N,ta=!1,ma=!1,y=!1,ua=!1,va=!0,na=!0,L=!1,M=!1,aa=0;if(!(q.boostData&&0<q.boostData.length)){q.gapSize&&(M="value"!==q.gapUnit?q.gapSize*a.closestPointRange:q.gapSize);if(Y){var ba=[];Y.forEach(function(a,b){if(a.color){var k=B(a.color).rgba;k[0]/=255;k[1]/=
255;k[2]/=255;ba[b]=k;L||"undefined"!==typeof a.value||(L=k)}});L||(t=a.pointAttribs&&a.pointAttribs().fill||a.color,L=B(t).rgba,L[0]/=255,L[1]/=255,L[2]/=255)}p.inverted&&(ra=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;var ia=function(a){a&&(b.colorData.push(a[0]),b.colorData.push(a[1]),b.colorData.push(a[2]),b.colorData.push(a[3]))},V=function(a,k,z,l,h){void 0===l&&(l=1);ia(h);1===Z||g.useGPUTranslations&&!b.skipTranslation||(a*=Z,k*=Z,l*=Z);g.usePreallocated&&e?(e.push(a,k,z?1:
0,l),aa+=4):(c.push(a),c.push(k),c.push(z?Z:0),c.push(l))},Ea=function(){b.segments.length&&(b.segments[b.segments.length-1].to=c.length||aa)},za=function(){b.segments.length&&b.segments[b.segments.length-1].from===(c.length||aa)||(Ea(),b.segments.push({from:c.length||aa}))},Fa=function(a,k,b,e,l){ia(l);V(a+b,k);ia(l);V(a,k);ia(l);V(a,k+e);ia(l);V(a,k+e);ia(l);V(a+b,k+e);ia(l);V(a+b,k)};za();if(d&&0<d.length)b.skipTranslation=!0,b.drawMode="TRIANGLES",d[0].node&&d[0].node.levelDynamic&&d.sort(function(a,
k){if(a.node){if(a.node.levelDynamic>k.node.levelDynamic)return 1;if(a.node.levelDynamic<k.node.levelDynamic)return-1}return 0}),d.forEach(function(k){var b=k.plotY;if("undefined"!==typeof b&&!isNaN(b)&&null!==k.y&&k.shapeArgs){var e=k.shapeArgs;b=e.x;b=void 0===b?0:b;var l=e.y;l=void 0===l?0:l;var z=e.width;z=void 0===z?0:z;e=e.height;e=void 0===e?0:e;var h=p.styledMode?k.series.colorAttribs(k):h=k.series.pointAttribs(k);k=h["stroke-width"]||0;y=B(h.fill).rgba;y[0]/=255;y[1]/=255;y[2]/=255;a.is("treemap")&&
(k=k||1,S=B(h.stroke).rgba,S[0]/=255,S[1]/=255,S[2]/=255,Fa(b,l,z,e,S),k/=2);a.is("heatmap")&&p.inverted&&(b=K.len-b,l=C.len-l,z=-z,e=-e);Fa(b+k,l+k,z-2*k,e-2*k,y)}});else{for(d=function(){D=E[++x];if("undefined"===typeof D)return"continue";if(ya)return"break";var e=da&&da[x];!w&&u(e,!0)&&e.color&&(y=B(e.color).rgba,y[0]/=255,y[1]/=255,y[2]/=255);w?(A=D[0],v=D[1],E[x+1]&&(U=E[x+1][0]),E[x-1]&&(P=E[x-1][0]),3<=D.length&&(ha=D[2],D[2]>b.zMax&&(b.zMax=D[2]),D[2]<b.zMin&&(b.zMin=D[2]))):(A=D,v=H[x],E[x+
1]&&(U=E[x+1]),E[x-1]&&(P=E[x-1]),I&&I.length&&(ha=I[x],I[x]>b.zMax&&(b.zMax=I[x]),I[x]<b.zMin&&(b.zMin=I[x])));if(!G&&(null===A||null===v))return za(),"continue";U&&U>=R&&U<=f&&(ta=!0);P&&P>=R&&P<=f&&(ma=!0);l?(w&&(v=D.slice(1,3)),N=v[0],v=v[1]):O&&(A=D.x,v=D.stackY,N=v-D.y);null!==m&&"undefined"!==typeof m&&null!==n&&"undefined"!==typeof n&&(va=v>=m&&v<=n);A>f&&z.x<f&&(z.x=A,z.y=v);A<R&&k.x>R&&(k.x=A,k.y=v);if(null===v&&G)return"continue";if(null===v||!va&&!ta&&!ma)return za(),"continue";(U>=R||
A>=R)&&(P<=f||A<=f)&&(ua=!0);if(!ua&&!ta&&!ma)return"continue";M&&A-P>M&&za();if(Y){var h;Y.some(function(a,k){var b=Y[k-1];return"x"===Ba?"undefined"!==typeof a.value&&A<=a.value?(ba[k]&&(!b||A>=b.value)&&(h=ba[k]),!0):!1:"undefined"!==typeof a.value&&v<=a.value?(ba[k]&&(!b||v>=b.value)&&(h=ba[k]),!0):!1});y=h||L||y}if(!g.useGPUTranslations&&(b.skipTranslation=!0,A=K.toPixels(A,!0),v=C.toPixels(v,!0),A>ra&&"POINTS"===b.drawMode))return"continue";b.hasMarkers&&ua&&!1!==ea&&(a.closestPointRangePx=
Math.min(a.closestPointRangePx,Math.abs(A-ea)));if(!g.useGPUTranslations&&!g.usePreallocated&&ea&&1>Math.abs(A-ea)&&fa&&1>Math.abs(v-fa))return g.debug.showSkipSummary&&++Q,"continue";if(Aa){W=N;if(!1===N||"undefined"===typeof N)W=0>v?v:0;l||O||(W=Math.max(null===T?m:T,m));g.useGPUTranslations||(W=C.toPixels(W,!0));V(A,W,0,0,y)}q.step&&!na&&V(A,fa,0,2,y);V(A,v,0,"bubble"===a.type?ha||1:2,y);ea=A;fa=v;sa=!0;na=!1};x<E.length-1&&"break"!==d(););g.debug.showSkipSummary&&console.log("skipped points:",
Q);d=function(a,k){g.useGPUTranslations||(b.skipTranslation=!0,a.x=K.toPixels(a.x,!0),a.y=C.toPixels(a.y,!0));k?h.data=[a.x,a.y,0,2].concat(h.data):V(a.x,a.y,0,2)};sa||!1===G||"line_strip"!==a.drawMode||(k.x<Number.MAX_VALUE&&d(k,!0),z.x>-Number.MAX_VALUE&&d(z))}Ea()}};c.prototype.pushSeries=function(a){var b=this.markerData,h=this.series,c=this.settings;0<h.length&&h[h.length-1].hasMarkers&&(h[h.length-1].markerTo=b.length);c.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");
b={segments:[],markerFrom:b.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:n[a.type]||"LINE_STRIP"};a.index>=h.length?h.push(b):h[a.index]=b;this.pushSeriesData(a,b);c.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")};c.prototype.flush=function(){var a=this.vbuffer;this.data=[];this.markerData=[];this.series=[];a&&a.destroy()};c.prototype.setXAxis=function(a){var b=
this.shader;if(b){var h=this.getPixelRatio();b.setUniform("xAxisTrans",a.transA*h);b.setUniform("xAxisMin",a.min);b.setUniform("xAxisMinPad",a.minPixelPadding*h);b.setUniform("xAxisPointRange",a.pointRange);b.setUniform("xAxisLen",a.len*h);b.setUniform("xAxisPos",a.pos*h);b.setUniform("xAxisCVSCoord",!a.horiz);b.setUniform("xAxisIsLog",!!a.logarithmic);b.setUniform("xAxisReversed",!!a.reversed)}};c.prototype.setYAxis=function(a){var b=this.shader;if(b){var c=this.getPixelRatio();b.setUniform("yAxisTrans",
a.transA*c);b.setUniform("yAxisMin",a.min);b.setUniform("yAxisMinPad",a.minPixelPadding*c);b.setUniform("yAxisPointRange",a.pointRange);b.setUniform("yAxisLen",a.len*c);b.setUniform("yAxisPos",a.pos*c);b.setUniform("yAxisCVSCoord",!a.horiz);b.setUniform("yAxisIsLog",!!a.logarithmic);b.setUniform("yAxisReversed",!!a.reversed)}};c.prototype.setThreshold=function(a,b){var c=this.shader;c&&(c.setUniform("hasThreshold",a),c.setUniform("translatedThreshold",b))};c.prototype.renderChart=function(b){var h=
this,r=this.gl,m=this.settings,n=this.shader,e=this.vbuffer,l=this.getPixelRatio();if(b)this.width=b.chartWidth*l,this.height=b.chartHeight*l;else return!1;var p=this.height,q=this.width;if(!(r&&n&&q&&p))return!1;m.debug.timeRendering&&console.time("gl rendering");r.canvas.width=q;r.canvas.height=p;n.bind();r.viewport(0,0,q,p);n.setPMatrix(c.orthoMatrix(q,p));1<m.lineWidth&&!f.isMS&&r.lineWidth(m.lineWidth);e&&(e.build(this.data,"aVertexPosition",4),e.bind());n.setInverted(b.inverted);this.series.forEach(function(c,
q){var d=c.series.options,f=d.marker,p="undefined"!==typeof d.lineWidth?d.lineWidth:1,O=d.threshold,t=H(O),C=c.series.yAxis.getThreshold(O);O=Q(d.marker?d.marker.enabled:null,c.series.xAxis.isRadial?!0:null,c.series.closestPointRangePx>2*((d.marker?d.marker.radius:10)||10));f=h.textureHandles[f&&f.symbol||c.series.symbol]||h.textureHandles.circle;if(0!==c.segments.length&&c.segments[0].from!==c.segments[0].to&&(f.isReady&&(r.bindTexture(r.TEXTURE_2D,f.handle),n.setTexture(f.handle)),b.styledMode?
f=c.series.markerGroup&&c.series.markerGroup.getStyle("fill"):(f="POINTS"===c.drawMode&&c.series.pointAttribs&&c.series.pointAttribs().fill||c.series.color,d.colorByPoint&&(f=c.series.chart.options.colors[q])),c.series.fillOpacity&&d.fillOpacity&&(f=(new a(f)).setOpacity(Q(d.fillOpacity,1)).get()),f=B(f).rgba,m.useAlpha||(f[3]=1),"LINES"===c.drawMode&&m.useAlpha&&1>f[3]&&(f[3]/=10),"add"===d.boostBlending?(r.blendFunc(r.SRC_ALPHA,r.ONE),r.blendEquation(r.FUNC_ADD)):"mult"===d.boostBlending||"multiply"===
d.boostBlending?r.blendFunc(r.DST_COLOR,r.ZERO):"darken"===d.boostBlending?(r.blendFunc(r.ONE,r.ONE),r.blendEquation(r.FUNC_MIN)):r.blendFuncSeparate(r.SRC_ALPHA,r.ONE_MINUS_SRC_ALPHA,r.ONE,r.ONE_MINUS_SRC_ALPHA),n.reset(),0<c.colorData.length?(n.setUniform("hasColor",1),q=new g(r,n),q.build(c.colorData,"aColor",4),q.bind()):r.disableVertexAttribArray(r.getAttribLocation(n.getProgram(),"aColor")),n.setColor(f),h.setXAxis(c.series.xAxis),h.setYAxis(c.series.yAxis),h.setThreshold(t,C),"POINTS"===c.drawMode&&
n.setPointSize(2*Q(d.marker&&d.marker.radius,.5)*l),n.setSkipTranslation(c.skipTranslation),"bubble"===c.series.type&&n.setBubbleUniforms(c.series,c.zMin,c.zMax,l),n.setDrawAsCircle(ca[c.series.type]||!1),e)){if(0<p||"LINE_STRIP"!==c.drawMode)for(p=0;p<c.segments.length;p++)e.render(c.segments[p].from,c.segments[p].to,c.drawMode);if(c.hasMarkers&&O)for(n.setPointSize(2*Q(d.marker&&d.marker.radius,5)*l),n.setDrawAsCircle(!0),p=0;p<c.segments.length;p++)e.render(c.segments[p].from,c.segments[p].to,
"POINTS")}});m.debug.timeRendering&&console.timeEnd("gl rendering");this.postRenderCallback&&this.postRenderCallback(this);this.flush()};c.prototype.render=function(a){var b=this;this.clear();if(a.renderer.forExport)return this.renderChart(a);this.isInited?this.renderChart(a):setTimeout(function(){b.render(a)},1)};c.prototype.setSize=function(a,b){var f=this.shader;!f||this.width===a&&this.height===b||(this.width=a,this.height=b,f.bind(),f.setPMatrix(c.orthoMatrix(a,b)))};c.prototype.init=function(a,
b){var c=this,f=this.settings;this.isInited=!1;if(!a)return!1;f.debug.timeSetup&&console.time("gl setup");for(var h=0;h<G.length&&!(this.gl=a.getContext(G[h],{}));++h);var e=this.gl;if(e)b||this.flush();else return!1;e.enable(e.BLEND);e.blendFunc(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA);e.disable(e.DEPTH_TEST);e.depthFunc(e.LESS);a=this.shader=new t(e);if(!a)return!1;this.vbuffer=new g(e,a);a=function(a,b){var l={isReady:!1,texture:m.createElement("canvas"),handle:e.createTexture()},f=l.texture.getContext("2d");
c.textureHandles[a]=l;l.texture.width=512;l.texture.height=512;f.mozImageSmoothingEnabled=!1;f.webkitImageSmoothingEnabled=!1;f.msImageSmoothingEnabled=!1;f.imageSmoothingEnabled=!1;f.strokeStyle="rgba(255, 255, 255, 0)";f.fillStyle="#FFF";b(f);try{e.activeTexture(e.TEXTURE0),e.bindTexture(e.TEXTURE_2D,l.handle),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,l.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),
e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.bindTexture(e.TEXTURE_2D,null),l.isReady=!0}catch(ka){}};a("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});a("square",function(a){a.fillRect(0,0,512,512)});a("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});a("triangle",function(a){a.beginPath();a.moveTo(0,
512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});a("triangle-down",function(a){a.beginPath();a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,0);a.lineTo(0,0);a.fill()});this.isInited=!0;f.debug.timeSetup&&console.timeEnd("gl setup");return!0};c.prototype.destroy=function(){var a=this.gl,b=this.shader,c=this.vbuffer;this.flush();c&&c.destroy();b&&b.destroy();a&&(X(this.textureHandles,function(b){b.handle&&a.deleteTexture(b.handle)}),a.canvas.width=1,a.canvas.height=1)};return c}()});
u(a,"Extensions/Boost/BoostSeries.js",[a["Extensions/Boost/BoostableMap.js"],a["Extensions/Boost/Boostables.js"],a["Extensions/Boost/BoostChart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLRenderer.js"]],function(a,f,c,n,t,g,B){function m(a,b){var k=b.boost;a&&k&&k.target&&k.canvas&&!q(b.chart)&&a.allocateBufferForSingleSeries(b)}function b(a){return Da(a&&a.options&&a.options.boost&&a.options.boost.enabled,!0)}function H(a,b){var k=a.constructor,e=
a.seriesGroup||b.group,c=a.chartWidth,z=a.chartHeight,f=a,l="undefined"!==typeof SVGForeignObjectElement;f=q(a)?a:b;var d=f.boost=f.boost||{};l=!1;E||(E=ka.createElement("canvas"));d.target||(d.canvas=E,a.renderer.forExport||!l?(f.renderTarget=d.target=a.renderer.image("",0,0,c,z).addClass("highcharts-boost-canvas").add(e),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize();
d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=a.renderer.createElement("foreignObject").add(e),f.renderTarget=d.target=ka.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height;d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){c=a.chartWidth;z=a.chartHeight;(d.targetFo||
d.target).attr({x:0,y:0,width:c,height:z}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});f instanceof k&&f.boost.markerGroup.translate(a.plotLeft,a.plotTop)},d.clipRect=a.renderer.clipRect(),(d.targetFo||d.target).clip(d.clipRect),f instanceof k&&(f.boost.markerGroup=f.renderer.g().add(e).translate(b.xAxis.pos,b.yAxis.pos)));d.canvas.width=c;d.canvas.height=z;d.clipRect&&d.clipRect.attr(p(a,f));d.resize();d.clear();d.wgl||(d.wgl=new B(function(a){a.settings.debug.timeBufferCopy&&console.time("buffer copy");
d.copy();a.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||Ca("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(a.options.boost||{}),f instanceof k&&d.wgl.allocateBuffer(a));d.wgl.setSize(c,z);return d.wgl}function u(a){var b=a.points;if(b){var k=void 0,e=void 0;for(e=0;e<b.length;e+=1)(k=b[e])&&k.destroyElements&&k.destroyElements()}["graph","area","tracker"].forEach(function(b){var k=a[b];k&&(a[b]=k.destroy())});a.getZonesGraphs&&a.getZonesGraphs([["graph",
"highcharts-graph"]]).forEach(function(b){var k=a[b[0]];k&&(a[b[0]]=k.destroy())})}function C(a,b,e,c,d,f){d=d||0;c=c||3E3;for(var k=d+c,l=!0;l&&d<k&&d<a.length;)l=b(a[d],d),++d;l&&(d<a.length?f?C(a,b,e,c,d,f):R.requestAnimationFrame?R.requestAnimationFrame(function(){C(a,b,e,c,d)}):setTimeout(C,0,a,b,e,c,d):e&&e())}function X(a){a.boost=a.boost||{getPoint:function(b){return h(a,b)}};var b=a.boost.altered=[];["allowDG","directTouch","stickyTracking"].forEach(function(e){b.push({prop:e,val:a[e],own:Object.hasOwnProperty.call(a,
e)})});a.allowDG=!1;a.directTouch=!1;a.stickyTracking=!0;a.finishedAnimating=!0;a.labelBySeries&&(a.labelBySeries=a.labelBySeries.destroy())}function Q(a){var b=a.boost;b&&((b.altered||[]).forEach(function(b){b.own?a[b.prop]=b.val:delete a[b.prop]}),b.clear&&b.clear())}function F(a,b){var e=a.options,c=a.xAxis&&a.xAxis.options,d=a.yAxis&&a.yAxis.options;a=a.colorAxis&&a.colorAxis.options;return e.data.length>(e.boostThreshold||Number.MAX_VALUE)&&I(d.min)&&I(d.max)&&(!b||I(c.min)&&I(c.max))&&(!a||
I(a.min)&&I(a.max))}function ca(){var a=this,b=a.chart;b.boost&&b.boost.markerGroup===a.markerGroup&&(a.markerGroup=null);b.hoverPoints&&(b.hoverPoints=b.hoverPoints.filter(function(b){return b.series===a}));b.hoverPoint&&b.hoverPoint.series===a&&(b.hoverPoint=null)}function G(){var a=this.boost;a&&a.canvas&&a.target&&(a.wgl&&a.wgl.clear(),a.clear&&a.clear())}function wa(a){var b=a.boost;b&&b.canvas&&b.target&&b.wgl&&!q(a.chart)&&b.wgl.render(a.chart)}function h(a,b){var e=a.options,c=a.xAxis,d=a.pointClass;
if(b instanceof d)return b;e=a.xData||e.xData||a.processedXData||!1;d=(new d).init(a,a.options.data[b.i],e?e[b.i]:void 0);d.category=Da(c.categories?c.categories[d.x]:d.x,d.x);d.dist=b.dist;d.distX=b.distX;d.plotX=b.plotX;d.plotY=b.plotY;d.index=b.i;d.percentage=b.percentage;d.isInside=a.isPointInside(d);return d}function da(){function a(a,b){var e="undefined"===typeof c.index,d=!1,k=!0;if("undefined"===typeof a)return!0;if(!e){if(ka){var g=a[0];var h=a[1]}else g=a,h=p[b];if(D)ka&&(h=a.slice(1,3)),
d=h[0],h=h[1];else if(B){g=a.x;h=a.stackY;d=h-a.y;var q=a.percentage}I||(k=(h||0)>=r&&h<=t);if(null!==h&&g>=O&&g<=R&&k)if(a=f.toPixels(g,!0),A){if("undefined"===typeof G||a===F){D||(d=h);if("undefined"===typeof L||h>K)K=h,L=b;if("undefined"===typeof G||d<la)la=d,G=b}E&&a===F||("undefined"!==typeof G&&(h=l.toPixels(K,!0),y=l.toPixels(la,!0),aa(a,h,L,q),y!==h&&aa(a,y,G,q)),G=L=void 0,F=a)}else h=Math.ceil(l.toPixels(h,!0)),aa(a,h,b,q)}return!e}var b=this,e=this.options||{},c=this.chart,f=this.xAxis,
l=this.yAxis,g=e.xData||this.processedXData,p=e.yData||this.processedYData,h=e.data,n=f.getExtremes(),O=n.min,R=n.max;n=l.getExtremes();var r=n.min,t=n.max,w={},A=!!this.sampling,v=!1!==e.enableMouseTracking;n=e.threshold;var D=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),B=!!e.stacking,x=this.cropStart||0,I=this.requireSorting,ka=!g,E="x"===e.findNearestPointBy,J=this.xData||this.options.xData||this.processedXData||!1;e=!1;var F,y=l.getThreshold(n),la,K,G,L;e=H(c,this);c.boosted=
!0;if(this.visible){(this.points||this.graph)&&u(this);q(c)?(this.markerGroup&&this.markerGroup!==c.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=c.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(c.boost&&this.markerGroup===c.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,c.seriesGroup));var M=this.points=[],aa=function(a,b,e,d){a=Math.ceil(a);qa=E?a:a+","+
b;v&&!w[qa]&&(w[qa]=!0,c.inverted&&(a=f.len-a,b=l.len-b),M.push({x:J?J[x+e]:!1,clientX:a,plotX:a,plotY:b,i:x+e,percentage:d}))};this.buildKDTree=d;e&&(m(e,this),e.pushSeries(this),wa(this));var ba=e.settings;e=function(){oa(b,"renderedCanvas");delete b.buildKDTree;b.buildKDTree();ba.debug.timeKDTree&&console.timeEnd("kd tree building")};c.renderer.forExport||(ba.debug.timeKDTree&&console.time("kd tree building"),C(B?this.data:g||h,a,e))}}function r(a){var b=!0;this.chart.options&&this.chart.options.boost&&
(b="undefined"===typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!b||!this.boosted)return a.call(this);this.chart.boosted=!0;if(a=H(this.chart,this))m(a,this),a.pushSeries(this);wa(this)}function ja(e,d,c){function f(e){var d=this.options.stacking&&("translate"===c||"generatePoints"===c);this.boosted&&!d&&b(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&a[this.type]&&0!==this.options.boostThreshold?"render"===c&&this.renderCanvas&&this.renderCanvas():e.call(this)}
K(e,c,f);"translate"===c&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(a){d[a]&&K(d[a].prototype,c,f)})}function xa(a){return this.boosted&&F(this)?{}:a.apply(this,[].slice.call(arguments,1))}function e(e){var d=this,c=this.options.data,f=function(a){return d.forceCrop?!1:q(d.chart)||(a?a.length:0)>=(d.options.boostThreshold||Number.MAX_VALUE)};b(this.chart)&&a[this.type]?(f(c)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&F(this,!0)||(e.apply(this,
[].slice.call(arguments,1)),c=this.processedXData),(this.boosted=f(c))?(c=void 0,this.options.data&&this.options.data.length&&(c=this.getFirstValidPoint(this.options.data),I(c)||pa(c)||Ca(12,!1,this.chart)),X(this)):Q(this)):e.apply(this,[].slice.call(arguments,1))}function l(a){var b=a.apply(this,[].slice.call(arguments,1));return this.boost&&b?this.boost.getPoint(b):b}var p=c.getBoostClipRect,q=c.isChartSeriesBoosting,O=n.getOptions,ka=t.doc,d=t.noop,R=t.win,la=g.addEvent,Ca=g.error,J=g.extend,
oa=g.fireEvent,pa=g.isArray,I=g.isNumber,Da=g.pick,K=g.wrap,w=[],qa,E;return{compose:function(a,b,c){if(-1===w.indexOf(a)){w.push(a);la(a,"destroy",ca);la(a,"hide",G);var d=a.prototype;c&&(d.renderCanvas=da);K(d,"getExtremes",xa);K(d,"processData",e);K(d,"searchPoint",l);["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(a){return ja(d,b,a)})}if(-1===w.indexOf(O)){w.push(O);var k=O().plotOptions;f.forEach(function(a){var e=k[a];e&&(e.boostThreshold=5E3,e.boostData=
[],b[a].prototype.fillOpacity=!0)})}if(c){var g=b.area,h=b.areaspline,p=b.bubble;c=b.column;var q=b.heatmap,n=b.scatter,m=b.treemap;g&&-1===w.indexOf(g)&&(w.push(g),J(g.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));h&&-1===w.indexOf(h)&&(w.push(h),J(h.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));p&&-1===w.indexOf(p)&&(w.push(p),g=p.prototype,delete g.buildKDTree,K(g,"markerAttribs",function(a){return this.boosted?!1:a.apply(this,[].slice.call(arguments,1))}));c&&-1===w.indexOf(c)&&(w.push(c),
J(c.prototype,{fill:!0,sampling:!0}));n&&-1===w.indexOf(n)&&(w.push(n),n.prototype.fill=!0);[q,m].forEach(function(a){a&&-1===w.indexOf(a)&&(w.push(a),K(a.prototype,"drawPoints",r))})}return a},destroyGraphics:u,getPoint:h}});u(a,"Extensions/BoostCanvas.js",[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,f,
c,n,t,g,B,m){var b=a.getBoostClipRect,u=a.isChartSeriesBoosting,H=f.destroyGraphics,C=n.parse,X=t.doc,Q=t.noop,F=B.seriesTypes,ca=m.addEvent,G=m.extend,wa=m.fireEvent,h=m.isNumber,da=m.merge,r=m.pick,ja=m.wrap,xa;return function(){t.seriesTypes.heatmap&&ja(t.seriesTypes.heatmap.prototype,"drawPoints",function(){var a=this.chart,b=this.getContext(),c=this.chart.inverted,f=this.xAxis,g=this.yAxis;b?(this.points.forEach(function(e){var d=e.plotY;if("undefined"!==typeof d&&!isNaN(d)&&null!==e.y&&b){var l=
e.shapeArgs||{};d=l.x;d=void 0===d?0:d;var h=l.y;h=void 0===h?0:h;var p=l.width;p=void 0===p?0:p;l=l.height;l=void 0===l?0:l;e=a.styledMode?e.series.colorAttribs(e):e.series.pointAttribs(e);b.fillStyle=e.fill;c?b.fillRect(g.len-h+f.left,f.len-d+g.top,-l,-p):b.fillRect(d+f.left,h+g.top,p,l)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")});G(g.prototype,{getContext:function(){var a=this.chart,c=u(a)?a:this,f=c===a?a.seriesGroup:
a.seriesGroup||this.group,g=a.chartWidth,h=a.chartHeight,n=function(a,b,e,c,d,f,l){a.call(this,e,b,c,d,f,l)},d=c.boost=c.boost||{};var m=d.targetCtx;d.canvas||(d.canvas=X.createElement("canvas"),d.target=a.renderer.image("",0,0,g,h).addClass("highcharts-boost-canvas").add(f),m=d.targetCtx=d.canvas.getContext("2d"),a.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(a){ja(m,a,n)}),d.copy=function(){d.target.attr({href:d.canvas.toDataURL("image/png")})},d.clear=function(){m.clearRect(0,0,
d.canvas.width,d.canvas.height);c===d.target&&d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.clipRect=a.renderer.clipRect(),d.target.clip(d.clipRect));d.canvas.width!==g&&(d.canvas.width=g);d.canvas.height!==h&&(d.canvas.height=h);d.target.attr({x:0,y:0,width:g,height:h,style:"pointer-events: none",href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});
d.clipRect&&d.clipRect.attr(b(a,c));return m},canvasToSVG:function(){u(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()},cvsLineTo:function(a,b,c){a.lineTo(b,c)},renderCanvas:function(){var a=this,b=a.options,c=a.chart,f=this.xAxis,g=this.yAxis,B=(c.options.boost||{}).timeRendering||!1,d=0,u=a.processedXData,F=a.processedYData,X=b.data,J=f.getExtremes(),oa=J.min,pa=J.max;J=g.getExtremes();
var I=J.min,ja=J.max,K={},w,qa=!!a.sampling,E=b.marker&&b.marker.radius,k=this.cvsDrawPoint,z=b.lineWidth?this.cvsLineTo:void 0,ya=E&&1>=E?this.cvsMarkerSquare:this.cvsMarkerCircle,Aa=this.cvsStrokeBatch||1E3,Ba=!1!==b.enableMouseTracking,Y;J=b.threshold;var T=g.getThreshold(J),Z=h(J),ra=T,ea=this.fill,fa=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),W=!!b.stacking,S=a.cropStart||0;J=c.options.loading;var Ga=a.requireSorting,sa,A=b.connectNulls,v=!u,D,ha,x,P,U,N=W?a.data:u||X,ta=a.fillOpacity?
n.parse(a.color).setOpacity(r(b.fillOpacity,.75)).get():a.color,ma=function(){ea?(M.fillStyle=ta,M.fill()):(M.strokeStyle=a.color,M.lineWidth=b.lineWidth,M.stroke())},y=function(b,e,f,g){0===d&&(M.beginPath(),z&&(M.lineJoin="round"));c.scroller&&"highcharts-navigator-series"===a.options.className?(e+=c.scroller.top,f&&(f+=c.scroller.top)):e+=c.plotTop;b+=c.plotLeft;sa?M.moveTo(b,e):k?k(M,b,e,f,Y):z?z(M,b,e):ya&&ya.call(a,M,b,e,E,g);d+=1;d===Aa&&(ma(),d=0);Y={clientX:b,plotY:e,yBottom:f}},ua="x"===
b.findNearestPointBy,va=this.xData||this.options.xData||this.processedXData||!1,na=function(a,b,d){U=ua?a:a+","+b;Ba&&!K[U]&&(K[U]=!0,c.inverted&&(a=f.len-a,b=g.len-b),L.push({x:va?va[S+d]:!1,clientX:a,plotX:a,plotY:b,i:S+d}))};u=this.boost||{};u.target&&u.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});(this.points||this.graph)&&H(this);a.plotGroup("group","series",a.visible?"visible":"hidden",b.zIndex,c.seriesGroup);
a.markerGroup=a.group;ca(a,"destroy",function(){a.markerGroup=null});var L=this.points=[];var M=this.getContext();a.buildKDTree=Q;u.clear&&u.clear();this.visible&&(99999<X.length&&(c.options.loading=da(J,{labelStyle:{backgroundColor:C("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),m.clearTimeout(xa),c.showLoading("Drawing..."),c.options.loading=J),B&&console.time("canvas rendering"),t.eachAsync(N,function(b,d){var e=!1,h=!1,l=!1,k=!1,
n="undefined"===typeof c.index,q=!0;if(!n){if(v){var p=b[0];var m=b[1];N[d+1]&&(l=N[d+1][0]);N[d-1]&&(k=N[d-1][0])}else p=b,m=F[d],N[d+1]&&(l=N[d+1]),N[d-1]&&(k=N[d-1]);l&&l>=oa&&l<=pa&&(e=!0);k&&k>=oa&&k<=pa&&(h=!0);if(fa){v&&(m=b.slice(1,3));var r=m[0];m=m[1]}else W&&(p=b.x,m=b.stackY,r=m-b.y);b=null===m;Ga||(q=m>=I&&m<=ja);if(!b&&(p>=oa&&p<=pa&&q||e||h))if(p=Math.round(f.toPixels(p,!0)),qa){if("undefined"===typeof x||p===w){fa||(r=m);if("undefined"===typeof P||m>ha)ha=m,P=d;if("undefined"===typeof x||
r<D)D=r,x=d}p!==w&&("undefined"!==typeof x&&(m=g.toPixels(ha,!0),T=g.toPixels(D,!0),y(p,Z?Math.min(m,ra):m,Z?Math.max(T,ra):T,d),na(p,m,P),T!==m&&na(p,T,x)),x=P=void 0,w=p)}else m=Math.round(g.toPixels(m,!0)),y(p,m,T,d),na(p,m,d);sa=b&&!A;0===d%5E4&&(a.boost&&a.boost.copy?a.boost.copy():a.chart.boost&&a.chart.boost.copy&&a.chart.boost.copy())}return!n},function(){var b=c.loadingDiv,d=c.loadingShown;ma();a.canvasToSVG();B&&console.timeEnd("canvas rendering");wa(a,"renderedCanvas");d&&(G(b.style,{transition:"opacity 250ms",
opacity:0}),c.loadingShown=!1,xa=setTimeout(function(){b.parentNode&&b.parentNode.removeChild(b);c.loadingDiv=c.loadingSpan=null},250));delete a.buildKDTree;a.buildKDTree()},c.renderer.forExport?Number.MAX_VALUE:void 0))}});F.scatter.prototype.cvsMarkerCircle=function(a,b,c,f){a.moveTo(b,c);a.arc(b,c,f,0,2*Math.PI,!1)};F.scatter.prototype.cvsMarkerSquare=function(a,b,c,f){a.rect(b-f,c-f,2*f,2*f)};F.scatter.prototype.fill=!0;F.bubble&&(F.bubble.prototype.cvsMarkerCircle=function(a,b,c,f,g){a.moveTo(b,
c);a.arc(b,c,this.radii&&this.radii[g],0,2*Math.PI,!1)},F.bubble.prototype.cvsStrokeBatch=1);G(F.area.prototype,{cvsDrawPoint:function(a,b,c,f,g){g&&b!==g.clientX&&(a.moveTo(g.clientX,g.yBottom),a.lineTo(g.clientX,g.plotY),a.lineTo(b,c),a.lineTo(b,f))},fill:!0,fillOpacity:!0,sampling:!0});G(F.column.prototype,{cvsDrawPoint:function(a,b,c,f){a.rect(b-1,c,1,f-c)},fill:!0,sampling:!0});c.prototype.callbacks.push(function(a){ca(a,"predraw",function(){var a=this.boost||{};a.target&&a.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});
a.canvas&&a.canvas.getContext("2d").clearRect(0,0,a.canvas.width,a.canvas.height)});ca(a,"render",function(){a.boost&&a.boost.copy&&a.boost.copy()})})}});u(a,"masters/modules/boost-canvas.src.js",[],function(){})});
//# sourceMappingURL=boost-canvas.js.map