import random
from curl_cffi.const import CurlWsFlag
from scrapy_cffi.utils import create_uniqueId
from scrapy_cffi.spiders import Spider
from scrapy_cffi.exceptions import Failure
from scrapy_cffi.internet import *
from items.item import CustomItem

class CustomSpider(Spider):
    name = "customSpider"
    robot_scheme = "http"
    allowed_domains = ["api.ipify.org", "127.0.0.1:8002", "localhost:8765"]
    start_urls = ["http://127.0.0.1:8002"]
    count = 0

    async def parse(self, response: HttpResponse):
        self.session_id = create_uniqueId()
        print(response.session_id, response.text)
        yield WebSocketRequest(
            session_id=self.session_id,
            url="ws://localhost:8765",
            headers=self.settings.DEFAULT_HEADERS,
            cookies=self.settings.DEFAULT_COOKIES,
            proxies=self.settings.PROXIES,
            timeout=self.settings.TIMEOUT,
            dont_filter=self.settings.DONT_FILTER,
            callback=self.sec_test, 
            errback=self.errRet,
            send_message=WebSocketMsg(data=f"connect send test".encode('utf-8'), flags=CurlWsFlag.BINARY), # Pydantic v2 models do not support positional initialization for fields, you must always use keywords.
            ping_data=WebSocketMsg(data="ping"),
        )

    async def sec_test(self, response: WebSocketResponse):
        js_res = self.use_execjs(ctx_key="js_action", funcname="count", params=(self.count, random.random()))
        print(f"spider {self.name} callback received：{self.count}")
        if self.count < 3:
            print({"session_id": response.session_id, "data": response.msg[0].decode()})
            yield WebSocketRequest(
                session_id=self.session_id,
                websocket_id=response.websocket_id,
                send_message=WebSocketMsg(data=f"hello：{self.count} -> {js_res}".encode('utf-8'), flags=CurlWsFlag.BINARY)
            )
        elif self.count == 3:
            # scrapy_cffi version >= 0.2.0
            yield CloseSignal(session_id=self.session_id, websocket_end_for_key=response.websocket_id)

            # scrapy_cffi version 0.1.x
            # yield WebSocketRequest(
            #     session_id=self.session_id,
            #     websocket_id=response.websocket_id,
            #     websocket_end=True,
            #     # send_message=f"hello：{self.count} -> {js_res}".encode('utf-8')
            # )
            customItem = CustomItem() or {}
            customItem["session_id"] = response.session_id
            customItem["data"] = response.msg[0].decode()
            yield customItem

            customItem = CustomItem() or {}
            customItem["session_id"] = response.session_id
            # customItem["session_end"] = True # scrapy_cffi version 0.1.x
            customItem["data"] = "spider end"
            yield customItem
            yield CloseSignal(session_id=self.session_id, session_end=True) # # scrapy_cffi version >= 0.2.0
            yield WebSocketRequest(
                session_id=self.session_id,
                websocket_id=response.websocket_id,
                send_message=WebSocketMsg(data=f"retry after send session_end=True：{self.count} -> {js_res}".encode('utf-8'), flags=CurlWsFlag.BINARY)
            )
        self.count += 1

    async def errRet(self, failure: Failure):
        print(f'error output：{str(failure)}')
        yield None