import pandas as pd
import re
import unicodedata
import sys
import os
from termcolor import colored

# Define regex patterns for aesthetic_physician related titles
aesthetic_physician_variants = [
    r"(?i)\bAesthetic\s?Physician\b",
    r"(?i)\bAesthetic\s?Med\s?Physician\b",
    r"(?i)\bAesthetic\s?Practitioner\b",
    r"(?i)\bAesthetic\s?Medicine\s?Physician\b",
    r"(?i)\bAesthetic\s?MD\b",
    r"(?i)\bAesthetic\s?Physician\s?Specialist\b",
    r"(?i)\bAesthetic\s?Doctor\b",
    r"(?i)\bAesthetic\s?Physician\s?Expert\b",
    r"(?i)\bMédico\s?Estético\b",
    r"(?i)\bMédico\s?De\s?Estética\b",
    r"(?i)\bMédico\s?Especialista\s?En\s?Estética\b",
    r"(?i)\bEspecialista\s?En\s?Medicina\s?Estética\b",
    r"(?i)\bMédico\s?En\s?Medicina\s?Estética\b",
    r"(?i)\bAesthetics Medicine\b",
    r"(?i)\bAedthetic Doctor\b",
    r"(?i)\bAesthetic Doktor\b",
    r"(?i)\bAesthetic Injections\b",
    r"(?i)\bAesthetic InjectorOwner\b",
    r"(?i)\bAesthetic Medici E\b",
    r"(?i)\bAesthetic Medicibe\b",
    r"(?i)\bAesthetic MedicineMd\b",
    r"(?i)\bAesthetic Medicines\b",
    r"(?i)\bAesthetic Medicinr\b",
    r"(?i)\bAesthetic Medicinr\b",
    r"(?i)\bAesthetic Phicisian\b",
    r"(?i)\bAesthetic Phisician\b",
    r"(?i)\bAesthetic Physian\b",
    r"(?i)\bAesthetic Physichian\b",
    r"(?i)\bAesthetic Physicians\b",
    r"(?i)\bAesthetic Physiocan\b",
    r"(?i)\bAesthetic Practiocioner\b",
    r"(?i)\bAesthetic Practitionar\b",
    r"(?i)\bAesthetic Practitioners\b",
    r"(?i)\bAesthetic S\b",
    r"(?i)\bAesthetic Specialty\b",
    r"(?i)\bAesthetic Toxins\b",
    r"(?i)\bAesthetical Doctor\b",
    r"(?i)\bAesthetical Medecin\b",
    r"(?i)\bAesthetiv Medicine\b",
    r"(?i)\bAesthitic Physician\b",
    r"(?i)\bAesthteic Docto\b",
    r"(?i)\bAestehtics Physician & Co Found\b",
    r"(?i)\bAestethic Medicine\b",
    r"(?i)\bArathetic Physician\b",
    r"(?i)\bAsthetic Medicine\b",
    r"(?i)\bAsthetic Physician\b",
    r"(?i)\bAsthteics Medicine\b",
    r"(?i)\bMedica Estetica\b",
    r"(?i)\bMedica Esttica No Quirurgica\b",
    r"(?i)\bMedico Estetici\b",
    r"(?i)\bPhysician Aesthetic Medicine\b",
    r"(?i)\bMedical Arsthetics\b",
    r"(?i)\bMsc Aesthetic Medicine\b",
    r"(?i)\bAesthetic Medecine Spec\b",
    r"(?i)\bPhysician  Esthetic Medicine\b",
    r"(?i)\bEsthetic Medecine\b",
    r"(?i)\bAesthethic Medicine\b",
    r"(?i)\bMedicine Aesthetic\b",
    r"(?i)\bEsthetique Medecine\b",
    r"(?i)\bAesthics\b",
    r"(?i)\bAesthetist\b",
    r"(?i)\bMedicina Estetca\b",
    r"(?i)\bEstetik Doktor\b",
    r"(?i)\bEsthetic Medicine\b",
    r"(?i)\bMedical Aesthetic\b",
    r"(?i)\bMedicine Stetic\b",
    r"(?i)\bAesthetic Injectables\b",
    r"(?i)\bAsthetics\b",
    r"(?i)\bMedicin Estetica\b",
    r"(?i)\bEstetica Medica\b",
    r"(?i)\bMedicina Estetica\b",
    r"(?i)\bMedecin Esthetique\b",
    r"(?i)\bMedecine Esthetique\b",
    r"(?i)Harmonizacao Facial",
    r"(?i)\bAesthethic Specialist\b",
    r"(?i)\bSpecialist Of Aesthetic Medicine\b",
    r"(?i)\bAdvanced Facial Aesthetics\b",
    r"(?i)\bAestehtic Specialist\b",
    r"(?i)\bM D AAesthetic Medicine\b",
    r"(?i)\bAeshtetic Medicine Dr\b",
]

# Exact matches that should be updated
aesthetic_physician_exact_matches = {
    'Aesthetic Physician',
    'Aesthetic Medicine Physician',
    'Aesthetic Doctor',
    'Aesthetic MD',
    'Aesthetic Practitioner',
    'Aesthetic Medicine Doctor',
    'Aesthetic Physician Expert',
    'Aesthetic Medicine Specialist',
    'Aesthetic Physician Specialist',
    'Aesthetic Medicine Doctor',
    'Aesthetic Medical Specialist',
    'Aesthetic Medical Doctor',
    'Aesthetic Medicine Expert',
    'Aesthetic Physician Specialist',
    'Aesthetic Physician Expert',
    'Aesthetic Medicine Doctor',
    'Estetica',
    'estetica',
    'Esthetique',
    'esthetique',
    'Medical Aesthetics',
    'medical aesthetics',
    'Medico Estetico',

    # Spanish Titles:
    'Médico Estético',
    'Médico De Estética',
    'Médico Especialista En Estética',  # Spanish: Aesthetic Physician, Aesthetic Doctor
    'Especialista En Medicina Estética',
    'Médico En Medicina Estética',  # Spanish: Specialist in Aesthetic Medicine
    'Doctor Estético',
    'Doctor De Estética',
    'Especialista En Estética',  # Spanish: Aesthetic Doctor, Specialist
    'Médico Estético Clínico',
    'Médico Estético Especialista',  # Spanish: Clinical Aesthetic Physician, Specialist Aesthetic Physician

    # Misspelled Titles (Aesthetic Physician related):
    'Aesthetic Physcian',
    'Aesthetic Pysician',
    'Aestehtic Physician',
    'Aesthetic Phyisician',
    'Aesthetic Physcian',
    'Aesthetich Physician',
    'Aesthic Physician',
    'Esthetic Physician',
    'Aesthetic Phycian',
    'Aestetic Physician',
    'Aesthetic Phrysician',
    'Aesthetic Physican',
    'Aesthetic Phsycian',
    'Aesthetic Physicin',
    'Aesthetic Physicain',

    # Case Mistakes (Captures both upper and lower case versions):
    'Aesthetic physician',
    'aesthetic physician',
    'AESTHETIC PHYSICIAN',
    'AESTHETIC physician',
    'aesthetic Physician',
    'aEsthetic physician',
    'Aesthetic PhysIcian',
    'Aesthetic PhYsician',

    # Common Misspellings:
    'Aesthetic Physican',
    'Aestehtic Doctor',
    'Aesthetic Physicain',
    'Aesthetic Phycian',
    'Aesthetic Medicin Physician',
    'Aesthetic Doctor Medicine',
    'Aestehtic Medical Doctor',
    'Aesthetic Doctor Physican',
    'Aesthetic Medical Practicioner',
    'Aesthetic Medicin Practitioner',
    'Aestethic Physician',
    'Aesthetic Practicioner',

    # Case-related Errors
    'aesthetic Physician',
    'Aesthetic physician',
    'Aesthetic PHYSICIAN',
    'AESTHETIC Physician',
    'aEsthetic PHYSICIAN',
    'aesthetic Physician Expert',
    'aesthetic Physican Expert',
    'Aesthetic physiCian',
    
    # Spanish Variants for Aesthetic Physician:
    'Médico Estético',
    'Médico De Estética',
    'Médico Especialista En Estética',  # Aesthetic Physician
    'Especialista En Medicina Estética Antienvejecimiento',
    'Médico Estético Clínico',  # Clinical Aesthetic Physician
    'Médico Estético Especialista',
    'Doctor Estético',
    'Doctor De Estética',  # Aesthetic Doctor
    'Médico De Estética Avanzada',  # Advanced Aesthetic Physician
    'Médico Estético Experto',  # Expert Aesthetic Physician

    # Doctor Forms:
    'Aesthetic Doctor',
    'Doctor Aesthetic',
    'Doctor of Aesthetic Medicine',
    'Aesthetic Medicine Doctor',
    'Aesthetic Practitioner',

    # Specialist Forms:
    'Aesthetic Specialist',
    'Aesthetic Medicine Specialist',
    'Aesthetic Medicine Expert',
    'Specialist in Aesthetic Medicine',
    'Aesthetic Medicine Expert',
    'Expert Aesthetic Physician',
    'Aesthetic Specialist Physician',
    
    # values from data sources
    'Aesthetic Medicine',
    "Aestetic Medicine",
    "Aesthetic Medcine",
    "Aesthetic Medicne",
    "Aesthic Medicine",
    "Aestetic Medicne",
    "Aesthetic Medecine",
    "Aesthetic Mdicine",
    "Aestheic Medicine",
    "Aethestic Medicine",
    'Aesthetics',
    'Aesthetic',
    'Aesthetics Practitioner',
    'Aesthetics Medicine',
    'Aesthetic Injector',
    'Esthetic',
    'Aesthetics Doctor',
    'Esthetic Doctor',
    'Aesthetic Medine Doctor',
    'Aesthteic Doctor',
    'Facial Injector',
    'Medical DirectorAesthetic Doctor',
    'Medical Estetic Doctor',
    'Physicician Injector',
    'Euaesthetic Director',
    'Minimally Invasive Aesthetics',
    'Aesthetics Md',
    'Osteopath & Medical Aesthetics',
    'Advanced Aesthetics',
    'Aesthetics Medical',
    'Advanced Aesthetics Practitioner',
    'Medical Aesthetics & Bhrt',
    'Med Aesthetics',
    'Chief Injector',
    'Arztin Fur Asthetische Medizin',
    'Aeathetic Doctor',
    'Non Surgical Aesthetics',
    'Medicinal Aesthetics',
    'Evoluzzione',
    'Aestetic Physician Rehabilitation',
    'Osteopathe Esthetique',
    'Diploma Of Non-Surgical Medical Aesthetics',
    'Lifting Threads',
    'Medecin EsthetiqueGeneraliste',
    'Medical Esthetic',
    'Integrative Aesthetics',
    'Esthetic & Famille Doctor',
    'Aesthetic Medical',
    'Easthetic Medicine',
    'Medical Estetik',
    'Physician Injector',
    'Aesthetic Medical Practitioner',
    'Facial Rejuvenation',
    'Aesthetics Physician',
    'Medicio Estetico',
    'Aesthetic Master',
    'Aesthetic Care Specialist',
    'Advanced Aestetic Injector',
    'Advanced aesthetic injector',
    'Doctor - injector',
    'Doctor Asthetic Physcian',
    'Esthetic Injector',
    'Esthetic physician',
    'MEDICO ESTETICO',
    'Medico estetico',
    'CAE LE',
    'Aesthetics Provider',
    'Certified Laser Tech',
    'Certified Laser Tecnician',
    'Esthetique generale',
}

# Define patterns for  Aesthetic & Anti-Aging Physician & Anti Aging Physician & Resident & Professor (these should NOT be changed)
aesthetic_physician_exclusions = {
    'Nurse Aesthetic Practitioner',
    'Aesthetic & Anti-Aging Physician',
    'Aesthetic & AntiAging Physiican',
    'Aesthetic Anti-Aging Physican',
    'Aesthetic Anti Aging Physcian',
    'Aesthetic Anti Aging Pracitioner',
    'Aesthetic Anti-Aging Medical Doctor',
    'Aesthetic AntiAging Medical Dotor',
    'Aesthetic Anti Aging Speciallist',
    'Aesthetic Anti Aging Pracitioner',
    'Aesthetic Anti Aging Practicioner',
    'Aesthetic AntiAging Pracitioner',
    'Aesthetic Antiaging Medical Doctor',
    'Aesthetic AntiAging Surgeion',
    'Aesthetic Anti Aging Medcial Specalist',
    'Aesthetic Anti Aging Physican',
    'Aesthetic Anti-Aging Speciallist',
    'Aesthetic Anti Aging Healthcare Practicioner',
    'Aesthetic AntiAging Specilist',
    'Aesthetic Anti Aging Aesthetician',
    'Aesthetic AntiAging Surgeion',
    'Aesthetic Antiaging Doctor',
    'Aesthetic Antiaging Healthcare Specialist',
    'Aesthetic & Anti-Aging Practicioner',
    'Anti-aging Physician',
    'Anti Aging Physician',
    'anti aging physician',
    'anti-aging physician',
    'Antiaging Physician',
    'AntiAging Physician',
    'antiaging physician',
    'antiAging physician',
    'anti-ageing physician',
    'anti ageeing physician',
    'Anti-Aging Dr.',
    'Anti Aging Dr.',
    'anti-aging dr',
    'anti aging dr',
    'Anti-Aging Specialist',
    'Anti Aging Specialist',
    'anti aging specialist',
    'anti-aging specialist',
    'Anti-aging Practitioner',
    'Anti Aging Practitioner',
    'anti-aging practitioner',
    'anti aging practitioner',
    'Anti-aging Physician Clinic',
    'Anti Aging Physician Clinic',
    'anti-aging physician clinic',
    'anti aging physician clinic',
    'Anti-aging MD',
    'Anti Aging MD',
    'anti-aging md',
    'anti aging md',
    'Anti-Aging Medical Doctor',
    'Anti Aging Medical Doctor',
    'anti-aging medical doctor',
    'anti aging medical doctor',
    'Resident',
    'resident',
    'student',
    'Trainee',
    'Resident Doctor',
    'Resident Physician',
    'Intern',
    'intern',
    'Medical Intern',
    'Fellow',
    'fellow',
    'Clinical Fellow',
    'Medical Student',
    'Clinical Trainee',
    'Trainee Doctor',
    'Trainee Physician',
    'Junior Doctor',
    'Postgraduate Trainee',
    'Aesthetic Fellow',
    'Aesthetic Trainee',
    'Aesthetic Medicine Fellow',
    'Aesthetic Resident',
    'Assistante Medecine Esthetique',
    'Medical Aesthetics Registered Nurse',
    'Aesthetic InjectorOwner',
    'Asistente Medico Estetico',
    'Prof  Esthetic Medicine Dentist',
    'Medical Aesthetic Manager',
    'Dentist Aesthetic Doctor',
    'Dermatologista E Medicina Estetica',
    'Oral Surgeon & Medical Aesthetic Doctor',
    'Gynecology Esthetic Medicine',
    'Dermatologist & Aesthetic Doctor',
    'Pharmacist-Aesthetic Practitioner',
    'Md Dermatology & Asthetics',
    'Oncologist & Medical Aesthetic',
    'Obgy & Asthetic Medicine',
    'Aesthetic Physician Assistant',
    'Medical Aesthetic Designer',
}

# Create a mask for Aesthetic Physician
mask_aesthetic_physician = df['speciality'].str.contains('|'.join(aesthetic_physician_variants), case=False, na=False, regex=True) | \
            df['speciality'].isin(aesthetic_physician_exact_matches)
mask_aesthetic_physician_exclusions = df['speciality'].isin(aesthetic_physician_exclusions)

# Final mask: Select Aesthetic Physician
mask_aesthetic_physician_final = mask_aesthetic_physician & ~mask_aesthetic_physician_exclusions

# Store the original values that will be replaced
original_aesthetic_physician_values = df.loc[mask_aesthetic_physician_final, 'speciality'].unique()

# Update the speciality column based on exact matches
df.loc[mask_aesthetic_physician_final, 'speciality'] = 'Aesthetic Physician'

# Check AFTER updating
print(colored("\nUnique values AFTER updating: Aesthetic Physician", 'green'))
print(df.loc[mask_aesthetic_physician_final, 'speciality'].unique())

# GroupBy to count how many records were replaced by the new value
grouped_aesthetic_physician_values = df.loc[mask_aesthetic_physician_final, 'speciality'].value_counts()

# Print the exact replacements
print(colored("\nReplaced Values: Aesthetic Physician", "cyan"))
for original_aesthetic_physician_value in original_aesthetic_physician_values:
    print(f"✅ {original_aesthetic_physician_value} → Aesthetic Physician")

# GroupBy after replacement (to show the new value)
print(colored("\nGroupBy counts AFTER replacing with Aesthetic Physician:", 'red'))
print(grouped_aesthetic_physician_values)

# Print summary
matched_count_aesthetic_physician = mask_aesthetic_physician_final.sum()

# Print results
print(colored(f"\nTotal values matched and changed (Stage 1) to Aesthetic Physician: {matched_count_aesthetic_physician}", 'red'))