"""
AUTO-GENERATED BY Testing Kit v1

Routine tests for optics builder helpers and OpticalPopulation.
"""
import pytest
import numpy as np

from pyparticle import AerosolSpecies
from pyparticle.optics.builder import build_optical_particle, build_optical_population
from pyparticle.population.base import ParticlePopulation


def make_minimal_population():
    # minimal population must include H2O species for many optics helpers
    spec_so4 = AerosolSpecies('SO4')
    spec_h2o = AerosolSpecies('H2O')
    # create a tiny population object directly with masses for SO4 and H2O
    pop = ParticlePopulation(species=(spec_so4, spec_h2o), spec_masses=np.array([[1.0, 0.0]]), num_concs=np.array([1.0]), ids=[0])
    return pop


def test_build_optical_particle_missing_type_raises():
    from pyparticle.aerosol_particle import Particle
    base_particle = make_minimal_population().get_particle(0)
    with pytest.raises(ValueError):
        build_optical_particle(base_particle, {})


def test_build_optical_population_happy_path():
    pop = make_minimal_population()
    cfg = {'type': 'homogeneous', 'wvl_grid': [550e-9], 'rh_grid': [0.0]}
    # May raise if underlying morphology cannot be discovered; ensure errors are explicit
    optical_pop = build_optical_population(pop, cfg)
    assert hasattr(optical_pop, 'get_optical_coeff')
