# Network Security Audit Framework

A cross-platform security auditing framework that performs automated security assessments on Unix/Linux and Windows systems. The framework detects security vulnerabilities, automatically remediates them, and generates structured JSON reports with detailed findings.

## Features

- **Cross-Platform Support**: Works on Unix/Linux and Windows environments
- **Automated Detection & Remediation**: Automatically detects and fixes security vulnerabilities
- **Structured Reporting**: JSON-formatted reports with MITRE ATT&CK TTPs
- **Backup System**: Automatic backup creation before any modifications
- **Extensible**: Easy to add new security checks

## Installation

### Install via pip (Recommended)

**Install directly from Git repository:**
```bash
pip install git+https://github.com/katerpii/OS-audit-tool.git
```

**Install from local source:**
```bash
git clone https://github.com/katerpii/OS-audit-tool.git
cd network_security
pip install .
```

**Development mode installation (changes take effect immediately):**
```bash
pip install -e .
```

### Manual Installation (without pip)

```bash
git clone https://github.com/katerpii/OS-audit-tool.git
cd network_security
```

## Usage

### After pip installation

Run full audit:
```bash
network-security-audit
```

### Manual execution (without pip installation)

```bash
python3 run.py
```

### Run specific checks on Unix/Linux

```bash
cd network_security/unix
source ./includes/functions.sh
U-37  # Apache AllowOverride AuthConfig check
U-39  # Apache FollowSymLinks check
```

## Output Locations

### For installed package

Logs and reports are created in the installed package directory:
```bash
# Check installation location
python3 -c "import network_security; print(network_security.__file__)"

# Typical locations:
# ~/.local/lib/python3.x/site-packages/network_security/
# /usr/local/lib/python3.x/site-packages/network_security/
```

Output files:
- **Unix/Linux logs**: `network_security/unix/logs/U-XX.log`
- **Unix/Linux reports**: `network_security/unix/reports/U-XX.json`
- **Windows reports**: `network_security/windows/reports/`

### For manual execution

- **Unix/Linux logs**: `network_security/unix/logs/`
- **Unix/Linux reports**: `network_security/unix/reports/`
- **Windows reports**: `network_security/windows/reports/`

## Current Security Checks

### Unix/Linux
- **U-37**: Apache `AllowOverride AuthConfig` restriction (prevents directory traversal via `.htaccess`)
- **U-39**: Apache `FollowSymLinks` restriction (prevents symbolic link exploitation)

### Windows
- Coming soon

## System Requirements

- **Python**: 3.7 or higher
- **Unix/Linux**: bash, zsh, or sh shell
- **Windows**: PowerShell
- **Permissions**: Some checks and remediation require administrator/root privileges

## Testing in VM

### PowerShell (Windows VM)

0. **One-liner for Python install(Powershell) for Windows Server 2019**
```powershell
Invoke-WebRequest -Uri https://www.python.org/ftp/python/3.12.5/python-3.12.5-amd64.exe -OutFile python-installer.exe; Start-Process .\python-installer.exe -ArgumentList "/quiet InstallAllUsers=1 PrependPath=1 Include_pip=1" -Wait

```

1. **If Python is installed:**
```powershell
# Install directly from PyPI
pip install network-security-audit

# Run
network-security-audit
```

2. **Without Python, download directly:**
```powershell
# Clone repository
git clone https://github.com/katerpii/OS-audit-tool.git
cd network_security

# After installing Python
python run.py
```

### Linux VM

```bash
# After SSH to VM
pip install git+https://github.com/katerpii/OS-audit-tool.git

# Run
network-security-audit
```

## Uninstallation

```bash
pip uninstall network-security-audit
```

## Development

To add new security checks, refer to the "Adding New Security Checks" section in `CLAUDE.md`.

## License

MIT License

## Contributing

Issues and pull requests are welcome.
