"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AliasedPortMutatingHook = exports.AliasedPortExtension = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const extension_interfaces_1 = require("./extension-interfaces");
class AliasedPortExtension extends extension_interfaces_1.ServiceExtension {
    constructor(props) {
        super('aliasedPort');
        this.aliasPort = props.aliasPort;
        this.alias = props.alias;
        this.appProtocol = props.appProtocol;
    }
    prehook(service, scope) {
        this.parentService = service;
        this.scope = scope;
        // If there isn't a default cloudmap namespace on the cluster, create a private HTTP namespace for SC.
        if (!this.parentService.cluster.defaultCloudMapNamespace) {
            this.parentService.environment.addDefaultCloudMapNamespace({
                name: this.parentService.environment.id,
            });
        }
        this.namespace = this.parentService.environment.cluster.defaultCloudMapNamespace?.namespaceName;
    }
    addHooks() {
        const containerextension = this.parentService.serviceDescription.get('service-container');
        if (!containerextension) {
            throw new Error('Aliased Port extension requires a Container extension to already exist.');
        }
        containerextension.addContainerMutatingHook(new AliasedPortMutatingHook({
            portMappingName: this.alias,
            aliasPort: containerextension.trafficPort,
            protocol: this.appProtocol,
        }));
    }
    modifyServiceProps(props) {
        if (props.serviceConnectConfiguration && props.serviceConnectConfiguration.namespace !== this.namespace) {
            throw new Error('Service connect cannot be enabled with two different namespaces.');
        }
        const containerextension = this.parentService.serviceDescription.get('service-container');
        if (!containerextension.container) {
            throw new Error('Parent service must have a container to enable an Aliased Port Extension.');
        }
        if (!containerextension.trafficPort && !this.aliasPort) {
            throw new Error('Cannot infer port: container has no traffic port and aliasPort was not specified.');
        }
        // If there is already a service connect config, we need to modify the existing properties instead of creating new ones.
        // Push a new service to the list of services.
        let services = [];
        if (props.serviceConnectConfiguration) {
            services = props.serviceConnectConfiguration.services ? props.serviceConnectConfiguration.services : [];
        }
        services.push({
            portMappingName: this.alias,
            port: this.aliasPort || containerextension.trafficPort,
            dnsName: this.alias,
        });
        if (!this.parentService.cluster.defaultCloudMapNamespace) {
            throw new Error('Cluster must have a default CloudMap namespace.');
        }
        if (!props.serviceConnectConfiguration) {
            return {
                ...props,
                serviceConnectConfiguration: {
                    namespace: this.parentService.cluster.defaultCloudMapNamespace.namespaceName,
                    services,
                },
            };
        }
        return {
            ...props,
            serviceConnectConfiguration: {
                ...props.serviceConnectConfiguration,
                services,
            },
        };
    }
}
exports.AliasedPortExtension = AliasedPortExtension;
_a = JSII_RTTI_SYMBOL_1;
AliasedPortExtension[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.AliasedPortExtension", version: "2.0.1-alpha.218" };
/**
 * This hook modifies the application container's settings so that
 * its primary port mapping has a name.
 */
class AliasedPortMutatingHook extends extension_interfaces_1.ContainerMutatingHook {
    constructor(props) {
        super();
        this.portMappingName = props.portMappingName;
        this.aliasPort = props.aliasPort;
        this.portMappingProtocol = props.protocol;
    }
    mutateContainerDefinition(props) {
        return {
            ...props,
            portMappings: [
                {
                    containerPort: this.aliasPort,
                    name: this.portMappingName,
                    appProtocol: this.portMappingProtocol,
                },
            ],
        };
    }
}
exports.AliasedPortMutatingHook = AliasedPortMutatingHook;
_b = JSII_RTTI_SYMBOL_1;
AliasedPortMutatingHook[_b] = { fqn: "@aws-cdk-containers/ecs-service-extensions.AliasedPortMutatingHook", version: "2.0.1-alpha.218" };
//# sourceMappingURL=data:application/json;base64,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