"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudwatchAgentExtension = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ecs = require("aws-cdk-lib/aws-ecs");
const iam = require("aws-cdk-lib/aws-iam");
const extension_interfaces_1 = require("./extension-interfaces");
const CLOUDWATCH_AGENT_IMAGE = 'amazon/cloudwatch-agent:latest';
/**
 * This extension adds a CloudWatch agent to the task definition and
 * configures the task to be able to publish metrics to CloudWatch.
 */
class CloudwatchAgentExtension extends extension_interfaces_1.ServiceExtension {
    constructor() {
        super('cloudwatchAgent');
        this.CW_CONFIG_CONTENT = {
            logs: {
                metrics_collected: {
                    emf: {},
                },
            },
            metrics: {
                metrics_collected: {
                    statsd: {},
                },
            },
        };
    }
    prehook(service, scope) {
        this.parentService = service;
        this.scope = scope;
    }
    useTaskDefinition(taskDefinition) {
        // Add the CloudWatch Agent to this task
        this.container = taskDefinition.addContainer('cloudwatch-agent', {
            image: ecs.ContainerImage.fromRegistry(CLOUDWATCH_AGENT_IMAGE),
            environment: {
                CW_CONFIG_CONTENT: JSON.stringify(this.CW_CONFIG_CONTENT),
            },
            logging: new ecs.AwsLogDriver({ streamPrefix: 'cloudwatch-agent' }),
            user: '0:1338',
            memoryReservationMiB: 50,
        });
        // Add permissions that allow the cloudwatch agent to publish metrics
        new iam.Policy(this.scope, `${this.parentService.id}-publish-metrics`, {
            roles: [taskDefinition.taskRole],
            statements: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: ['cloudwatch:PutMetricData'],
                }),
            ],
        });
    }
    resolveContainerDependencies() {
        if (!this.container) {
            throw new Error('The container dependency hook was called before the container was created');
        }
        const appmeshextension = this.parentService.serviceDescription.get('appmesh');
        if (appmeshextension && appmeshextension.container) {
            this.container.addContainerDependencies({
                container: appmeshextension.container,
                condition: ecs.ContainerDependencyCondition.HEALTHY,
            });
        }
    }
}
exports.CloudwatchAgentExtension = CloudwatchAgentExtension;
_a = JSII_RTTI_SYMBOL_1;
CloudwatchAgentExtension[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.CloudwatchAgentExtension", version: "2.0.1-alpha.218" };
//# sourceMappingURL=data:application/json;base64,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