# coding: utf-8

"""
    Aignostics Platform API reference

     Pagination is done via `page` and `page_size`. Sorting via `sort` query parameter. The `sort` query parameter can be provided multiple times. The sorting direction can be indicated via `+` (ascending) or `-` (descending) (e.g. `/v1/applications?sort=+name)`.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OrganizationReadResponse(BaseModel):
    """
    This model corresponds to the response schema returned from Auth0 GET /v2/organizations/{id} endpoint, flattens out the metadata out and doesn't return branding or token_quota objects. For details, see: https://auth0.com/docs/api/management/v2/organizations/get-organizations-by-id
    """ # noqa: E501
    id: StrictStr
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    aignostics_bucket_hmac_access_key_id: StrictStr
    aignostics_bucket_hmac_secret_access_key: StrictStr
    aignostics_bucket_name: StrictStr
    aignostics_bucket_protocol: StrictStr
    aignostics_logfire_token: StrictStr
    aignostics_sentry_dsn: StrictStr
    __properties: ClassVar[List[str]] = ["id", "name", "display_name", "aignostics_bucket_hmac_access_key_id", "aignostics_bucket_hmac_secret_access_key", "aignostics_bucket_name", "aignostics_bucket_protocol", "aignostics_logfire_token", "aignostics_sentry_dsn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "aignostics_bucket_hmac_access_key_id": obj.get("aignostics_bucket_hmac_access_key_id"),
            "aignostics_bucket_hmac_secret_access_key": obj.get("aignostics_bucket_hmac_secret_access_key"),
            "aignostics_bucket_name": obj.get("aignostics_bucket_name"),
            "aignostics_bucket_protocol": obj.get("aignostics_bucket_protocol"),
            "aignostics_logfire_token": obj.get("aignostics_logfire_token"),
            "aignostics_sentry_dsn": obj.get("aignostics_sentry_dsn")
        })
        return _obj
