# coding: utf-8

"""
    Aignostics Platform API reference

     Pagination is done via `page` and `page_size`. Sorting via `sort` query parameter. The `sort` query parameter can be provided multiple times. The sorting direction can be indicated via `+` (ascending) or `-` (descending) (e.g. `/v1/applications?sort=+name)`.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aignx.codegen.models.application_run_status import ApplicationRunStatus
from aignx.codegen.models.user_payload import UserPayload
from typing import Optional, Set
from typing_extensions import Self

class RunReadResponse(BaseModel):
    """
    RunReadResponse
    """ # noqa: E501
    application_run_id: StrictStr = Field(description="UUID of the application")
    application_version_id: StrictStr = Field(description="ID of the application version")
    organization_id: StrictStr = Field(description="Organization of the owner of the application run")
    user_payload: Optional[UserPayload] = None
    status: ApplicationRunStatus = Field(description=" When the application run request is received by the Platform, the `status` of it is set to `received`. Then it is transitioned to `scheduled`, when it is scheduled for the processing. When the application run is scheduled, it will process the input items and generate the result incrementally. As soon as the first result is generated, the state is changed to `running`. The results can be downloaded via `/v1/runs/{run_id}/results` endpoint. When all items are processed and all results are generated, the application status is set to `completed`. If the processing is done, but some items fail, the status is set to `completed_with_error`.  When the application run request is rejected by the Platform before scheduling, it is transferred to `rejected`. When the application run reaches the threshold of number of failed items, the whole application run is set to `canceled_system` and the remaining pending items are not processed. When the application run fails, the finished item results are available for download.  If the application run is canceled by calling `POST /v1/runs/{run_id}/cancel` endpoint, the processing of the items is stopped, and the application status is set to `cancelled_user`     ")
    triggered_at: datetime = Field(description="Timestamp showing when the application run was triggered")
    triggered_by: StrictStr = Field(description="Id of the user who triggered the application run")
    __properties: ClassVar[List[str]] = ["application_run_id", "application_version_id", "organization_id", "user_payload", "status", "triggered_at", "triggered_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user_payload
        if self.user_payload:
            _dict['user_payload'] = self.user_payload.to_dict()
        # set to None if user_payload (nullable) is None
        # and model_fields_set contains the field
        if self.user_payload is None and "user_payload" in self.model_fields_set:
            _dict['user_payload'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "application_run_id": obj.get("application_run_id"),
            "application_version_id": obj.get("application_version_id"),
            "organization_id": obj.get("organization_id"),
            "user_payload": UserPayload.from_dict(obj["user_payload"]) if obj.get("user_payload") is not None else None,
            "status": obj.get("status"),
            "triggered_at": obj.get("triggered_at"),
            "triggered_by": obj.get("triggered_by")
        })
        return _obj
