import os

from PIL import Image
import pytesseract

def captcha_number(img, tesseract_path=None, save_debug=False, debug_dir="captcha_debug"):
    """
    识别图片中的数字（支持 PIL.Image.Image 或文件路径）

    :param img: PIL.Image.Image 对象或图片路径
    :param tesseract_path: Tesseract 可执行文件路径
    :param save_debug: 是否保存调试图片
    :param debug_dir: 调试图片保存目录
    :return: 识别出的数字字符串
    """
    if isinstance(img, str):
        img = Image.open(img)

    if tesseract_path:
        pytesseract.pytesseract.tesseract_cmd = tesseract_path

    if save_debug:
        if not os.path.exists(debug_dir):
            os.makedirs(debug_dir)
        debug_path = os.path.join(debug_dir, "debug_image.png")
        img.save(debug_path)
        print(f"调试图片已保存: {debug_path}")

    text = pytesseract.image_to_string(
        img, config="--psm 7 -c tessedit_char_whitelist=0123456789"
    ).strip()
    return text