from setuptools import setup, find_packages
import pathlib

here = pathlib.Path(__file__).parent.resolve()

# 读取 README.md 作为 long_description
long_description = (here / "README.md").read_text(encoding="utf-8")

setup(
    name="captcha_number",  # pip 包名
    version="0.1.1",
    packages=find_packages(),  # 自动寻找包
    python_requires=">=3.8",
    install_requires=[
        "Pillow>=10.0.0",
        "pytesseract>=0.3.10"
    ],
    author="MiChen",
    author_email="rmcyyds@gmail.com",
    description="Recognize numbers from images (captcha and others) using Tesseract OCR",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/captcha-number",  # 仓库地址
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    include_package_data=True,
)
