# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SubscriptionInfo(UniversalBaseModel):
    """
    Subscription information response.
    """

    plan: str = pydantic.Field()
    """
    Current billing plan
    """

    status: str = pydantic.Field()
    """
    Subscription status
    """

    trial_ends_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Trial end date
    """

    grace_period_ends_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Grace period end date
    """

    current_period_start: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Current billing period start
    """

    current_period_end: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Current billing period end
    """

    cancel_at_period_end: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether subscription will cancel at period end
    """

    limits: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Plan limits
    """

    is_oss: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether using OSS version
    """

    has_active_subscription: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether has active Stripe subscription
    """

    in_trial: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether currently in trial period
    """

    in_grace_period: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether currently in grace period
    """

    payment_method_added: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether payment method is added
    """

    requires_payment_method: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether payment method is required now
    """

    pending_plan_change: typing.Optional[str] = pydantic.Field(default=None)
    """
    Plan that will take effect at period end
    """

    pending_plan_change_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the pending plan change takes effect
    """

    has_yearly_prepay: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether organization has an active yearly prepay credit
    """

    yearly_prepay_started_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When yearly prepay was started
    """

    yearly_prepay_expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When yearly prepay expires
    """

    yearly_prepay_amount_cents: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total amount (in cents) credited for yearly prepay
    """

    yearly_prepay_coupon_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Coupon ID used for yearly prepay
    """

    yearly_prepay_payment_intent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Payment intent ID used for yearly prepay
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
