# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .billing_period_usage import BillingPeriodUsage
from .usage_trend import UsageTrend


class UsageDashboard(UniversalBaseModel):
    """
    Complete dashboard data.
    """

    current_period: BillingPeriodUsage = pydantic.Field()
    """
    Current billing period usage
    """

    previous_periods: typing.Optional[typing.List[BillingPeriodUsage]] = pydantic.Field(default=None)
    """
    Historical billing periods
    """

    total_entities_all_time: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total entities processed all time
    """

    total_queries_all_time: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total queries executed all time
    """

    average_daily_entities: typing.Optional[int] = pydantic.Field(default=None)
    """
    Average entities per day (current period)
    """

    average_daily_queries: typing.Optional[int] = pydantic.Field(default=None)
    """
    Average queries per day (current period)
    """

    trends: typing.Optional[typing.List[UsageTrend]] = pydantic.Field(default=None)
    """
    Usage trends compared to previous period
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
