# mypy-boto3-codestar-connections

[![PyPI - mypy-boto3-codestar-connections](https://img.shields.io/pypi/v/mypy-boto3-codestar-connections.svg?color=blue)](https://pypi.org/project/mypy-boto3-codestar-connections)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codestar-connections.svg?color=blue)](https://pypi.org/project/mypy-boto3-codestar-connections)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CodeStarconnections 1.15.16](https://boto3.amazonaws.com/v1/documentation/api/1.15.16/reference/services/codestar-connections.html#CodeStarconnections) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-codestar-connections](#mypy-boto3-codestar-connections)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CodeStarconnections` service.

```bash
python -m pip install boto3-stubs[codestar-connections]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codestar-connections]` in your environment: `python -m pip install 'boto3-stubs[codestar-connections]'`

Both type checking and auto-complete should work for `CodeStarconnections` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[codestar-connections]` in your environment: `python -m pip install 'boto3-stubs[codestar-connections]'`

Both type checking and auto-complete should work for `CodeStarconnections` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codestar-connections]` in your environment: `python -m pip install 'boto3-stubs[codestar-connections]'`
- Run `mypy` as usual

Type checking should work for `CodeStarconnections` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codestar-connections]` in your environment: `python -m pip install 'boto3-stubs[codestar-connections]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeStarconnections` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CodeStarconnectionsClient` provides annotations for `boto3.client("codestar-connections")`.

```python
import boto3

from mypy_boto3_codestar_connections import CodeStarconnectionsClient

client: CodeStarconnectionsClient = boto3.client("codestar-connections")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeStarconnectionsClient = session.client("codestar-connections")
```








### Typed dictionations

`mypy_boto3_codestar_connections.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_codestar_connections.type_defs import (
    ConnectionTypeDef,
    CreateConnectionOutputTypeDef,
    CreateHostOutputTypeDef,
    GetConnectionOutputTypeDef,
    GetHostOutputTypeDef,
    HostTypeDef,
    ListConnectionsOutputTypeDef,
    ListHostsOutputTypeDef,
    ListTagsForResourceOutputTypeDef,
    ResponseMetadata,
    TagTypeDef,
    VpcConfigurationTypeDef,
)

def get_structure() -> ConnectionTypeDef:
    return {
      ...
    }
```
