# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [0.1.5] - 2025-10-25

### Added
- **Agentic RAG Pipeline**: Iterative query generation and retrieval with LLM-based evaluation
  - `AgenticQueryPipeline` with support for multi-iteration search
  - Automatic query generation using OpenAI (or custom LLM providers)
  - Source evaluation to determine when sufficient information is retrieved
  - Parallel query execution for improved performance
- **Keyword Search Support**: Full-text search alongside semantic vector search
  - `BaseKeywordStore` abstract interface
  - `QdrantKeywordStore` implementation using Qdrant's full-text search
  - `SupabaseKeywordStore` implementation using PostgreSQL full-text search
  - Query routing by type: "keyword" vs "semantic"
- **LLM Abstractions**:
  - `BaseLLM` interface for query generation and source evaluation
  - `OpenAILLM` implementation with JSON mode and precise token tracking
  - `LLMUsage` dataclass for accurate token counting
- **Enhanced Configuration**:
  - `max_queries_per_iter` parameter for controlling query volume
  - `keyword_limit` parameter for keyword search results
  - `include_query_results` flag for debugging query-to-result mappings
  - Optional `supabase` dependency group

### Changed
- Ruff configuration now ignores E501 (line length) for prompt strings and N806 (variable naming) for test mocks

## [0.1.4] - 2025-10-25

### Fixed
- Renamed the reranker provider from "Zerank" (the model name) to "ZeroEntropy" (the company name) throughout the codebase and documentation for consistency.

### Added
- Added support for both list and single-value filters.

## [0.1.3] - 2025-10-11

### Fixed
- **Critical:** QdrantStore now correctly uses UUIDs for point IDs in all modes (in-memory, local, and server)
- Fixed error: "value book_XXX#chunk_X is not a valid point ID" when using Qdrant server mode
- Query results now return original string IDs (e.g., `book_123#chunk_0`) instead of internal UUIDs
- Migrated from deprecated `search()` to modern `query_points()` API
- **CI Build Fix:** Pinned `chromadb<1.1` to avoid dependency resolution failure with non-existent `mdurl==0.1.3`

### Added
- Comprehensive QdrantStore integration tests covering string ID handling, namespaces, and document deletion

## [0.1.2] - 2025-10-10

### Added
- ZeroEntropy Zerank reranker support via `ZerankReranker` class
- New optional dependency group: `zeroentropy`
- Async reranking with graceful fallback to heuristic scoring
- Comprehensive test coverage for Zerank reranker

## [0.1.0] - 2025-10-09

### Added
- Query pipeline with automatic reranking and citation formatting
- Ingestion pipeline for document processing
- Provider-agnostic embedding support (OpenAI, Azure, Cohere, Voyage)
- Vector store integrations (Qdrant, Pinecone, Chroma, Redis)
- Unstructured document chunking via LlamaIndex
- Cohere reranking support
- Async-first API design
- Full type hints and Pydantic validation
- Comprehensive test coverage
- Arabic and multilingual language support

### Documentation
- Overview, quickstart, and provider guides
- Example scripts for common use cases
- API reference documentation

[Unreleased]: https://github.com/nuhatech/maktaba/compare/v0.1.5...HEAD
[0.1.5]: https://github.com/nuhatech/maktaba/compare/v0.1.4...v0.1.5
[0.1.4]: https://github.com/nuhatech/maktaba/compare/v0.1.3...v0.1.4
[0.1.3]: https://github.com/nuhatech/maktaba/compare/v0.1.2...v0.1.3
[0.1.2]: https://github.com/nuhatech/maktaba/compare/v0.1.0...v0.1.2
[0.1.0]: https://github.com/nuhatech/maktaba/releases/tag/v0.1.0
