import * as cloudwatch from "aws-cdk-lib/aws-cloudwatch";
import { Construct } from "constructs";
import { HealthCheckBase, HealthCheckOptions } from "./health-check";
export interface AlarmHealthCheckProps extends HealthCheckOptions {
    /**
     * The alarm that Route53 monitors
     */
    readonly alarm: cloudwatch.IAlarm;
    /**
     * The status to assign to the HealthCheck when CloudWatch has insufficient data about the metric
     */
    readonly insufficientDataHealthStatus?: InsufficientDataHealthStatus;
}
/**
 * Create a Route53 HealthCheck that monitors a CloudWatch Alarm.
 *
 * <b>Example</b>
 * ```typescript
 * const alarm new Alarm(stack, "Alarm", {
 *   // ...
 * });
 * new AlarmHealthCheck(stack, "HealthCheck", {
 *   alarm: alarm,
 * });
 * ```
 * @link https://docs.aws.amazon.com/de_de/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#aws-resource-route53-healthcheck-properties
 *
 * @resource AWS::Route53::HealthCheck
 */
export declare class AlarmHealthCheck extends HealthCheckBase {
    readonly healthCheckId: string;
    constructor(scope: Construct, id: string, props: AlarmHealthCheckProps);
}
export declare enum InsufficientDataHealthStatus {
    /**
     * Route53 considers the health check to be healthy.
     */
    HEALTHY = "Healthy",
    /**
     * Route53 considers the health check to be unhealthy.
     */
    UNHEALTHY = "Unhealthy",
    /**
     * Route53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state, otherwise healthy
     */
    LAST_KNOWN_STATUS = "LastKnownStatus"
}
