import * as cloudwatch from "aws-cdk-lib/aws-cloudwatch";
import { Construct } from "constructs";
import { HealthCheckBase, HealthCheckOptions, IHealthCheck } from "./health-check";
export interface CalculatedHealthCheckProps extends HealthCheckOptions {
    /**
     * The list of HealthCheck that monitors other Route53 HealthChecks.
     */
    readonly childHealthChecks?: IHealthCheck[];
    /**
     * The number of child HealthChecks that Amazon Route53 must consider healthy
     */
    readonly healthThreshold?: number;
}
/**
 * Create a Route53 HealthCheck that monitors other Route53 HealthChecks.
 *
 * <b>Example</b>
 * ```typescript
 * const healthCheck = new EndpointHealthCheck(stack, "HealthCheck", {
 *   domainName: "pepperize.com",
 * });
 * new CalculatedHealthCheck(stack, "CalculatedHealthCheck", {
 *   childHealthChecks: [healthCheck],
 * });
 * ```
 * @link https://docs.aws.amazon.com/de_de/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#aws-resource-route53-healthcheck-properties
 *
 * @resource AWS::Route53::HealthCheck
 */
export declare class CalculatedHealthCheck extends HealthCheckBase {
    readonly healthCheckId: string;
    private childHealthChecks;
    constructor(scope: Construct, id: string, props: CalculatedHealthCheckProps);
    /**
     * The number of ChildHealthChecks that are healthy that Route53 is monitoring.
     *
     * Valid statistics: Average (recommended), Minimum, Maximum
     */
    metricChildHealthCheckHealthyCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    addChildHealthCheck(healthCheck: IHealthCheck): void;
}
