"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const acm = require("aws-cdk-lib/aws-certificatemanager");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const route53 = require("aws-cdk-lib/aws-route53");
const targets = require("aws-cdk-lib/aws-route53-targets");
const endpoint_health_check_1 = require("./endpoint-health-check");
const app = new aws_cdk_lib_1.App();
const shared = new aws_cdk_lib_1.Stack(app, "Shared");
const hostedZone = new route53.PublicHostedZone(shared, "HostedZone", {
    zoneName: "pepperize.com",
});
const primary = new aws_cdk_lib_1.Stack(app, "Primary");
const distribution = cloudfront.Distribution.fromDistributionAttributes(primary, "Distribution", {
    domainName: "pepperize.com",
    distributionId: "d111111abcdef8",
});
const recordSetPrimary = new route53.ARecord(primary, "RecordSetPrimary", {
    recordName: "www.pepperize.com",
    zone: hostedZone,
    target: route53.RecordTarget.fromAlias(new targets.CloudFrontTarget(distribution)),
});
const healthCheckPrimary = new endpoint_health_check_1.EndpointHealthCheck(primary, "HealthCheckPrimary", {
    domainName: "www.pepperize.com",
});
healthCheckPrimary.failoverPrimary(recordSetPrimary);
const secondary = new aws_cdk_lib_1.Stack(app, "Secondary");
const certificate = acm.Certificate.fromCertificateArn(secondary, "Certificate", "arn:aws:acm:region:account:certificate/certificate_ID");
const restApi = new apigateway.RestApi(secondary, "RestApi", {
    domainName: { domainName: "www-1.pepperize.com", certificate: certificate },
});
restApi.root.addResource("{proxy+}", {}).addMethod("ANY");
const recordSetSecondary = new route53.ARecord(secondary, "RecordSetSecondary", {
    recordName: "www-1.pepperize.com",
    zone: hostedZone,
    target: route53.RecordTarget.fromAlias(new targets.ApiGateway(restApi)),
});
const healthCheckSecondary = new endpoint_health_check_1.EndpointHealthCheck(secondary, "HealthCheckSecondary", {
    domainName: "www-1.pepperize.com",
});
healthCheckSecondary.failoverSecondary(recordSetSecondary, true);
app.synth();
//# sourceMappingURL=data:application/json;base64,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