"""Dictionary object to store Protocol Number."""

from typing import Dict

PROTO_NAME_TO_NUM: Dict[str, int] = {
    "HOPOPT": 0,
    "ICMP": 1,
    "IGMP": 2,
    "GGP": 3,
    "IPv4": 4,
    "ST": 5,
    "TCP": 6,
    "CBT": 7,
    "EGP": 8,
    "IGP": 9,
    "BBN-RCC-MON": 10,
    "NVP-II": 11,
    "PUP": 12,
    "ARGUS": 13,
    "EMCON": 14,
    "XNET": 15,
    "CHAOS": 16,
    "UDP": 17,
    "MUX": 18,
    "DCN-MEAS": 19,
    "HMP": 20,
    "PRM": 21,
    "XNS-IDP": 22,
    "TRUNK-1": 23,
    "TRUNK-2": 24,
    "LEAF-1": 25,
    "LEAF-2": 26,
    "RDP": 27,
    "IRTP": 28,
    "ISO-TP4": 29,
    "NETBLT": 30,
    "MFE-NSP": 31,
    "MERIT-INP": 32,
    "DCCP": 33,
    "3PC": 34,
    "IDPR": 35,
    "XTP": 36,
    "DDP": 37,
    "IDPR-CMTP": 38,
    "TP++": 39,
    "IL": 40,
    "IPv6": 41,
    "SDRP": 42,
    "IPv6-Route": 43,
    "IPv6-Frag": 44,
    "IDRP": 45,
    "RSVP": 46,
    "GRE": 47,
    "DSR": 48,
    "BNA": 49,
    "ESP": 50,
    "AH": 51,
    "I-NLSP": 52,
    "SWIPE": 53,
    "NARP": 54,
    "Min-IPv4": 55,
    "TLSP": 56,
    "SKIP": 57,
    "IPv6-ICMP": 58,
    "IPv6-NoNxt": 59,
    "IPv6-Opts": 60,
    "CFTP": 62,
    "SAT-EXPAK": 64,
    "KRYPTOLAN": 65,
    "RVD": 66,
    "IPPC": 67,
    "SAT-MON": 69,
    "VISA": 70,
    "IPCV": 71,
    "CPNX": 72,
    "CPHB": 73,
    "WSN": 74,
    "PVP": 75,
    "BR-SAT-MON": 76,
    "SUN-ND": 77,
    "WB-MON": 78,
    "WB-EXPAK": 79,
    "ISO-IP": 80,
    "VMTP": 81,
    "SECURE-VMTP": 82,
    "VINES": 83,
    "IPTM": 84,
    "NSFNET-IGP": 85,
    "DGP": 86,
    "TCF": 87,
    "EIGRP": 88,
    "OSPFIGP": 89,
    "Sprite-RPC": 90,
    "LARP": 91,
    "MTP": 92,
    "AX.25": 93,
    "IPIP": 94,
    "MICP": 95,
    "SCC-SP": 96,
    "ETHERIP": 97,
    "ENCAP": 98,
    "GMTP": 100,
    "IFMP": 101,
    "PNNI": 102,
    "PIM": 103,
    "ARIS": 104,
    "SCPS": 105,
    "QNX": 106,
    "A/N": 107,
    "IPComp": 108,
    "SNP": 109,
    "Compaq-Peer": 110,
    "IPX-in-IP": 111,
    "VRRP": 112,
    "PGM": 113,
    "L2TP": 115,
    "DDX": 116,
    "IATP": 117,
    "STP": 118,
    "SRP": 119,
    "UTI": 120,
    "SMP": 121,
    "SM": 122,
    "PTP": 123,
    "ISIS over IPv4": 124,
    "FIRE": 125,
    "CRTP": 126,
    "CRUDP": 127,
    "SSCOPMCE": 128,
    "IPLT": 129,
    "SPS": 130,
    "PIPE": 131,
    "SCTP": 132,
    "FC": 133,
    "RSVP-E2E-IGNORE": 134,
    "Mobility Header": 135,
    "UDPLite": 136,
    "MPLS-in-IP": 137,
    "manet": 138,
    "HIP": 139,
    "Shim6": 140,
    "WESP": 141,
    "ROHC": 142,
    "Ethernet": 143,
    "AGGFRAG": 144,
    "NSH": 145,
    "Homa": 146,
    "BIT-EMU": 147,
    "Reserved": 255,
}
PROTO_NUM_TO_NAME: Dict[int, str] = {
    0: "HOPOPT",
    1: "ICMP",
    2: "IGMP",
    3: "GGP",
    4: "IPv4",
    5: "ST",
    6: "TCP",
    7: "CBT",
    8: "EGP",
    9: "IGP",
    10: "BBN-RCC-MON",
    11: "NVP-II",
    12: "PUP",
    13: "ARGUS",
    14: "EMCON",
    15: "XNET",
    16: "CHAOS",
    17: "UDP",
    18: "MUX",
    19: "DCN-MEAS",
    20: "HMP",
    21: "PRM",
    22: "XNS-IDP",
    23: "TRUNK-1",
    24: "TRUNK-2",
    25: "LEAF-1",
    26: "LEAF-2",
    27: "RDP",
    28: "IRTP",
    29: "ISO-TP4",
    30: "NETBLT",
    31: "MFE-NSP",
    32: "MERIT-INP",
    33: "DCCP",
    34: "3PC",
    35: "IDPR",
    36: "XTP",
    37: "DDP",
    38: "IDPR-CMTP",
    39: "TP++",
    40: "IL",
    41: "IPv6",
    42: "SDRP",
    43: "IPv6-Route",
    44: "IPv6-Frag",
    45: "IDRP",
    46: "RSVP",
    47: "GRE",
    48: "DSR",
    49: "BNA",
    50: "ESP",
    51: "AH",
    52: "I-NLSP",
    53: "SWIPE",
    54: "NARP",
    55: "Min-IPv4",
    56: "TLSP",
    57: "SKIP",
    58: "IPv6-ICMP",
    59: "IPv6-NoNxt",
    60: "IPv6-Opts",
    62: "CFTP",
    64: "SAT-EXPAK",
    65: "KRYPTOLAN",
    66: "RVD",
    67: "IPPC",
    69: "SAT-MON",
    70: "VISA",
    71: "IPCV",
    72: "CPNX",
    73: "CPHB",
    74: "WSN",
    75: "PVP",
    76: "BR-SAT-MON",
    77: "SUN-ND",
    78: "WB-MON",
    79: "WB-EXPAK",
    80: "ISO-IP",
    81: "VMTP",
    82: "SECURE-VMTP",
    83: "VINES",
    84: "IPTM",
    85: "NSFNET-IGP",
    86: "DGP",
    87: "TCF",
    88: "EIGRP",
    89: "OSPFIGP",
    90: "Sprite-RPC",
    91: "LARP",
    92: "MTP",
    93: "AX.25",
    94: "IPIP",
    95: "MICP",
    96: "SCC-SP",
    97: "ETHERIP",
    98: "ENCAP",
    100: "GMTP",
    101: "IFMP",
    102: "PNNI",
    103: "PIM",
    104: "ARIS",
    105: "SCPS",
    106: "QNX",
    107: "A/N",
    108: "IPComp",
    109: "SNP",
    110: "Compaq-Peer",
    111: "IPX-in-IP",
    112: "VRRP",
    113: "PGM",
    115: "L2TP",
    116: "DDX",
    117: "IATP",
    118: "STP",
    119: "SRP",
    120: "UTI",
    121: "SMP",
    122: "SM",
    123: "PTP",
    124: "ISIS over IPv4",
    125: "FIRE",
    126: "CRTP",
    127: "CRUDP",
    128: "SSCOPMCE",
    129: "IPLT",
    130: "SPS",
    131: "PIPE",
    132: "SCTP",
    133: "FC",
    134: "RSVP-E2E-IGNORE",
    135: "Mobility Header",
    136: "UDPLite",
    137: "MPLS-in-IP",
    138: "manet",
    139: "HIP",
    140: "Shim6",
    141: "WESP",
    142: "ROHC",
    143: "Ethernet",
    144: "AGGFRAG",
    145: "NSH",
    146: "Homa",
    147: "BIT-EMU",
    255: "Reserved",
}
