# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.11.2863
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid.api_client import ApiClient
from lusid.exceptions import (
    ApiTypeError,
    ApiValueError
)


class LegalEntitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_legal_entity(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Delete Legal Entity  # noqa: E501

        Delete a legal entity. Deletion will be valid from the legal entity's creation datetime.  This means that the legal entity will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_legal_entity(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: The scope of the legal entity identifier type. (required)
        :param str id_type_code: The code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with defined              identifier type uniquely identifies the legal entity to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletedEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_legal_entity_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def delete_legal_entity_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Delete Legal Entity  # noqa: E501

        Delete a legal entity. Deletion will be valid from the legal entity's creation datetime.  This means that the legal entity will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_legal_entity_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: The scope of the legal entity identifier type. (required)
        :param str id_type_code: The code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with defined              identifier type uniquely identifies the legal entity to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_legal_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `delete_legal_entity`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `delete_legal_entity`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `delete_legal_entity`")  # noqa: E501

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `delete_legal_entity`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `delete_legal_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `delete_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `delete_legal_entity`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `delete_legal_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `delete_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_legal_entity`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_legal_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletedEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_legal_entity_access_metadata(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete a Legal Entity Access Metadata entry  # noqa: E501

        Deletes the Legal Entity Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_legal_entity_access_metadata(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletedEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_legal_entity_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, **kwargs)  # noqa: E501

    def delete_legal_entity_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete a Legal Entity Access Metadata entry  # noqa: E501

        Deletes the Legal Entity Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_legal_entity_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'metadata_key', 'effective_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_legal_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `delete_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `delete_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `delete_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if ('metadata_key' not in local_var_params or
                local_var_params['metadata_key'] is None):
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `delete_legal_entity_access_metadata`")  # noqa: E501

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `delete_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `delete_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `delete_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `delete_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `delete_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `delete_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('metadata_key' in local_var_params and
                len(local_var_params['metadata_key']) > 100):
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_legal_entity_access_metadata`, length must be less than or equal to `100`")  # noqa: E501
        if ('metadata_key' in local_var_params and
                len(local_var_params['metadata_key']) < 1):
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletedEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_legal_entity_access_metadata(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Access Metadata rules for a Legal Entity  # noqa: E501

        Pass the Scope and Code of the Legal Entity identifier along with the Legal Entity code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_legal_entity_access_metadata(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, list[AccessMetadataValue])
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_legal_entity_access_metadata_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_all_legal_entity_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Access Metadata rules for a Legal Entity  # noqa: E501

        Pass the Scope and Code of the Legal Entity identifier along with the Legal Entity code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_legal_entity_access_metadata_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, list[AccessMetadataValue]), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'effective_at', 'as_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_legal_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `get_all_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `get_all_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `get_all_legal_entity_access_metadata`")  # noqa: E501

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_all_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_all_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_all_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_all_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_all_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_all_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, list[AccessMetadataValue])',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_legal_entity(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Get Legal Entity  # noqa: E501

        Retrieve the definition of a legal entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the legal entity. (required)
        :param list[str] property_keys: A list of property keys or identifier types (as property keys) from the \"LegalEntity\" domain to include for found legal entity.              These take the format {domain}/{scope}/{code} e.g. \"LegalEntity/ContactDetails/Address\".
        :param str effective_at: The effective datetime or cut label at which to retrieve the legal entity. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the legal entity. Defaults to return the latest version of the legal entity if not specified.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LegalEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_legal_entity_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_legal_entity_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Get Legal Entity  # noqa: E501

        Retrieve the definition of a legal entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the legal entity. (required)
        :param list[str] property_keys: A list of property keys or identifier types (as property keys) from the \"LegalEntity\" domain to include for found legal entity.              These take the format {domain}/{scope}/{code} e.g. \"LegalEntity/ContactDetails/Address\".
        :param str effective_at: The effective datetime or cut label at which to retrieve the legal entity. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the legal entity. Defaults to return the latest version of the legal entity if not specified.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LegalEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'property_keys', 'effective_at', 'as_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_legal_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) > 256):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity`, length must be less than or equal to `256`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) < 0):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity`, length must be greater than or equal to `0`")  # noqa: E501
        if 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'property_keys' in local_var_params:
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LegalEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_legal_entity_access_metadata_by_key(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get an entry identified by a metadataKey in the Access Metadata of a Legal Entity  # noqa: E501

        Get a specific Legal Entity Access Metadata by specifying the corresponding identifier parts and Legal Entity code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_access_metadata_by_key(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AccessMetadataValue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_legal_entity_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, **kwargs)  # noqa: E501

    def get_legal_entity_access_metadata_by_key_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get an entry identified by a metadataKey in the Access Metadata of a Legal Entity  # noqa: E501

        Get a specific Legal Entity Access Metadata by specifying the corresponding identifier parts and Legal Entity code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AccessMetadataValue], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'metadata_key', 'effective_at', 'as_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_legal_entity_access_metadata_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `get_legal_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `get_legal_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `get_legal_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if ('metadata_key' not in local_var_params or
                local_var_params['metadata_key'] is None):
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `get_legal_entity_access_metadata_by_key`")  # noqa: E501

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('metadata_key' in local_var_params and
                len(local_var_params['metadata_key']) > 100):
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_legal_entity_access_metadata_by_key`, length must be less than or equal to `100`")  # noqa: E501
        if ('metadata_key' in local_var_params and
                len(local_var_params['metadata_key']) < 1):
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_legal_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_legal_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AccessMetadataValue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_legal_entity_property_time_series(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Legal Entity Property Time Series  # noqa: E501

        List the complete time series of a legal entity property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_property_time_series(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the legal entity. (required)
        :param str property_key: The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"LegalEntity/ContactDetails/Address\".              Each property must be from the \"LegalEntity\" domain.
        :param datetime as_at: The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.
        :param str filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :param str page: The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.
        :param int limit: When paginating, limit the number of returned results to this many.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceListOfPropertyInterval
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_legal_entity_property_time_series_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_legal_entity_property_time_series_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Legal Entity Property Time Series  # noqa: E501

        List the complete time series of a legal entity property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_property_time_series_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the legal entity. (required)
        :param str property_key: The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"LegalEntity/ContactDetails/Address\".              Each property must be from the \"LegalEntity\" domain.
        :param datetime as_at: The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.
        :param str filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :param str page: The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.
        :param int limit: When paginating, limit the number of returned results to this many.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceListOfPropertyInterval, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'property_key', 'as_at', 'filter', 'page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_legal_entity_property_time_series" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_property_time_series`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_property_time_series`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_property_time_series`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_legal_entity_property_time_series`, must be a value less than or equal to `5000`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_legal_entity_property_time_series`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'property_key' in local_var_params:
            query_params.append(('propertyKey', local_var_params['property_key']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'page' in local_var_params:
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/properties/time-series', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceListOfPropertyInterval',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_legal_entity_relations(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[DEPRECATED] Get Relations for Legal Entity  # noqa: E501

        Get relations for the specified Legal Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_relations(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the legal entity. (required)
        :param str effective_at: The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the legal entity's relations. Defaults to return the latest LUSID AsAt time if not specified.
        :param str filter: Expression to filter the relations. Users should provide null or empty string for this field until further notice.
        :param list[str] identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceListOfRelation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_legal_entity_relations_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_legal_entity_relations_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[DEPRECATED] Get Relations for Legal Entity  # noqa: E501

        Get relations for the specified Legal Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_relations_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the legal entity. (required)
        :param str effective_at: The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the legal entity's relations. Defaults to return the latest LUSID AsAt time if not specified.
        :param str filter: Expression to filter the relations. Users should provide null or empty string for this field until further notice.
        :param list[str] identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceListOfRelation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'effective_at', 'as_at', 'filter', 'identifier_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_legal_entity_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_relations`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_relations`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_relations`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_relations`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_relations`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_relations`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_relations`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_relations`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_relations`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) > 256):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity_relations`, length must be less than or equal to `256`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) < 0):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity_relations`, length must be greater than or equal to `0`")  # noqa: E501
        if 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity_relations`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if ('filter' in local_var_params and
                len(local_var_params['filter']) > 2147483647):
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_legal_entity_relations`, length must be less than or equal to `2147483647`")  # noqa: E501
        if ('filter' in local_var_params and
                len(local_var_params['filter']) < 0):
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_legal_entity_relations`, length must be greater than or equal to `0`")  # noqa: E501
        if 'filter' in local_var_params and not re.search(r'(?s).*', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_legal_entity_relations`, must conform to the pattern `/(?s).*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'identifier_types' in local_var_params:
            query_params.append(('identifierTypes', local_var_params['identifier_types']))  # noqa: E501
            collection_formats['identifierTypes'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/relations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceListOfRelation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_legal_entity_relationships(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Relationships for Legal Entity  # noqa: E501

        Get Relationships for the specified Legal Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_relationships(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity's identifier type. (required)
        :param str id_type_code: Code of the legal entity's identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the legal entity. (required)
        :param str effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :param str filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :param list[str] identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relationships. If not applicable, provide an empty array.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceListOfRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_legal_entity_relationships_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_legal_entity_relationships_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Relationships for Legal Entity  # noqa: E501

        Get Relationships for the specified Legal Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_legal_entity_relationships_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity's identifier type. (required)
        :param str id_type_code: Code of the legal entity's identifier type. (required)
        :param str code: Code of the legal entity under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the legal entity. (required)
        :param str effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :param str filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :param list[str] identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relationships. If not applicable, provide an empty array.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceListOfRelationship, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'effective_at', 'as_at', 'filter', 'identifier_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_legal_entity_relationships" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_legal_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_legal_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_legal_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) > 256):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity_relationships`, length must be less than or equal to `256`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) < 0):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_legal_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if ('filter' in local_var_params and
                len(local_var_params['filter']) > 2147483647):
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_legal_entity_relationships`, length must be less than or equal to `2147483647`")  # noqa: E501
        if ('filter' in local_var_params and
                len(local_var_params['filter']) < 0):
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_legal_entity_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if 'filter' in local_var_params and not re.search(r'(?s).*', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_legal_entity_relationships`, must conform to the pattern `/(?s).*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'identifier_types' in local_var_params:
            query_params.append(('identifierTypes', local_var_params['identifier_types']))  # noqa: E501
            collection_formats['identifierTypes'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/relationships', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceListOfRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_legal_entities(self, id_type_scope, id_type_code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] List Legal Entities  # noqa: E501

        List legal entities which has identifier of specific identifier type's scope and code, and satisfies filter criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_legal_entities(id_type_scope, id_type_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :param str page: The pagination token to use to continue listing legal entities from a previous call to list legal entities. This  value is returned from the previous call. If a pagination token is provided the filter, effectiveAt  and asAt fields must not have changed since the original request.
        :param int limit: When paginating, limit the number of returned results to this many. Defaults to 65,535 if not specified.
        :param str filter: Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :param list[str] property_keys: A list of property keys or identifier types (as property keys) from the \"LegalEntity\" domain to include for each legal entity.              These take the format {domain}/{scope}/{code} e.g. \"LegalEntity/ContactDetails/Address\".
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResourceListOfLegalEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_legal_entities_with_http_info(id_type_scope, id_type_code, **kwargs)  # noqa: E501

    def list_legal_entities_with_http_info(self, id_type_scope, id_type_code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] List Legal Entities  # noqa: E501

        List legal entities which has identifier of specific identifier type's scope and code, and satisfies filter criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_legal_entities_with_http_info(id_type_scope, id_type_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the legal entity identifier type. (required)
        :param str id_type_code: Code of the legal entity identifier type. (required)
        :param str effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :param str page: The pagination token to use to continue listing legal entities from a previous call to list legal entities. This  value is returned from the previous call. If a pagination token is provided the filter, effectiveAt  and asAt fields must not have changed since the original request.
        :param int limit: When paginating, limit the number of returned results to this many. Defaults to 65,535 if not specified.
        :param str filter: Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :param list[str] property_keys: A list of property keys or identifier types (as property keys) from the \"LegalEntity\" domain to include for each legal entity.              These take the format {domain}/{scope}/{code} e.g. \"LegalEntity/ContactDetails/Address\".
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResourceListOfLegalEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'effective_at', 'as_at', 'page', 'limit', 'filter', 'property_keys']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_legal_entities" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `list_legal_entities`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `list_legal_entities`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `list_legal_entities`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `list_legal_entities`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `list_legal_entities`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `list_legal_entities`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) > 256):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `list_legal_entities`, length must be less than or equal to `256`")  # noqa: E501
        if ('effective_at' in local_var_params and
                len(local_var_params['effective_at']) < 0):
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `list_legal_entities`, length must be greater than or equal to `0`")  # noqa: E501
        if 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `list_legal_entities`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if ('page' in local_var_params and
                len(local_var_params['page']) > 500):
            raise ApiValueError("Invalid value for parameter `page` when calling `list_legal_entities`, length must be less than or equal to `500`")  # noqa: E501
        if ('page' in local_var_params and
                len(local_var_params['page']) < 1):
            raise ApiValueError("Invalid value for parameter `page` when calling `list_legal_entities`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_legal_entities`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_legal_entities`, must be a value less than or equal to `5000`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_legal_entities`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('filter' in local_var_params and
                len(local_var_params['filter']) > 2147483647):
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_legal_entities`, length must be less than or equal to `2147483647`")  # noqa: E501
        if ('filter' in local_var_params and
                len(local_var_params['filter']) < 0):
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_legal_entities`, length must be greater than or equal to `0`")  # noqa: E501
        if 'filter' in local_var_params and not re.search(r'(?s).*', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_legal_entities`, must conform to the pattern `/(?s).*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'page' in local_var_params:
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'property_keys' in local_var_params:
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResourceListOfLegalEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_legal_entity(self, upsert_legal_entity_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Upsert Legal Entity  # noqa: E501

        Create or update a legal entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_legal_entity(upsert_legal_entity_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpsertLegalEntityRequest upsert_legal_entity_request: Request to create or update a legal entity. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LegalEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_legal_entity_with_http_info(upsert_legal_entity_request, **kwargs)  # noqa: E501

    def upsert_legal_entity_with_http_info(self, upsert_legal_entity_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Upsert Legal Entity  # noqa: E501

        Create or update a legal entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_legal_entity_with_http_info(upsert_legal_entity_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpsertLegalEntityRequest upsert_legal_entity_request: Request to create or update a legal entity. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LegalEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upsert_legal_entity_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_legal_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upsert_legal_entity_request' is set
        if ('upsert_legal_entity_request' not in local_var_params or
                local_var_params['upsert_legal_entity_request'] is None):
            raise ApiValueError("Missing the required parameter `upsert_legal_entity_request` when calling `upsert_legal_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_legal_entity_request' in local_var_params:
            body_params = local_var_params['upsert_legal_entity_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LegalEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_legal_entity_access_metadata(self, id_type_scope, id_type_code, code, metadata_key, upsert_legal_entity_access_metadata_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Upsert a Legal Entity Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Legal Entity Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Legal Entity Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_legal_entity_access_metadata(id_type_scope, id_type_code, code, metadata_key, upsert_legal_entity_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param UpsertLegalEntityAccessMetadataRequest upsert_legal_entity_access_metadata_request: The Legal Entity Access Metadata entry to upsert (required)
        :param str effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceListOfAccessMetadataValueOf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_legal_entity_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_legal_entity_access_metadata_request, **kwargs)  # noqa: E501

    def upsert_legal_entity_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, upsert_legal_entity_access_metadata_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Upsert a Legal Entity Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Legal Entity Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Legal Entity Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_legal_entity_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_legal_entity_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the Legal Entity identifier. (required)
        :param str id_type_code: Code of the Legal Entity identifier. (required)
        :param str code: Code of the Legal Entity under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param UpsertLegalEntityAccessMetadataRequest upsert_legal_entity_access_metadata_request: The Legal Entity Access Metadata entry to upsert (required)
        :param str effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceListOfAccessMetadataValueOf, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'metadata_key', 'upsert_legal_entity_access_metadata_request', 'effective_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_legal_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `upsert_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `upsert_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `upsert_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if ('metadata_key' not in local_var_params or
                local_var_params['metadata_key'] is None):
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `upsert_legal_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'upsert_legal_entity_access_metadata_request' is set
        if ('upsert_legal_entity_access_metadata_request' not in local_var_params or
                local_var_params['upsert_legal_entity_access_metadata_request'] is None):
            raise ApiValueError("Missing the required parameter `upsert_legal_entity_access_metadata_request` when calling `upsert_legal_entity_access_metadata`")  # noqa: E501

        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `upsert_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_scope' in local_var_params and
                len(local_var_params['id_type_scope']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `upsert_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `upsert_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) > 64):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `upsert_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('id_type_code' in local_var_params and
                len(local_var_params['id_type_code']) < 1):
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `upsert_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `upsert_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_legal_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if ('metadata_key' in local_var_params and
                len(local_var_params['metadata_key']) > 100):
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `upsert_legal_entity_access_metadata`, length must be less than or equal to `100`")  # noqa: E501
        if ('metadata_key' in local_var_params and
                len(local_var_params['metadata_key']) < 1):
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `upsert_legal_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `upsert_legal_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_legal_entity_access_metadata_request' in local_var_params:
            body_params = local_var_params['upsert_legal_entity_access_metadata_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2863'

        return self.api_client.call_api(
            '/api/legalentities/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceListOfAccessMetadataValueOf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
