"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonPackage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const python_1 = require("projen/lib/python");
const codeowners_1 = require("../../components/github/codeowners");
const pull_request_template_1 = require("../../components/github/pull-request-template");
const readme_1 = require("../../components/readme");
const merge_options_1 = require("../../utils/merge-options");
function getOptions(options) {
    const { name } = options;
    const defaults = {
        name,
        pullRequestTemplate: true,
        pullRequestTemplateContents: pull_request_template_1.DEFAULT_PULL_REQUEST_TEMPLATE,
    };
    return (0, merge_options_1.mergeOptions)(defaults, options);
}
/**
 * A Python package
 *
 *
 * @pjid python-package
 */
class PythonPackage extends python_1.PythonProject {
    constructor(options) {
        const mergedOptions = getOptions(options);
        super({
            ...mergedOptions,
        });
        new codeowners_1.CodeOwners(this, mergedOptions.codeOwners);
        if (mergedOptions.pullRequestTemplate ?? true) {
            this.github?.addPullRequestTemplate(...(mergedOptions.pullRequestTemplateContents ?? []));
        }
        this.readme = new readme_1.Readme(this, {
            description: mergedOptions.readme?.description,
        });
        this.readme.addSection('Getting Started', '```sh\nyarn install\nnpx projen build\n```');
    }
}
exports.PythonPackage = PythonPackage;
_a = JSII_RTTI_SYMBOL_1;
PythonPackage[_a] = { fqn: "projen-modules.PythonPackage", version: "1.1.7" };
__exportStar(require("./python-package-options"), exports);
//# sourceMappingURL=data:application/json;base64,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