import { ManagedInstanceRole } from '@renovosolutions/cdk-library-managed-instance-role';
import { aws_ec2 as ec2, aws_iam as iam, aws_route53 as route53 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface InstanceServiceProps {
    /**
     * The type of instance to launch.
     *
     * @stability stable
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * AMI to launch.
     *
     * @stability stable
     */
    readonly machineImage: ec2.IMachineImage;
    /**
     * The name of the service the instance is for.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The VPC to launch the instance in.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * Whether the instance could initiate connections to anywhere by default.
     *
     * @stability stable
     */
    readonly allowAllOutbound?: boolean;
    /**
     * Specifies how block devices are exposed to the instance.
     *
     * You can specify virtual devices and EBS volumes
     *
     * @stability stable
     */
    readonly blockDevices?: ec2.BlockDevice[];
    /**
     * Name of the SSH keypair to grant access to the instance.
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * Defines a private IP address to associate with the instance.
     *
     * @stability stable
     */
    readonly privateIpAddress?: string;
    /**
     * The subnet type to launch this service in.
     *
     * @default ec2.SubnetType.PRIVATE_WITH_NAT
     * @stability stable
     */
    readonly subnetType?: ec2.SubnetType;
    /**
     * Select subnets only in the given AZs.
     *
     * @stability stable
     */
    readonly availabilityZones?: string[];
    /**
     * Whether or not to enable logging to Cloudwatch Logs.
     *
     * @default true
     * @stability stable
     */
    readonly enableCloudwatchLogs?: boolean;
    /**
     * Whether to disable inline ingress and egress rule optimization for the instances security group.
     *
     * If this is set to true, ingress and egress rules will not be declared under the SecurityGroup in cloudformation, but will be separate elements.
     *
     * Inlining rules is an optimization for producing smaller stack templates.
     * Sometimes this is not desirable, for example when security group access is managed via tags.
     *
     * The default value can be overriden globally by setting the context variable '@aws-cdk/aws-ec2.securityGroupDisableInlineRules'.
     *
     * @default false
     * @stability stable
     */
    readonly disableInlineRules?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access to remote management ports: SSH, RDP, WinRM, WinRM over HTTPs.
     *
     * If these ports are opened when this is enabled an error will be added to CDK metadata and deployment and synth will fail.
     *
     * @default true
     * @stability stable
     */
    readonly enableNoRemoteManagementPortsAspect?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access to relational DB ports: MySQL, PostgreSQL, MariaDB, Oracle, SQL Server.
     *
     * If these ports are opened when this is enabled an error will be added to CDK metadata and deployment and synth will fail.
     *
     * @default true
     * @stability stable
     */
    readonly enableNoDBPortsAspect?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access from the public internet: Any rule with a source from 0.0.0.0/0 or ::/0.
     *
     * If these sources are used when this is enabled and error will be added to CDK metadata and deployment and synth will fail.
     *
     * @stability stable
     */
    readonly enabledNoPublicIngressAspect?: boolean;
    /**
     * The parent domain of the service.
     *
     * @stability stable
     */
    readonly parentDomain: string;
}
/**
 * @stability stable
 */
export interface ManagedLoggingPolicyProps {
    /**
     * The OS of the instance this policy is for.
     *
     * @stability stable
     */
    readonly os: string;
}
/**
 * @stability stable
 */
export interface AmiLookup {
    /**
     * The name string to use for AMI lookup.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The owners to use for AMI lookup.
     *
     * @stability stable
     */
    readonly owners?: string[];
    /**
     * Is this AMI expected to be windows?
     *
     * @stability stable
     */
    readonly windows?: boolean;
}
export declare function ec2ImageToOsString(stack: Construct, image: ec2.IMachineImage): string;
/**
 * @stability stable
 */
export declare class ManagedLoggingPolicy extends Construct {
    /**
     * @stability stable
     */
    readonly policy: iam.ManagedPolicy;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ManagedLoggingPolicyProps);
}
/**
 * @stability stable
 */
export declare class InstanceService extends Construct {
    /**
     * The instance profile associated with this instance.
     *
     * @stability stable
     */
    readonly instanceProfile: ManagedInstanceRole;
    /**
     * The security group associated with this instance.
     *
     * @stability stable
     */
    readonly securityGroup: ec2.SecurityGroup;
    /**
     * The underlying instance resource.
     *
     * @stability stable
     */
    readonly instance: ec2.Instance;
    /**
     * The underlying CfnInstance resource.
     *
     * @stability stable
     */
    readonly instanceCfn: ec2.CfnInstance;
    /**
     * The availability zone of the instance.
     *
     * @stability stable
     */
    readonly instanceAvailabilityZone: string;
    /**
     * The instance's ID.
     *
     * @stability stable
     */
    readonly instanceId: string;
    /**
     * Private DNS name for this instance assigned by EC2.
     *
     * @stability stable
     */
    readonly instanceEc2PrivateDnsName: string;
    /**
     * Private IP for this instance.
     *
     * @stability stable
     */
    readonly instancePrivateIp: string;
    /**
     * Public DNS name for this instance assigned by EC2.
     *
     * @stability stable
     */
    readonly instanceEc2PublicDnsName: string;
    /**
     * DNS record for this instance created in Route53.
     *
     * @stability stable
     */
    readonly instanceDnsName: route53.ARecord;
    /**
     * The type of OS the instance is running.
     *
     * @stability stable
     */
    readonly osType: ec2.OperatingSystemType;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: InstanceServiceProps);
}
