"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceService = exports.ManagedLoggingPolicy = exports.ec2ImageToOsString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_aspects_library_security_group_1 = require("@renovosolutions/cdk-aspects-library-security-group");
const cdk_library_managed_instance_role_1 = require("@renovosolutions/cdk-library-managed-instance-role");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function ec2ImageToOsString(stack, image) {
    return aws_cdk_lib_1.aws_ec2.OperatingSystemType[image.getImage(stack).osType].toLowerCase();
}
exports.ec2ImageToOsString = ec2ImageToOsString;
/**
 * @stability stable
 */
class ManagedLoggingPolicy extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (!(props.os.toLowerCase() == 'windows') && !(props.os.toLowerCase() == 'linux')) {
            throw new Error(`The os property for ManagedLoggingPolicy must be windows or linux and you gave: ${props.os.toLowerCase()}`);
        }
        let logResources = [];
        const logGroups = [
            `/${props.os}/logs`,
            `/${props.os}/logs/*`,
        ];
        logGroups.forEach((g) => {
            logResources.push(`arn:aws:logs:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:log-group:${g}`);
        });
        this.policy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'loggingPolicy', {
            description: 'Allow instance to log system logs to Cloudwatch',
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'logs:PutLogEvents',
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                    ],
                    resources: logResources,
                }),
            ],
        });
    }
}
exports.ManagedLoggingPolicy = ManagedLoggingPolicy;
_a = JSII_RTTI_SYMBOL_1;
ManagedLoggingPolicy[_a] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.ManagedLoggingPolicy", version: "2.2.0" };
/**
 * @stability stable
 */
class InstanceService extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f;
        super(scope, id);
        let enableNoRemoteManagementPortsAspect = (_c = props.enableNoRemoteManagementPortsAspect) !== null && _c !== void 0 ? _c : true;
        let enableNoDBPortsAspect = (_d = props.enableNoDBPortsAspect) !== null && _d !== void 0 ? _d : true;
        let enabledNoPublicIngressAspect = (_e = props.enabledNoPublicIngressAspect) !== null && _e !== void 0 ? _e : true;
        if (enableNoRemoteManagementPortsAspect)
            aws_cdk_lib_1.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonManagementPortsAspect());
        if (enableNoDBPortsAspect)
            aws_cdk_lib_1.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonRelationalDBPortsAspect());
        if (enabledNoPublicIngressAspect)
            aws_cdk_lib_1.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoPublicIngressAspect());
        let managedPolicies = [];
        // Logging configuration
        let enableCloudwatchLogs = (props.enableCloudwatchLogs === undefined) ? true : props.enableCloudwatchLogs;
        if (enableCloudwatchLogs) {
            managedPolicies.push(new ManagedLoggingPolicy(this, 'loggingPolicy', {
                os: ec2ImageToOsString(this, props.machineImage),
            }).policy);
        }
        this.instanceProfile = new cdk_library_managed_instance_role_1.ManagedInstanceRole(this, 'instanceRole', {
            domainJoinEnabled: false,
            ssmManagementEnabled: true,
            managedPolicies,
        });
        let allowAllOutbound = (props.allowAllOutbound === undefined) ? true : props.allowAllOutbound;
        let disableInlineRules = (props.disableInlineRules === undefined) ? false : props.disableInlineRules;
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'securityGroup', {
            allowAllOutbound: allowAllOutbound,
            vpc: props.vpc,
            description: `The security group applied to the instance service for ${props.name}`,
            disableInlineRules: disableInlineRules,
        });
        this.instance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'instance', {
            instanceType: props.instanceType,
            machineImage: props.machineImage,
            vpc: props.vpc,
            allowAllOutbound: allowAllOutbound,
            blockDevices: props.blockDevices,
            keyName: props.keyName,
            privateIpAddress: props.privateIpAddress,
            propagateTagsToVolumeOnCreation: true,
            requireImdsv2: true,
            securityGroup: this.securityGroup,
            // userData: props.userData,
            userDataCausesReplacement: false,
            vpcSubnets: {
                subnetType: (_f = props.subnetType) !== null && _f !== void 0 ? _f : aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_NAT,
                onePerAz: true,
                availabilityZones: props.availabilityZones,
            },
        });
        this.instance.instance.addPropertyOverride('IamInstanceProfile', this.instanceProfile.instanceProfile.ref);
        this.instanceCfn = this.instance.instance;
        this.instanceAvailabilityZone = this.instance.instanceAvailabilityZone;
        this.instanceId = this.instance.instanceId;
        this.instanceEc2PrivateDnsName = this.instance.instancePrivateDnsName;
        this.instancePrivateIp = this.instance.instancePrivateIp;
        this.instanceEc2PublicDnsName = this.instance.instancePublicDnsName;
        this.osType = this.instance.osType;
        aws_cdk_lib_1.Tags.of(this.instance.instance).add('Name', props.name + '.' + props.parentDomain);
        this.instanceDnsName = new aws_cdk_lib_1.aws_route53.ARecord(this, 'A', {
            recordName: props.name + '.' + props.parentDomain,
            zone: aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, 'zone', {
                domainName: props.parentDomain,
            }),
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromIpAddresses(this.instance.instancePrivateIp),
        });
    }
}
exports.InstanceService = InstanceService;
_b = JSII_RTTI_SYMBOL_1;
InstanceService[_b] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.InstanceService", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw0R0FJNkQ7QUFDN0QsMEdBQXlGO0FBQ3pGLDZDQU9xQjtBQUNyQiwyQ0FBdUM7QUFtRHZDLFNBQWdCLGtCQUFrQixDQUFDLEtBQWUsRUFBRSxLQUF1QjtJQUN6RSxPQUFPLHFCQUFHLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztBQUM3RSxDQUFDO0FBRkQsZ0RBRUM7Ozs7QUFFRCxNQUFhLG9CQUFxQixTQUFRLHNCQUFTOzs7O0lBSWpELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDeEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxJQUFJLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxJQUFJLE9BQU8sQ0FBQyxFQUFFO1lBQ2xGLE1BQU0sSUFBSSxLQUFLLENBQUMsbUZBQW9GLEtBQUssQ0FBQyxFQUFFLENBQUMsV0FBVyxFQUFHLEVBQUUsQ0FBQyxDQUFDO1NBQ2hJO1FBRUQsSUFBSSxZQUFZLEdBQVksRUFBRSxDQUFDO1FBRS9CLE1BQU0sU0FBUyxHQUFZO1lBQ3pCLElBQUssS0FBSyxDQUFDLEVBQUcsT0FBTztZQUNyQixJQUFLLEtBQUssQ0FBQyxFQUFHLFNBQVM7U0FDeEIsQ0FBQztRQUVGLFNBQVMsQ0FBQyxPQUFPLENBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUN2QixZQUFZLENBQUMsSUFBSSxDQUFDLGdCQUFpQixtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFPLElBQUssbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBUSxjQUFlLENBQUUsRUFBRSxDQUFDLENBQUM7UUFDNUcsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUkscUJBQUcsQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLGVBQWUsRUFBRTtZQUN6RCxXQUFXLEVBQUUsaURBQWlEO1lBQzlELFVBQVUsRUFBRTtnQkFDVixJQUFJLHFCQUFHLENBQUMsZUFBZSxDQUFDO29CQUN0QixNQUFNLEVBQUUscUJBQUcsQ0FBQyxNQUFNLENBQUMsS0FBSztvQkFDeEIsT0FBTyxFQUFFO3dCQUNQLG1CQUFtQjt3QkFDbkIscUJBQXFCO3dCQUNyQixzQkFBc0I7cUJBQ3ZCO29CQUNELFNBQVMsRUFBRSxZQUFZO2lCQUN4QixDQUFDO2FBQ0g7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOztBQXBDSCxvREFxQ0M7Ozs7OztBQUVELE1BQWEsZUFBZ0IsU0FBUSxzQkFBUzs7OztJQXlCNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEyQjs7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLG1DQUFtQyxTQUFZLEtBQUssQ0FBQyxtQ0FBbUMsbUNBQUksSUFBSSxDQUFDO1FBQ3JHLElBQUkscUJBQXFCLFNBQVksS0FBSyxDQUFDLHFCQUFxQixtQ0FBSSxJQUFJLENBQUM7UUFDekUsSUFBSSw0QkFBNEIsU0FBWSxLQUFLLENBQUMsNEJBQTRCLG1DQUFJLElBQUksQ0FBQztRQUV2RixJQUFJLG1DQUFtQztZQUFFLHFCQUFPLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLHlFQUFvQyxFQUFFLENBQUMsQ0FBQztRQUMxRyxJQUFJLHFCQUFxQjtZQUFFLHFCQUFPLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLDJFQUFzQyxFQUFFLENBQUMsQ0FBQztRQUM5RixJQUFJLDRCQUE0QjtZQUFFLHFCQUFPLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLDBEQUFxQixFQUFFLENBQUMsQ0FBQztRQUVwRixJQUFJLGVBQWUsR0FBRyxFQUFFLENBQUM7UUFFekIsd0JBQXdCO1FBQ3hCLElBQUksb0JBQW9CLEdBQVksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBRW5ILElBQUksb0JBQW9CLEVBQUU7WUFDeEIsZUFBZSxDQUFDLElBQUksQ0FBQyxJQUFJLG9CQUFvQixDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7Z0JBQ25FLEVBQUUsRUFBRSxrQkFBa0IsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQzthQUNqRCxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDWjtRQUVELElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSx1REFBbUIsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ25FLGlCQUFpQixFQUFFLEtBQUs7WUFDeEIsb0JBQW9CLEVBQUUsSUFBSTtZQUMxQixlQUFlO1NBQ2hCLENBQUMsQ0FBQztRQUVILElBQUksZ0JBQWdCLEdBQVksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQ3ZHLElBQUksa0JBQWtCLEdBQVksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBRTlHLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxxQkFBRyxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsZUFBZSxFQUFFO1lBQ2hFLGdCQUFnQixFQUFFLGdCQUFnQjtZQUNsQyxHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7WUFDZCxXQUFXLEVBQUUsMERBQTJELEtBQUssQ0FBQyxJQUFLLEVBQUU7WUFDckYsa0JBQWtCLEVBQUUsa0JBQWtCO1NBQ3ZDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxxQkFBRyxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2pELFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsR0FBRyxFQUFFLEtBQUssQ0FBQyxHQUFHO1lBQ2QsZ0JBQWdCLEVBQUUsZ0JBQWdCO1lBQ2xDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QywrQkFBK0IsRUFBRSxJQUFJO1lBQ3JDLGFBQWEsRUFBRSxJQUFJO1lBQ25CLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyw0QkFBNEI7WUFDNUIseUJBQXlCLEVBQUUsS0FBSztZQUNoQyxVQUFVLEVBQUU7Z0JBQ1YsVUFBVSxRQUFFLEtBQUssQ0FBQyxVQUFVLG1DQUFJLHFCQUFHLENBQUMsVUFBVSxDQUFDLGdCQUFnQjtnQkFDL0QsUUFBUSxFQUFFLElBQUk7Z0JBQ2QsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjthQUMzQztTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBRTNHLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUM7UUFDMUMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsd0JBQXdCLENBQUM7UUFDdkUsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQztRQUMzQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQztRQUN0RSxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQztRQUN6RCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxxQkFBcUIsQ0FBQztRQUNwRSxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDO1FBRW5DLGtCQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsSUFBSSxHQUFHLEdBQUcsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUM7UUFFbkYsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLHlCQUFPLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxHQUFHLEVBQUU7WUFDcEQsVUFBVSxFQUFFLEtBQUssQ0FBQyxJQUFJLEdBQUcsR0FBRyxHQUFHLEtBQUssQ0FBQyxZQUFZO1lBQ2pELElBQUksRUFBRSx5QkFBTyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRTtnQkFDaEQsVUFBVSxFQUFFLEtBQUssQ0FBQyxZQUFZO2FBQy9CLENBQUM7WUFDRixNQUFNLEVBQUUseUJBQU8sQ0FBQyxZQUFZLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsaUJBQWlCLENBQUM7U0FDOUUsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF0R0gsMENBdUdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgTm9JbmdyZXNzQ29tbW9uTWFuYWdlbWVudFBvcnRzQXNwZWN0LFxuICBOb1B1YmxpY0luZ3Jlc3NBc3BlY3QsXG4gIE5vSW5ncmVzc0NvbW1vblJlbGF0aW9uYWxEQlBvcnRzQXNwZWN0LFxufSBmcm9tICdAcmVub3Zvc29sdXRpb25zL2Nkay1hc3BlY3RzLWxpYnJhcnktc2VjdXJpdHktZ3JvdXAnO1xuaW1wb3J0IHsgTWFuYWdlZEluc3RhbmNlUm9sZSB9IGZyb20gJ0ByZW5vdm9zb2x1dGlvbnMvY2RrLWxpYnJhcnktbWFuYWdlZC1pbnN0YW5jZS1yb2xlJztcbmltcG9ydCB7XG4gIGF3c19lYzIgYXMgZWMyLFxuICBhd3NfaWFtIGFzIGlhbSxcbiAgU3RhY2ssXG4gIEFzcGVjdHMsXG4gIGF3c19yb3V0ZTUzIGFzIHJvdXRlNTMsXG4gIFRhZ3MsXG59IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEluc3RhbmNlU2VydmljZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpbnN0YW5jZVR5cGU6IGVjMi5JbnN0YW5jZVR5cGU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWFjaGluZUltYWdlOiBlYzIuSU1hY2hpbmVJbWFnZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZwYzogZWMyLklWcGM7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFsbG93QWxsT3V0Ym91bmQ/OiBib29sZWFuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBibG9ja0RldmljZXM/OiBlYzIuQmxvY2tEZXZpY2VbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkga2V5TmFtZT86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByaXZhdGVJcEFkZHJlc3M/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3VibmV0VHlwZT86IGVjMi5TdWJuZXRUeXBlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXZhaWxhYmlsaXR5Wm9uZXM/OiBzdHJpbmdbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5hYmxlQ2xvdWR3YXRjaExvZ3M/OiBib29sZWFuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRpc2FibGVJbmxpbmVSdWxlcz86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVuYWJsZU5vUmVtb3RlTWFuYWdlbWVudFBvcnRzQXNwZWN0PzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5hYmxlTm9EQlBvcnRzQXNwZWN0PzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5hYmxlZE5vUHVibGljSW5ncmVzc0FzcGVjdD86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwYXJlbnREb21haW46IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNYW5hZ2VkTG9nZ2luZ1BvbGljeVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG9zOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQW1pTG9va3VwIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG93bmVycz86IHN0cmluZ1tdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB3aW5kb3dzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGVjMkltYWdlVG9Pc1N0cmluZyhzdGFjazpDb25zdHJ1Y3QsIGltYWdlOmVjMi5JTWFjaGluZUltYWdlKSB7XG4gIHJldHVybiBlYzIuT3BlcmF0aW5nU3lzdGVtVHlwZVtpbWFnZS5nZXRJbWFnZShzdGFjaykub3NUeXBlXS50b0xvd2VyQ2FzZSgpO1xufVxuXG5leHBvcnQgY2xhc3MgTWFuYWdlZExvZ2dpbmdQb2xpY3kgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuXG4gIHB1YmxpYyByZWFkb25seSBwb2xpY3k6IGlhbS5NYW5hZ2VkUG9saWN5O1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBNYW5hZ2VkTG9nZ2luZ1BvbGljeVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGlmICghKHByb3BzLm9zLnRvTG93ZXJDYXNlKCkgPT0gJ3dpbmRvd3MnKSAmJiAhKHByb3BzLm9zLnRvTG93ZXJDYXNlKCkgPT0gJ2xpbnV4JykpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgVGhlIG9zIHByb3BlcnR5IGZvciBNYW5hZ2VkTG9nZ2luZ1BvbGljeSBtdXN0IGJlIHdpbmRvd3Mgb3IgbGludXggYW5kIHlvdSBnYXZlOiAkeyBwcm9wcy5vcy50b0xvd2VyQ2FzZSgpIH1gKTtcbiAgICB9XG5cbiAgICBsZXQgbG9nUmVzb3VyY2VzOnN0cmluZ1tdID0gW107XG5cbiAgICBjb25zdCBsb2dHcm91cHM6c3RyaW5nW10gPSBbXG4gICAgICBgLyR7IHByb3BzLm9zIH0vbG9nc2AsXG4gICAgICBgLyR7IHByb3BzLm9zIH0vbG9ncy8qYCxcbiAgICBdO1xuXG4gICAgbG9nR3JvdXBzLmZvckVhY2goIChnKSA9PiB7XG4gICAgICBsb2dSZXNvdXJjZXMucHVzaChgYXJuOmF3czpsb2dzOiR7IFN0YWNrLm9mKHRoaXMpLnJlZ2lvbiB9OiR7IFN0YWNrLm9mKHRoaXMpLmFjY291bnQgfTpsb2ctZ3JvdXA6JHsgZyB9YCk7XG4gICAgfSk7XG5cbiAgICB0aGlzLnBvbGljeSA9IG5ldyBpYW0uTWFuYWdlZFBvbGljeSh0aGlzLCAnbG9nZ2luZ1BvbGljeScsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiAnQWxsb3cgaW5zdGFuY2UgdG8gbG9nIHN5c3RlbSBsb2dzIHRvIENsb3Vkd2F0Y2gnLFxuICAgICAgc3RhdGVtZW50czogW1xuICAgICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgICAgZWZmZWN0OiBpYW0uRWZmZWN0LkFMTE9XLFxuICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICdsb2dzOlB1dExvZ0V2ZW50cycsXG4gICAgICAgICAgICAnbG9nczpDcmVhdGVMb2dHcm91cCcsXG4gICAgICAgICAgICAnbG9nczpDcmVhdGVMb2dTdHJlYW0nLFxuICAgICAgICAgIF0sXG4gICAgICAgICAgcmVzb3VyY2VzOiBsb2dSZXNvdXJjZXMsXG4gICAgICAgIH0pLFxuICAgICAgXSxcbiAgICB9KTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgSW5zdGFuY2VTZXJ2aWNlIGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGluc3RhbmNlUHJvZmlsZTogTWFuYWdlZEluc3RhbmNlUm9sZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgc2VjdXJpdHlHcm91cDogZWMyLlNlY3VyaXR5R3JvdXA7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBpbnN0YW5jZTogZWMyLkluc3RhbmNlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgaW5zdGFuY2VDZm46IGVjMi5DZm5JbnN0YW5jZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgaW5zdGFuY2VBdmFpbGFiaWxpdHlab25lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBpbnN0YW5jZUlkOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBpbnN0YW5jZUVjMlByaXZhdGVEbnNOYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGluc3RhbmNlUHJpdmF0ZUlwOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGluc3RhbmNlRWMyUHVibGljRG5zTmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgaW5zdGFuY2VEbnNOYW1lOiByb3V0ZTUzLkFSZWNvcmQ7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBvc1R5cGU6IGVjMi5PcGVyYXRpbmdTeXN0ZW1UeXBlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJbnN0YW5jZVNlcnZpY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBsZXQgZW5hYmxlTm9SZW1vdGVNYW5hZ2VtZW50UG9ydHNBc3BlY3Q6IGJvb2xlYW4gPSBwcm9wcy5lbmFibGVOb1JlbW90ZU1hbmFnZW1lbnRQb3J0c0FzcGVjdCA/PyB0cnVlO1xuICAgIGxldCBlbmFibGVOb0RCUG9ydHNBc3BlY3Q6IGJvb2xlYW4gPSBwcm9wcy5lbmFibGVOb0RCUG9ydHNBc3BlY3QgPz8gdHJ1ZTtcbiAgICBsZXQgZW5hYmxlZE5vUHVibGljSW5ncmVzc0FzcGVjdDogYm9vbGVhbiA9IHByb3BzLmVuYWJsZWROb1B1YmxpY0luZ3Jlc3NBc3BlY3QgPz8gdHJ1ZTtcblxuICAgIGlmIChlbmFibGVOb1JlbW90ZU1hbmFnZW1lbnRQb3J0c0FzcGVjdCkgQXNwZWN0cy5vZih0aGlzKS5hZGQobmV3IE5vSW5ncmVzc0NvbW1vbk1hbmFnZW1lbnRQb3J0c0FzcGVjdCgpKTtcbiAgICBpZiAoZW5hYmxlTm9EQlBvcnRzQXNwZWN0KSBBc3BlY3RzLm9mKHRoaXMpLmFkZChuZXcgTm9JbmdyZXNzQ29tbW9uUmVsYXRpb25hbERCUG9ydHNBc3BlY3QoKSk7XG4gICAgaWYgKGVuYWJsZWROb1B1YmxpY0luZ3Jlc3NBc3BlY3QpIEFzcGVjdHMub2YodGhpcykuYWRkKG5ldyBOb1B1YmxpY0luZ3Jlc3NBc3BlY3QoKSk7XG5cbiAgICBsZXQgbWFuYWdlZFBvbGljaWVzID0gW107XG5cbiAgICAvLyBMb2dnaW5nIGNvbmZpZ3VyYXRpb25cbiAgICBsZXQgZW5hYmxlQ2xvdWR3YXRjaExvZ3M6IGJvb2xlYW4gPSAocHJvcHMuZW5hYmxlQ2xvdWR3YXRjaExvZ3MgPT09IHVuZGVmaW5lZCkgPyB0cnVlIDogcHJvcHMuZW5hYmxlQ2xvdWR3YXRjaExvZ3M7XG5cbiAgICBpZiAoZW5hYmxlQ2xvdWR3YXRjaExvZ3MpIHtcbiAgICAgIG1hbmFnZWRQb2xpY2llcy5wdXNoKG5ldyBNYW5hZ2VkTG9nZ2luZ1BvbGljeSh0aGlzLCAnbG9nZ2luZ1BvbGljeScsIHtcbiAgICAgICAgb3M6IGVjMkltYWdlVG9Pc1N0cmluZyh0aGlzLCBwcm9wcy5tYWNoaW5lSW1hZ2UpLFxuICAgICAgfSkucG9saWN5KTtcbiAgICB9XG5cbiAgICB0aGlzLmluc3RhbmNlUHJvZmlsZSA9IG5ldyBNYW5hZ2VkSW5zdGFuY2VSb2xlKHRoaXMsICdpbnN0YW5jZVJvbGUnLCB7XG4gICAgICBkb21haW5Kb2luRW5hYmxlZDogZmFsc2UsXG4gICAgICBzc21NYW5hZ2VtZW50RW5hYmxlZDogdHJ1ZSxcbiAgICAgIG1hbmFnZWRQb2xpY2llcyxcbiAgICB9KTtcblxuICAgIGxldCBhbGxvd0FsbE91dGJvdW5kOiBib29sZWFuID0gKHByb3BzLmFsbG93QWxsT3V0Ym91bmQgPT09IHVuZGVmaW5lZCkgPyB0cnVlIDogcHJvcHMuYWxsb3dBbGxPdXRib3VuZDtcbiAgICBsZXQgZGlzYWJsZUlubGluZVJ1bGVzOiBib29sZWFuID0gKHByb3BzLmRpc2FibGVJbmxpbmVSdWxlcyA9PT0gdW5kZWZpbmVkKSA/IGZhbHNlIDogcHJvcHMuZGlzYWJsZUlubGluZVJ1bGVzO1xuXG4gICAgdGhpcy5zZWN1cml0eUdyb3VwID0gbmV3IGVjMi5TZWN1cml0eUdyb3VwKHRoaXMsICdzZWN1cml0eUdyb3VwJywge1xuICAgICAgYWxsb3dBbGxPdXRib3VuZDogYWxsb3dBbGxPdXRib3VuZCxcbiAgICAgIHZwYzogcHJvcHMudnBjLFxuICAgICAgZGVzY3JpcHRpb246IGBUaGUgc2VjdXJpdHkgZ3JvdXAgYXBwbGllZCB0byB0aGUgaW5zdGFuY2Ugc2VydmljZSBmb3IgJHsgcHJvcHMubmFtZSB9YCxcbiAgICAgIGRpc2FibGVJbmxpbmVSdWxlczogZGlzYWJsZUlubGluZVJ1bGVzLFxuICAgIH0pO1xuXG4gICAgdGhpcy5pbnN0YW5jZSA9IG5ldyBlYzIuSW5zdGFuY2UodGhpcywgJ2luc3RhbmNlJywge1xuICAgICAgaW5zdGFuY2VUeXBlOiBwcm9wcy5pbnN0YW5jZVR5cGUsXG4gICAgICBtYWNoaW5lSW1hZ2U6IHByb3BzLm1hY2hpbmVJbWFnZSxcbiAgICAgIHZwYzogcHJvcHMudnBjLFxuICAgICAgYWxsb3dBbGxPdXRib3VuZDogYWxsb3dBbGxPdXRib3VuZCxcbiAgICAgIGJsb2NrRGV2aWNlczogcHJvcHMuYmxvY2tEZXZpY2VzLFxuICAgICAga2V5TmFtZTogcHJvcHMua2V5TmFtZSxcbiAgICAgIHByaXZhdGVJcEFkZHJlc3M6IHByb3BzLnByaXZhdGVJcEFkZHJlc3MsXG4gICAgICBwcm9wYWdhdGVUYWdzVG9Wb2x1bWVPbkNyZWF0aW9uOiB0cnVlLFxuICAgICAgcmVxdWlyZUltZHN2MjogdHJ1ZSxcbiAgICAgIHNlY3VyaXR5R3JvdXA6IHRoaXMuc2VjdXJpdHlHcm91cCxcbiAgICAgIC8vIHVzZXJEYXRhOiBwcm9wcy51c2VyRGF0YSxcbiAgICAgIHVzZXJEYXRhQ2F1c2VzUmVwbGFjZW1lbnQ6IGZhbHNlLFxuICAgICAgdnBjU3VibmV0czoge1xuICAgICAgICBzdWJuZXRUeXBlOiBwcm9wcy5zdWJuZXRUeXBlID8/IGVjMi5TdWJuZXRUeXBlLlBSSVZBVEVfV0lUSF9OQVQsXG4gICAgICAgIG9uZVBlckF6OiB0cnVlLFxuICAgICAgICBhdmFpbGFiaWxpdHlab25lczogcHJvcHMuYXZhaWxhYmlsaXR5Wm9uZXMsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5pbnN0YW5jZS5pbnN0YW5jZS5hZGRQcm9wZXJ0eU92ZXJyaWRlKCdJYW1JbnN0YW5jZVByb2ZpbGUnLCB0aGlzLmluc3RhbmNlUHJvZmlsZS5pbnN0YW5jZVByb2ZpbGUucmVmKTtcblxuICAgIHRoaXMuaW5zdGFuY2VDZm4gPSB0aGlzLmluc3RhbmNlLmluc3RhbmNlO1xuICAgIHRoaXMuaW5zdGFuY2VBdmFpbGFiaWxpdHlab25lID0gdGhpcy5pbnN0YW5jZS5pbnN0YW5jZUF2YWlsYWJpbGl0eVpvbmU7XG4gICAgdGhpcy5pbnN0YW5jZUlkID0gdGhpcy5pbnN0YW5jZS5pbnN0YW5jZUlkO1xuICAgIHRoaXMuaW5zdGFuY2VFYzJQcml2YXRlRG5zTmFtZSA9IHRoaXMuaW5zdGFuY2UuaW5zdGFuY2VQcml2YXRlRG5zTmFtZTtcbiAgICB0aGlzLmluc3RhbmNlUHJpdmF0ZUlwID0gdGhpcy5pbnN0YW5jZS5pbnN0YW5jZVByaXZhdGVJcDtcbiAgICB0aGlzLmluc3RhbmNlRWMyUHVibGljRG5zTmFtZSA9IHRoaXMuaW5zdGFuY2UuaW5zdGFuY2VQdWJsaWNEbnNOYW1lO1xuICAgIHRoaXMub3NUeXBlID0gdGhpcy5pbnN0YW5jZS5vc1R5cGU7XG5cbiAgICBUYWdzLm9mKHRoaXMuaW5zdGFuY2UuaW5zdGFuY2UpLmFkZCgnTmFtZScsIHByb3BzLm5hbWUgKyAnLicgKyBwcm9wcy5wYXJlbnREb21haW4pO1xuXG4gICAgdGhpcy5pbnN0YW5jZURuc05hbWUgPSBuZXcgcm91dGU1My5BUmVjb3JkKHRoaXMsICdBJywge1xuICAgICAgcmVjb3JkTmFtZTogcHJvcHMubmFtZSArICcuJyArIHByb3BzLnBhcmVudERvbWFpbixcbiAgICAgIHpvbmU6IHJvdXRlNTMuSG9zdGVkWm9uZS5mcm9tTG9va3VwKHRoaXMsICd6b25lJywge1xuICAgICAgICBkb21haW5OYW1lOiBwcm9wcy5wYXJlbnREb21haW4sXG4gICAgICB9KSxcbiAgICAgIHRhcmdldDogcm91dGU1My5SZWNvcmRUYXJnZXQuZnJvbUlwQWRkcmVzc2VzKHRoaXMuaW5zdGFuY2UuaW5zdGFuY2VQcml2YXRlSXApLFxuICAgIH0pO1xuICB9XG59XG4iXX0=