# This file was auto-generated by Fern from our API Definition.

from .....core.pydantic_utilities import UniversalBaseModel
import pydantic
import datetime as dt
from .lambda_package_type import LambdaPackageType
import typing
from .lambda_architecture import LambdaArchitecture
from .lambda_logging_config import LambdaLoggingConfig
from .....core.pydantic_utilities import IS_PYDANTIC_V2


class LambdaConfigurationInfo(UniversalBaseModel):
    revision_id: str = pydantic.Field(alias="revisionId")
    runtime: str
    handler: str
    code_size_in_bytes: int = pydantic.Field(alias="codeSizeInBytes")
    timeout_in_seconds: int = pydantic.Field(alias="timeoutInSeconds")
    memory_size_in_mb: int = pydantic.Field(alias="memorySizeInMb")
    ephemeral_storage_in_mb: int = pydantic.Field(alias="ephemeralStorageInMb")
    last_modified: dt.datetime = pydantic.Field(alias="lastModified")
    package_type: LambdaPackageType = pydantic.Field(alias="packageType")
    description: typing.Optional[str] = None
    code_sha_256: typing.Optional[str] = pydantic.Field(alias="codeSha256", default=None)
    architectures: typing.Optional[typing.List[LambdaArchitecture]] = None
    logging_config: typing.Optional[LambdaLoggingConfig] = pydantic.Field(alias="loggingConfig", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
