<a id="mypy-boto3-apigateway"></a>

# mypy-boto3-apigateway

[![PyPI - mypy-boto3-apigateway](https://img.shields.io/pypi/v/mypy-boto3-apigateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigateway)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-apigateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigateway)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-apigateway?color=blue)](https://pypistats.org/packages/mypy-boto3-apigateway)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.APIGateway 1.19.2](https://boto3.amazonaws.com/v1/documentation/api/1.19.2/reference/services/apigateway.html#APIGateway)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-apigateway docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_apigateway/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-apigateway](#mypy-boto3-apigateway)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `APIGateway` service.

```bash
python -m pip install boto3-stubs[apigateway]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[apigateway]` in your environment:
  `python -m pip install 'boto3-stubs[apigateway]'`

Both type checking and auto-complete should work for `APIGateway` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[apigateway]` in your environment:
  `python -m pip install 'boto3-stubs[apigateway]'`

Both type checking and auto-complete should work for `APIGateway` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[apigateway]` in your environment:
  `python -m pip install 'boto3-stubs[apigateway]'`
- Run `mypy` as usual

Type checking should work for `APIGateway` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[apigateway]` in your environment:
  `python -m pip install 'boto3-stubs[apigateway]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `APIGateway` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`APIGatewayClient` provides annotations for `boto3.client("apigateway")`.

```python
import boto3

from mypy_boto3_apigateway import APIGatewayClient

client: APIGatewayClient = boto3.client("apigateway")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: APIGatewayClient = session.client("apigateway")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_apigateway.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_apigateway import APIGatewayClient
from mypy_boto3_apigateway.paginator import (
    GetApiKeysPaginator,
    GetAuthorizersPaginator,
    GetBasePathMappingsPaginator,
    GetClientCertificatesPaginator,
    GetDeploymentsPaginator,
    GetDocumentationPartsPaginator,
    GetDocumentationVersionsPaginator,
    GetDomainNamesPaginator,
    GetGatewayResponsesPaginator,
    GetModelsPaginator,
    GetRequestValidatorsPaginator,
    GetResourcesPaginator,
    GetRestApisPaginator,
    GetSdkTypesPaginator,
    GetUsagePaginator,
    GetUsagePlanKeysPaginator,
    GetUsagePlansPaginator,
    GetVpcLinksPaginator,
)

client: APIGatewayClient = boto3.client("apigateway")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_api_keys_paginator: GetApiKeysPaginator = client.get_paginator("get_api_keys")
get_authorizers_paginator: GetAuthorizersPaginator = client.get_paginator("get_authorizers")
get_base_path_mappings_paginator: GetBasePathMappingsPaginator = client.get_paginator("get_base_path_mappings")
get_client_certificates_paginator: GetClientCertificatesPaginator = client.get_paginator("get_client_certificates")
get_deployments_paginator: GetDeploymentsPaginator = client.get_paginator("get_deployments")
get_documentation_parts_paginator: GetDocumentationPartsPaginator = client.get_paginator("get_documentation_parts")
get_documentation_versions_paginator: GetDocumentationVersionsPaginator = client.get_paginator("get_documentation_versions")
get_domain_names_paginator: GetDomainNamesPaginator = client.get_paginator("get_domain_names")
get_gateway_responses_paginator: GetGatewayResponsesPaginator = client.get_paginator("get_gateway_responses")
get_models_paginator: GetModelsPaginator = client.get_paginator("get_models")
get_request_validators_paginator: GetRequestValidatorsPaginator = client.get_paginator("get_request_validators")
get_resources_paginator: GetResourcesPaginator = client.get_paginator("get_resources")
get_rest_apis_paginator: GetRestApisPaginator = client.get_paginator("get_rest_apis")
get_sdk_types_paginator: GetSdkTypesPaginator = client.get_paginator("get_sdk_types")
get_usage_paginator: GetUsagePaginator = client.get_paginator("get_usage")
get_usage_plan_keys_paginator: GetUsagePlanKeysPaginator = client.get_paginator("get_usage_plan_keys")
get_usage_plans_paginator: GetUsagePlansPaginator = client.get_paginator("get_usage_plans")
get_vpc_links_paginator: GetVpcLinksPaginator = client.get_paginator("get_vpc_links")
```

<a id="literals"></a>

### Literals

`mypy_boto3_apigateway.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_apigateway.literals import (
    ApiKeySourceTypeType,
    ApiKeysFormatType,
    AuthorizerTypeType,
    CacheClusterSizeType,
    CacheClusterStatusType,
    ConnectionTypeType,
    ContentHandlingStrategyType,
    DocumentationPartTypeType,
    DomainNameStatusType,
    EndpointTypeType,
    GatewayResponseTypeType,
    GetApiKeysPaginatorName,
    GetAuthorizersPaginatorName,
    GetBasePathMappingsPaginatorName,
    GetClientCertificatesPaginatorName,
    GetDeploymentsPaginatorName,
    GetDocumentationPartsPaginatorName,
    GetDocumentationVersionsPaginatorName,
    GetDomainNamesPaginatorName,
    GetGatewayResponsesPaginatorName,
    GetModelsPaginatorName,
    GetRequestValidatorsPaginatorName,
    GetResourcesPaginatorName,
    GetRestApisPaginatorName,
    GetSdkTypesPaginatorName,
    GetUsagePaginatorName,
    GetUsagePlanKeysPaginatorName,
    GetUsagePlansPaginatorName,
    GetVpcLinksPaginatorName,
    IntegrationTypeType,
    LocationStatusTypeType,
    OpType,
    PutModeType,
    QuotaPeriodTypeType,
    SecurityPolicyType,
    UnauthorizedCacheControlHeaderStrategyType,
    VpcLinkStatusType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ApiKeySourceTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_apigateway.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_apigateway.type_defs import (
    AccessLogSettingsTypeDef,
    AccountTypeDef,
    ApiKeyIdsTypeDef,
    ApiKeyResponseMetadataTypeDef,
    ApiKeyTypeDef,
    ApiKeysTypeDef,
    ApiStageTypeDef,
    AuthorizerResponseMetadataTypeDef,
    AuthorizerTypeDef,
    AuthorizersTypeDef,
    BasePathMappingResponseMetadataTypeDef,
    BasePathMappingTypeDef,
    BasePathMappingsTypeDef,
    CanarySettingsTypeDef,
    ClientCertificateResponseMetadataTypeDef,
    ClientCertificateTypeDef,
    ClientCertificatesTypeDef,
    CreateApiKeyRequestRequestTypeDef,
    CreateAuthorizerRequestRequestTypeDef,
    CreateBasePathMappingRequestRequestTypeDef,
    CreateDeploymentRequestRequestTypeDef,
    CreateDocumentationPartRequestRequestTypeDef,
    CreateDocumentationVersionRequestRequestTypeDef,
    CreateDomainNameRequestRequestTypeDef,
    CreateModelRequestRequestTypeDef,
    CreateRequestValidatorRequestRequestTypeDef,
    CreateResourceRequestRequestTypeDef,
    CreateRestApiRequestRequestTypeDef,
    CreateStageRequestRequestTypeDef,
    CreateUsagePlanKeyRequestRequestTypeDef,
    CreateUsagePlanRequestRequestTypeDef,
    CreateVpcLinkRequestRequestTypeDef,
    DeleteApiKeyRequestRequestTypeDef,
    DeleteAuthorizerRequestRequestTypeDef,
    DeleteBasePathMappingRequestRequestTypeDef,
    DeleteClientCertificateRequestRequestTypeDef,
    DeleteDeploymentRequestRequestTypeDef,
    DeleteDocumentationPartRequestRequestTypeDef,
    DeleteDocumentationVersionRequestRequestTypeDef,
    DeleteDomainNameRequestRequestTypeDef,
    DeleteGatewayResponseRequestRequestTypeDef,
    DeleteIntegrationRequestRequestTypeDef,
    DeleteIntegrationResponseRequestRequestTypeDef,
    DeleteMethodRequestRequestTypeDef,
    DeleteMethodResponseRequestRequestTypeDef,
    DeleteModelRequestRequestTypeDef,
    DeleteRequestValidatorRequestRequestTypeDef,
    DeleteResourceRequestRequestTypeDef,
    DeleteRestApiRequestRequestTypeDef,
    DeleteStageRequestRequestTypeDef,
    DeleteUsagePlanKeyRequestRequestTypeDef,
    DeleteUsagePlanRequestRequestTypeDef,
    DeleteVpcLinkRequestRequestTypeDef,
    DeploymentCanarySettingsTypeDef,
    DeploymentResponseMetadataTypeDef,
    DeploymentTypeDef,
    DeploymentsTypeDef,
    DocumentationPartIdsTypeDef,
    DocumentationPartLocationTypeDef,
    DocumentationPartResponseMetadataTypeDef,
    DocumentationPartTypeDef,
    DocumentationPartsTypeDef,
    DocumentationVersionResponseMetadataTypeDef,
    DocumentationVersionTypeDef,
    DocumentationVersionsTypeDef,
    DomainNameResponseMetadataTypeDef,
    DomainNameTypeDef,
    DomainNamesTypeDef,
    EndpointConfigurationTypeDef,
    ExportResponseTypeDef,
    FlushStageAuthorizersCacheRequestRequestTypeDef,
    FlushStageCacheRequestRequestTypeDef,
    GatewayResponseResponseMetadataTypeDef,
    GatewayResponseTypeDef,
    GatewayResponsesTypeDef,
    GenerateClientCertificateRequestRequestTypeDef,
    GetApiKeyRequestRequestTypeDef,
    GetApiKeysRequestRequestTypeDef,
    GetAuthorizerRequestRequestTypeDef,
    GetAuthorizersRequestRequestTypeDef,
    GetBasePathMappingRequestRequestTypeDef,
    GetBasePathMappingsRequestRequestTypeDef,
    GetClientCertificateRequestRequestTypeDef,
    GetClientCertificatesRequestRequestTypeDef,
    GetDeploymentRequestRequestTypeDef,
    GetDeploymentsRequestRequestTypeDef,
    GetDocumentationPartRequestRequestTypeDef,
    GetDocumentationPartsRequestRequestTypeDef,
    GetDocumentationVersionRequestRequestTypeDef,
    GetDocumentationVersionsRequestRequestTypeDef,
    GetDomainNameRequestRequestTypeDef,
    GetDomainNamesRequestRequestTypeDef,
    GetExportRequestRequestTypeDef,
    GetGatewayResponseRequestRequestTypeDef,
    GetGatewayResponsesRequestRequestTypeDef,
    GetIntegrationRequestRequestTypeDef,
    GetIntegrationResponseRequestRequestTypeDef,
    GetMethodRequestRequestTypeDef,
    GetMethodResponseRequestRequestTypeDef,
    GetModelRequestRequestTypeDef,
    GetModelTemplateRequestRequestTypeDef,
    GetModelsRequestRequestTypeDef,
    GetRequestValidatorRequestRequestTypeDef,
    GetRequestValidatorsRequestRequestTypeDef,
    GetResourceRequestRequestTypeDef,
    GetResourcesRequestRequestTypeDef,
    GetRestApiRequestRequestTypeDef,
    GetRestApisRequestRequestTypeDef,
    GetSdkRequestRequestTypeDef,
    GetSdkTypeRequestRequestTypeDef,
    GetSdkTypesRequestRequestTypeDef,
    GetStageRequestRequestTypeDef,
    GetStagesRequestRequestTypeDef,
    GetTagsRequestRequestTypeDef,
    GetUsagePlanKeyRequestRequestTypeDef,
    GetUsagePlanKeysRequestRequestTypeDef,
    GetUsagePlanRequestRequestTypeDef,
    GetUsagePlansRequestRequestTypeDef,
    GetUsageRequestRequestTypeDef,
    GetVpcLinkRequestRequestTypeDef,
    GetVpcLinksRequestRequestTypeDef,
    ImportApiKeysRequestRequestTypeDef,
    ImportDocumentationPartsRequestRequestTypeDef,
    ImportRestApiRequestRequestTypeDef,
    IntegrationResponseMetadataTypeDef,
    IntegrationResponseResponseMetadataTypeDef,
    IntegrationResponseTypeDef,
    IntegrationTypeDef,
    MethodResponseMetadataTypeDef,
    MethodResponseResponseMetadataTypeDef,
    MethodResponseTypeDef,
    MethodSettingTypeDef,
    MethodSnapshotTypeDef,
    MethodTypeDef,
    ModelResponseMetadataTypeDef,
    ModelTypeDef,
    ModelsTypeDef,
    MutualTlsAuthenticationInputTypeDef,
    MutualTlsAuthenticationTypeDef,
    PaginatorConfigTypeDef,
    PatchOperationTypeDef,
    PutGatewayResponseRequestRequestTypeDef,
    PutIntegrationRequestRequestTypeDef,
    PutIntegrationResponseRequestRequestTypeDef,
    PutMethodRequestRequestTypeDef,
    PutMethodResponseRequestRequestTypeDef,
    PutRestApiRequestRequestTypeDef,
    QuotaSettingsTypeDef,
    RequestValidatorResponseMetadataTypeDef,
    RequestValidatorTypeDef,
    RequestValidatorsTypeDef,
    ResourceResponseMetadataTypeDef,
    ResourceTypeDef,
    ResourcesTypeDef,
    ResponseMetadataTypeDef,
    RestApiResponseMetadataTypeDef,
    RestApiTypeDef,
    RestApisTypeDef,
    SdkConfigurationPropertyTypeDef,
    SdkResponseTypeDef,
    SdkTypeResponseMetadataTypeDef,
    SdkTypeTypeDef,
    SdkTypesTypeDef,
    StageKeyTypeDef,
    StageResponseMetadataTypeDef,
    StageTypeDef,
    StagesTypeDef,
    TagResourceRequestRequestTypeDef,
    TagsTypeDef,
    TemplateTypeDef,
    TestInvokeAuthorizerRequestRequestTypeDef,
    TestInvokeAuthorizerResponseTypeDef,
    TestInvokeMethodRequestRequestTypeDef,
    TestInvokeMethodResponseTypeDef,
    ThrottleSettingsTypeDef,
    TlsConfigTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAccountRequestRequestTypeDef,
    UpdateApiKeyRequestRequestTypeDef,
    UpdateAuthorizerRequestRequestTypeDef,
    UpdateBasePathMappingRequestRequestTypeDef,
    UpdateClientCertificateRequestRequestTypeDef,
    UpdateDeploymentRequestRequestTypeDef,
    UpdateDocumentationPartRequestRequestTypeDef,
    UpdateDocumentationVersionRequestRequestTypeDef,
    UpdateDomainNameRequestRequestTypeDef,
    UpdateGatewayResponseRequestRequestTypeDef,
    UpdateIntegrationRequestRequestTypeDef,
    UpdateIntegrationResponseRequestRequestTypeDef,
    UpdateMethodRequestRequestTypeDef,
    UpdateMethodResponseRequestRequestTypeDef,
    UpdateModelRequestRequestTypeDef,
    UpdateRequestValidatorRequestRequestTypeDef,
    UpdateResourceRequestRequestTypeDef,
    UpdateRestApiRequestRequestTypeDef,
    UpdateStageRequestRequestTypeDef,
    UpdateUsagePlanRequestRequestTypeDef,
    UpdateUsageRequestRequestTypeDef,
    UpdateVpcLinkRequestRequestTypeDef,
    UsagePlanKeyResponseMetadataTypeDef,
    UsagePlanKeyTypeDef,
    UsagePlanKeysTypeDef,
    UsagePlanResponseMetadataTypeDef,
    UsagePlanTypeDef,
    UsagePlansTypeDef,
    UsageTypeDef,
    VpcLinkResponseMetadataTypeDef,
    VpcLinkTypeDef,
    VpcLinksTypeDef,
)

def get_structure() -> AccessLogSettingsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-apigateway` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-apigateway docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_apigateway/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
