
#!/usr/bin/env python
# coding: utf-8

# Copyright (c) Saga Inc.
# Distributed under the terms of The Mito Enterprise license.

from typing import Any, Dict, List, Optional, Set

from mitosheet.code_chunks.code_chunk import CodeChunk
from mitosheet.code_chunks.one_hot_encoding_code_chunk import \
    OneHotEncodingCodeChunk
from mitosheet.state import State
from mitosheet.step_performers.step_performer import StepPerformer
from mitosheet.step_performers.utils.utils import get_param


class OneHotEncodingStepPerformer(StepPerformer):
    """
    Allows you to do a one hot encoding of a column.
    """

    @classmethod
    def step_version(cls) -> int:
        return 1

    @classmethod
    def step_type(cls) -> str:
        return 'one_hot_encoding'


    @classmethod
    def transpile(
        cls,
        prev_state: State,
        params: Dict[str, Any],
        execution_data: Optional[Dict[str, Any]],
    ) -> List[CodeChunk]:
        return [
            OneHotEncodingCodeChunk(
                prev_state, 
                get_param(params, 'sheet_index'), 
                get_param(params, 'column_id'), 
            )
        ]

    @classmethod
    def get_modified_dataframe_indexes(cls, params: Dict[str, Any]) -> Set[int]:
        return {get_param(params, 'sheet_index')}
    