"""
Lance Namespace Python Client

A Python client for the Lance Namespace API that provides a unified interface
for managing namespaces and tables across different backend implementations.
"""

from .namespace import LanceNamespace, connect

# Re-export all models from the urllib3 client
from lance_namespace_urllib3_client.models import (
    ListNamespacesRequest,
    ListNamespacesResponse,
    DescribeNamespaceRequest,
    DescribeNamespaceResponse,
    CreateNamespaceRequest,
    CreateNamespaceResponse,
    DropNamespaceRequest,
    DropNamespaceResponse,
    NamespaceExistsRequest,
    ListTablesRequest,
    ListTablesResponse,
    DescribeTableRequest,
    DescribeTableResponse,
    RegisterTableRequest,
    RegisterTableResponse,
    TableExistsRequest,
    DropTableRequest,
    DropTableResponse,
    DeregisterTableRequest,
    DeregisterTableResponse,
    CountTableRowsRequest,
    CreateEmptyTableRequest,
    CreateEmptyTableResponse,
    CreateTableRequest,
    CreateTableResponse,
    InsertIntoTableRequest,
    InsertIntoTableResponse,
    MergeInsertIntoTableRequest,
    MergeInsertIntoTableResponse,
    UpdateTableRequest,
    UpdateTableResponse,
    DeleteFromTableRequest,
    DeleteFromTableResponse,
    QueryTableRequest,
    CreateTableIndexRequest,
    CreateTableIndexResponse,
    ListTableIndicesRequest,
    ListTableIndicesResponse,
    DescribeTableIndexStatsRequest,
    DescribeTableIndexStatsResponse,
    DescribeTransactionRequest,
    DescribeTransactionResponse,
    AlterTransactionRequest,
    AlterTransactionResponse,
)

__all__ = [
    # Main interface and connect function
    "LanceNamespace",
    "connect",
    
    # Request/Response models
    "ListNamespacesRequest",
    "ListNamespacesResponse",
    "DescribeNamespaceRequest", 
    "DescribeNamespaceResponse",
    "CreateNamespaceRequest",
    "CreateNamespaceResponse",
    "DropNamespaceRequest",
    "DropNamespaceResponse",
    "NamespaceExistsRequest",
    "ListTablesRequest",
    "ListTablesResponse",
    "DescribeTableRequest",
    "DescribeTableResponse",
    "RegisterTableRequest",
    "RegisterTableResponse",
    "TableExistsRequest",
    "DropTableRequest",
    "DropTableResponse",
    "DeregisterTableRequest",
    "DeregisterTableResponse",
    "CountTableRowsRequest",
    "CreateEmptyTableRequest",
    "CreateEmptyTableResponse",
    "CreateTableRequest",
    "CreateTableResponse",
    "InsertIntoTableRequest",
    "InsertIntoTableResponse",
    "MergeInsertIntoTableRequest",
    "MergeInsertIntoTableResponse",
    "UpdateTableRequest",
    "UpdateTableResponse",
    "DeleteFromTableRequest",
    "DeleteFromTableResponse",
    "QueryTableRequest",
    "CreateTableIndexRequest",
    "CreateTableIndexResponse",
    "ListTableIndicesRequest",
    "ListTableIndicesResponse",
    "DescribeTableIndexStatsRequest",
    "DescribeTableIndexStatsResponse",
    "DescribeTransactionRequest",
    "DescribeTransactionResponse",
    "AlterTransactionRequest",
    "AlterTransactionResponse",
]