#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-mssql-prod-sync-export-config-param.json
#
# Do not edit this file manually!
#

from delphixpy.v1_11_17.web.objects.ProdSyncExportConfigParam import ProdSyncExportConfigParam
from delphixpy.v1_11_17 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class MSSqlProdSyncExportConfigParam(ProdSyncExportConfigParam):
    """
    *(extends* :py:class:`v1_11_17.web.vo.ProdSyncExportConfigParam` *)* The
    config parameters to use as input to export MSSQL databases for prod sync.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("MSSqlProdSyncExportConfigParam", True)
        self._enable_self_recovery = (self.__undef__, True)
        self._enable_worker = (self.__undef__, True)
        self._is_db_recovered = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._enable_self_recovery = (data.get("enableSelfRecovery", obj.__undef__), dirty)
        if obj._enable_self_recovery[0] is not None and obj._enable_self_recovery[0] is not obj.__undef__:
            assert isinstance(obj._enable_self_recovery[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._enable_self_recovery[0], type(obj._enable_self_recovery[0])))
            common.validate_format(obj._enable_self_recovery[0], "None", None, None)
        obj._enable_worker = (data.get("enableWorker", obj.__undef__), dirty)
        if obj._enable_worker[0] is not None and obj._enable_worker[0] is not obj.__undef__:
            assert isinstance(obj._enable_worker[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._enable_worker[0], type(obj._enable_worker[0])))
            common.validate_format(obj._enable_worker[0], "None", None, None)
        obj._is_db_recovered = (data.get("isDbRecovered", obj.__undef__), dirty)
        if obj._is_db_recovered[0] is not None and obj._is_db_recovered[0] is not obj.__undef__:
            assert isinstance(obj._is_db_recovered[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._is_db_recovered[0], type(obj._is_db_recovered[0])))
            common.validate_format(obj._is_db_recovered[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "enable_self_recovery" == "type" or (self.enable_self_recovery is not self.__undef__ and (not (dirty and not self._enable_self_recovery[1]) or self.is_dirty_list(self.enable_self_recovery, self._enable_self_recovery) or belongs_to_parent)):
            dct["enableSelfRecovery"] = dictify(self.enable_self_recovery)
        elif belongs_to_parent and self.enable_self_recovery is self.__undef__:
            dct["enableSelfRecovery"] = True
        if "enable_worker" == "type" or (self.enable_worker is not self.__undef__ and (not (dirty and not self._enable_worker[1]) or self.is_dirty_list(self.enable_worker, self._enable_worker) or belongs_to_parent)):
            dct["enableWorker"] = dictify(self.enable_worker)
        elif belongs_to_parent and self.enable_worker is self.__undef__:
            dct["enableWorker"] = True
        if "is_db_recovered" == "type" or (self.is_db_recovered is not self.__undef__ and (not (dirty and not self._is_db_recovered[1]))):
            dct["isDbRecovered"] = dictify(self.is_db_recovered)
        if dirty and "isDbRecovered" in dct:
            del dct["isDbRecovered"]
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._enable_self_recovery = (self._enable_self_recovery[0], True)
        self._enable_worker = (self._enable_worker[0], True)
        self._is_db_recovered = (self._is_db_recovered[0], True)

    def is_dirty(self):
        return any([self._enable_self_recovery[1], self._enable_worker[1], self._is_db_recovered[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, MSSqlProdSyncExportConfigParam):
            return False
        return super().__eq__(other) and \
               self.enable_self_recovery == other.enable_self_recovery and \
               self.enable_worker == other.enable_worker and \
               self.is_db_recovered == other.is_db_recovered

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def enable_self_recovery(self):
        """
        *(default value: True)* If enabled restore worker will bring exported
        MSSQL db online after it in sync with parent VDB.

        :rtype: ``bool``
        """
        return self._enable_self_recovery[0]

    @enable_self_recovery.setter
    def enable_self_recovery(self, value):
        self._enable_self_recovery = (value, True)

    @property
    def enable_worker(self):
        """
        *(default value: True)* Enable or disable restore worker on exported
        MSSQL database.

        :rtype: ``bool``
        """
        return self._enable_worker[0]

    @enable_worker.setter
    def enable_worker(self, value):
        self._enable_worker = (value, True)

    @property
    def is_db_recovered(self):
        """
        Indicates whether exported MSSQL db is marked recovered or not.

        :rtype: ``bool``
        """
        return self._is_db_recovered[0]

