#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-mssql-instance.json
#
# Do not edit this file manually!
#

from delphixpy.v1_11_24.web.objects.MSSqlRepository import MSSqlRepository
from delphixpy.v1_11_24 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class MSSqlInstance(MSSqlRepository):
    """
    *(extends* :py:class:`v1_11_24.web.vo.MSSqlRepository` *)* A SQL Server
    Instance.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("MSSqlInstance", True)
        self._instance_name = (self.__undef__, True)
        self._installation_path = (self.__undef__, True)
        self._server_name = (self.__undef__, True)
        self._port = (self.__undef__, True)
        self._instance_owner = (self.__undef__, True)
        self._version = (self.__undef__, True)
        self._discovered = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._instance_name = (data.get("instanceName", obj.__undef__), dirty)
        if obj._instance_name[0] is not None and obj._instance_name[0] is not obj.__undef__:
            assert isinstance(obj._instance_name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._instance_name[0], type(obj._instance_name[0])))
            common.validate_format(obj._instance_name[0], "None", 1, 256)
        obj._installation_path = (data.get("installationPath", obj.__undef__), dirty)
        if obj._installation_path[0] is not None and obj._installation_path[0] is not obj.__undef__:
            assert isinstance(obj._installation_path[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._installation_path[0], type(obj._installation_path[0])))
            common.validate_format(obj._installation_path[0], "None", 1, 300)
        obj._server_name = (data.get("serverName", obj.__undef__), dirty)
        if obj._server_name[0] is not None and obj._server_name[0] is not obj.__undef__:
            assert isinstance(obj._server_name[0], str), ("Expected one of ['string', 'null'], but got %s of type %s" % (obj._server_name[0], type(obj._server_name[0])))
            common.validate_format(obj._server_name[0], "None", None, 128)
        obj._port = (data.get("port", obj.__undef__), dirty)
        if obj._port[0] is not None and obj._port[0] is not obj.__undef__:
            assert isinstance(obj._port[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._port[0], type(obj._port[0])))
            common.validate_format(obj._port[0], "None", None, None)
        obj._instance_owner = (data.get("instanceOwner", obj.__undef__), dirty)
        if obj._instance_owner[0] is not None and obj._instance_owner[0] is not obj.__undef__:
            assert isinstance(obj._instance_owner[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._instance_owner[0], type(obj._instance_owner[0])))
            common.validate_format(obj._instance_owner[0], "None", 1, 255)
        obj._version = (data.get("version", obj.__undef__), dirty)
        if obj._version[0] is not None and obj._version[0] is not obj.__undef__:
            assert isinstance(obj._version[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._version[0], type(obj._version[0])))
            common.validate_format(obj._version[0], "None", 1, 256)
        obj._discovered = (data.get("discovered", obj.__undef__), dirty)
        if obj._discovered[0] is not None and obj._discovered[0] is not obj.__undef__:
            assert isinstance(obj._discovered[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._discovered[0], type(obj._discovered[0])))
            common.validate_format(obj._discovered[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "instance_name" == "type" or (self.instance_name is not self.__undef__ and (not (dirty and not self._instance_name[1]) or self.is_dirty_list(self.instance_name, self._instance_name) or belongs_to_parent)):
            dct["instanceName"] = dictify(self.instance_name)
        if "installation_path" == "type" or (self.installation_path is not self.__undef__ and (not (dirty and not self._installation_path[1]) or self.is_dirty_list(self.installation_path, self._installation_path) or belongs_to_parent)):
            dct["installationPath"] = dictify(self.installation_path)
        if "server_name" == "type" or (self.server_name is not self.__undef__ and (not (dirty and not self._server_name[1]) or self.is_dirty_list(self.server_name, self._server_name) or belongs_to_parent)):
            dct["serverName"] = dictify(self.server_name)
        if "port" == "type" or (self.port is not self.__undef__ and (not (dirty and not self._port[1]) or self.is_dirty_list(self.port, self._port) or belongs_to_parent)):
            dct["port"] = dictify(self.port)
        if "instance_owner" == "type" or (self.instance_owner is not self.__undef__ and (not (dirty and not self._instance_owner[1]) or self.is_dirty_list(self.instance_owner, self._instance_owner) or belongs_to_parent)):
            dct["instanceOwner"] = dictify(self.instance_owner)
        if "version" == "type" or (self.version is not self.__undef__ and (not (dirty and not self._version[1]) or self.is_dirty_list(self.version, self._version) or belongs_to_parent)):
            dct["version"] = dictify(self.version)
        if "discovered" == "type" or (self.discovered is not self.__undef__ and (not (dirty and not self._discovered[1]))):
            dct["discovered"] = dictify(self.discovered)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._instance_name = (self._instance_name[0], True)
        self._installation_path = (self._installation_path[0], True)
        self._server_name = (self._server_name[0], True)
        self._port = (self._port[0], True)
        self._instance_owner = (self._instance_owner[0], True)
        self._version = (self._version[0], True)
        self._discovered = (self._discovered[0], True)

    def is_dirty(self):
        return any([self._instance_name[1], self._installation_path[1], self._server_name[1], self._port[1], self._instance_owner[1], self._version[1], self._discovered[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, MSSqlInstance):
            return False
        return super().__eq__(other) and \
               self.instance_name == other.instance_name and \
               self.installation_path == other.installation_path and \
               self.server_name == other.server_name and \
               self.port == other.port and \
               self.instance_owner == other.instance_owner and \
               self.version == other.version and \
               self.discovered == other.discovered

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def instance_name(self):
        """
        The name of the SQL Server instance.

        :rtype: ``str``
        """
        return self._instance_name[0]

    @instance_name.setter
    def instance_name(self, value):
        self._instance_name = (value, True)

    @property
    def installation_path(self):
        """
        The SQL Server instance home.

        :rtype: ``str``
        """
        return self._installation_path[0]

    @installation_path.setter
    def installation_path(self, value):
        self._installation_path = (value, True)

    @property
    def server_name(self):
        """
        The Server Name of the SQL Server instance.

        :rtype: ``str`` *or* ``null``
        """
        return self._server_name[0]

    @server_name.setter
    def server_name(self, value):
        self._server_name = (value, True)

    @property
    def port(self):
        """
        The network port for connecting to the SQL Server instance.

        :rtype: ``int``
        """
        return self._port[0]

    @port.setter
    def port(self, value):
        self._port = (value, True)

    @property
    def instance_owner(self):
        """
        Account the SQL Server instance is running as.

        :rtype: ``str``
        """
        return self._instance_owner[0]

    @instance_owner.setter
    def instance_owner(self, value):
        self._instance_owner = (value, True)

    @property
    def version(self):
        """
        The version of the SQL Server instance.

        :rtype: ``str``
        """
        return self._version[0]

    @version.setter
    def version(self, value):
        self._version = (value, True)

    @property
    def discovered(self):
        """
        True if the MSSQL instance was automatically discovered.

        :rtype: ``bool``
        """
        return self._discovered[0]

    @discovered.setter
    def discovered(self, value):
        self._discovered = (value, True)

