#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-refresh-policy.json
#
# Do not edit this file manually!
#

from delphixpy.v1_11_8.web.objects.SchedulePolicy import SchedulePolicy
from delphixpy.v1_11_8 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class RefreshPolicy(SchedulePolicy):
    """
    *(extends* :py:class:`v1_11_8.web.vo.SchedulePolicy` *)* This policy
    refreshes a container according to a schedule.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("RefreshPolicy", True)
        self._provision_source = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._provision_source = (data.get("provisionSource", obj.__undef__), dirty)
        if obj._provision_source[0] is not None and obj._provision_source[0] is not obj.__undef__:
            assert isinstance(obj._provision_source[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._provision_source[0], type(obj._provision_source[0])))
            assert obj._provision_source[0] in ['LATEST_SNAPSHOT', 'LATEST_TIME_FLOW_LOG'], "Expected enum ['LATEST_SNAPSHOT', 'LATEST_TIME_FLOW_LOG'] but got %s" % obj._provision_source[0]
            common.validate_format(obj._provision_source[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "provision_source" == "type" or (self.provision_source is not self.__undef__ and (not (dirty and not self._provision_source[1]) or self.is_dirty_list(self.provision_source, self._provision_source) or belongs_to_parent)):
            dct["provisionSource"] = dictify(self.provision_source)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._provision_source = (self._provision_source[0], True)

    def is_dirty(self):
        return any([self._provision_source[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, RefreshPolicy):
            return False
        return super().__eq__(other) and \
               self.provision_source == other.provision_source

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def provision_source(self):
        """
        Provision source, either the latest time or latest snapshot.
        *(permitted values: LATEST_SNAPSHOT, LATEST_TIME_FLOW_LOG)*

        :rtype: ``str``
        """
        return self._provision_source[0]

    @provision_source.setter
    def provision_source(self, value):
        self._provision_source = (value, True)

