#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-dynamic-parameter-value.json
#
# Do not edit this file manually!
#

from delphixpy.v1_4_0.web.objects.TypedObject import TypedObject
from delphixpy.v1_4_0 import factory
from delphixpy.v1_4_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class DynamicParameterValue(TypedObject):
    """
    *(extends* :py:class:`v1_4_0.web.vo.TypedObject` *)* A settable value for a
    dynamic parameter. Each value object has an associated DynamicParameter
    definition that defines acceptable inputs.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("DynamicParameterValue", True)
        self._definition = (self.__undef__, True)
        self._value = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "definition" not in data:
            raise ValueError("Missing required property \"definition\".")
        if "definition" in data and data["definition"] is not None:
            obj._definition = (factory.create_object(data["definition"], "DynamicParameter"), dirty)
            factory.validate_type(obj._definition[0], "DynamicParameter")
        else:
            obj._definition = (obj.__undef__, dirty)
        if "value" not in data:
            raise ValueError("Missing required property \"value\".")
        obj._value = (data.get("value", obj.__undef__), dirty)
        if obj._value[0] is not None and obj._value[0] is not obj.__undef__:
            assert isinstance(obj._value[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._value[0], type(obj._value[0])))
            common.validate_format(obj._value[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "definition" == "type" or (self.definition is not self.__undef__ and (not (dirty and not self._definition[1]) or self.is_dirty_list(self.definition, self._definition) or belongs_to_parent)):
            dct["definition"] = dictify(self.definition, prop_is_list_or_vo=True)
        if "value" == "type" or (self.value is not self.__undef__ and (not (dirty and not self._value[1]) or self.is_dirty_list(self.value, self._value) or belongs_to_parent)):
            dct["value"] = dictify(self.value)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._definition = (self._definition[0], True)
        self._value = (self._value[0], True)

    def is_dirty(self):
        return any([self._definition[1], self._value[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, DynamicParameterValue):
            return False
        return super().__eq__(other) and \
               self.definition == other.definition and \
               self.value == other.value

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def definition(self):
        """
        The contraints this value will be validated against.

        :rtype: :py:class:`v1_4_0.web.vo.DynamicParameter`
        """
        return self._definition[0]

    @definition.setter
    def definition(self, value):
        self._definition = (value, True)

    @property
    def value(self):
        """
        The value. This must be valid according to the associated definition.

        :rtype: ``str``
        """
        return self._value[0]

    @value.setter
    def value(self, value):
        self._value = (value, True)

