#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-file-mapping-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.v1_4_0.web.objects.TypedObject import TypedObject
from delphixpy.v1_4_0 import factory
from delphixpy.v1_4_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class FileMappingParameters(TypedObject):
    """
    *(extends* :py:class:`v1_4_0.web.vo.TypedObject` *)* Input parameters to
    test file mapping rules.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("FileMappingParameters", True)
        self._mapping_rules = (self.__undef__, True)
        self._timeflow_point_parameters = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "mappingRules" not in data:
            raise ValueError("Missing required property \"mappingRules\".")
        obj._mapping_rules = (data.get("mappingRules", obj.__undef__), dirty)
        if obj._mapping_rules[0] is not None and obj._mapping_rules[0] is not obj.__undef__:
            assert isinstance(obj._mapping_rules[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._mapping_rules[0], type(obj._mapping_rules[0])))
            common.validate_format(obj._mapping_rules[0], "None", None, None)
        if "timeflowPointParameters" not in data:
            raise ValueError("Missing required property \"timeflowPointParameters\".")
        if "timeflowPointParameters" in data and data["timeflowPointParameters"] is not None:
            obj._timeflow_point_parameters = (factory.create_object(data["timeflowPointParameters"], "TimeflowPointParameters"), dirty)
            factory.validate_type(obj._timeflow_point_parameters[0], "TimeflowPointParameters")
        else:
            obj._timeflow_point_parameters = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "mapping_rules" == "type" or (self.mapping_rules is not self.__undef__ and (not (dirty and not self._mapping_rules[1]) or self.is_dirty_list(self.mapping_rules, self._mapping_rules) or belongs_to_parent)):
            dct["mappingRules"] = dictify(self.mapping_rules)
        if "timeflow_point_parameters" == "type" or (self.timeflow_point_parameters is not self.__undef__ and (not (dirty and not self._timeflow_point_parameters[1]) or self.is_dirty_list(self.timeflow_point_parameters, self._timeflow_point_parameters) or belongs_to_parent)):
            dct["timeflowPointParameters"] = dictify(self.timeflow_point_parameters, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._mapping_rules = (self._mapping_rules[0], True)
        self._timeflow_point_parameters = (self._timeflow_point_parameters[0], True)

    def is_dirty(self):
        return any([self._mapping_rules[1], self._timeflow_point_parameters[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, FileMappingParameters):
            return False
        return super().__eq__(other) and \
               self.mapping_rules == other.mapping_rules and \
               self.timeflow_point_parameters == other.timeflow_point_parameters

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def mapping_rules(self):
        """
        Database file mapping rules.

        :rtype: ``str``
        """
        return self._mapping_rules[0]

    @mapping_rules.setter
    def mapping_rules(self, value):
        self._mapping_rules = (value, True)

    @property
    def timeflow_point_parameters(self):
        """
        The timeflow point, bookmark or semantic location to use for list of
        files.

        :rtype: :py:class:`v1_4_0.web.vo.TimeflowPointParameters`
        """
        return self._timeflow_point_parameters[0]

    @timeflow_point_parameters.setter
    def timeflow_point_parameters(self, value):
        self._timeflow_point_parameters = (value, True)

