#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-js-operation.json
#
# Do not edit this file manually!
#

from delphixpy.v1_4_0.web.objects.NamedUserObject import NamedUserObject
from delphixpy.v1_4_0 import factory
from delphixpy.v1_4_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class JSOperation(NamedUserObject):
    """
    *(extends* :py:class:`v1_4_0.web.vo.NamedUserObject` *)* An operation that
    occurred on a Jet Stream data layout.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("JSOperation", True)
        self._bookmark = (self.__undef__, True)
        self._branch = (self.__undef__, True)
        self._data_layout = (self.__undef__, True)
        self._data_parent = (self.__undef__, True)
        self._data_time = (self.__undef__, True)
        self._description = (self.__undef__, True)
        self._end_time = (self.__undef__, True)
        self._operation = (self.__undef__, True)
        self._root_action = (self.__undef__, True)
        self._start_time = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._bookmark = (data.get("bookmark", obj.__undef__), dirty)
        if obj._bookmark[0] is not None and obj._bookmark[0] is not obj.__undef__:
            assert isinstance(obj._bookmark[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._bookmark[0], type(obj._bookmark[0])))
            common.validate_format(obj._bookmark[0], "objectReference", None, None)
        obj._branch = (data.get("branch", obj.__undef__), dirty)
        if obj._branch[0] is not None and obj._branch[0] is not obj.__undef__:
            assert isinstance(obj._branch[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._branch[0], type(obj._branch[0])))
            common.validate_format(obj._branch[0], "objectReference", None, None)
        obj._data_layout = (data.get("dataLayout", obj.__undef__), dirty)
        if obj._data_layout[0] is not None and obj._data_layout[0] is not obj.__undef__:
            assert isinstance(obj._data_layout[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._data_layout[0], type(obj._data_layout[0])))
            common.validate_format(obj._data_layout[0], "objectReference", None, None)
        if "dataParent" in data and data["dataParent"] is not None:
            obj._data_parent = (factory.create_object(data["dataParent"], "JSDataParent"), dirty)
            factory.validate_type(obj._data_parent[0], "JSDataParent")
        else:
            obj._data_parent = (obj.__undef__, dirty)
        obj._data_time = (data.get("dataTime", obj.__undef__), dirty)
        if obj._data_time[0] is not None and obj._data_time[0] is not obj.__undef__:
            assert isinstance(obj._data_time[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._data_time[0], type(obj._data_time[0])))
            common.validate_format(obj._data_time[0], "date", None, None)
        obj._description = (data.get("description", obj.__undef__), dirty)
        if obj._description[0] is not None and obj._description[0] is not obj.__undef__:
            assert isinstance(obj._description[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._description[0], type(obj._description[0])))
            common.validate_format(obj._description[0], "None", None, None)
        obj._end_time = (data.get("endTime", obj.__undef__), dirty)
        if obj._end_time[0] is not None and obj._end_time[0] is not obj.__undef__:
            assert isinstance(obj._end_time[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._end_time[0], type(obj._end_time[0])))
            common.validate_format(obj._end_time[0], "date", None, None)
        obj._operation = (data.get("operation", obj.__undef__), dirty)
        if obj._operation[0] is not None and obj._operation[0] is not obj.__undef__:
            assert isinstance(obj._operation[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._operation[0], type(obj._operation[0])))
            common.validate_format(obj._operation[0], "None", None, None)
        obj._root_action = (data.get("rootAction", obj.__undef__), dirty)
        if obj._root_action[0] is not None and obj._root_action[0] is not obj.__undef__:
            assert isinstance(obj._root_action[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._root_action[0], type(obj._root_action[0])))
            common.validate_format(obj._root_action[0], "objectReference", None, None)
        obj._start_time = (data.get("startTime", obj.__undef__), dirty)
        if obj._start_time[0] is not None and obj._start_time[0] is not obj.__undef__:
            assert isinstance(obj._start_time[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._start_time[0], type(obj._start_time[0])))
            common.validate_format(obj._start_time[0], "date", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "bookmark" == "type" or (self.bookmark is not self.__undef__ and (not (dirty and not self._bookmark[1]))):
            dct["bookmark"] = dictify(self.bookmark)
        if "branch" == "type" or (self.branch is not self.__undef__ and (not (dirty and not self._branch[1]))):
            dct["branch"] = dictify(self.branch)
        if "data_layout" == "type" or (self.data_layout is not self.__undef__ and (not (dirty and not self._data_layout[1]))):
            dct["dataLayout"] = dictify(self.data_layout)
        if "data_parent" == "type" or (self.data_parent is not self.__undef__ and (not (dirty and not self._data_parent[1]))):
            dct["dataParent"] = dictify(self.data_parent)
        if "data_time" == "type" or (self.data_time is not self.__undef__ and (not (dirty and not self._data_time[1]))):
            dct["dataTime"] = dictify(self.data_time)
        if "description" == "type" or (self.description is not self.__undef__ and (not (dirty and not self._description[1]))):
            dct["description"] = dictify(self.description)
        if "end_time" == "type" or (self.end_time is not self.__undef__ and (not (dirty and not self._end_time[1]))):
            dct["endTime"] = dictify(self.end_time)
        if "operation" == "type" or (self.operation is not self.__undef__ and (not (dirty and not self._operation[1]))):
            dct["operation"] = dictify(self.operation)
        if "root_action" == "type" or (self.root_action is not self.__undef__ and (not (dirty and not self._root_action[1]))):
            dct["rootAction"] = dictify(self.root_action)
        if "start_time" == "type" or (self.start_time is not self.__undef__ and (not (dirty and not self._start_time[1]))):
            dct["startTime"] = dictify(self.start_time)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._bookmark = (self._bookmark[0], True)
        self._branch = (self._branch[0], True)
        self._data_layout = (self._data_layout[0], True)
        self._data_parent = (self._data_parent[0], True)
        self._data_time = (self._data_time[0], True)
        self._description = (self._description[0], True)
        self._end_time = (self._end_time[0], True)
        self._operation = (self._operation[0], True)
        self._root_action = (self._root_action[0], True)
        self._start_time = (self._start_time[0], True)

    def is_dirty(self):
        return any([self._bookmark[1], self._branch[1], self._data_layout[1], self._data_parent[1], self._data_time[1], self._description[1], self._end_time[1], self._operation[1], self._root_action[1], self._start_time[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, JSOperation):
            return False
        return super().__eq__(other) and \
               self.bookmark == other.bookmark and \
               self.branch == other.branch and \
               self.data_layout == other.data_layout and \
               self.data_parent == other.data_parent and \
               self.data_time == other.data_time and \
               self.description == other.description and \
               self.end_time == other.end_time and \
               self.operation == other.operation and \
               self.root_action == other.root_action and \
               self.start_time == other.start_time

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def bookmark(self):
        """
        The bookmark that was created.

        :rtype: ``str``
        """
        return self._bookmark[0]

    @bookmark.setter
    def bookmark(self, value):
        self._bookmark = (value, True)

    @property
    def branch(self):
        """
        The branch that this operation was performed on.

        :rtype: ``str``
        """
        return self._branch[0]

    @branch.setter
    def branch(self, value):
        self._branch = (value, True)

    @property
    def data_layout(self):
        """
        The data layout that this operation was performed on.

        :rtype: ``str``
        """
        return self._data_layout[0]

    @data_layout.setter
    def data_layout(self, value):
        self._data_layout = (value, True)

    @property
    def data_parent(self):
        """
        The data parent of the operation.

        :rtype: :py:class:`v1_4_0.web.vo.JSDataParent`
        """
        return self._data_parent[0]

    @data_parent.setter
    def data_parent(self, value):
        self._data_parent = (value, True)

    @property
    def data_time(self):
        """
        The time that the data represented by this operation was active. It
        will be null if the operation is in progress.

        :rtype: ``str``
        """
        return self._data_time[0]

    @data_time.setter
    def data_time(self, value):
        self._data_time = (value, True)

    @property
    def description(self):
        """
        Plain text description of the operation.

        :rtype: ``str``
        """
        return self._description[0]

    @description.setter
    def description(self, value):
        self._description = (value, True)

    @property
    def end_time(self):
        """
        The time the operation finished. It will be null if the operation is in
        progress.

        :rtype: ``str``
        """
        return self._end_time[0]

    @end_time.setter
    def end_time(self, value):
        self._end_time = (value, True)

    @property
    def operation(self):
        """
        The operation performed. *(permitted values: REFRESH, RESET,
        CREATE_BRANCH, DELETE_BRANCH, CREATE_BOOKMARK, DELETE_BOOKMARK, ENABLE,
        DISABLE, ACTIVATE, DEACTIVATE, RECOVER, RESTORE)*

        :rtype: ``str``
        """
        return self._operation[0]

    @operation.setter
    def operation(self, value):
        self._operation = (value, True)

    @property
    def root_action(self):
        """
        The root action that spawned this operation.

        :rtype: ``str``
        """
        return self._root_action[0]

    @root_action.setter
    def root_action(self, value):
        self._root_action = (value, True)

    @property
    def start_time(self):
        """
        The time the operation started.

        :rtype: ``str``
        """
        return self._start_time[0]

    @start_time.setter
    def start_time(self, value):
        self._start_time = (value, True)

