#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-appdata-link-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.v1_4_2.web.objects.LinkParameters import LinkParameters
from delphixpy.v1_4_2 import factory
from delphixpy.v1_4_2 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class AppDataLinkParameters(LinkParameters):
    """
    *(extends* :py:class:`v1_4_2.web.vo.LinkParameters` *)* Represents the
    AppData specific parameters of a link request.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("AppDataLinkParameters", True)
        self._container = (self.__undef__, True)
        self._environment_user = (self.__undef__, True)
        self._excludes = (self.__undef__, True)
        self._follow_symlinks = (self.__undef__, True)
        self._source = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "container" not in data:
            raise ValueError("Missing required property \"container\".")
        if "container" in data and data["container"] is not None:
            obj._container = (factory.create_object(data["container"], "AppDataContainer"), dirty)
            factory.validate_type(obj._container[0], "AppDataContainer")
        else:
            obj._container = (obj.__undef__, dirty)
        if "environmentUser" not in data:
            raise ValueError("Missing required property \"environmentUser\".")
        obj._environment_user = (data.get("environmentUser", obj.__undef__), dirty)
        if obj._environment_user[0] is not None and obj._environment_user[0] is not obj.__undef__:
            assert isinstance(obj._environment_user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._environment_user[0], type(obj._environment_user[0])))
            common.validate_format(obj._environment_user[0], "objectReference", None, None)
        obj._excludes = []
        for item in data.get("excludes") or []:
            assert isinstance(item, str), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._excludes.append(item)
        obj._excludes = (obj._excludes, dirty)
        obj._follow_symlinks = []
        for item in data.get("followSymlinks") or []:
            assert isinstance(item, str), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._follow_symlinks.append(item)
        obj._follow_symlinks = (obj._follow_symlinks, dirty)
        if "source" not in data:
            raise ValueError("Missing required property \"source\".")
        if "source" in data and data["source"] is not None:
            obj._source = (factory.create_object(data["source"], "AppDataSource"), dirty)
            factory.validate_type(obj._source[0], "AppDataSource")
        else:
            obj._source = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "container" == "type" or (self.container is not self.__undef__ and (not (dirty and not self._container[1]) or self.is_dirty_list(self.container, self._container) or belongs_to_parent)):
            dct["container"] = dictify(self.container, prop_is_list_or_vo=True)
        if "environment_user" == "type" or (self.environment_user is not self.__undef__ and (not (dirty and not self._environment_user[1]) or self.is_dirty_list(self.environment_user, self._environment_user) or belongs_to_parent)):
            dct["environmentUser"] = dictify(self.environment_user)
        if "excludes" == "type" or (self.excludes is not self.__undef__ and (not (dirty and not self._excludes[1]) or self.is_dirty_list(self.excludes, self._excludes) or belongs_to_parent)):
            dct["excludes"] = dictify(self.excludes, prop_is_list_or_vo=True)
        if "follow_symlinks" == "type" or (self.follow_symlinks is not self.__undef__ and (not (dirty and not self._follow_symlinks[1]) or self.is_dirty_list(self.follow_symlinks, self._follow_symlinks) or belongs_to_parent)):
            dct["followSymlinks"] = dictify(self.follow_symlinks, prop_is_list_or_vo=True)
        if "source" == "type" or (self.source is not self.__undef__ and (not (dirty and not self._source[1]) or self.is_dirty_list(self.source, self._source) or belongs_to_parent)):
            dct["source"] = dictify(self.source, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._container = (self._container[0], True)
        self._environment_user = (self._environment_user[0], True)
        self._excludes = (self._excludes[0], True)
        self._follow_symlinks = (self._follow_symlinks[0], True)
        self._source = (self._source[0], True)

    def is_dirty(self):
        return any([self._container[1], self._environment_user[1], self._excludes[1], self._follow_symlinks[1], self._source[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, AppDataLinkParameters):
            return False
        return super().__eq__(other) and \
               self.container == other.container and \
               self.environment_user == other.environment_user and \
               self.excludes == other.excludes and \
               self.follow_symlinks == other.follow_symlinks and \
               self.source == other.source

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def container(self):
        """
        Container to create as part of the linking process.

        :rtype: :py:class:`v1_4_2.web.vo.AppDataContainer`
        """
        return self._container[0]

    @container.setter
    def container(self, value):
        self._container = (value, True)

    @property
    def environment_user(self):
        """
        The OS user to use for linking.

        :rtype: ``str``
        """
        return self._environment_user[0]

    @environment_user.setter
    def environment_user(self, value):
        self._environment_user = (value, True)

    @property
    def excludes(self):
        """
        List of subdirectories in the source to exclude when running rsync.
        These paths are relative to the root of the source directory.

        :rtype: ``list`` of ``str``
        """
        return self._excludes[0]

    @excludes.setter
    def excludes(self, value):
        self._excludes = (value, True)

    @property
    def follow_symlinks(self):
        """
        List of symlinks in the source to follow when running rsync. These
        paths are relative to the root of the source directory. All other
        symlinks are preserved.

        :rtype: ``list`` of ``str``
        """
        return self._follow_symlinks[0]

    @follow_symlinks.setter
    def follow_symlinks(self, value):
        self._follow_symlinks = (value, True)

    @property
    def source(self):
        """
        Source to link the container to. This must reference an existing linked
        source config.

        :rtype: :py:class:`v1_4_2.web.vo.AppDataSource`
        """
        return self._source[0]

    @source.setter
    def source(self, value):
        self._source = (value, True)

